#ifndef _hmod_fx_h
#define _hmod_fx_h
/* fx.h. __get_sfx_chan() returns the "recommended" channel for a new sfx. */

struct
{
 int curpos,endpos,startpos,channels_res;
 int sam_count;
} s_fx;

int __get_sfx_chan()
{
 s_fx.curpos++;
 if (s_fx.curpos>s_fx.endpos) s_fx.curpos=s_fx.startpos;
 return s_fx.curpos;
}

int __get_sfx_channels_res()
{
 return s_fx.channels_res;
}

void __init_sfx_engine(int how_many_channels)
{
 s_fx.channels_res=how_many_channels;
 s_fx.startpos=_output_get_channels()-how_many_channels;
 s_fx.endpos=_output_get_channels();
 s_fx.curpos=s_fx.startpos;
}

int __get_smp_nro()
{
 s_fx.sam_count++;
 return max_samples-s_fx.sam_count;
}

void __init_sam_engine()
{
 s_fx.sam_count=0;
}

#endif

