#ifndef _hmod_sbstaff_h
#define _hmod_sbstaff_h
/*sbstaff.h, sound blaster routines stuff*/

#include "sb_set.h"

int soundblaster_init(int ask_user) /*1 yes, do ask; 0 no, don't ask*/
{ /* DO NOT CALL. call sb_init instead. */
 unsigned int blocksizee;
 signed int i;
 int allow_auto_init=1;
 int allow_16bit=1;
 int allow_stereo=1;

 if (sb.installed==1) {strcat(error,"already inited.\n"); return -1;}

 for (i=0; i<33; i++) /*reset channels*/
  {
   channel[i].playing=0;
   channel[i].sample=0;
   channel[i].position=0;
   channel[i].freq=0;
   channel[i].volume=0;
  }

 if (sb_get_settings()==-1)
  {
   strcat(error,"blaster env. variable not (properly) set.\n");
   return -1;
  }

 sb.base=sb_settings.base;
 sb.irq=sb_settings.irq;
 sb.dma=sb_settings.dma;
 sb.hdma=sb_settings.hdma;
 sb.playspeed=45454;

 resetdsp(10); /* stop the playback :) */
 if (resetdsp(10)==-1) {strcat(error,"no sb.\n"); return -1;}

 do {
  sb.dspversion=get_dspversion();
 } while (sb.dspversion!=get_dspversion());

 if (ask_user==1)
  {
   i=choose_mixing_mode(sb.dspversion);
   if ((i==-1)||(i<0)||(i>6)) {strcat(error,"aborted by user.\n"); return -1;}
   allow_16bit=mixingmodes[i].allow_16bit;
   allow_auto_init=mixingmodes[i].allow_auto_init;
   allow_stereo=mixingmodes[i].allow_stereo;
  }
 if (sb.dspversion>=0x200) sb.autoinit=1; else sb.autoinit=0; /*sb 1.5 (dsp 2.00) or better*/
 if ((sb.dspversion>0x400)&&(sb.hdma>3)&&(sb.hdma<8)) sb._16bit=1; else sb._16bit=0;
 if (allow_16bit==0) sb._16bit=0; /*force 8-bit mode*/
 if ((sb.dspversion>0x400)&&(allow_stereo==1)) sb.stereo=1; else sb.stereo=0; /*sb 16, stereo*/
 if ((sb.dspversion>=0x300)&&(allow_stereo==1)) sb.stereo=1; /*sb pro, stereo*/

 if (allow_auto_init==0) { sb._16bit=0; sb.autoinit=0; sb.stereo=0; }
 /*force irq controlled (single cycle) dma, 8-bit & mono*/

 sb.playspeed=verify_freq(sb.playspeed);

 if (ask_user==1) sb.playspeed=verify_freq( select_speed(sb.playspeed) );

/*hmm.. i wonder if the interrupt really does get called 50 times
  per second in all mixing modes.. */

 blocksizee=((sb.playspeed/50)+3)&0xFFFFFFFC; /*blocksizee%4=0*/
/* printf("blocksizee: %u, mod4: %u\n",blocksizee,blocksizee&3);*/

 if (blocksizee>2048) blocksizee=2048;
 sb.dma_buf_size=blocksizee;

 /*if 16-bit output is used, the output buffer has to be doubled*/
 if (sb._16bit==1) sb.dma_buf_size=sb.dma_buf_size*2;

 /*if stereo is used, the output buffer has to be doubled*/
 if (sb.stereo==1) sb.dma_buf_size*=2;

 sb.dma_buf_segment=__dpmi_allocate_dos_memory(((sb.dma_buf_size*4+15)>>4),&sb.dma_buf_selector);
 if ((sb.dma_buf_segment>0xFFFF)||(sb.dma_buf_segment<0))
  {
   strcat(error,"out of base memory.\n");
   return -1;
  }
 for (i=0;i<(sb.dma_buf_size*4);i++) _farpokeb(sb.dma_buf_selector,i,0); /*clear the dma buffer*/

/**************************************************************************************************************************************************/
 sb.dma_buf_offset=0; /*check if the dma_buffer crosses a page boundary*/
 if ((unsigned int)(((((unsigned int)sb.dma_buf_segment<<4)+(unsigned int)sb.dma_buf_offset)&0xFFFF)+(unsigned int)sb.dma_buf_size*2)>0x0000FFFF)
  (sb.dma_buf_offset=sb.dma_buf_size*2); /*if it does, move it.*/
/**************************************************************************************************************************************************/

/*make the dma_buf_size indicate the number of words*/
 if (sb._16bit==1) sb.dma_buf_size=sb.dma_buf_size/2;

 /*this'll suite us better*/
 if (sb.stereo==1) sb.dma_buf_size=sb.dma_buf_size/2;

 switch (sb._16bit)
 {
  case 0:
/*   printf("setting these up for 8bit modes..\n"); */
   sb.dmamaskport=0x0A;   /* yes, i've seen smix :D */
   sb.dmaclrptrport=0x0C;
   sb.dmamodeport=0x0B;
   sb.dmabaseaddrport=(2*sb.dma);
   sb.dmacountport=(1+2*sb.dma);
   switch (sb.dma)
   {
    case 0:sb.pageport=0x87; break;
    case 1:sb.pageport=0x83; break;
    case 2:sb.pageport=0x81; break;
    case 3:sb.pageport=0x82; break;
   }
   sb.dstam=sb.dma;
   sb.dstom=sb.dma|0x04;
   if (sb.autoinit==1) sb.dmode=(sb.dma|0x58); else sb.dmode=(sb.dma|0x48);
   sb.ackport=(sb.base+0x0E);
   break; /*end case 0*/
  case 1: /*use 16 bit output mode*/
/*   printf("doing 16bit man.\n");*/
   sb.dmamaskport=0xd4;
   sb.dmaclrptrport=0xd8;
   sb.dmamodeport=0xd6;
   sb.dmabaseaddrport=0xc0+4*(sb.hdma-4);
   sb.dmacountport=0xc2+4*(sb.hdma-4);
   switch (sb.hdma)
   {
    case 4:sb.pageport=0x8F; break; /* uselessimo. */
    case 5:sb.pageport=0x8B; break;
    case 6:sb.pageport=0x89; break;
    case 7:sb.pageport=0x8A; break;
   }
   sb.dstam=(sb.hdma-4);
   sb.dstom=(sb.hdma-4)|0x04;
   sb.dmode=(sb.hdma-4)|0x58;
   sb.ackport=sb.base+0x0F;
   break; /*end case 1*/
 } /*end switch*/
 if (sb.autoinit==1) sb.dmalen=(sb.dma_buf_size*2); else sb.dmalen=sb.dma_buf_size;
/* if ((sb.stereo==1) && (sb.dspversion<0x401)) sb.dmalen*=2;*/

 if (sb.irq<=7) sb.airq=sb.irq+0x08; else sb.airq=0x70+sb.irq-0x08;
 if (sb.irq<=7) sb.pic=0x21; else sb.pic=0xA1;

 sb.istom=1<<(sb.irq%8);
 sb.istam=(sb.istom^0xFF);
 mixerinfo.vuoro=0;
 sb.interrupts=0;

 disable();
 __asm__ __volatile__ ("cli"); /*INSTALL MIXER*/

 outportb(sb.pic, (inportb(sb.pic)|sb.istom) );

 _go32_dpmi_get_protected_mode_interrupt_vector(sb.airq,&sb.vanha);
 sb.info.pm_offset=(unsigned long int)keskeytys;
 sb.info.pm_selector=_my_cs();
 disable();
 _go32_dpmi_allocate_iret_wrapper(&sb.info);
 _go32_dpmi_set_protected_mode_interrupt_vector(sb.airq,&sb.info);

 if (sb.irq>7) outportb(0xA0,0x20);
 outportb(0x20,0x20);

 inportb(sb.ackport);

 sb.installed=1;

 outportb(sb.pic, (inportb(sb.pic)&sb.istam) );
 if (sb._16bit==1) writedsp(0xD5);
  else
   {
    writedsp(0xD0);
    writedsp(0xD3);
   }
 __asm__ __volatile__ ("sti"); /*mixer installed*/
 enable();

 playback(); /*start playback*/
 return 0; /*everything ok*/
}

static int sb_deinit()
{
 int tulos;
 if (sb.installed!=1) {strcat(error,"sb driver not installed.\n"); return -1;}

 __asm__ __volatile__ ("cli");
 disable();

 resetdsp(5);
 resetdsp(5); /*this'll stop the playback for sure.*/

 outportb(sb.dmamaskport,sb.dstom);
 if (sb._16bit==1) writedsp(0xd5); /*pause dma16*/
  else { writedsp(0xD0); writedsp(0xd3); } /*pause dma8 and close speaker*/

 __asm__ __volatile__ ("cli");
 disable();

 outportb(sb.pic, (inportb(sb.pic)|sb.istom) ); /*disallow the sb interrupt*/
 tulos=_go32_dpmi_set_protected_mode_interrupt_vector(sb.airq,&sb.vanha);
  /*restore the old interrupt vector*/
 tulos+=__dpmi_free_dos_memory(sb.dma_buf_selector); /*free base memory*/
 if (voltable!=NULL) free(voltable);
/* if (mixerinfo.tmp!=NULL) free(mixerinfo.tmp);*/
 inportb(sb.ackport);
 __asm__ __volatile__ ("sti");
 enable();
 sb.installed=0;
 return tulos; /* i wonder who cares if this didn't succeed. oh well */
}

static int sb_playsample(int channaa, int sample, int volume, int frequ, int ppan, int __offset)
/*OUT: 0*/
{
 if (sample>=max_samples) return -1;
 if (samples[sample].used!=1) return -1;
 if (channaa>32) return -1;
 asm volatile (
 "pushfl
  cli");
 channel[channaa].playing=0;
 channel[channaa].sample=sample;
 if (volume==-1) channel[channaa].volume=samples[sample].volume; else
  if (volume!=-2) channel[channaa].volume=volume;
 if (frequ==-1) channel[channaa].freq=samples[sample].c2spd; else
  if (frequ!=-2) channel[channaa].freq=frequ;
 if (ppan==-1) channel[channaa].pan=samples[sample].pan; else
  if (ppan!=-2) channel[channaa].pan=ppan;
 channel[channaa].position=__offset;
 channel[channaa].position<<=32;
 if (__offset<samples[sample].length) channel[channaa].playing=1;
 asm volatile ("popfl");
 return 0;
}

static void sb_stopchannel(int channaa)
{
 channel[channaa].playing=0;
}

static void sb_set_volume(int channaa, int _volume)
{
 if (_volume<0) _volume=0; else
  if (_volume>64) _volume=64;
 channel[channaa].volume=_volume;
}

static void sb_set_pan(int channaa, int _pan)
{
 if (_pan>256) _pan=256; else
 if (_pan<0) _pan=0;
 channel[channaa].pan=_pan;
}

static void sb_set_freq(unsigned int channaa, unsigned int _freq)
{
 channel[channaa].freq=_freq;
}

static int sb_loadsample_8_bits_raw_from_opened_file_curpos(FILE *f, int samplenro, int frequ, int pan, int loopstart, int loopend, int read_length, char ssigned)
{
  int i;
/*  if (samples[samplenro].used==1)
   {strcat(error,"sample slot already in use.\n"); return -1;} */
  if (f==NULL)
   {
    strcat(error,"sb_lsmp: file not open.\n");
    return -1;
   }
  samples[samplenro].length=read_length;
/*  printf("loading %ld bytes.\n",samples[samplenro].length);*/
  samples[samplenro].data=(char *)malloc(samples[samplenro].length+4);
  if (samples[samplenro].data==NULL) {
   strcat(error,"sb_lsmp: out of memory.\n");
   return -1;
  }
  memset(samples[samplenro].data,0,samples[samplenro].length+4);
  _go32_dpmi_lock_data(samples[samplenro].data,samples[samplenro].length+4);

  if ((-1)==fread(samples[samplenro].data,1,samples[samplenro].length,f))
   {
    strcat(error,"sb_lsmp: load error.\n");
    return -1;
   }

  for (i=0;i<samples[samplenro].length;i++)
    samples[samplenro].data[i]^=ssigned;

  samples[samplenro].c2spd=frequ;
  samples[samplenro].loop_start=loopstart;
  samples[samplenro].loop_endi=loopend;
  samples[samplenro].loop_length=loopend-loopstart;
  samples[samplenro].pan=pan;
  samples[samplenro].used=1;
  return 0;
}

static int sb_loadsample_signed_8_bits_raw(char *filename, int samplenro, int frequ, int pan, int loopstart, int loopend)
{
  FILE *f;
  signed int rr;

  if (samples[samplenro].used==1)
   {
    strcat(error,"sb_lsmp: sample slot already in use.\n");
    return -1;
   }
  f=fopen(filename,"rb");
  if (f==NULL)
   {
    unsigned char tempp[50]="sb_lsmp: file ("; /*hard?*/
    strcat(tempp,filename);
    strcat(tempp,") not found.\n");
    strcat(error,tempp);
    return -1;
   }
  samples[samplenro].length=filelength(fileno(f));
  rr=sb_loadsample_8_bits_raw_from_opened_file_curpos(f,samplenro,frequ,pan,
                           loopstart,loopend,samples[samplenro].length,0x80);
  fclose(f);
  return rr;
}


static int sb_freesample(int samplenro)
{
 if ((samplenro<0)||(samplenro>100)) return -1;
 if ((samples[samplenro].used==0)||(samples[samplenro].data==NULL)) return -1;
 samples[samplenro].used=0;
 free(samples[samplenro].data);
 return 0;
}
/* end of sbstaff.h */
#endif
