#ifndef _hmod_output_h
#define _hmod_output_h
/* output.h. 32-channels, channel is always 1-32, NOT 0-31. */
/* it may be stupid, but that's how it is for now. */

#define NOSOUND 200
#define SB 201
#define GUS 202

unsigned int master; /*master volume, use mastervolume(int vol) to set this*/

void mastervolume(signed int vol) /* 0-64 */
{
 if (vol>64) vol=64; else if (vol<0) vol=0;
 master=vol;
}

#ifndef NO_SB_SUPPORT
#include "sbdev.h"  /*sound blaster*/
#endif

#include "nsdev.h"  /*no sound*/
#include "usdev.h"  /*ultrasound*/
#include "best.h"   /*"detect" best device*/
#include "devsel.h" /*select device*/

void _output_set_channels(int __channels)
{
 __channels+=__get_sfx_channels_res();
 switch (_output.device)
 {
  case GUS:gus_set_channels(__channels);break;
#ifndef NO_SB_SUPPORT
  case SB:sb_set_channels(__channels);break;
#endif
  default:break;
 }
}

int _output_get_channels()
{
 switch (_output.device)
 {
  case GUS:return gus_get_channels();break;
#ifndef NO_SB_SUPPORT
  case SB:return sb_get_channels();break;
#endif
  default:break;
 }
 return 32;
}

int _output_loadsample_signed_8_bits_raw(char *filename, int samplenro, int frequ, int pan, int loopstart, int loopend)
{
 switch (_output.device)
 {
#ifndef NO_SB_SUPPORT
  case SB:
   return (sb_loadsample_signed_8_bits_raw(filename,samplenro,frequ,pan,
           loopstart,loopend));
   break;
#endif
  case GUS:
   return (gus_loadsample_signed_8_bits_raw(filename,samplenro,frequ,pan,
           loopstart,loopend));
   break;
  case NOSOUND:
   return 0;
   break;
 }
 return -2;
}

int _output_loadsample_8_bits_raw_from_opened_file_curpos(FILE *f, int samplenro, int frequ, int pan, int loopstart, int loopend, int read_length, char ssigned)
{
 switch (_output.device)
 {
#ifndef NO_SB_SUPPORT
  case SB:
   return (sb_loadsample_8_bits_raw_from_opened_file_curpos(f,samplenro,
    frequ,pan,loopstart,loopend,read_length,ssigned));
   break;
#endif
  case GUS:
   return (gus_loadsample_8_bits_raw_from_opened_file_curpos(f,samplenro,
    frequ,pan,loopstart,loopend,read_length,ssigned));
   break;
  case NOSOUND:
   if (fseek(f,read_length,SEEK_CUR)==0) return 0;
    else return -1;
   break;
 }
 return -2;
}

void deinit_device()
{
 switch (_output.device)
 {
#ifndef NO_SB_SUPPORT
  case SB: sb_deinit(); break;
#endif
  case GUS: gus_deinit(); break;
  default:
  case NOSOUND: break;
 }
 memset(&_output,0,sizeof(_output));
}

int init_device(int ask_user)
/* IN: device: NOSOUND, SB, GUS                  */
/*     ask_user: 1 yes, do ask 0 no, don't ask  */
/* OUT: 0 successful, -1 failed.               */
{
 int device,i;
 memset(&_output,0,sizeof(_output));
 if (ask_user==1)
  {
   device=choose_device();
   best_setup.base=0xEEEE;
  }
 else
  {
   best_dev();
   device=best_setup.device;
  }
 _output.device=device;
 printf("device: ");
 switch (_output.device)
  {
#ifndef NO_SB_SUPPORT
   case SB:printf("%d, SB 1.0/1.5/2.0/pro/16/compatibles \n",SB); break;
#endif
   case GUS:printf("%d, US classic/compatibles \n",GUS); break;
   case NOSOUND:printf("%d, NS \n",NOSOUND); break;
   default:printf("duh \n"); break;
  }
 switch (_output.device)
 {
  case -1:strcat(error,"aborted by user.\n");return -1; break;
#ifndef NO_SB_SUPPORT
  case SB:
   _output.playsample=sb_playsample;
   _output.freesample=sb_freesample;
   _output.stopchannel=sb_stopchannel;
   _output.set_volume=sb_set_volume;
   _output.set_pan=sb_set_pan;
   _output.set_freq=sb_set_freq;
   _output.devicemem=134217728;
   if (atexit(deinit_device)!=0) strcat(error,"auto clean-up not inited.\n");
   return (sb_init(ask_user));
   break;
#endif
  case GUS:
   _output.playsample=gus_playsample;
   _output.freesample=_1_int_para_return_0;
   _output.stopchannel=gus_stopchannel;
   _output.set_volume=gus_set_volume;
   _output.set_pan=gus_set_pan;
   _output.set_freq=gus_set_freq;
   if (atexit(deinit_device)!=0) strcat(error,"auto clean-up not inited.\n");
   i=gus_init(best_setup.base);
   _output.devicemem=gus.totalmem;
   return i;
   break;

  default:
  case NOSOUND:
   _output.playsample=_6_int_paras_return_0;
   _output.freesample=_1_int_para_return_0;
   _output.stopchannel=_1_int;
   _output.set_volume=_2_int;
   _output.set_pan=_2_int;
   _output.set_freq=_2_int_u;
   _output.devicemem=134217728*2;
   return 0;
   break;
 }
 return -1;
}

void freeallsamples()
{
 int i;
 switch (_output.device)
  {
   case SB:for (i=0;i<max_samples;i++) _output.freesample(i);break;
   case GUS:gus_freeallsamples();break;
   default:
   case NOSOUND:break;
  }
}

#ifdef _hmod_structs_h
/* well, this doesn't exactly belong here */

void free_mod() /*this one usually always works*/
{
 int i;
 for (i=0;i<=song.patterns;i++)
  if (song.pattern[i]!=NULL) free(song.pattern[i]);
 freeallsamples();
}
#endif
/* end of output.h */
#endif
