#ifndef __hub_mp_h_included_
#define __hub_mp_h_included_

/* hub_mp.h, the hubris module player interface */

#include <stdlib.h>  /* include some stuff */
#include <stdio.h>
#include <conio.h>
#include <dpmi.h>
#include <pc.h>
#include <go32.h>
#include <sys\farptr.h>
#include <io.h>
#include <string.h>
#include <dos.h>     /* ..yep */

#define max_samples 130

unsigned char error[256]; /* error string */

volatile struct
{
 int speed;
 int bpm;
 int tick;
 int order;
 unsigned int row;
 int physpatta;
 int patternjump; /*0 false, 1 true*/
 int patternbreak; /*0 false, 1 true*/
 int patterndelay;
} play; /* module player's playing structure. feel free to check row&order */

struct
{
 char title[28];
 unsigned char channels;
 unsigned char instruments;
 unsigned char maxsamples;
 unsigned char fast_vslides; /*1 yes, 0 no*/
 unsigned char type; /*MOD, S3M*/
 unsigned long file_offset; /* the loaders load from this offset of the file. */
 unsigned long sample_space; /* save some space for the samples */
} module; /* file_offset is good for data-file purposes.. */

struct
{
 int device,devicemem;
 int ((*playsample)(int channaa, int sample, int volume, int frequ, int ppan, int __offset));
 int ((*freesample)(int samplenro));
 void ((*stopchannel)(int channaa));
 void ((*set_volume)(int channaa, int _volume));
 void ((*set_pan)(int channaa, int _pan));
 void ((*set_freq)(unsigned int channaa, unsigned int _freq));
} _output;

void lopeta(int code); /* show error string, and exit with code */
void mastervolume(signed int vol); /* 0-64 */
void _output_set_channels(int __channels); /* set the amount of active channels */
int _output_loadsample_signed_8_bits_raw(char *filename, int samplenro, int frequ, int pan, int loopstart, int loopend);
int _output_loadsample_8_bits_raw_from_opened_file_curpos(FILE *f, int samplenro, int frequ, int pan, int loopstart, int loopend, int read_length, char ssigned);
void deinit_device(); /* deinitialize device */
int init_device(int ask_user); /* initialize device, ask_user 0 no, 1 yes */
void freeallsamples(); /* free all loaded samples */
void free_mod(); /* dispose module, calls freeallsamples */
#ifndef NO_MOD_SUPPORT
int load_mod(char *name); /* load .mod files */
#endif
#ifndef NO_S3M_SUPPORT
int load_s3m(char *name); /* load .s3m files */
#endif
void deinit_playing(); /* stop playing */
void init_playing(); /* start playing */
signed int file_type(char *file_name); /* detect file type. check hmodxtra*/
int check_mk(FILE *f, char output); /* check for .mod-file type */
int __load_MOD_or_S3M(char *fn); /* autodetects module type and calls the right loader */

/* minimal sound effect -support */
int __get_sfx_chan();
void __init_sfx_engine(int how_many_channels);
int __get_smp_nro();
void __init_sam_engine();
int __get_sfx_channels_res();

/* end of hub_mp.h */
#endif
