#ifndef _hmod_best_h
#define _hmod_best_h
/*best.h, used to determine the "best" device available*/

#include "gus_set.h"
struct
{
 unsigned int device,base,irq,dma,dma16;
} best_setup;

void best_dev()
{
 if (gus_get_settings()==0)
  {
   best_setup.device=GUS;
   best_setup.base=gus_settings.base;
   best_setup.irq=0;
   best_setup.dma=0;
   best_setup.dma16=0;
  }
#ifndef NO_SB_SUPPORT
 else if (sb_get_settings()==0)
  {
   best_setup.device=SB;
   best_setup.base=sb_settings.base;
   best_setup.irq=sb_settings.irq;
   best_setup.dma=sb_settings.dma;
   best_setup.dma16=sb_settings.hdma;
  }
#endif
 else
  {
   best_setup.device=NOSOUND;
   best_setup.base=0;
   best_setup.irq=0;
   best_setup.dma=0;
   best_setup.dma16=0;
  }
}
/* end of best.h */
#endif
