/************************************************************************/
/* interfac.h, "user" interface.                                        */
/************************************************************************/
#ifndef __hmp_interfac_h_included
#define __hmp_interfac_h_included

#ifdef __cplusplus
extern "C" {
#endif

#include "ialot.h"          // include most of djgpp's libraries.
#include "structs.h"        // include global structures.

extern output_type _output; // output device
extern play_type   play;    // playing structure. check row&order here.
extern module_type module;  // sample_space and file_offset are here.
extern kello_type  kello;   // kello.kelloja increases 200 times per sec.
unsigned char error[256];   // error string.
extern instrument_type *instruments;

int HubrisModulePlayer();   // start the program with a call here
void lopeta(int code);      // show error string, and exit with code

void freeallsamples();      // free all loaded samples
void free_mod();            // dispose module, calls freeallsamples

void init_playing();        // start playing
void deinit_playing();      // stop playing
void rewind();              // rewind the tune one row.

                            // initialize device, ask_user 0 no, 1 yes
int  init_device(int ask_user);
void deinit_device();       // deinitialize device

int load_mod(char *name);   // load .mod files. 0 ok, -1 error.
int load_s3m(char *name);   // load .s3m files. 0 ok, -1 error.
int load_xm(char *name);    // load .xm files.  0 ok, -1 error.
int load_tune(char *name);  // load mod, s3m and xm files. 0 ok, -1 error.
signed int load_voc(char *filename, int samplenro); // 0 ok, -1 fail

void mastervolume(signed int vol);
                            // 0-64.

                            // minimal sound effect -support :
void __init_sfx_engine(int how_many_channels);
void __init_sam_engine();   // initialize __get_smp_nro()-"engine"
int __get_sfx_chan();       // returns a good channel for a sound effect
int __get_smp_nro();        // returns a slot number for a sample
int __get_sfx_channels_res(); // how many channels are reserved for sfx.

#ifdef __cplusplus
}
#endif

#endif
