/**
 ** VESAINFO.C ---- test program to print VESA BIOS information
 **
 ** Copyright (c) 1995 Csaba Biegl, 820 Stirrup Dr, Nashville, TN 37221
 ** [e-mail: csaba@vuse.vanderbilt.edu] See "doc/copying.cb" for details.
 **/

#include "libgrx.h"
#include "vesa.h"

void printinfo(VESAvgaInfoBlock *vgainfo)
{
	char  far *sp = vgainfo->OEMstringPtr;
	short far *mp = vgainfo->VideoModePtr;

	printf("VESASignature:\t\"%c%c%c%c\"\n",
	    vgainfo->VESAsignature[0],
	    vgainfo->VESAsignature[1],
	    vgainfo->VESAsignature[2],
	    vgainfo->VESAsignature[3]
	);
	printf("VESAVersion:\t%d.%d\n",
	    VESA_VERSION_MAJOR(vgainfo->VESAversion),
	    VESA_VERSION_MINOR(vgainfo->VESAversion)
	);
	printf("OEMStringPtr:\t\"");
	while(*sp != '\0') putchar(*sp++);
	printf("\"\nCapabilities:\t%ld\n",vgainfo->Capabilities);
	printf("VideoModePtr:\t0x%08lx\n",(long)mp);
	printf("Video Modes:\t");
	while(*mp != (short)(-1)) printf("0x%x ",(unsigned short)(*mp++));
	printf("\n");
	if(vgainfo->VESAversion >= VESA_VERSION(1,2)) {
	    printf("Memory Size:\t%d*64KBytes\n",vgainfo->MemorySize);
	}
	printf("\n");

}

typedef struct {
    int	   bit;
    char  *name;
#   define DEFBIT(bit)	   { bit, #bit }
} bitdef;

bitdef modeattrbits[] = {
    DEFBIT(MODE_SUPPORTED),
    DEFBIT(MODE_EXTINFO),
    DEFBIT(MODE_SUPBIOS),
    DEFBIT(MODE_ISCOLOR),
    DEFBIT(MODE_ISGRAPHICS),
    { 0 }
};

bitdef winattrbits[] = {
    DEFBIT(WIN_SUPPORTED),
    DEFBIT(WIN_READABLE),
    DEFBIT(WIN_WRITABLE),
    { 0 }
};

bitdef memorymodels[] = {
    DEFBIT(MODEL_TEXT),
    DEFBIT(MODEL_CGA),
    DEFBIT(MODEL_HERC),
    DEFBIT(MODEL_4PLANE),
    DEFBIT(MODEL_PACKED),
    DEFBIT(MODEL_256_NC),
    DEFBIT(MODEL_DIRECT),
    { 0 }
};

void printbits(int value,bitdef *def)
{
	int prev = 0;

	while(def->bit != 0) {
	    if(value & def->bit) {
		if(prev) printf(" | ");
		printf(def->name);
		prev = 1;
	    }
	    def++;
	}
	if(!prev) printf("0");
	printf("\n");
}

char *getmodelname(int model)
{
	static char temp[50];

	if(model < 0) return(sprintf(temp,"Invalid model [%d]",model),temp);
	if(model <= MODEL_DIRECT) return(memorymodels[model].name);
	if(model <= 15) return(sprintf(temp,"VESA model [0x%02x]",model),temp);
	return(sprintf(temp,"OEM model [%0x2x]",model),temp);
}

void printmodeinfo(int mode,int version,VESAmodeInfoBlock *modeinfo)
{
	printf("Mode 0x%x is supported\n",mode);
	printf("  ModeAttributes:   ");
	printbits(modeinfo->ModeAttributes,modeattrbits);
	printf("  WinAAttributes:   ");
	printbits(modeinfo->WinAAttributes,winattrbits);
	printf("  WinBAttributes:   ");
	printbits(modeinfo->WinBAttributes,winattrbits);
	printf("  WinGranularity:   %d\n",modeinfo->WinGranularity);
	printf("  WinSize:          %d\n",modeinfo->WinSize);
	printf("  WinASegment:      0x%04x\n",(ushort)modeinfo->WinASegment);
	printf("  WinBSegment:      0x%04x\n",(ushort)modeinfo->WinBSegment);
	printf("  WinFuncPtr:       0x%08lx\n",(long)modeinfo->WinFuncPtr);
	printf("  BytesPerScanLine: %d\n",modeinfo->BytesPerScanLine);
	if(!(modeinfo->ModeAttributes & MODE_EXTINFO)) return;
	printf("  XResolution:      %d\n",modeinfo->XResolution);
	printf("  YResolution:      %d\n",modeinfo->YResolution);
	printf("  XCharSize:        %d\n",modeinfo->XCharSize);
	printf("  YCharSize:        %d\n",modeinfo->YCharSize);
	printf("  NumberOfPlanes:   %d\n",modeinfo->NumberOfPlanes);
	printf("  BitsPerPixel:     %d\n",modeinfo->BitsPerPixel);
	printf("  NumberOfBanks:    %d\n",modeinfo->NumberOfBanks);
	printf("  MemoryModel:      %d (%s)\n",modeinfo->MemoryModel,getmodelname(modeinfo->MemoryModel));
	printf("  BankSize:         %d\n",modeinfo->BankSize);
	printf("  NumImagePages     %d\n",modeinfo->NumImagePages);
	if(version < VESA_VERSION(1,2)) return;
	printf("  RedMaskSize:      %d\n",modeinfo->RedMaskSize);
	printf("  RedMaskPos:       %d\n",modeinfo->RedMaskPos);
	printf("  GreenMaskSize:    %d\n",modeinfo->GreenMaskSize);
	printf("  GreenMaskPos:     %d\n",modeinfo->GreenMaskPos);
	printf("  BlueMaskSize:     %d\n",modeinfo->BlueMaskSize);
	printf("  BlueMaskPos:      %d\n",modeinfo->BlueMaskPos);
	printf("  ReservedMaskSize: %d\n",modeinfo->ReservedMaskSize);
	printf("  ReservedMaskPos:  %d\n",modeinfo->ReservedMaskPos);
	printf("  DirectScreenMode: %d\n",modeinfo->DirectScreenMode);
}

void main(void)
{
	VESAvgaInfoBlock  vb;
	VESAmodeInfoBlock mb;
	if(_GrViDrvVESAgetVGAinfo(&vb)) {
	    short far *mp = vb.VideoModePtr;
	    printinfo(&vb);
	    while(*mp != (short)(-1)) {
		if(_GrViDrvVESAgetModeInfo(*mp,&mb)) {
		    printmodeinfo(*mp,vb.VESAversion,&mb);
		}
		else {
		    printf("Mode 0x%x IS NOT SUPPORTED!\n",*mp);
		}
		mp++;
	    }
	}
	else printf("VESA BIOS extensions not found\n");
	exit(0);
}

