/**
 ** ET4000.C ---- Tseng ET4000 video driver
 **
 ** Copyright (c) 1995 Csaba Biegl, 820 Stirrup Dr, Nashville, TN 37221
 ** [e-mail: csaba@vuse.vanderbilt.edu] See "doc/copying.cb" for details.
 **/

#include "grdriver.h"
#include "libgrx.h"
#include "arith.h"
#include "int86.h"
#include "ioport.h"
#include "memfill.h"

static void setbank(int bk)
{
	outport_b(0x3cd,((bk & 15) | ((bk & 15) << 4)));
}

static void setrwbanks(int rb,int wb)
{
	outport_b(0x3cd,((wb & 15) | ((rb & 15) << 4)));
}

static GrVideoModeExt gr4ext = {
    GR_frameSVGA4,			/* frame driver */
    NULL,				/* frame driver override */
    MK_FP(0xa000,0),			/* frame buffer address */
    { 6, 6, 6 },			/* color precisions */
    { 0, 0, 0 },			/* color component bit positions */
    0,					/* mode flag bits */
    _GrViDrvSetEGAVGAmode,		/* mode set */
    _GrViDrvVESAsetVirtualSize,		/* virtual size set */
    _GrViDrvVESAvirtualScroll,		/* virtual scroll */
    setbank,				/* bank set function */
    setrwbanks,				/* double bank set function */
    _GrViDrvLoadColorVGA4		/* color loader */
};

static GrVideoModeExt gr8ext = {
    GR_frameSVGA8,			/* frame driver */
    NULL,				/* frame driver override */
    MK_FP(0xa000,0),			/* frame buffer address */
    { 6, 6, 6 },			/* color precisions */
    { 0, 0, 0 },			/* color component bit positions */
    GR_VMODEF_FAST_SVGA8,		/* mode flag bits */
    _GrViDrvSetEGAVGAmode,		/* mode set */
    _GrViDrvVESAsetVirtualSize,		/* virtual size set */
    _GrViDrvVESAvirtualScroll,		/* virtual scroll */
    setbank,				/* bank set function */
    setrwbanks,				/* double bank set function */
    _GrViDrvLoadColorVGA8		/* color loader */
};

static int setmode16(GrVideoMode *mp,int noclear)
{
	if(_GrViDrvSetEGAVGAmode(mp,noclear)) {
	    Int86Regs r;
	    sttzero(&r);
	    IREG_AX(r) = 0x10f0;
	    IREG_BX(r) = mp->mode;
	    int10(&r);
	    if(IREG_AX(r) == 0x10) return(TRUE);
	}
	return(FALSE);
}

static GrVideoModeExt gr15ext = {
    GR_frameSVGA16,			/* frame driver */
    NULL,				/* frame driver override */
    MK_FP(0xa000,0),			/* frame buffer address */
    { 5,  5,  5 },			/* color precisions */
    { 10, 5,  0 },			/* color component bit positions */
    0,					/* mode flag bits */
    setmode16,				/* mode set */
    _GrViDrvVESAsetVirtualSize,		/* virtual size set */
    _GrViDrvVESAvirtualScroll,		/* virtual scroll */
    setbank,				/* bank set function */
    setrwbanks,				/* double bank set function */
    NULL				/* color loader */
};

static GrVideoMode modes[] = {
    /* pres.  bpp wdt	hgt   BIOS   scan  priv. &ext				  */
    {  TRUE,  4,  100,  40,   0x2a,  200,  0,	 &_GrViDrvEGAVGAtextModeExt	  },
    {  TRUE,  4,  132,  25,   0x23,  264,  0,	 &_GrViDrvEGAVGAtextModeExt	  },
    {  TRUE,  4,  132,  28,   0x24,  264,  0,	 &_GrViDrvEGAVGAtextModeExt	  },
    {  TRUE,  4,  132,  44,   0x22,  264,  0,	 &_GrViDrvEGAVGAtextModeExt	  },
    {  TRUE,  4,  132,  50,   0x61,  264,  0,	 &_GrViDrvEGAVGAtextModeExt	  },
    {  TRUE,  4,  800,  600,  0x29,  100,  0,	 &gr4ext			  },
    {  TRUE,  4,  1024, 768,  0x37,  128,  0,	 &gr4ext			  },
    {  TRUE,  4,  1280, 1024, 0x3d,  160,  0,	 &gr4ext			  },
    {  TRUE,  8,  640,  350,  0x2d,  640,  0,	 &gr8ext			  },
    {  TRUE,  8,  640,  400,  0x2f,  640,  0,	 &gr8ext			  },
    {  TRUE,  8,  640,  480,  0x2e,  640,  0,	 &gr8ext			  },
    {  TRUE,  8,  800,  600,  0x30,  800,  0,	 &gr8ext			  },
    {  TRUE,  8,  1024, 768,  0x38,  1024, 0,	 &gr8ext			  },
    {  FALSE, 15, 640,  350,  0x2d,  1280, 0,	 &gr15ext			  },
    {  FALSE, 15, 640,  400,  0x2f,  1280, 0,	 &gr15ext			  },
    {  FALSE, 15, 640,  480,  0x2e,  1280, 0,	 &gr15ext			  },
    {  FALSE, 15, 800,  600,  0x30,  1600, 0,	 &gr15ext			  }
};

static int init(char *options)
{
	if(_GrViDrvInitEGAVGA(options)) {
	    Int86Regs r;
	    sttzero(&r);
	    IREG_AX(r) = 0x10f1;
	    int10(&r);
	    if((IREG_AX(r) == 0x10) && (IREG_BX(r) >= 1)) {
		GrVideoMode *mp = &modes[itemsof(modes)];
		while(--mp >= modes) {
		    if(mp->bpp == 15) mp->present = TRUE;
		}
	    }
	    return(TRUE);
	}
	return(FALSE);
}

GrVideoDriver _GrVideoDriverET4000 = {
    "et4000",				/* name */
    GR_VGA,				/* adapter type */
    &_GrVideoDriverSTDVGA,		/* inherit modes from this driver */
    modes,				/* mode table */
    itemsof(modes),			/* # of modes */
    NULL,				/* detection routine */
    init,				/* initialization routine */
    _GrViDrvResetEGAVGA			/* reset routine */
};

