/**
 ** RAM8.C ---- the 256 color system RAM frame driver
 **
 ** Copyright (c) 1995 Csaba Biegl, 820 Stirrup Dr, Nashville, TN 37221
 ** [e-mail: csaba@vuse.vanderbilt.edu] See "doc/copying.cb" for details.
 **/

#include "grdriver.h"
#include "libgrx.h"
#include "mempeek.h"

static
#ifdef __GNUC__
inline
#endif
long readpixel(GrFrame *c,int x,int y)
{
	return((uchar)peek_b(&c->gf_baseaddr[0][(y * c->gf_lineoffset) + x]));
}

static
#ifdef __GNUC__
inline
#endif
void drawpixel(int x,int y,long color)
{
	char far *ptr = &CURC->gc_baseaddr[0][(y * CURC->gc_lineoffset) + x];
	switch(C_OPER(color)) {
	    case C_XOR: poke_b_xor(ptr,(uchar)color); break;
	    case C_OR:  poke_b_or( ptr,(uchar)color); break;
	    case C_AND: poke_b_and(ptr,(uchar)color); break;
	    default:	poke_b(	   ptr,(uchar)color); break;
	}
}

static
#include "fdrivers/generic/hline.c"

static
#include "fdrivers/generic/vline.c"

static
#include "fdrivers/generic/block.c"

static
#include "fdrivers/generic/line.c"

static
#include "fdrivers/generic/bitmap.c"

static
#include "fdrivers/generic/pattern.c"

GrFrameDriver _GrFrameDriverRAM8 = {
    GR_frameRAM8,		/* frame mode */
    GR_frameUndef,		/* compatible RAM frame mode */
    FALSE,			/* onscreen */
    4,				/* line width alignment */
    1,				/* number of planes */
    8,				/* bits per pixel */
#ifdef __TURBOC__
    65520L,			/* max plane size the code can handle */
#else
    8*16*1024L*1024L,		/* max plane size the code can handle */
#endif
    NULL,
    readpixel,
    drawpixel,
    drawline,
    drawhline,
    drawvline,
    drawblock,
    drawbitmap,
    drawpattern,
    _GrFrDrvPackedBitBltR2R,
    NULL,
    NULL,
};

