/**
 ** RAM16.C ---- the 32768/655536 color system RAM frame driver
 **
 ** Copyright (c) 1995 Csaba Biegl, 820 Stirrup Dr, Nashville, TN 37221
 ** [e-mail: csaba@vuse.vanderbilt.edu] See "doc/copying.cb" for details.
 **/

#include "grdriver.h"
#include "libgrx.h"
#include "mempeek.h"

static
#ifdef __GNUC__
inline
#endif
long readpixel(GrFrame *c,int x,int y)
{
	return((ushort)peek_w(&c->gf_baseaddr[0][(y * c->gf_lineoffset) + (x << 1)]));
}

static
#ifdef __GNUC__
inline
#endif
void drawpixel(int x,int y,long color)
{
	char far *ptr = &CURC->gc_baseaddr[0][(y * CURC->gc_lineoffset) + (x << 1)];
	switch(C_OPER(color)) {
	    case C_XOR: poke_w_xor(ptr,(ushort)color); break;
	    case C_OR:  poke_w_or( ptr,(ushort)color); break;
	    case C_AND: poke_w_and(ptr,(ushort)color); break;
	    default:	poke_w(	   ptr,(ushort)color); break;
	}
}

static
#include "fdrivers/generic/hline.c"

static
#include "fdrivers/generic/vline.c"

static
#include "fdrivers/generic/block.c"

static
#include "fdrivers/generic/line.c"

static
#include "fdrivers/generic/bitmap.c"

static
#include "fdrivers/generic/pattern.c"

static void bitblt(GrFrame *dst,int dx,int dy,GrFrame *src,int sx,int sy,int w,int h,long op)
{
	if(GrColorMode(op) == GrIMAGE) _GrFrDrvGenericBitBlt(
	    dst,dx,dy,
	    src,sx,sy,
	    w,h,
	    op
	);
	else _GrFrDrvPackedBitBltR2R(
	    dst,(dx << 1),dy,
	    src,(sx << 1),sy,
	    (w << 1),h,
	    op
	);
}

GrFrameDriver _GrFrameDriverRAM16 = {
    GR_frameRAM16,		/* frame mode */
    GR_frameUndef,		/* compatible RAM frame mode */
    FALSE,			/* onscreen */
    4,				/* scan line width alignment */
    1,				/* number of planes */
    16,				/* bits per pixel */
#ifdef __TURBOC__
    65520L,			/* max plane size the code can handle */
#else
    16*16*1024L*1024L,		/* max plane size the code can handle */
#endif
    NULL,
    readpixel,
    drawpixel,
    drawline,
    drawhline,
    drawvline,
    drawblock,
    drawbitmap,
    drawpattern,
    bitblt,
    NULL,
    NULL,
};

