/**
 ** DFLTFONT.C ---- the default font
 **
 ** Copyright (c) 1995 Csaba Biegl, 820 Stirrup Dr, Nashville, TN 37221
 ** [e-mail: csaba@vuse.vanderbilt.edu] See "doc/copying.cb" for details.
 **/

#define  GrDefaultFont  FONTNAME_TEMPORARY_REDIRECTION
#include "libgrx.h"
#undef	 GrDefaultFont

static char far fnt8x14bits[] = {
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x7e,0x81,0xa5,0x81,0x81,0xbd,0x99,0x81,0x7e,0x00,0x00,0x00,
    0x00,0x00,0x7e,0xff,0xdb,0xff,0xff,0xc3,0xe7,0xff,0x7e,0x00,0x00,0x00,
    0x00,0x00,0x00,0x6c,0xfe,0xfe,0xfe,0xfe,0x7c,0x38,0x10,0x00,0x00,0x00,
    0x00,0x00,0x00,0x10,0x38,0x7c,0xfe,0x7c,0x38,0x10,0x00,0x00,0x00,0x00,
    0x00,0x00,0x18,0x3c,0x3c,0xe7,0xe7,0xe7,0x18,0x18,0x3c,0x00,0x00,0x00,
    0x00,0x00,0x18,0x3c,0x7e,0xff,0xff,0x7e,0x18,0x18,0x3c,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x18,0x3c,0x3c,0x18,0x00,0x00,0x00,0x00,0x00,
    0xff,0xff,0xff,0xff,0xff,0xe7,0xc3,0xc3,0xe7,0xff,0xff,0xff,0xff,0xff,
    0x00,0x00,0x00,0x00,0x3c,0x66,0x42,0x42,0x66,0x3c,0x00,0x00,0x00,0x00,
    0xff,0xff,0xff,0xff,0xc3,0x99,0xbd,0xbd,0x99,0xc3,0xff,0xff,0xff,0xff,
    0x00,0x00,0x1e,0x0e,0x1a,0x32,0x78,0xcc,0xcc,0xcc,0x78,0x00,0x00,0x00,
    0x00,0x00,0x3c,0x66,0x66,0x66,0x3c,0x18,0x7e,0x18,0x18,0x00,0x00,0x00,
    0x00,0x00,0x3f,0x33,0x3f,0x30,0x30,0x30,0x70,0xf0,0xe0,0x00,0x00,0x00,
    0x00,0x00,0x7f,0x63,0x7f,0x63,0x63,0x63,0x67,0xe7,0xe6,0xc0,0x00,0x00,
    0x00,0x00,0x18,0x18,0xdb,0x3c,0xe7,0x3c,0xdb,0x18,0x18,0x00,0x00,0x00,
    0x00,0x00,0x80,0xc0,0xe0,0xf8,0xfe,0xf8,0xe0,0xc0,0x80,0x00,0x00,0x00,
    0x00,0x00,0x02,0x06,0x0e,0x3e,0xfe,0x3e,0x0e,0x06,0x02,0x00,0x00,0x00,
    0x00,0x00,0x18,0x3c,0x7e,0x18,0x18,0x18,0x7e,0x3c,0x18,0x00,0x00,0x00,
    0x00,0x00,0x66,0x66,0x66,0x66,0x66,0x66,0x00,0x66,0x66,0x00,0x00,0x00,
    0x00,0x00,0x7f,0xdb,0xdb,0xdb,0x7b,0x1b,0x1b,0x1b,0x1b,0x00,0x00,0x00,
    0x00,0x7c,0xc6,0x60,0x38,0x6c,0xc6,0xc6,0x6c,0x38,0x0c,0xc6,0x7c,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0xfe,0xfe,0x00,0x00,0x00,
    0x00,0x00,0x18,0x3c,0x7e,0x18,0x18,0x18,0x7e,0x3c,0x18,0x7e,0x00,0x00,
    0x00,0x00,0x18,0x3c,0x7e,0x18,0x18,0x18,0x18,0x18,0x18,0x00,0x00,0x00,
    0x00,0x00,0x18,0x18,0x18,0x18,0x18,0x18,0x7e,0x3c,0x18,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x18,0x0c,0xfe,0x0c,0x18,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x30,0x60,0xfe,0x60,0x30,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0xc0,0xc0,0xc0,0xfe,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x28,0x6c,0xfe,0x6c,0x28,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x10,0x38,0x38,0x7c,0x7c,0xfe,0xfe,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0xfe,0xfe,0x7c,0x7c,0x38,0x38,0x10,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x18,0x3c,0x3c,0x3c,0x18,0x18,0x00,0x18,0x18,0x00,0x00,0x00,
    0x00,0x66,0x66,0x66,0x24,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x6c,0x6c,0xfe,0x6c,0x6c,0x6c,0xfe,0x6c,0x6c,0x00,0x00,0x00,
    0x18,0x18,0x7c,0xc6,0xc2,0xc0,0x7c,0x06,0x86,0xc6,0x7c,0x18,0x18,0x00,
    0x00,0x00,0x00,0x00,0xc2,0xc6,0x0c,0x18,0x30,0x66,0xc6,0x00,0x00,0x00,
    0x00,0x00,0x38,0x6c,0x6c,0x38,0x76,0xdc,0xcc,0xcc,0x76,0x00,0x00,0x00,
    0x00,0x30,0x30,0x30,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x0c,0x18,0x30,0x30,0x30,0x30,0x30,0x18,0x0c,0x00,0x00,0x00,
    0x00,0x00,0x30,0x18,0x0c,0x0c,0x0c,0x0c,0x0c,0x18,0x30,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x66,0x3c,0xff,0x3c,0x66,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x18,0x18,0x7e,0x18,0x18,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x18,0x30,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x00,0x00,0x00,
    0x00,0x00,0x02,0x06,0x0c,0x18,0x30,0x60,0xc0,0x80,0x00,0x00,0x00,0x00,
    0x00,0x00,0x7c,0xc6,0xce,0xde,0xf6,0xe6,0xc6,0xc6,0x7c,0x00,0x00,0x00,
    0x00,0x00,0x18,0x38,0x78,0x18,0x18,0x18,0x18,0x18,0x7e,0x00,0x00,0x00,
    0x00,0x00,0x7c,0xc6,0x06,0x0c,0x18,0x30,0x60,0xc6,0xfe,0x00,0x00,0x00,
    0x00,0x00,0x7c,0xc6,0x06,0x06,0x3c,0x06,0x06,0xc6,0x7c,0x00,0x00,0x00,
    0x00,0x00,0x0c,0x1c,0x3c,0x6c,0xcc,0xfe,0x0c,0x0c,0x1e,0x00,0x00,0x00,
    0x00,0x00,0xfe,0xc0,0xc0,0xc0,0xfc,0x06,0x06,0xc6,0x7c,0x00,0x00,0x00,
    0x00,0x00,0x38,0x60,0xc0,0xc0,0xfc,0xc6,0xc6,0xc6,0x7c,0x00,0x00,0x00,
    0x00,0x00,0xfe,0xc6,0x06,0x0c,0x18,0x30,0x30,0x30,0x30,0x00,0x00,0x00,
    0x00,0x00,0x7c,0xc6,0xc6,0xc6,0x7c,0xc6,0xc6,0xc6,0x7c,0x00,0x00,0x00,
    0x00,0x00,0x7c,0xc6,0xc6,0xc6,0x7e,0x06,0x06,0x0c,0x78,0x00,0x00,0x00,
    0x00,0x00,0x00,0x18,0x18,0x00,0x00,0x00,0x18,0x18,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x18,0x18,0x00,0x00,0x00,0x18,0x18,0x30,0x00,0x00,0x00,
    0x00,0x00,0x06,0x0c,0x18,0x30,0x60,0x30,0x18,0x0c,0x06,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x7e,0x00,0x00,0x7e,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x60,0x30,0x18,0x0c,0x06,0x0c,0x18,0x30,0x60,0x00,0x00,0x00,
    0x00,0x00,0x7c,0xc6,0xc6,0x0c,0x18,0x18,0x00,0x18,0x18,0x00,0x00,0x00,
    0x00,0x00,0x7c,0xc6,0xc6,0xde,0xde,0xde,0xdc,0xc0,0x7c,0x00,0x00,0x00,
    0x00,0x00,0x10,0x38,0x6c,0xc6,0xc6,0xfe,0xc6,0xc6,0xc6,0x00,0x00,0x00,
    0x00,0x00,0xfc,0x66,0x66,0x66,0x7c,0x66,0x66,0x66,0xfc,0x00,0x00,0x00,
    0x00,0x00,0x3c,0x66,0xc2,0xc0,0xc0,0xc0,0xc2,0x66,0x3c,0x00,0x00,0x00,
    0x00,0x00,0xf8,0x6c,0x66,0x66,0x66,0x66,0x66,0x6c,0xf8,0x00,0x00,0x00,
    0x00,0x00,0xfe,0x66,0x62,0x68,0x78,0x68,0x62,0x66,0xfe,0x00,0x00,0x00,
    0x00,0x00,0xfe,0x66,0x62,0x68,0x78,0x68,0x60,0x60,0xf0,0x00,0x00,0x00,
    0x00,0x00,0x3c,0x66,0xc2,0xc0,0xc0,0xde,0xc6,0x66,0x3a,0x00,0x00,0x00,
    0x00,0x00,0xc6,0xc6,0xc6,0xc6,0xfe,0xc6,0xc6,0xc6,0xc6,0x00,0x00,0x00,
    0x00,0x00,0x3c,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x3c,0x00,0x00,0x00,
    0x00,0x00,0x1e,0x0c,0x0c,0x0c,0x0c,0x0c,0xcc,0xcc,0x78,0x00,0x00,0x00,
    0x00,0x00,0xe6,0x66,0x6c,0x6c,0x78,0x6c,0x6c,0x66,0xe6,0x00,0x00,0x00,
    0x00,0x00,0xf0,0x60,0x60,0x60,0x60,0x60,0x62,0x66,0xfe,0x00,0x00,0x00,
    0x00,0x00,0xc6,0xee,0xfe,0xfe,0xd6,0xc6,0xc6,0xc6,0xc6,0x00,0x00,0x00,
    0x00,0x00,0xc6,0xe6,0xf6,0xfe,0xde,0xce,0xc6,0xc6,0xc6,0x00,0x00,0x00,
    0x00,0x00,0x38,0x6c,0xc6,0xc6,0xc6,0xc6,0xc6,0x6c,0x38,0x00,0x00,0x00,
    0x00,0x00,0xfc,0x66,0x66,0x66,0x7c,0x60,0x60,0x60,0xf0,0x00,0x00,0x00,
    0x00,0x00,0x7c,0xc6,0xc6,0xc6,0xc6,0xd6,0xde,0x7c,0x0c,0x0e,0x00,0x00,
    0x00,0x00,0xfc,0x66,0x66,0x66,0x7c,0x6c,0x66,0x66,0xe6,0x00,0x00,0x00,
    0x00,0x00,0x7c,0xc6,0xc6,0x60,0x38,0x0c,0xc6,0xc6,0x7c,0x00,0x00,0x00,
    0x00,0x00,0x7e,0x7e,0x5a,0x18,0x18,0x18,0x18,0x18,0x3c,0x00,0x00,0x00,
    0x00,0x00,0xc6,0xc6,0xc6,0xc6,0xc6,0xc6,0xc6,0xc6,0x7c,0x00,0x00,0x00,
    0x00,0x00,0xc6,0xc6,0xc6,0xc6,0xc6,0xc6,0x6c,0x38,0x10,0x00,0x00,0x00,
    0x00,0x00,0xc6,0xc6,0xc6,0xc6,0xd6,0xd6,0xfe,0x7c,0x6c,0x00,0x00,0x00,
    0x00,0x00,0xc6,0xc6,0x6c,0x38,0x38,0x38,0x6c,0xc6,0xc6,0x00,0x00,0x00,
    0x00,0x00,0x66,0x66,0x66,0x66,0x3c,0x18,0x18,0x18,0x3c,0x00,0x00,0x00,
    0x00,0x00,0xfe,0xc6,0x8c,0x18,0x30,0x60,0xc2,0xc6,0xfe,0x00,0x00,0x00,
    0x00,0x00,0x3c,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x3c,0x00,0x00,0x00,
    0x00,0x00,0x80,0xc0,0xe0,0x70,0x38,0x1c,0x0e,0x06,0x02,0x00,0x00,0x00,
    0x00,0x00,0x3c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x3c,0x00,0x00,0x00,
    0x10,0x38,0x6c,0xc6,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0x00,
    0x30,0x30,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x78,0x0c,0x7c,0xcc,0xcc,0x76,0x00,0x00,0x00,
    0x00,0x00,0xe0,0x60,0x60,0x78,0x6c,0x66,0x66,0x66,0x7c,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x7c,0xc6,0xc0,0xc0,0xc6,0x7c,0x00,0x00,0x00,
    0x00,0x00,0x1c,0x0c,0x0c,0x3c,0x6c,0xcc,0xcc,0xcc,0x76,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x7c,0xc6,0xfe,0xc0,0xc6,0x7c,0x00,0x00,0x00,
    0x00,0x00,0x38,0x6c,0x64,0x60,0xf0,0x60,0x60,0x60,0xf0,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x76,0xcc,0xcc,0xcc,0x7c,0x0c,0xcc,0x78,0x00,
    0x00,0x00,0xe0,0x60,0x60,0x6c,0x76,0x66,0x66,0x66,0xe6,0x00,0x00,0x00,
    0x00,0x00,0x18,0x18,0x00,0x38,0x18,0x18,0x18,0x18,0x3c,0x00,0x00,0x00,
    0x00,0x00,0x06,0x06,0x00,0x0e,0x06,0x06,0x06,0x06,0x66,0x66,0x3c,0x00,
    0x00,0x00,0xe0,0x60,0x60,0x66,0x6c,0x78,0x6c,0x66,0xe6,0x00,0x00,0x00,
    0x00,0x00,0x38,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x3c,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0xec,0xfe,0xd6,0xd6,0xd6,0xc6,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0xdc,0x66,0x66,0x66,0x66,0x66,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x7c,0xc6,0xc6,0xc6,0xc6,0x7c,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0xdc,0x66,0x66,0x66,0x7c,0x60,0x60,0xf0,0x00,
    0x00,0x00,0x00,0x00,0x00,0x76,0xcc,0xcc,0xcc,0x7c,0x0c,0x0c,0x1e,0x00,
    0x00,0x00,0x00,0x00,0x00,0xdc,0x76,0x66,0x60,0x60,0xf0,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x7c,0xc6,0x70,0x1c,0xc6,0x7c,0x00,0x00,0x00,
    0x00,0x00,0x10,0x30,0x30,0xfc,0x30,0x30,0x30,0x36,0x1c,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0xcc,0xcc,0xcc,0xcc,0xcc,0x76,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x66,0x66,0x66,0x66,0x3c,0x18,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0xc6,0xc6,0xd6,0xd6,0xfe,0x6c,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0xc6,0x6c,0x38,0x38,0x6c,0xc6,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0xc6,0xc6,0xc6,0xc6,0x7e,0x06,0x0c,0xf8,0x00,
    0x00,0x00,0x00,0x00,0x00,0xfe,0xcc,0x18,0x30,0x66,0xfe,0x00,0x00,0x00,
    0x00,0x00,0x0e,0x18,0x18,0x18,0x70,0x18,0x18,0x18,0x0e,0x00,0x00,0x00,
    0x00,0x00,0x18,0x18,0x18,0x18,0x00,0x18,0x18,0x18,0x18,0x00,0x00,0x00,
    0x00,0x00,0x70,0x18,0x18,0x18,0x0e,0x18,0x18,0x18,0x70,0x00,0x00,0x00,
    0x00,0x00,0x76,0xdc,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x10,0x38,0x6c,0xc6,0xc6,0xfe,0x00,0x00,0x00,0x00,
    0x00,0x00,0x3c,0x66,0xc2,0xc0,0xc0,0xc2,0x66,0x3c,0x0c,0x06,0x7c,0x00,
    0x00,0x00,0xcc,0xcc,0x00,0xcc,0xcc,0xcc,0xcc,0xcc,0x76,0x00,0x00,0x00,
    0x00,0x0c,0x18,0x30,0x00,0x7c,0xc6,0xfe,0xc0,0xc6,0x7c,0x00,0x00,0x00,
    0x00,0x10,0x38,0x6c,0x00,0x78,0x0c,0x7c,0xcc,0xcc,0x76,0x00,0x00,0x00,
    0x00,0x00,0xcc,0xcc,0x00,0x78,0x0c,0x7c,0xcc,0xcc,0x76,0x00,0x00,0x00,
    0x00,0x60,0x30,0x18,0x00,0x78,0x0c,0x7c,0xcc,0xcc,0x76,0x00,0x00,0x00,
    0x00,0x38,0x6c,0x38,0x00,0x78,0x0c,0x7c,0xcc,0xcc,0x76,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x3c,0x66,0x60,0x66,0x3c,0x0c,0x06,0x3c,0x00,0x00,
    0x00,0x10,0x38,0x6c,0x00,0x7c,0xc6,0xfe,0xc0,0xc6,0x7c,0x00,0x00,0x00,
    0x00,0x00,0xcc,0xcc,0x00,0x7c,0xc6,0xfe,0xc0,0xc6,0x7c,0x00,0x00,0x00,
    0x00,0x60,0x30,0x18,0x00,0x7c,0xc6,0xfe,0xc0,0xc6,0x7c,0x00,0x00,0x00,
    0x00,0x00,0x66,0x66,0x00,0x38,0x18,0x18,0x18,0x18,0x3c,0x00,0x00,0x00,
    0x00,0x18,0x3c,0x66,0x00,0x38,0x18,0x18,0x18,0x18,0x3c,0x00,0x00,0x00,
    0x00,0x60,0x30,0x18,0x00,0x38,0x18,0x18,0x18,0x18,0x3c,0x00,0x00,0x00,
    0x00,0xc6,0xc6,0x10,0x38,0x6c,0xc6,0xc6,0xfe,0xc6,0xc6,0x00,0x00,0x00,
    0x38,0x6c,0x38,0x00,0x38,0x6c,0xc6,0xc6,0xfe,0xc6,0xc6,0x00,0x00,0x00,
    0x18,0x30,0x60,0x00,0xfe,0x66,0x60,0x7c,0x60,0x66,0xfe,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0xcc,0x76,0x36,0x7e,0xd8,0xd8,0x6e,0x00,0x00,0x00,
    0x00,0x00,0x3e,0x6c,0xcc,0xcc,0xfe,0xcc,0xcc,0xcc,0xce,0x00,0x00,0x00,
    0x00,0x10,0x38,0x6c,0x00,0x7c,0xc6,0xc6,0xc6,0xc6,0x7c,0x00,0x00,0x00,
    0x00,0x00,0xc6,0xc6,0x00,0x7c,0xc6,0xc6,0xc6,0xc6,0x7c,0x00,0x00,0x00,
    0x00,0x60,0x30,0x18,0x00,0x7c,0xc6,0xc6,0xc6,0xc6,0x7c,0x00,0x00,0x00,
    0x00,0x30,0x78,0xcc,0x00,0xcc,0xcc,0xcc,0xcc,0xcc,0x76,0x00,0x00,0x00,
    0x00,0x60,0x30,0x18,0x00,0xcc,0xcc,0xcc,0xcc,0xcc,0x76,0x00,0x00,0x00,
    0x00,0x00,0xc6,0xc6,0x00,0xc6,0xc6,0xc6,0xc6,0x7e,0x06,0x0c,0x78,0x00,
    0x00,0xc6,0xc6,0x38,0x6c,0xc6,0xc6,0xc6,0xc6,0x6c,0x38,0x00,0x00,0x00,
    0x00,0xc6,0xc6,0x00,0xc6,0xc6,0xc6,0xc6,0xc6,0xc6,0x7c,0x00,0x00,0x00,
    0x00,0x18,0x18,0x3c,0x66,0x60,0x60,0x66,0x3c,0x18,0x18,0x00,0x00,0x00,
    0x00,0x38,0x6c,0x64,0x60,0xf0,0x60,0x60,0x60,0xe6,0xfc,0x00,0x00,0x00,
    0x00,0x00,0x66,0x66,0x3c,0x18,0x7e,0x18,0x7e,0x18,0x18,0x00,0x00,0x00,
    0x00,0xf8,0xcc,0xcc,0xf8,0xc4,0xcc,0xde,0xcc,0xcc,0xc6,0x00,0x00,0x00,
    0x00,0x0e,0x1b,0x18,0x18,0x18,0x7e,0x18,0x18,0x18,0x18,0xd8,0x70,0x00,
    0x00,0x18,0x30,0x60,0x00,0x78,0x0c,0x7c,0xcc,0xcc,0x76,0x00,0x00,0x00,
    0x00,0x0c,0x18,0x30,0x00,0x38,0x18,0x18,0x18,0x18,0x3c,0x00,0x00,0x00,
    0x00,0x18,0x30,0x60,0x00,0x7c,0xc6,0xc6,0xc6,0xc6,0x7c,0x00,0x00,0x00,
    0x00,0x18,0x30,0x60,0x00,0xcc,0xcc,0xcc,0xcc,0xcc,0x76,0x00,0x00,0x00,
    0x00,0x00,0x76,0xdc,0x00,0xdc,0x66,0x66,0x66,0x66,0x66,0x00,0x00,0x00,
    0x76,0xdc,0x00,0xc6,0xe6,0xf6,0xfe,0xde,0xce,0xc6,0xc6,0x00,0x00,0x00,
    0x00,0x3c,0x6c,0x6c,0x3e,0x00,0x7e,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x38,0x6c,0x6c,0x38,0x00,0x7c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x30,0x30,0x00,0x30,0x30,0x60,0xc6,0xc6,0x7c,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0xc0,0xc0,0xc0,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0x06,0x06,0x06,0x00,0x00,0x00,0x00,
    0x00,0xc0,0xc0,0xc6,0xcc,0xd8,0x30,0x60,0xdc,0x86,0x0c,0x18,0x3e,0x00,
    0x00,0xc0,0xc0,0xc6,0xcc,0xd8,0x30,0x66,0xce,0x9e,0x3e,0x06,0x06,0x00,
    0x00,0x00,0x18,0x18,0x00,0x18,0x18,0x3c,0x3c,0x3c,0x18,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x36,0x6c,0xd8,0x6c,0x36,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0xd8,0x6c,0x36,0x6c,0xd8,0x00,0x00,0x00,0x00,0x00,
    0x11,0x44,0x11,0x44,0x11,0x44,0x11,0x44,0x11,0x44,0x11,0x44,0x11,0x44,
    0x55,0xaa,0x55,0xaa,0x55,0xaa,0x55,0xaa,0x55,0xaa,0x55,0xaa,0x55,0xaa,
    0xdd,0x77,0xdd,0x77,0xdd,0x77,0xdd,0x77,0xdd,0x77,0xdd,0x77,0xdd,0x77,
    0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,
    0x18,0x18,0x18,0x18,0x18,0x18,0x18,0xf8,0x18,0x18,0x18,0x18,0x18,0x18,
    0x18,0x18,0x18,0x18,0x18,0xf8,0x18,0xf8,0x18,0x18,0x18,0x18,0x18,0x18,
    0x36,0x36,0x36,0x36,0x36,0x36,0x36,0xf6,0x36,0x36,0x36,0x36,0x36,0x36,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0x36,0x36,0x36,0x36,0x36,0x36,
    0x00,0x00,0x00,0x00,0x00,0xf8,0x18,0xf8,0x18,0x18,0x18,0x18,0x18,0x18,
    0x36,0x36,0x36,0x36,0x36,0xf6,0x06,0xf6,0x36,0x36,0x36,0x36,0x36,0x36,
    0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,
    0x00,0x00,0x00,0x00,0x00,0xfe,0x06,0xf6,0x36,0x36,0x36,0x36,0x36,0x36,
    0x36,0x36,0x36,0x36,0x36,0xf6,0x06,0xfe,0x00,0x00,0x00,0x00,0x00,0x00,
    0x36,0x36,0x36,0x36,0x36,0x36,0x36,0xfe,0x00,0x00,0x00,0x00,0x00,0x00,
    0x18,0x18,0x18,0x18,0x18,0xf8,0x18,0xf8,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0x18,0x18,0x18,0x18,0x18,0x18,
    0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,
    0x18,0x18,0x18,0x18,0x18,0x18,0x18,0xff,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0x18,0x18,0x18,0x18,0x18,0x18,
    0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x1f,0x18,0x18,0x18,0x18,0x18,0x18,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0x00,0x00,0x00,0x00,0x00,0x00,
    0x18,0x18,0x18,0x18,0x18,0x18,0x18,0xff,0x18,0x18,0x18,0x18,0x18,0x18,
    0x18,0x18,0x18,0x18,0x18,0x1f,0x18,0x1f,0x18,0x18,0x18,0x18,0x18,0x18,
    0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x37,0x36,0x36,0x36,0x36,0x36,0x36,
    0x36,0x36,0x36,0x36,0x36,0x37,0x30,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x3f,0x30,0x37,0x36,0x36,0x36,0x36,0x36,0x36,
    0x36,0x36,0x36,0x36,0x36,0xf7,0x00,0xff,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0xff,0x00,0xf7,0x36,0x36,0x36,0x36,0x36,0x36,
    0x36,0x36,0x36,0x36,0x36,0x37,0x30,0x37,0x36,0x36,0x36,0x36,0x36,0x36,
    0x00,0x00,0x00,0x00,0x00,0xff,0x00,0xff,0x00,0x00,0x00,0x00,0x00,0x00,
    0x36,0x36,0x36,0x36,0x36,0xf7,0x00,0xf7,0x36,0x36,0x36,0x36,0x36,0x36,
    0x18,0x18,0x18,0x18,0x18,0xff,0x00,0xff,0x00,0x00,0x00,0x00,0x00,0x00,
    0x36,0x36,0x36,0x36,0x36,0x36,0x36,0xff,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0xff,0x00,0xff,0x18,0x18,0x18,0x18,0x18,0x18,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0x36,0x36,0x36,0x36,0x36,0x36,
    0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,
    0x18,0x18,0x18,0x18,0x18,0x1f,0x18,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x1f,0x18,0x1f,0x18,0x18,0x18,0x18,0x18,0x18,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3f,0x36,0x36,0x36,0x36,0x36,0x36,
    0x36,0x36,0x36,0x36,0x36,0x36,0x36,0xff,0x36,0x36,0x36,0x36,0x36,0x36,
    0x18,0x18,0x18,0x18,0x18,0xff,0x18,0xff,0x18,0x18,0x18,0x18,0x18,0x18,
    0x18,0x18,0x18,0x18,0x18,0x18,0x18,0xf8,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0x18,0x18,0x18,0x18,0x18,0x18,
    0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
    0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,
    0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,
    0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x76,0xdc,0xd8,0xd8,0xdc,0x76,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x7c,0xc6,0xfc,0xc6,0xc6,0xfc,0xc0,0xc0,0x40,0x00,
    0x00,0x00,0xfe,0xc6,0xc6,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0xfe,0x6c,0x6c,0x6c,0x6c,0x6c,0x6c,0x00,0x00,0x00,
    0x00,0x00,0xfe,0xc6,0x60,0x30,0x18,0x30,0x60,0xc6,0xfe,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x7e,0xd8,0xd8,0xd8,0xd8,0x70,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x66,0x66,0x66,0x66,0x7c,0x60,0x60,0xc0,0x00,0x00,
    0x00,0x00,0x00,0x00,0x76,0xdc,0x18,0x18,0x18,0x18,0x18,0x00,0x00,0x00,
    0x00,0x00,0x7e,0x18,0x3c,0x66,0x66,0x66,0x3c,0x18,0x7e,0x00,0x00,0x00,
    0x00,0x00,0x38,0x6c,0xc6,0xc6,0xfe,0xc6,0xc6,0x6c,0x38,0x00,0x00,0x00,
    0x00,0x00,0x38,0x6c,0xc6,0xc6,0xc6,0x6c,0x6c,0x6c,0xee,0x00,0x00,0x00,
    0x00,0x00,0x1e,0x30,0x18,0x0c,0x3e,0x66,0x66,0x66,0x3c,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x7e,0xdb,0xdb,0x7e,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x03,0x06,0x7e,0xdb,0xdb,0xf3,0x7e,0x60,0xc0,0x00,0x00,0x00,
    0x00,0x00,0x1c,0x30,0x60,0x60,0x7c,0x60,0x60,0x30,0x1c,0x00,0x00,0x00,
    0x00,0x00,0x00,0x7c,0xc6,0xc6,0xc6,0xc6,0xc6,0xc6,0xc6,0x00,0x00,0x00,
    0x00,0x00,0x00,0xfe,0x00,0x00,0xfe,0x00,0x00,0xfe,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x18,0x18,0x7e,0x18,0x18,0x00,0x00,0xff,0x00,0x00,0x00,
    0x00,0x00,0x30,0x18,0x0c,0x06,0x0c,0x18,0x30,0x00,0x7e,0x00,0x00,0x00,
    0x00,0x00,0x0c,0x18,0x30,0x60,0x30,0x18,0x0c,0x00,0x7e,0x00,0x00,0x00,
    0x00,0x00,0x0e,0x1b,0x1b,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,
    0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0xd8,0xd8,0x70,0x00,0x00,0x00,
    0x00,0x00,0x00,0x18,0x18,0x00,0x7e,0x00,0x18,0x18,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x76,0xdc,0x00,0x76,0xdc,0x00,0x00,0x00,0x00,0x00,
    0x00,0x38,0x6c,0x6c,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x0f,0x0c,0x0c,0x0c,0x0c,0x0c,0xec,0x6c,0x3c,0x1c,0x00,0x00,0x00,
    0x00,0xd8,0x6c,0x6c,0x6c,0x6c,0x6c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x70,0xd8,0x30,0x60,0xc8,0xf8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x7c,0x7c,0x7c,0x7c,0x7c,0x7c,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
};

struct {
    GrFont	  theFont;
    GrFontChrInfo rest[255];
} GrDefaultFont = {
    {
	{			/* font header */
	    "pc8x14",		/* font name */
	    "ibmpc",		/* font family name */
	    FALSE,		/* characters have varying width */
	    FALSE,		/* derived from a scalable font */
	    TRUE,		/* font permanently linked into program */
	    GR_FONTCVT_NONE,	/* "tweaked" font (resized, etc..) */
	    8,			/* width (average when proportional) */
	    14,			/* font height */
	    12,			/* baseline pixel pos (from top) */
	    13,			/* underline pixel pos (from top) */
	    1,			/* underline width */
	    0,			/* lowest character code in font */
	    256			/* number of characters in font */
	},
	fnt8x14bits,		/* character bitmap array */
	NULL,			/* auxilary bitmap */
	8,			/* width of narrowest character */
	8,			/* width of widest character */
	0,			/* allocated size of auxilary bitmap */
	0,			/* free space in auxilary bitmap */
	{ NULL		   },	/* converted character bitmap offsets */
	{ { 8,  14*0	 } }	/* first character info */
    },
    {
	{ 8,	14*1	   },	/* remaining 255 characters */
	{ 8,	14*2	   },
	{ 8,	14*3	   },
	{ 8,	14*4	   },
	{ 8,	14*5	   },
	{ 8,	14*6	   },
	{ 8,	14*7	   },
	{ 8,	14*8	   },
	{ 8,	14*9	   },
	{ 8,	14*10	   },
	{ 8,	14*11	   },
	{ 8,	14*12	   },
	{ 8,	14*13	   },
	{ 8,	14*14	   },
	{ 8,	14*15	   },
	{ 8,	14*16	   },
	{ 8,	14*17	   },
	{ 8,	14*18	   },
	{ 8,	14*19	   },
	{ 8,	14*20	   },
	{ 8,	14*21	   },
	{ 8,	14*22	   },
	{ 8,	14*23	   },
	{ 8,	14*24	   },
	{ 8,	14*25	   },
	{ 8,	14*26	   },
	{ 8,	14*27	   },
	{ 8,	14*28	   },
	{ 8,	14*29	   },
	{ 8,	14*30	   },
	{ 8,	14*31	   },
	{ 8,	14*32	   },
	{ 8,	14*33	   },
	{ 8,	14*34	   },
	{ 8,	14*35	   },
	{ 8,	14*36	   },
	{ 8,	14*37	   },
	{ 8,	14*38	   },
	{ 8,	14*39	   },
	{ 8,	14*40	   },
	{ 8,	14*41	   },
	{ 8,	14*42	   },
	{ 8,	14*43	   },
	{ 8,	14*44	   },
	{ 8,	14*45	   },
	{ 8,	14*46	   },
	{ 8,	14*47	   },
	{ 8,	14*48	   },
	{ 8,	14*49	   },
	{ 8,	14*50	   },
	{ 8,	14*51	   },
	{ 8,	14*52	   },
	{ 8,	14*53	   },
	{ 8,	14*54	   },
	{ 8,	14*55	   },
	{ 8,	14*56	   },
	{ 8,	14*57	   },
	{ 8,	14*58	   },
	{ 8,	14*59	   },
	{ 8,	14*60	   },
	{ 8,	14*61	   },
	{ 8,	14*62	   },
	{ 8,	14*63	   },
	{ 8,	14*64	   },
	{ 8,	14*65	   },
	{ 8,	14*66	   },
	{ 8,	14*67	   },
	{ 8,	14*68	   },
	{ 8,	14*69	   },
	{ 8,	14*70	   },
	{ 8,	14*71	   },
	{ 8,	14*72	   },
	{ 8,	14*73	   },
	{ 8,	14*74	   },
	{ 8,	14*75	   },
	{ 8,	14*76	   },
	{ 8,	14*77	   },
	{ 8,	14*78	   },
	{ 8,	14*79	   },
	{ 8,	14*80	   },
	{ 8,	14*81	   },
	{ 8,	14*82	   },
	{ 8,	14*83	   },
	{ 8,	14*84	   },
	{ 8,	14*85	   },
	{ 8,	14*86	   },
	{ 8,	14*87	   },
	{ 8,	14*88	   },
	{ 8,	14*89	   },
	{ 8,	14*90	   },
	{ 8,	14*91	   },
	{ 8,	14*92	   },
	{ 8,	14*93	   },
	{ 8,	14*94	   },
	{ 8,	14*95	   },
	{ 8,	14*96	   },
	{ 8,	14*97	   },
	{ 8,	14*98	   },
	{ 8,	14*99	   },
	{ 8,	14*100	   },
	{ 8,	14*101	   },
	{ 8,	14*102	   },
	{ 8,	14*103	   },
	{ 8,	14*104	   },
	{ 8,	14*105	   },
	{ 8,	14*106	   },
	{ 8,	14*107	   },
	{ 8,	14*108	   },
	{ 8,	14*109	   },
	{ 8,	14*110	   },
	{ 8,	14*111	   },
	{ 8,	14*112	   },
	{ 8,	14*113	   },
	{ 8,	14*114	   },
	{ 8,	14*115	   },
	{ 8,	14*116	   },
	{ 8,	14*117	   },
	{ 8,	14*118	   },
	{ 8,	14*119	   },
	{ 8,	14*120	   },
	{ 8,	14*121	   },
	{ 8,	14*122	   },
	{ 8,	14*123	   },
	{ 8,	14*124	   },
	{ 8,	14*125	   },
	{ 8,	14*126	   },
	{ 8,	14*127	   },
	{ 8,	14*128	   },
	{ 8,	14*129	   },
	{ 8,	14*130	   },
	{ 8,	14*131	   },
	{ 8,	14*132	   },
	{ 8,	14*133	   },
	{ 8,	14*134	   },
	{ 8,	14*135	   },
	{ 8,	14*136	   },
	{ 8,	14*137	   },
	{ 8,	14*138	   },
	{ 8,	14*139	   },
	{ 8,	14*140	   },
	{ 8,	14*141	   },
	{ 8,	14*142	   },
	{ 8,	14*143	   },
	{ 8,	14*144	   },
	{ 8,	14*145	   },
	{ 8,	14*146	   },
	{ 8,	14*147	   },
	{ 8,	14*148	   },
	{ 8,	14*149	   },
	{ 8,	14*150	   },
	{ 8,	14*151	   },
	{ 8,	14*152	   },
	{ 8,	14*153	   },
	{ 8,	14*154	   },
	{ 8,	14*155	   },
	{ 8,	14*156	   },
	{ 8,	14*157	   },
	{ 8,	14*158	   },
	{ 8,	14*159	   },
	{ 8,	14*160	   },
	{ 8,	14*161	   },
	{ 8,	14*162	   },
	{ 8,	14*163	   },
	{ 8,	14*164	   },
	{ 8,	14*165	   },
	{ 8,	14*166	   },
	{ 8,	14*167	   },
	{ 8,	14*168	   },
	{ 8,	14*169	   },
	{ 8,	14*170	   },
	{ 8,	14*171	   },
	{ 8,	14*172	   },
	{ 8,	14*173	   },
	{ 8,	14*174	   },
	{ 8,	14*175	   },
	{ 8,	14*176	   },
	{ 8,	14*177	   },
	{ 8,	14*178	   },
	{ 8,	14*179	   },
	{ 8,	14*180	   },
	{ 8,	14*181	   },
	{ 8,	14*182	   },
	{ 8,	14*183	   },
	{ 8,	14*184	   },
	{ 8,	14*185	   },
	{ 8,	14*186	   },
	{ 8,	14*187	   },
	{ 8,	14*188	   },
	{ 8,	14*189	   },
	{ 8,	14*190	   },
	{ 8,	14*191	   },
	{ 8,	14*192	   },
	{ 8,	14*193	   },
	{ 8,	14*194	   },
	{ 8,	14*195	   },
	{ 8,	14*196	   },
	{ 8,	14*197	   },
	{ 8,	14*198	   },
	{ 8,	14*199	   },
	{ 8,	14*200	   },
	{ 8,	14*201	   },
	{ 8,	14*202	   },
	{ 8,	14*203	   },
	{ 8,	14*204	   },
	{ 8,	14*205	   },
	{ 8,	14*206	   },
	{ 8,	14*207	   },
	{ 8,	14*208	   },
	{ 8,	14*209	   },
	{ 8,	14*210	   },
	{ 8,	14*211	   },
	{ 8,	14*212	   },
	{ 8,	14*213	   },
	{ 8,	14*214	   },
	{ 8,	14*215	   },
	{ 8,	14*216	   },
	{ 8,	14*217	   },
	{ 8,	14*218	   },
	{ 8,	14*219	   },
	{ 8,	14*220	   },
	{ 8,	14*221	   },
	{ 8,	14*222	   },
	{ 8,	14*223	   },
	{ 8,	14*224	   },
	{ 8,	14*225	   },
	{ 8,	14*226	   },
	{ 8,	14*227	   },
	{ 8,	14*228	   },
	{ 8,	14*229	   },
	{ 8,	14*230	   },
	{ 8,	14*231	   },
	{ 8,	14*232	   },
	{ 8,	14*233	   },
	{ 8,	14*234	   },
	{ 8,	14*235	   },
	{ 8,	14*236	   },
	{ 8,	14*237	   },
	{ 8,	14*238	   },
	{ 8,	14*239	   },
	{ 8,	14*240	   },
	{ 8,	14*241	   },
	{ 8,	14*242	   },
	{ 8,	14*243	   },
	{ 8,	14*244	   },
	{ 8,	14*245	   },
	{ 8,	14*246	   },
	{ 8,	14*247	   },
	{ 8,	14*248	   },
	{ 8,	14*249	   },
	{ 8,	14*250	   },
	{ 8,	14*251	   },
	{ 8,	14*252	   },
	{ 8,	14*253	   },
	{ 8,	14*254	   },
	{ 8,	14*255	   }
    }
};

