/**
 ** VGA8X.C ---- the 256 color VGA mode X frame driver
 **
 ** Copyright (c) 1995 Csaba Biegl, 820 Stirrup Dr, Nashville, TN 37221
 ** [e-mail: csaba@vuse.vanderbilt.edu] See "doc/copying.cb" for details.
 **/

#include "grdriver.h"
#include "libgrx.h"
#include "arith.h"
#include "mempeek.h"
#include "ioport.h"
#include "vgaregs.h"

static
#ifdef __GNUC__
inline
#endif
long readpixel(GrFrame *c,int x,int y)
{
	outport_w(VGA_GR_CTRL_PORT,(((x & 3) << 8) | VGA_RD_PLANE_SEL_REG));
	setup_far_selector(c->gf_selector);
	return((uchar)peek_b_f(&c->gf_baseaddr[0][(y * c->gf_lineoffset) + (x >> 2)]));
}

static
#ifdef __GNUC__
inline
#endif
void drawpixel(int x,int y,long color)
{
	char far *ptr = &CURC->gc_baseaddr[0][(y * CURC->gc_lineoffset) + (x >> 2)];
	outport_w(VGA_SEQUENCER_PORT,((0x100 << (x & 3)) | VGA_WRT_PLANE_ENB_REG));
	setup_far_selector(CURC->gc_selector);
	switch(C_OPER(color)) {
	  case C_XOR:
	    outport_w(VGA_GR_CTRL_PORT,(((x & 3) << 8) | VGA_RD_PLANE_SEL_REG));
	    poke_b_f_xor(ptr,(uchar)color);
	    break;
	  case C_OR:
	    outport_w(VGA_GR_CTRL_PORT,(((x & 3) << 8) | VGA_RD_PLANE_SEL_REG));
	    poke_b_f_or( ptr,(uchar)color);
	    break;
	  case C_AND:
	    outport_w(VGA_GR_CTRL_PORT,(((x & 3) << 8) | VGA_RD_PLANE_SEL_REG));
	    poke_b_f_and(ptr,(uchar)color);
	    break;
	  default:
	    poke_b_f(ptr,(uchar)color);
	    break;
	}
}

static
#include "fdrivers/generic/hline.c"

static
#include "fdrivers/generic/vline.c"

static
#include "fdrivers/generic/block.c"

static
#include "fdrivers/generic/line.c"

static
#include "fdrivers/generic/bitmap.c"

static
#include "fdrivers/generic/pattern.c"

static
#include "fdrivers/generic/bitblt.c"

GrFrameDriver _GrFrameDriverVGA8X = {
    GR_frameVGA8X,		/* frame mode */
    GR_frameRAM8,		/* compatible RAM frame mode */
    TRUE,			/* onscreen */
    2,				/* scan line width alignment */
    4,				/* number of planes */
    8,				/* bits per pixel */
    64*1024L,			/* max plane size the code can handle */
    NULL,
    readpixel,
    drawpixel,
    drawline,
    drawhline,
    drawvline,
    drawblock,
    drawbitmap,
    drawpattern,
    bitblt,
    _GrFrDrvGenericBitBlt,
    _GrFrDrvGenericBitBlt
};

