/**
 ** RAM32H.C ---- the 16M color padded system RAM frame driver (high)
 **
 ** Copyright (c) 1995 Csaba Biegl, 820 Stirrup Dr, Nashville, TN 37221
 ** [e-mail: csaba@vuse.vanderbilt.edu] See "doc/copying.cb" for details.
 **/

#include "grdriver.h"
#include "libgrx.h"
#include "mempeek.h"

static
#ifdef __GNUC__
inline
#endif
long readpixel(GrFrame *c,int x,int y)
{
	char far *ptr = &c->gf_baseaddr[0][(y * c->gf_lineoffset) + (x << 2)];
	return((ulong)peek_l(ptr) >> 8);
}

static
#ifdef __GNUC__
inline
#endif
void drawpixel(int x,int y,long color)
{
	char far *ptr = &CURC->gc_baseaddr[0][(y * CURC->gc_lineoffset) + (x << 2)];
	int op = C_OPER(color);
	color <<= 8;
	switch(op) {
	    case C_XOR: poke_l_xor(ptr,color); break;
	    case C_OR:  poke_l_or(ptr,color);  break;
	    case C_AND: poke_l_and(ptr,color); break;
	    default:    poke_l(ptr,color);     break;
	}
}

static
#include "fdrivers/generic/hline.c"

static
#include "fdrivers/generic/vline.c"

static
#include "fdrivers/generic/block.c"

static
#include "fdrivers/generic/line.c"

static
#include "fdrivers/generic/bitmap.c"

static
#include "fdrivers/generic/pattern.c"

static void bitblt(GrFrame *dst,int dx,int dy,GrFrame *src,int sx,int sy,int w,int h,long op)
{
	if(GrColorMode(op) == GrIMAGE) _GrFrDrvGenericBitBlt(
	    dst,dx,dy,
	    src,sx,sy,
	    w,h,
	    op
	);
	else _GrFrDrvPackedBitBltR2R(
	    dst,(dx << 2),dy,
	    src,(sx << 2),sy,
	    (w << 2),h,
	    op
	);
}

GrFrameDriver _GrFrameDriverRAM32H = {
    GR_frameRAM32H,		/* frame mode */
    GR_frameUndef,		/* compatible RAM frame mode */
    FALSE,			/* onscreen */
    4,				/* scan line width alignment */
    1,				/* number of planes */
    32,				/* bits per pixel */
#ifdef __TURBOC__
    65520L,			/* max plane size the code can handle */
#else
    32*16*1024L*1024L,		/* max plane size the code can handle */
#endif
    NULL,
    readpixel,
    drawpixel,
    drawline,
    drawhline,
    drawvline,
    drawblock,
    drawbitmap,
    drawpattern,
    bitblt,
    NULL,
    NULL,
};

