// Copyright Kjell Schubert unbu@rz.uni-karlsruhe.de

#include <string.h>
#include "device/vesadrv.h"
#include "gfx/bitmap.h"
#include "gfx/fastmem.h"
#include "misc/error.h"
#include "misc/template.h"


// like FastMemBlockCopy, but the end ptrs are returned.
#ifdef __WATCOMC__
void FastMemBlockCopy_End(UBYTE* &DstPtr,UBYTE* &SrcPtr,int RectWidth,int DstDiff,int SrcDiff,int RectHeight);   
#pragma aux FastMemBlockCopy_End =\
  "              push ebp"\
  "              push edi"\
  "              push esi"\
  "              mov edi,[edi]"\
  "              mov esi,[esi]"\
  "              cmp      ecx,00000007H"\
  "              je      End"\
  "              jle     near ptr Loop7"\
  "              mov     ebp,ecx"\
  "              sar     ecx,02H"\  
  "LoopBig:      test    edi,01H"\
  "              je      short L2"\
  "              movsb"\
  "L2:           test    edi,02H"\
  "              je      short L3"\
  "              movsw"\
  "L3:           push    ecx"\
  "              repe    movsd"\
  "              pop     ecx"\
  "              test    ebp,02H"\
  "              je      short L4"\
  "              movsw"\
  "L4:           test    ebp,01H"\
  "              je      short L5"\
  "              movsb"\
  "L5:           add     edi,eax"\
  "              add     esi,ebx"\
  "              dec     edx" \
  "              jne     LoopBig"\
  "              jmp     End"\
 "Loop7:                    "\
  "              test    ecx,04H"\
  "              je      short L7"\
  "              movsd"\
  "L7:           test    ecx,02H"\
  "              je      short L8"\
  "              movsw"\
  "L8:           test    edi,01H"\
  "              je      short L9"\
  "              movsb"\
  "L9:           add     edi,eax"\
  "              add     esi,ebx"\
  "              dec     edx"\
  "              jne     short Loop7"\
  "End:          "\
  "              pop ecx"\
  "              pop edx"\
  "              mov [ecx],esi"\
  "              mov [edx],edi"\
  "              pop ebp"\
  parm [edi] [esi] [ecx] [eax] [ebx] [edx] 
#else
inline void FastMemBlockCopy_End(UBYTE* &DstPtr,UBYTE* &SrcPtr,int RectWidth,int DstDiff,int SrcDiff,int RectHeight)
  {
  if (RectWidth>7)
    {
    const int DWORDAlignBytes=(4-((int)DstPtr))&3;
    RectWidth-=DWORDAlignBytes;
    const int DWORDs=RectWidth>>2; 
    const int RectWidthMasked=RectWidth&(~3);
    while (RectHeight--)
      {
      if (DWORDAlignBytes&2) { *((WORD*)(DstPtr))=*((WORD*)(SrcPtr));DstPtr+=2;SrcPtr+=2; }
      if (DWORDAlignBytes&1) { *((BYTE*)(DstPtr))=*((BYTE*)(SrcPtr));DstPtr+=1;SrcPtr+=1; }
      int DWORDsToGo=DWORDs;
      while (DWORDsToGo--) { *((DWORD*)(DstPtr))=*((DWORD*)(SrcPtr));DstPtr+=4;SrcPtr+=4; }
      DstPtr+=RectWidthMasked;
      SrcPtr+=RectWidthMasked;
      if (RectWidth&2) { *((WORD*)(DstPtr))=*((WORD*)(SrcPtr));DstPtr+=2;SrcPtr+=2; }
      if (RectWidth&1) { *((BYTE*)(DstPtr))=*((BYTE*)(SrcPtr));DstPtr+=1;SrcPtr+=1; }
      DstPtr+=DstDiff;
      SrcPtr+=SrcDiff;
      }
    }
  else
    {
    while (RectHeight--)
      {
      if (RectWidth&4) { *((DWORD*)(DstPtr))=*((DWORD*)(SrcPtr));DstPtr+=4;SrcPtr+=4; }
      if (RectWidth&2) { *((WORD*)(DstPtr))=*((WORD*)(SrcPtr));DstPtr+=2;SrcPtr+=2; }
      if (RectWidth&1) { *((BYTE*)(DstPtr))=*((BYTE*)(SrcPtr));DstPtr+=1;SrcPtr+=1; }
      DstPtr+=DstDiff;
      SrcPtr+=SrcDiff;
      }
    }
  }
#endif


inline void VideoDriver::virtualwinswitch(int Win)
  {
//!!!!!! future: call pm handler (VBE2.0)
  if (Win!=currentvirtualwin)
    {
    union REGS regs;
    regs.w.ax=0x4f05;
    regs.w.bx=(WORD)usedwinAB;
    regs.w.dx=(WORD)(Win<<virtualwin2win);
    int386(0x10,&regs,&regs);
    currentvirtualwin=Win;
    }
  }


void BlitToScreenInvalid(VideoDriver&,int,int,Bitmap&,const Rect&)
  {
  ErrorHandler.Abort("VideoDriver::BlitToScreen  invalid bitmap/videomode or mode not included (see #define VIDEOSUPPORT_*).");
  }
#ifdef VIDEOSUPPORT_PP8L
void BlitToScreenPP8L(VideoDriver &Video,int DstX,int DstY,Bitmap &Src,const Rect &SrcRect)
  {
  #ifdef DEBUG
  if (&Video.Palette()!=&Src.Palette()) ErrorHandler.Abort("VideoDriver::BlitToScreen()  can't blit bitmap with different palette.");
//!!!!!!!!!! check rect size
  #endif
  const int RectWidth=SrcRect.Width();
  const int RectHeight=SrcRect.Height();
  const int SrcDiff=Src.WidthBytes()-RectWidth;
  const int DstDiff=Video.widthbytes-RectWidth;
  UBYTE *DstPtr=Video.winptr+DstY*Video.widthbytes+DstX;
  UBYTE *SrcPtr=Src.Bits()+SrcRect.Top*Src.WidthBytes()+SrcRect.Left;
  FastMemBlockCopy(DstPtr,SrcPtr,RectWidth,DstDiff,SrcDiff,RectHeight);
  }
#endif

#ifdef VIDEOSUPPORT_PP8W
//!!!!!! with VESA2.0 I should use the protected mode bank switcher.
void BlitToScreenPP8W(VideoDriver &Video,int DstX,int DstY,Bitmap &Src,const Rect &SrcRect)
  {
  #ifdef DEBUG
  if (&Video.Palette()!=&Src.Palette()) ErrorHandler.Abort("VideoDriver::BlitToScreen()  can't blit bitmap with different palette.");
//!!!!!!!!!! check rect size
  #endif
  const int RectWidth=SrcRect.Width();
  const int RectHeight=SrcRect.Height();
  const int SrcDiff=Src.WidthBytes()-RectWidth;
  const int DstDiff=Video.widthbytes-RectWidth;
  UBYTE *SrcPtr=Src.Bits()+SrcRect.Top*Src.WidthBytes()+SrcRect.Left;
  long DstOffset=DstY*Video.widthbytes+DstX;
  const int EndY=DstY+RectHeight;
  // find the number of the window that we are in now
  int WinNr=DstOffset>>Video.offset2virtualwin;
  VideoDriver::VirtualWinInfo *WinInfo=&Video.virtualwininfo[WinNr];
  UBYTE *DstPtr=Video.winptr+DstOffset-WinInfo->StartOffset;
  Video.virtualwinswitch(WinNr);
  int SwitchY=WinInfo->LastY;
  while (DstY<EndY)
    {
    int FullLinesToGo=Min(SwitchY,EndY)-DstY;
    if (FullLinesToGo!=0)
      {
      // copy all scanlines that are fully in one virtual window
      UBYTE *EndDstPtr=DstPtr,*EndSrcPtr=SrcPtr; // better optimized by Watcom
      FastMemBlockCopy_End(EndDstPtr,EndSrcPtr,RectWidth,DstDiff,SrcDiff,FullLinesToGo);
      DstPtr=EndDstPtr;
      SrcPtr=EndSrcPtr;
      DstY=SwitchY;
      }
    if (DstY>=EndY) break;
    // now copy that part of the next scanline that is still in the
    // current window.
    int BytesToGo=WinInfo->Pixels-DstX; // last pixels in this window
    if (BytesToGo>0)
      {
      if (BytesToGo>RectWidth) BytesToGo=RectWidth;
      FastMemCpy(DstPtr,SrcPtr,BytesToGo);
      SrcPtr+=BytesToGo;
      DstPtr+=BytesToGo;
      }
    // window switching
    WinNr++;
    WinInfo++;
    Video.virtualwinswitch(WinNr);
    DstPtr-=Video.virtualwinbytes;
    SwitchY=WinInfo->LastY;
    // now copy the rest of the current scanline that is already in the new window
    BytesToGo=RectWidth-BytesToGo; // in the new window
    if (BytesToGo>0)
      {
      if (BytesToGo>RectWidth) BytesToGo=RectWidth;
      FastMemCpy(DstPtr,SrcPtr,BytesToGo);
      SrcPtr+=BytesToGo;
      DstPtr+=BytesToGo;
      }
    SrcPtr+=SrcDiff;
    DstPtr+=DstDiff;
    DstY++;
    }
  }
#endif

#if defined(VIDEOSUPPORT_DC565) || defined(VIDEOSUPPORT_DC1555)
#error "DC565/1555 not yet implemented"
void BlitToScreenDC565(VideoDriver &Video,int DstX,int DstY,Bitmap &Src,const Rect &SrcRect)
  {
  }
#endif

#ifdef VIDEOSUPPORT_DC888
#error "DC888 not yet implemented"
void BlitToScreenDC888(VideoDriver &Video,int DstX,int DstY,Bitmap &Src,const Rect &SrcRect)
  {
  }
#endif
