// Copyright Kjell Schubert unbu@rz.uni-karlsruhe.de

// Animate several polygons.

#include <stdlib.h>
#include <iostream.h>
#include "device/keyboard.h"
#include "device/vesadrv.h"
#include "device/timer.h"
#include "gfx/bitmap.h"
#include "gfx/blit.h"
#include "gfx/poly.h"
#include "poly.h"

const int TrianglesOnX=4,TrianglesOnY=4;

int i=0;
main()
  {
  // print all available video modes
  // let the user choose a video mode
  cout << "\nVideo mode list:\nmodeID   width x height x colors\n";
  for (int ModeIndex=0;ModeIndex<Video.SupportedModes();ModeIndex++)
    {
    int ModeID=Video.SupportedMode(ModeIndex);
    VideoDriver::ModeInfo Mode=Video.GetModeInfo(ModeID);
    cout.setf(ios::left);
    cout.width(5);
    cout << ModeID << "   " << Mode.Width << 'x' << Mode.Height << 'x' << (1<<Mode.BitsPerPixel) << '\n';
    }
  int DesiredModeID;
  cin >> DesiredModeID;
  if (cin.fail())ErrorHandler.Abort("Wrong number.\n");
  if (!Video.IsSupportedMode(DesiredModeID)) ErrorHandler.Abort("This video mode is not supported by your graphic card.\n");
  VideoDriver::ModeInfo Mode=Video.GetModeInfo(DesiredModeID);
  if (Mode.BitsPerPixel!=8) ErrorHandler.Abort("Only functions for 256 color modes (S)VGA are implemented in this version of GLIB.");
  // init the video mode
  if (Video.SetMode(DesiredModeID)!=0) ErrorHandler.Abort("This mode is not supported by the graphic library. Only 256/32K/64K/16M color video modes are supported.");
  SystemTimer.TimeVal(20);
  // create a palette that is compatible to the screen palette and
  // contains the colors we want (just reddish colors): 
  Palette &MyPalette=*new Palette(Video.Palette().ClassID(),Video.Palette().Colors());
  if (MyPalette.ClassID()==Palette::ClassColorArray) // otherwise the palette must belong to a true/hi color mode (colors are constant)
    for (int c=0;c<256;c++) MyPalette.SetColor(c,RGB8(c,0,0));
  MyPalette.SetFlags(Palette::AutoDelete); // delete Palette automatically if it is no longer used by a bitmap
  // create an off screen buffer 
  Bitmap HiddenScreen(Video.Width(),Video.Height(),Video.ClassID());
  // off screen buffer and screen shall use the same palette
  HiddenScreen.UsePalette(MyPalette);
  Video.UsePalette(MyPalette);
  // create a polygon and init it
  const int Triangles=TrianglesOnX*TrianglesOnY;
  AnimatedTriangle Triangle[Triangles];
  {
  const int xDiff=Video.Width()/TrianglesOnX/2;
  const int yDiff=Video.Height()/TrianglesOnY/2;
  const int xSize=Video.Width()/2+xDiff-1;
  const int ySize=Video.Height()/2+yDiff-1;
  int Index=0;
  for (int x=0;x<TrianglesOnX;x++)
    for (int y=0;y<TrianglesOnY;y++)
      {
      const int x0=x*xDiff;
      const int y0=y*yDiff;
      Triangle[Index].SetBorder(Rect(x0,y0,x0+xSize,y0+ySize));
      Triangle[Index].Color(HiddenScreen.Palette().GetPaletteIndex(RGB8(128+127*Index/Triangles,0,0))); // precompute the proper palette index (saves time in the main loop)
      Index++;
      }
  }
  // draw and move the polygons
  long Frames=0;
  int StartTime=SystemTimer.Time();
  const Rect FullRect(0,0,Video.Width()-1,Video.Height()-1);
  do
    {
    const int Time=SystemTimer.Time();
    FillRect(HiddenScreen,FullRect,0); // clear off screen buffer
    for (int Index=0;Index<Triangles;Index++) 
      {
      Triangle[Index].Move(Time);
      FillPoly(HiddenScreen,Triangle[Index],Triangle[Index].Color());
      }
    Video.BlitToScreen(0,0,HiddenScreen,FullRect);
    Frames++;
    }
  while (!Keyboard.WasPressed(KeyboardDriver::Escape));
  Video.RestoreInitialMode();
  int dTime=SystemTimer.Time()-StartTime;
  if (dTime) cout << ((float)Frames)/dTime*1000 << " fps.\n";
  return(0);
  }
