This is gdbint.info, produced by Makeinfo version 3.12f from
./gdbint.texinfo.

START-INFO-DIR-ENTRY
* Gdb-Internals: (gdbint).	The GNU debugger's internals.
END-INFO-DIR-ENTRY

   This file documents the internals of the GNU debugger GDB.

   Copyright 1990-1999 Free Software Foundation, Inc.  Contributed by
Cygnus Solutions.  Written by John Gilmore.  Second Edition by Stan
Shebs.

   Permission is granted to make and distribute verbatim copies of this
manual provided the copyright notice and this permission notice are
preserved on all copies.

   Permission is granted to copy or distribute modified versions of this
manual under the terms of the GPL (for which purpose this text may be
regarded as a program in the language TeX).


File: gdbint.info,  Node: Support Libraries,  Next: Coding,  Prev: Native Debugging,  Up: Top

Support Libraries
*****************

BFD
===

   BFD provides support for GDB in several ways:

_identifying executable and core files_
     BFD will identify a variety of file types, including a.out, coff,
     and several variants thereof, as well as several kinds of core
     files.

_access to sections of files_
     BFD parses the file headers to determine the names, virtual
     addresses, sizes, and file locations of all the various named
     sections in files (such as the text section or the data section).
     GDB simply calls BFD to read or write section X at byte offset Y
     for length Z.

_specialized core file support_
     BFD provides routines to determine the failing command name stored
     in a core file, the signal with which the program failed, and
     whether a core file matches (i.e. could be a core dump of) a
     particular executable file.

_locating the symbol information_
     GDB uses an internal interface of BFD to determine where to find
     the symbol information in an executable file or symbol-file.  GDB
     itself handles the reading of symbols, since BFD does not
     "understand" debug symbols, but GDB uses BFD's cached information
     to find the symbols, string table, etc.

opcodes
=======

   The opcodes library provides GDB's disassembler.  (It's a separate
library because it's also used in binutils, for `objdump').

readline
========

mmalloc
=======

libiberty
=========

gnu-regex
=========

   Regex conditionals.

`C_ALLOCA'

`NFAILURES'

`RE_NREGS'

`SIGN_EXTEND_CHAR'

`SWITCH_ENUM_BUG'

`SYNTAX_TABLE'

`Sword'

`sparc'
include
=======


File: gdbint.info,  Node: Coding,  Next: Porting GDB,  Prev: Support Libraries,  Up: Top

Coding
******

   This chapter covers topics that are lower-level than the major
algorithms of GDB.

Cleanups
========

   Cleanups are a structured way to deal with things that need to be
done later.  When your code does something (like `malloc' some memory,
or open a file) that needs to be undone later (e.g. free the memory or
close the file), it can make a cleanup.  The cleanup will be done at
some future point: when the command is finished, when an error occurs,
or when your code decides it's time to do cleanups.

   You can also discard cleanups, that is, throw them away without doing
what they say.  This is only done if you ask that it be done.

   Syntax:

`struct cleanup *OLD_CHAIN;'
     Declare a variable which will hold a cleanup chain handle.

`OLD_CHAIN = make_cleanup (FUNCTION, ARG);'
     Make a cleanup which will cause FUNCTION to be called with ARG (a
     `char *') later.  The result, OLD_CHAIN, is a handle that can be
     passed to `do_cleanups' or `discard_cleanups' later.  Unless you
     are going to call `do_cleanups' or `discard_cleanups' yourself,
     you can ignore the result from `make_cleanup'.

`do_cleanups (OLD_CHAIN);'
     Perform all cleanups done since `make_cleanup' returned OLD_CHAIN.
     E.g.:
          make_cleanup (a, 0);
          old = make_cleanup (b, 0);
          do_cleanups (old);

     will call `b()' but will not call `a()'.  The cleanup that calls
     `a()' will remain in the cleanup chain, and will be done later
     unless otherwise discarded.

`discard_cleanups (OLD_CHAIN);'
     Same as `do_cleanups' except that it just removes the cleanups from
     the chain and does not call the specified functions.

   Some functions, e.g. `fputs_filtered()' or `error()', specify that
they "should not be called when cleanups are not in place".  This means
that any actions you need to reverse in the case of an error or
interruption must be on the cleanup chain before you call these
functions, since they might never return to your code (they `longjmp'
instead).

Wrapping Output Lines
=====================

   Output that goes through `printf_filtered' or `fputs_filtered' or
`fputs_demangled' needs only to have calls to `wrap_here' added in
places that would be good breaking points.  The utility routines will
take care of actually wrapping if the line width is exceeded.

   The argument to `wrap_here' is an indentation string which is
printed _only_ if the line breaks there.  This argument is saved away
and used later.  It must remain valid until the next call to
`wrap_here' or until a newline has been printed through the
`*_filtered' functions.  Don't pass in a local variable and then return!

   It is usually best to call `wrap_here()' after printing a comma or
space.  If you call it before printing a space, make sure that your
indentation properly accounts for the leading space that will print if
the line wraps there.

   Any function or set of functions that produce filtered output must
finish by printing a newline, to flush the wrap buffer, before switching
to unfiltered ("`printf'") output.  Symbol reading routines that print
warnings are a good example.

GDB Coding Standards
====================

   GDB follows the GNU coding standards, as described in
`etc/standards.texi'.  This file is also available for anonymous FTP
from GNU archive sites.  GDB takes a strict interpretation of the
standard; in general, when the GNU standard recommends a practice but
does not require it, GDB requires it.

   GDB follows an additional set of coding standards specific to GDB,
as described in the following sections.

   You can configure with `--enable-build-warnings' to get GCC to check
on a number of these rules.  GDB sources ought not to engender any
complaints, unless they are caused by bogus host systems.  (The exact
set of enabled warnings is currently `-Wall -Wpointer-arith
-Wstrict-prototypes -Wmissing-prototypes -Wmissing-declarations'.

Formatting
----------

   The standard GNU recommendations for formatting must be followed
strictly.

   Note that while in a definition, the function's name must be in
column zero; in a function declaration, the name must be on the same
line as the return type.

   In addition, there must be a space between a function or macro name
and the opening parenthesis of its argument list (except for macro
definitions, as required by C).  There must not be a space after an open
paren/bracket or before a close paren/bracket.

   While additional whitespace is generally helpful for reading, do not
use more than one blank line to separate blocks, and avoid adding
whitespace after the end of a program line (as of 1/99, some 600 lines
had whitespace after the semicolon).  Excess whitespace causes
difficulties for diff and patch.

Comments
--------

   The standard GNU requirements on comments must be followed strictly.

   Block comments must appear in the following form, with no `/*'- or
'*/'-only lines, and no leading `*':

     /* Wait for control to return from inferior to debugger.  If inferior
        gets a signal, we may decide to start it up again instead of
        returning.  That is why there is a loop in this function.  When
        this function actually returns it means the inferior should be left
        stopped and GDB should read more commands.  */

   (Note that this format is encouraged by Emacs; tabbing for a
multi-line comment works correctly, and M-Q fills the block
consistently.)

   Put a blank line between the block comments preceding function or
variable definitions, and the definition itself.

   In general, put function-body comments on lines by themselves, rather
than trying to fit them into the 20 characters left at the end of a
line, since either the comment or the code will inevitably get longer
than will fit, and then somebody will have to move it anyhow.

C Usage
-------

   Code must not depend on the sizes of C data types, the format of the
host's floating point numbers, the alignment of anything, or the order
of evaluation of expressions.

   Use functions freely.  There are only a handful of compute-bound
areas in GDB that might be affected by the overhead of a function call,
mainly in symbol reading.  Most of GDB's performance is limited by the
target interface (whether serial line or system call).

   However, use functions with moderation.  A thousand one-line
functions are just as hard to understand as a single thousand-line
function.

Function Prototypes
-------------------

   Prototypes must be used to _declare_ functions, and may be used to
_define_ them.  Prototypes for GDB functions must include both the
argument type and name, with the name matching that used in the actual
function definition.

   All external functions should have a declaration in a header file
that callers include, except for `_initialize_*' functions, which must
be external so that `init.c' construction works, but shouldn't be
visible to random source files.

   All static functions must be declared in a block near the top of the
source file.

Clean Design
------------

   In addition to getting the syntax right, there's the little question
of semantics.  Some things are done in certain ways in GDB because long
experience has shown that the more obvious ways caused various kinds of
trouble.

   You can't assume the byte order of anything that comes from a target
(including VALUEs, object files, and instructions).  Such things must
be byte-swapped using `SWAP_TARGET_AND_HOST' in GDB, or one of the swap
routines defined in `bfd.h', such as `bfd_get_32'.

   You can't assume that you know what interface is being used to talk
to the target system.  All references to the target must go through the
current `target_ops' vector.

   You can't assume that the host and target machines are the same
machine (except in the "native" support modules).  In particular, you
can't assume that the target machine's header files will be available
on the host machine.  Target code must bring along its own header files
- written from scratch or explicitly donated by their owner, to avoid
copyright problems.

   Insertion of new `#ifdef''s will be frowned upon.  It's much better
to write the code portably than to conditionalize it for various
systems.

   New `#ifdef''s which test for specific compilers or manufacturers or
operating systems are unacceptable.  All `#ifdef''s should test for
features.  The information about which configurations contain which
features should be segregated into the configuration files.  Experience
has proven far too often that a feature unique to one particular system
often creeps into other systems; and that a conditional based on some
predefined macro for your current system will become worthless over
time, as new versions of your system come out that behave differently
with regard to this feature.

   Adding code that handles specific architectures, operating systems,
target interfaces, or hosts, is not acceptable in generic code.  If a
hook is needed at that point, invent a generic hook and define it for
your configuration, with something like:

     #ifdef	WRANGLE_SIGNALS
        WRANGLE_SIGNALS (signo);
     #endif

   In your host, target, or native configuration file, as appropriate,
define `WRANGLE_SIGNALS' to do the machine-dependent thing.  Take a bit
of care in defining the hook, so that it can be used by other ports in
the future, if they need a hook in the same place.

   If the hook is not defined, the code should do whatever "most"
machines want.  Using `#ifdef', as above, is the preferred way to do
this, but sometimes that gets convoluted, in which case use

     #ifndef SPECIAL_FOO_HANDLING
     #define SPECIAL_FOO_HANDLING(pc, sp) (0)
     #endif

   where the macro is used or in an appropriate header file.

   Whether to include a "small" hook, a hook around the exact pieces of
code which are system-dependent, or whether to replace a whole function
with a hook depends on the case.  A good example of this dilemma can be
found in `get_saved_register'.  All machines that GDB 2.8 ran on just
needed the `FRAME_FIND_SAVED_REGS' hook to find the saved registers.
Then the SPARC and Pyramid came along, and `HAVE_REGISTER_WINDOWS' and
`REGISTER_IN_WINDOW_P' were introduced.  Then the 29k and 88k required
the `GET_SAVED_REGISTER' hook.  The first three are examples of small
hooks; the latter replaces a whole function.  In this specific case, it
is useful to have both kinds; it would be a bad idea to replace all the
uses of the small hooks with `GET_SAVED_REGISTER', since that would
result in much duplicated code.  Other times, duplicating a few lines
of code here or there is much cleaner than introducing a large number
of small hooks.

   Another way to generalize GDB along a particular interface is with an
attribute struct.  For example, GDB has been generalized to handle
multiple kinds of remote interfaces - not by #ifdef's everywhere, but
by defining the "target_ops" structure and having a current target (as
well as a stack of targets below it, for memory references).  Whenever
something needs to be done that depends on which remote interface we are
using, a flag in the current target_ops structure is tested (e.g.
`target_has_stack'), or a function is called through a pointer in the
current target_ops structure.  In this way, when a new remote interface
is added, only one module needs to be touched - the one that actually
implements the new remote interface.  Other examples of
attribute-structs are BFD access to multiple kinds of object file
formats, or GDB's access to multiple source languages.

   Please avoid duplicating code.  For example, in GDB 3.x all the code
interfacing between `ptrace' and the rest of GDB was duplicated in
`*-dep.c', and so changing something was very painful.  In GDB 4.x,
these have all been consolidated into `infptrace.c'.  `infptrace.c' can
deal with variations between systems the same way any
system-independent file would (hooks, #if defined, etc.), and machines
which are radically different don't need to use infptrace.c at all.

   Don't put debugging printfs in the code.


File: gdbint.info,  Node: Porting GDB,  Next: Testsuite,  Prev: Coding,  Up: Top

Porting GDB
***********

   Most of the work in making GDB compile on a new machine is in
specifying the configuration of the machine.  This is done in a
dizzying variety of header files and configuration scripts, which we
hope to make more sensible soon.  Let's say your new host is called an
XYZ (e.g.  `sun4'), and its full three-part configuration name is
`ARCH-XVEND-XOS' (e.g.  `sparc-sun-sunos4').  In particular:

   In the top level directory, edit `config.sub' and add ARCH, XVEND,
and XOS to the lists of supported architectures, vendors, and operating
systems near the bottom of the file.  Also, add XYZ as an alias that
maps to `ARCH-XVEND-XOS'.  You can test your changes by running

     ./config.sub XYZ

and
     ./config.sub `ARCH-XVEND-XOS'

which should both respond with `ARCH-XVEND-XOS' and no error messages.

   You need to port BFD, if that hasn't been done already.  Porting BFD
is beyond the scope of this manual.

   To configure GDB itself, edit `gdb/configure.host' to recognize your
system and set `gdb_host' to XYZ, and (unless your desired target is
already available) also edit `gdb/configure.tgt', setting `gdb_target'
to something appropriate (for instance, XYZ).

   Finally, you'll need to specify and define GDB's host-, native-, and
target-dependent `.h' and `.c' files used for your configuration.

Configuring GDB for Release
===========================

   From the top level directory (containing `gdb', `bfd', `libiberty',
and so on):
     make -f Makefile.in gdb.tar.gz

   This will properly configure, clean, rebuild any files that are
distributed pre-built (e.g. `c-exp.tab.c' or `refcard.ps'), and will
then make a tarfile.  (If the top level directory has already been
configured, you can just do `make gdb.tar.gz' instead.)

   This procedure requires:
   * symbolic links

   * `makeinfo' (texinfo2 level)

   * TeX

   * `dvips'

   * `yacc' or `bison'

... and the usual slew of utilities (`sed', `tar', etc.).

TEMPORARY RELEASE PROCEDURE FOR DOCUMENTATION
---------------------------------------------

   `gdb.texinfo' is currently marked up using the texinfo-2 macros,
which are not yet a default for anything (but we have to start using
them sometime).

   For making paper, the only thing this implies is the right
generation of `texinfo.tex' needs to be included in the distribution.

   For making info files, however, rather than duplicating the texinfo2
distribution, generate `gdb-all.texinfo' locally, and include the files
`gdb.info*' in the distribution.  Note the plural; `makeinfo' will
split the document into one overall file and five or so included files.


File: gdbint.info,  Node: Testsuite,  Next: Hints,  Prev: Porting GDB,  Up: Top

Testsuite
*********

   The testsuite is an important component of the GDB package.  While
it is always worthwhile to encourage user testing, in practice this is
rarely sufficient; users typically use only a small subset of the
available commands, and it has proven all too common for a change to
cause a significant regression that went unnoticed for some time.

   The GDB testsuite uses the DejaGNU testing framework.  DejaGNU is
built using tcl and expect.  The tests themselves are calls to various
tcl procs; the framework runs all the procs and summarizes the passes
and fails.

Using the Testsuite
===================

   To run the testsuite, simply go to the GDB object directory (or to
the testsuite's objdir) and type `make check'.  This just sets up some
environment variables and invokes DejaGNU's `runtest' script.  While
the testsuite is running, you'll get mentions of which test file is in
use, and a mention of any unexpected passes or fails.  When the
testsuite is finished, you'll get a summary that looks like this:
                     === gdb Summary ===
     
     # of expected passes            6016
     # of unexpected failures        58
     # of unexpected successes       5
     # of expected failures          183
     # of unresolved testcases       3
     # of untested testcases         5
   The ideal test run consists of expected passes only; however, reality
conspires to keep us from this ideal.  Unexpected failures indicate
real problems, whether in GDB or in the testsuite.  Expected failures
are still failures, but ones which have been decided are too hard to
deal with at the time; for instance, a test case might work everywhere
except on AIX, and there is no prospect of the AIX case being fixed in
the near future.  Expected failures should not be added lightly, since
you may be masking serious bugs in GDB.  Unexpected successes are
expected fails that are passing for some reason, while unresolved and
untested cases often indicate some minor catastrophe, such as the
compiler being unable to deal with a test program.

   When making any significant change to GDB, you should run the
testsuite before and after the change, to confirm that there are no
regressions.  Note that truly complete testing would require that you
run the testsuite with all supported configurations and a variety of
compilers; however this is more than really necessary.  In many cases
testing with a single configuration is sufficient.  Other useful
options are to test one big-endian (Sparc) and one little-endian (x86)
host, a cross config with a builtin simulator (powerpc-eabi, mips-elf),
or a 64-bit host (Alpha).

   If you add new functionality to GDB, please consider adding tests
for it as well; this way future GDB hackers can detect and fix their
changes that break the functionality you added.  Similarly, if you fix
a bug that was not previously reported as a test failure, please add a
test case for it.  Some cases are extremely difficult to test, such as
code that handles host OS failures or bugs in particular versions of
compilers, and it's OK not to try to write tests for all of those.

Testsuite Organization
======================

   The testsuite is entirely contained in `gdb/testsuite'.  While the
testsuite includes some makefiles and configury, these are very minimal,
and used for little besides cleaning up, since the tests themselves
handle the compilation of the programs that GDB will run.  The file
`testsuite/lib/gdb.exp' contains common utility procs useful for all
GDB tests, while the directory `testsuite/config' contains
configuration-specific files, typically used for special-purpose
definitions of procs like `gdb_load' and `gdb_start'.

   The tests themselves are to be found in `testsuite/gdb.*' and
subdirectories of those.  The names of the test files must always end
with `.exp'.  DejaGNU collects the test files by wildcarding in the
test directories, so both subdirectories and individual files get
chosen and run in alphabetical order.

   The following table lists the main types of subdirectories and what
they are for.  Since DejaGNU finds test files no matter where they are
located, and since each test file sets up its own compilation and
execution environment, this organization is simply for convenience and
intelligibility.

`gdb.base'
     This is the base testsuite.  The tests in it should apply to all
     configurations of GDB (but generic native-only tests may live
     here).  The test programs should be in the subset of C that is
     valid K&R, ANSI/ISO, and C++ (ifdefs are allowed if necessary, for
     instance for prototypes).

`gdb.LANG'
     Language-specific tests for all languages besides C.  Examples are
     `gdb.c++' and `gdb.java'.

`gdb.PLATFORM'
     Non-portable tests.  The tests are specific to a specific
     configuration (host or target), such as HP-UX or eCos.  Example is
     `gdb.hp', for HP-UX.

`gdb.COMPILER'
     Tests specific to a particular compiler.  As of this writing (June
     1999), there aren't currently any groups of tests in this category
     that couldn't just as sensibly be made platform-specific, but one
     could imagine a gdb.gcc, for tests of GDB's handling of GCC
     extensions.

`gdb.SUBSYSTEM'
     Tests that exercise a specific GDB subsystem in more depth.  For
     instance, `gdb.disasm' exercises various disassemblers, while
     `gdb.stabs' tests pathways through the stabs symbol reader.

Writing Tests
=============

   In many areas, the GDB tests are already quite comprehensive; you
should be able to copy existing tests to handle new cases.

   You should try to use `gdb_test' whenever possible, since it
includes cases to handle all the unexpected errors that might happen.
However, it doesn't cost anything to add new test procedures; for
instance, `gdb.base/exprs.exp' defines a `test_expr' that calls
`gdb_test' multiple times.

   Only use `send_gdb' and `gdb_expect' when absolutely necessary, such
as when GDB has several valid responses to a command.

   The source language programs do _not_ need to be in a consistent
style.  Since GDB is used to debug programs written in many different
styles, it's worth having a mix of styles in the testsuite; for
instance, some GDB bugs involving the display of source lines would
never manifest themselves if the programs used GNU coding style
uniformly.


File: gdbint.info,  Node: Hints,  Prev: Testsuite,  Up: Top

Hints
*****

   Check the `README' file, it often has useful information that does
not appear anywhere else in the directory.

* Menu:

* Getting Started::		Getting started working on GDB
* Debugging GDB::		Debugging GDB with itself


File: gdbint.info,  Node: Getting Started,  Up: Hints

Getting Started
===============

   GDB is a large and complicated program, and if you first starting to
work on it, it can be hard to know where to start.  Fortunately, if you
know how to go about it, there are ways to figure out what is going on.

   This manual, the GDB Internals manual, has information which applies
generally to many parts of GDB.

   Information about particular functions or data structures are
located in comments with those functions or data structures.  If you
run across a function or a global variable which does not have a
comment correctly explaining what is does, this can be thought of as a
bug in GDB; feel free to submit a bug report, with a suggested comment
if you can figure out what the comment should say.  If you find a
comment which is actually wrong, be especially sure to report that.

   Comments explaining the function of macros defined in host, target,
or native dependent files can be in several places.  Sometimes they are
repeated every place the macro is defined.  Sometimes they are where the
macro is used.  Sometimes there is a header file which supplies a
default definition of the macro, and the comment is there.  This manual
also documents all the available macros.

   Start with the header files.  Once you have some idea of how GDB's
internal symbol tables are stored (see `symtab.h', `gdbtypes.h'), you
will find it much easier to understand the code which uses and creates
those symbol tables.

   You may wish to process the information you are getting somehow, to
enhance your understanding of it.  Summarize it, translate it to another
language, add some (perhaps trivial or non-useful) feature to GDB, use
the code to predict what a test case would do and write the test case
and verify your prediction, etc.  If you are reading code and your eyes
are starting to glaze over, this is a sign you need to use a more active
approach.

   Once you have a part of GDB to start with, you can find more
specifically the part you are looking for by stepping through each
function with the `next' command.  Do not use `step' or you will
quickly get distracted; when the function you are stepping through
calls another function try only to get a big-picture understanding
(perhaps using the comment at the beginning of the function being
called) of what it does.  This way you can identify which of the
functions being called by the function you are stepping through is the
one which you are interested in.  You may need to examine the data
structures generated at each stage, with reference to the comments in
the header files explaining what the data structures are supposed to
look like.

   Of course, this same technique can be used if you are just reading
the code, rather than actually stepping through it.  The same general
principle applies--when the code you are looking at calls something
else, just try to understand generally what the code being called does,
rather than worrying about all its details.

   A good place to start when tracking down some particular area is
with a command which invokes that feature.  Suppose you want to know how
single-stepping works.  As a GDB user, you know that the `step' command
invokes single-stepping.  The command is invoked via command tables
(see `command.h'); by convention the function which actually performs
the command is formed by taking the name of the command and adding
`_command', or in the case of an `info' subcommand, `_info'.  For
example, the `step' command invokes the `step_command' function and the
`info display' command invokes `display_info'.  When this convention is
not followed, you might have to use `grep' or `M-x tags-search' in
emacs, or run GDB on itself and set a breakpoint in `execute_command'.

   If all of the above fail, it may be appropriate to ask for
information on `bug-gdb'.  But _never_ post a generic question like "I
was wondering if anyone could give me some tips about understanding
GDB"--if we had some magic secret we would put it in this manual.
Suggestions for improving the manual are always welcome, of course.


File: gdbint.info,  Node: Debugging GDB,  Up: Hints

Debugging GDB with itself
=========================

   If GDB is limping on your machine, this is the preferred way to get
it fully functional.  Be warned that in some ancient Unix systems, like
Ultrix 4.2, a program can't be running in one process while it is being
debugged in another.  Rather than typing the command `./gdb ./gdb',
which works on Suns and such, you can copy `gdb' to `gdb2' and then
type `./gdb ./gdb2'.

   When you run GDB in the GDB source directory, it will read a
`.gdbinit' file that sets up some simple things to make debugging gdb
easier.  The `info' command, when executed without a subcommand in a
GDB being debugged by gdb, will pop you back up to the top level gdb.
See `.gdbinit' for details.

   If you use emacs, you will probably want to do a `make TAGS' after
you configure your distribution; this will put the machine dependent
routines for your local machine where they will be accessed first by
`M-.'

   Also, make sure that you've either compiled GDB with your local cc,
or have run `fixincludes' if you are compiling with gcc.

Submitting Patches
==================

   Thanks for thinking of offering your changes back to the community of
GDB users.  In general we like to get well designed enhancements.
Thanks also for checking in advance about the best way to transfer the
changes.

   The GDB maintainers will only install "cleanly designed" patches.
This manual summarizes what we believe to be clean design for GDB.

   If the maintainers don't have time to put the patch in when it
arrives, or if there is any question about a patch, it goes into a
large queue with everyone else's patches and bug reports.

   The legal issue is that to incorporate substantial changes requires a
copyright assignment from you and/or your employer, granting ownership
of the changes to the Free Software Foundation.  You can get the
standard documents for doing this by sending mail to `gnu@gnu.org' and
asking for it.  We recommend that people write in "All programs owned
by the Free Software Foundation" as "NAME OF PROGRAM", so that changes
in many programs (not just GDB, but GAS, Emacs, GCC, etc) can be
contributed with only one piece of legalese pushed through the
bureacracy and filed with the FSF.  We can't start merging changes until
this paperwork is received by the FSF (their rules, which we follow
since we maintain it for them).

   Technically, the easiest way to receive changes is to receive each
feature as a small context diff or unidiff, suitable for "patch".  Each
message sent to me should include the changes to C code and header files
for a single feature, plus ChangeLog entries for each directory where
files were modified, and diffs for any changes needed to the manuals
(gdb/doc/gdb.texinfo or gdb/doc/gdbint.texinfo).  If there are a lot of
changes for a single feature, they can be split down into multiple
messages.

   In this way, if we read and like the feature, we can add it to the
sources with a single patch command, do some testing, and check it in.
If you leave out the ChangeLog, we have to write one.  If you leave out
the doc, we have to puzzle out what needs documenting.  Etc.

   The reason to send each change in a separate message is that we will
not install some of the changes.  They'll be returned to you with
questions or comments.  If we're doing our job correctly, the message
back to you will say what you have to fix in order to make the change
acceptable.  The reason to have separate messages for separate features
is so that the acceptable changes can be installed while one or more
changes are being reworked.  If multiple features are sent in a single
message, we tend to not put in the effort to sort out the acceptable
changes from the unacceptable, so none of the features get installed
until all are acceptable.

   If this sounds painful or authoritarian, well, it is.  But we get a
lot of bug reports and a lot of patches, and many of them don't get
installed because we don't have the time to finish the job that the bug
reporter or the contributor could have done.  Patches that arrive
complete, working, and well designed, tend to get installed on the day
they arrive.  The others go into a queue and get installed as time
permits, which, since the maintainers have many demands to meet, may not
be for quite some time.

   Please send patches directly to the GDB maintainers at
`gdb-patches@sourceware.cygnus.com'.

Obsolete Conditionals
=====================

   Fragments of old code in GDB sometimes reference or set the following
configuration macros.  They should not be used by new code, and old uses
should be removed as those parts of the debugger are otherwise touched.

`STACK_END_ADDR'
     This macro used to define where the end of the stack appeared, for
     use in interpreting core file formats that don't record this
     address in the core file itself.  This information is now
     configured in BFD, and GDB gets the info portably from there.  The
     values in GDB's configuration files should be moved into BFD
     configuration files (if needed there), and deleted from all of
     GDB's config files.

     Any `FOO-xdep.c' file that references STACK_END_ADDR is so old
     that it has never been converted to use BFD.  Now that's old!

`PYRAMID_CONTROL_FRAME_DEBUGGING'
     pyr-xdep.c

`PYRAMID_CORE'
     pyr-xdep.c

`PYRAMID_PTRACE'
     pyr-xdep.c

`REG_STACK_SEGMENT'
     exec.c


