// Palette
// =======
// The code here was taken from Mark Morely's VGL library.  Thank you Mark for
// placing it in the Public Domain.  It's helped me out a lot. :)
//
// I've made some changes to this code for my own personal benefits.  If you
// would like to real thing you can obtain it via FTP at suncad.camosun.bc.ca
// in the /pub/morley directory.  The file is named VGL20.ZIP.
//
// Scott A. Deming
// sad@umcc.umich.edu

#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <mem.h>

#include "gfxpal.h"

char    gfxPalette[768];

void    gfxSetPalette(int first, int number, char *palette)
{
    int     i;

    if (number < first) {
        return;
    }

    outp(0x03c8, first);

    i = 0;
    do {
        outp(0x03c9, palette[i++]);
        outp(0x03c9, palette[i++]);
        outp(0x03c9, palette[i++]);
        first++;
    } while (first < number);
}

void    gfxLoadPalette(char *palFName, char *palette)
{
    FILE    *pFile;
    char    palFilename[69];

    sprintf(palFilename, "%s", palFName);

    pFile = fopen(palFilename, "rb");
    if (pFile == 0) {
        return;
    }

    if (fread(palette, 1, 768, pFile) == 768) {
        gfxSetPalette(0, 255, palette);
    }

    fclose(pFile);
}

void    gfxSavePalette(char *palFile, char *palette)
{
    FILE    *pFile;

    pFile = fopen(palFile, "wb");
    if (pFile == 0) {
        return;
    }

    fwrite(palette, 1, 768, pFile);

    fclose(pFile);
}

void    gfxBlackPalette(char *palette)
{
    memset(palette, 0, 768 );
    gfxSetPalette(0, 255, palette);
}

void    gfxFadeIn(int first, int number, char *palette)
{
    int i, j;

    for (i=0; i<32; i++) {
        for (j=0; j<number*3; j++) {
            gfxPalette[j+first] =  (i * (unsigned)palette[j]) >> 5;
        }

        gfxSetPalette(first, number, gfxPalette);
   }
}

void    gfxFadeOut(int first, int number, char *palette)
{
    int i, j;

    for (i=31; i>=0; i--) {
        for (j=0; j<number*3; j++) {
            gfxPalette[j+first] =  (i * (unsigned)palette[j]) >> 5;
        }

        gfxSetPalette(first, number, gfxPalette);
   }
}

void    gfxCycleLeft(int first, int number, char far *palette)
{
    char    tmp[3];

    tmp[0] = palette[first*3];
    tmp[1] = palette[first*3+1];
    tmp[2] = palette[first*3+2];

    memmove(palette+(first*3), palette+((first+1)*3), number*3);

    palette[(first+number)*3] = tmp[0];
    palette[(first+number)*3+1] = tmp[1];
    palette[(first+number)*3+2] = tmp[2];

    gfxSetPalette(0, 255, palette);
}

void    gfxCycleRight(int first, int number, char *palette)
{
    char    tmp[3];

    tmp[0] = palette[(first+number)*3];
    tmp[1] = palette[(first+number)*3+1];
    tmp[2] = palette[(first+number)*3+2];

    memmove(palette+((first+1)*3), palette+(first*3), number*3);

    palette[first*3] = tmp[0];
    palette[first*3+1] = tmp[1];
    palette[first*3+2] = tmp[2];

    gfxSetPalette(0, 255, palette);
}
