/*$Author:   DCODY  $*/
/*$Date:   25 Jun 1992 23:21:50  $*/
/*$Header:   W:/sccs/inc/binary.h_v   1.1   25 Jun 1992 23:21:50   DCODY  $*/
/*$Log:   W:/sccs/inc/binary.h_v  $
 * 
 *    Rev 1.1   25 Jun 1992 23:21:50   DCODY
 * added generic SB mixer channel equates
 * 
 *    Rev 1.0   15 Jun 1992 09:58:34   BCRANE
 * Initial revision.
*/
/*$Logfile:   W:/sccs/inc/binary.h_v  $*/
/*$Modtimes$*/
/*$Revision:   1.1  $*/
/*$Workfile:   binary.h  $*/

    /*\
    |*|----====< BINARY.H >====----
    |*|
    |*| Copyright (c) 1991, Media Vision, Inc.	All Rights Reserved.
    |*|
    \*/

/*
// commands issued to the 2F interface
*/

#define BI_INSTALLCHECK 0		/* Check if the driver is installed */
#define BI_GETVERSION	1		/* Get the version #		    */
#define BI_GETSTATE	2		/* Get the state pointer and size   */
#define BI_GETFUNCTION	3		/* Get the function table pointer   */
#define BI_GETDMAIRQ	4		/* Get the DMA/IRQ/INT number	    */
#define BI_SENDCMD	5		/* reserved			    */
#define BI_GETSTATUSSTR 6		/* Get the status string	    */
#define BI_reserved1	7		/* reserved			    */
#define BI_reserved2	8		/* reserved			    */
#define BI_reserved3	9		/* reserved			    */
#define BI_SETSCANCODE	10		/* set the hot key scan codes	    */
#define BI_GETPATH	11		/* get the file path		    */

/*
// TRUE/FALSE & ON/OFF logic values
*/

#define BI_TRUE 	-1
#define BI_FALSE	0

#define BI_ON		BI_TRUE 	/* on state			    */
#define BI_OFF		BI_FALSE	/* off state			    */

#define BI_INT2FCODE1	0xBC		/* Bryan's initials                 */

/* int 2F ID (func 0) return register values				    */

#define BI_INT2FREGBX	0x6D00		/* 'm '                             */
#define BI_INT2FREGCX	0x0076		/* ' v'                             */
#define BI_INT2FREGDX	0x2020		/* UPPERCASE XOR MASK		    */

/*
// Command Block Structure
*/

	typedef struct {

	  unsigned int bc_blockID;	/* language command block	 (mandatory)  */

	  unsigned int bc_devcode;	/* device code (MIXER/VOLUME/CROSS/FILTER...) */

	  unsigned int bc_deviceselect; /* INPUT|OUTPUT mixer select & more...	      */

	  unsigned int bc_fromflag;	/* [FROM <term>] TRUE/FALSE		      */
	  unsigned int bc_fromtype;	/* type fromvalue is type # or %	      */
	  unsigned int bc_fromvalue;	/* value derived from <term>		      */

	  unsigned int bc_toflag;	/* [TO <term>] TRUE/FALSE	 (mandatory)  */
	  unsigned int bc_totype;	/* type fromvalue is type # or %	      */
	  unsigned int bc_tovalue;	/* value derived from <term>		      */

	  unsigned int breserved1;	/* reserved for internal use		      */

	  unsigned int bc_leftchflag;	/* set left channel  TRUE/FALSE 	      */
	  unsigned int bc_leftchannel;	/* left channel #			      */

	  unsigned int bc_ritchflag;	/* set right channel TRUE/FALSE 	      */
	  unsigned int bc_ritchannel;	/* right channel #			      */

	  unsigned int bc_secondsflag;	/* TRUE/FALSE to do it over time	      */
	  unsigned int bc_secondcount;	/* # of seconds to spread out the command     */

	  unsigned int breserved2;	/* reserved for internal use		      */

	  unsigned int bc_errorcode;	/* holds the error number		      */
	  unsigned long bc_targetstr;	/* user's target string pointer               */

	} cmdblk;

/*
// blockID Commands
*/

#define BI_RESETCMD	0		/* Reset the hardware settings		      */
#define BI_SETCMD	1		/* SET parsed language block		      */
#define BI_GETCMD	2		/* GET parsed language block		      */
#define BI_HOLDCMD	3		/* Hold the queue			      */
#define BI_RELCMD	4		/* Release the queue			      */

/*
// execode Commands
*/

#define BI_CROSSCMD	0		/* command is for the cross channel	      */
#define BI_FILTERCMD	1		/* command is for the filter		      */
#define BI_MIXERCMD	2		/* command is for the mixer		      */
#define BI_REALCMD	3		/* command is for the real sound switch       */
#define BI_VOLUMECMD	4		/* command is for the volume		      */

#define BI_LASTEXECMD	VOLUMECMD	/* Last valid command			      */

/*
// different logic flags for a TO condition (c_xxxxflag)
*/

#define BI_DONTSET	0		/* don't process FROM value                   */
#define BI_SETFROM	-1		/* FROM setting is available		      */
#define BI_SETTO	-1		/* TO setting is available (mandatory)	      */
#define BI_UPTO 	-2		/* set up from current setting		      */
#define BI_DOWNTO	-3		/* set down from current setting	      */

/*
// types of numeric data in FROM and TO fields (c_xxxxtype)
*/

#define BI_TYPEINT	1		/* "getterm" return type                      */
#define BI_TYPEPCT	2		/* "getterm" return type                      */

/*
// deviceselect values (c_deviceselect)
//
//	 (none for the filter)
*/

/*	 for mixers							    */

#define BI_OUTPUTMIXER	0x00		/* output mixer H/W select		      */
#define BI_INPUTMIXER	0x40		/* input mixer select			      */
#define BI_DEFMIXER	0xff		/* use the default mixer		      */

/*	 for cross channel						    */

#define BI_RIGHT2RIGHT	0x01		/* right to right			      */
#define BI_LEFT2RIGHT	0x02		/* left  to right			      */
#define BI_RIGHT2LEFT	0x04		/* right to left			      */
#define BI_LEFT2LEFT	0x08		/* left  to left			      */

/*	 for volume control						    */

#define BI_VOLLOUD	0x00		/* LOUDNESS switch			      */
#define BI_VOLENHANCE	0x01		/* ENHANCED stereo			      */
#define BI_VOLBASS	0x02		/* BASS (0-12)				      */
#define BI_VOLTREBLE	0x03		/* TREBLE (0-12)			      */
#define BI_VOLLEFT	0x04		/* LEFT VOLUME	(0-40)			      */
#define BI_VOLRIGHT	0x05		/* RIGHT VOLUME (0-40)			      */
#define BI_VOLMODE	0x06		/* MODE  (LEFT/STEREO/RIGHT)		      */

#define BI_bVOLLOUD	0x01		/* enhanced bass bit			      */
#define BI_bVOLENH	0x02		/* enhanced stereo bit			      */

/*
// left/right mixer channel selection
*/

/*	 left channel values						    */

#define BI_L_FM 	0x01
#define BI_L_IMIXER	0x02
#define BI_L_EXT	0x03
#define BI_L_INT	0x04
#define BI_L_MIC	0x05
#define BI_L_PCM	0x06
#define BI_L_SPEAKER	0x07
#define BI_L_SBDAC	0x00

/*	 right channel values						    */

#define BI_R_FM 	0x08
#define BI_R_IMIXER	0x09
#define BI_R_EXT	0x0A
#define BI_R_INT	0x0B
#define BI_R_MIC	0x0C
#define BI_R_PCM	0x0D
#define BI_R_SPEAKER	0x0E
#define BI_R_SBDAC	0x0F

/*
// end of binary.h
*/

