#include <stdio.h>
#include "colors.h"
#include "!bestlib.h"

   /*** NOTE  the names and structure of the routines used in these examples
              have changed in The Best Library 2.00; the updated examples will
              be released soon                                            ***/

   /*** NOTE  even though this program only uses the "keyp" structure, the
              other three are necessary for the assembler routines in the
              !BESTLIB.LIB library to function properly.  C would also
              produce a "linker warning" if you have enabled that warning ***/
filldata fidata;                       /* create a "filldata" structure     */
printdata prdata;                      /* create a "printdata" structure    */
mousedata msdata;                      /* create a "mousedata" structure    */
asciiscan keyp;                        /* create an "asciiscan" structure   */

void main(void)
{
   int oldmode;
   char *errmsg;

   oldmode = readvideomode();          /* save the current video mode       */
   textm(0);                           /* make sure we are in text mode     */
   textmem(3);                         /* store text video memory           */
   cursor(3, 1);                       /* hide and store cursor position    */
   clear(LIGHTGRAY, BLACK);            /* clear the screen and set colors   */

   do {
      printsatxy("Select an option:", 5, 3);
      printsatxy("1) Load", 8, 5);
      printsatxy("2) Save", 8, 6);
      printsatxy("3) Shell to DOS", 8, 7);
      printsatxy("4) Exit program", 8, 8);       /* print small sample menu */

      getchr();                        /* wait for a user response          */
      switch(keyp.ascii) {
      case '1':                        /* load was selected                 */
         beep();                       /* beep the speaker                  */
         printsatxy("The Load option has not yet been written", 5, 24);
         break;                        /* exit from switch statement        */
      case '2':
         beep();                       /* beep the speaker                  */
         printsatxy("The Save option has not yet been written", 5, 24);
         break;                        /* exit from switch statement        */
      case '3':                        /* shell to DOS was selected         */
         cursor(1, 1);                 /* show and restore cursor position  */
         if ((errmsg = dosshell()) != NULL)
            printsatxy(errmsg, 5, 24); /* print the returned error message  */
         else {                        /* else if no error occurred..       */
            cursor(3, 0);              /* hide and store ignore position    */
            clear(LIGHTGRAY, BLACK);   /* clear the screen and set colors   */
            printsatxy("Welcome back!", 5, 24);
         }
         break;                        /* exit from switch statement        */
      case '4':                        /* exit program was selected         */
         changevideomode(oldmode);     /* restore the original video mode   */
         if (oldmode == 3 || oldmode == 7 || oldmode == 21) {
                                       /* if the old mode was a text mode.. */
            textmem(1);                /* restore text video memory         */
            cursor(1, 1);              /* show and restore cursor position  */
         }
         break;                        /* exit from switch statement        */
      default:                         /* the user pressed an invalid key   */
         printsatxy("That is not a valid choice              ", 5, 24);
         beep();                       /* beep the speaker to denote error  */
      }
   } while (keyp.ascii != '4');        /* loop until exit is chosen         */
}
