#include <stdlib.h>
#include "colors.h"
#include "!bestlib.h"

   /*** NOTE  the names and structure of the routines used in these examples
              have changed in The Best Library 2.00; the updated examples will
              be released soon                                            ***/

   /*** NOTE  even though this program only uses the "keyp" and "prdata"
              structures, the other two are necessary for the assembler
              routines in the !BESTLIB.LIB library to function properly.  C
              would also produce a "linker warning" if you have enabled that
              warning                                                     ***/
filldata fidata;                       /* create a "filldata" structure     */
printdata prdata = { WHITE, BLUE, -1, 1, 1, "Press any key to exit" };
    /* see "printdata" under GLOBAL VARIABLES for explanation of the values */
mousedata msdata;                      /* create a "mousedata" structure    */
asciiscan keyp;                        /* create an "asciiscan" structure   */

void main(void)
{
   int oldmode, deltax = 1, deltay = 1, mouse, delaytime, z;
   char input[80];          /* enough space for a 79-letter string and NULL */

   oldmode = readvideomode();          /* save the current video mode       */
   if (oldmode == 3 || oldmode == 7 || oldmode == 21) {
                                       /* if the old mode was a text mode.. */
      textmem(3);                      /* store text video memory           */
      cursor(3, 1);                    /* hide and store cursor position    */
   }
   textm(1);                          /* change to 80x25x16 color text mode */
   clear(LIGHTGRAY, BLACK);            /* clear the screen and set colors   */
   printsatxy("What text would you like to be animated? (79 letters maximum)",
               1, 10);
   z = readstring(input, 79, 0, 11);   /* ask user for the text to animate  */
   if (z == -1) prdata.string2print = "Demonstration";
   else prdata.string2print = input;   /* set up the text for printing      */
   printsatxy("Enter movement delay in milliseconds (1-1000): [30]", 1, 13);
   z = readnumber(1000, 1, 53, 13, &delaytime);  /* ask user for delay time */
   if (z == FALSE) delaytime = 30;     /* if <ENTER> or <ESC>, use default  */
   clear(WHITE, BLUE);                 /* clear the screen and set colors   */
   mouse = initms();                   /* initialize mouse if installed     */
   msec(1);                            /* initialize CPU-independent delay  */

   if (mouse == TRUE)                  /* if the mouse was initialized..    */
      xyminmaxms(9, 4, 70, 20);        /* restrict its movement (for show)  */
   while (!keyhit()) {                 /* loop until a key is pressed       */
      print();                         /* print user-inputted text          */
      if (mouse == TRUE) printsatxy("The mouse is just for show", 27, 0);
      printsatxy("Press any key to exit", 29, 24);
      if (mouse == TRUE) showms();     /* restore mouse cursor onto screen  */
      msec(delaytime);                 /* wait 10 milliseconds              */
      if (mouse == TRUE) hidems();     /* hide mouse before a screen update */
      if (prdata.x >= 80 - stringlenpr() || prdata.x <= 0)
                                       /* if the x-coordinate is at an edge */
         deltax = -deltax;             /* reverse the x-increment (negate)  */
      if (prdata.y >= 24 || prdata.y <= 0) /* if y-coordinate is at an edge */
         deltay = -deltay;             /* reverse the y-increment (negate)  */
      stringerasepr();                 /* erase user inputted text          */
      prdata.x += deltax,
      prdata.y += deltay;              /* increment the x and y coordinates */
   }

   changevideomode(oldmode);           /* restore the original video mode   */
   if (oldmode == 3 || oldmode == 7 || oldmode == 21) {
                                       /* if the old mode was a text mode.. */
      textmem(1);                      /* restore text video memory         */
      cursor(1, 1);                    /* show and restore cursor position  */
   }
}
