/********************************************************/
/*                                                      */
/*      Sourcecode for PART I in Abe's Demoschool       */
/*                                                      */
/*      compile with :                                  */
/*                                                      */
/*      bcc -1 demo1.c          (Borland C)             */
/*      tcc -1 demo1.c          (Turbo C)               */
/*                                                      */
/*      the -1 option allows 286-specific code          */
/*      (ie shl di,6).                                  */
/*      If you are using another compiler remember to   */
/*      set the settings of the compiler to allow       */
/*      286-specific instructions.                      */
/*                                                      */
/*              13/12-95 Dirty Abe                      */
/*                                                      */
/********************************************************/

#include<conio.h>
#include<math.h>

#define PI 3.1415926 /* I suppose most of you've heard of this little weazel */
#define KX 2*PI/320     /* KX & KY are constants for the picture drawing */
#define KY 2*PI/200


/* wtsync waits for the vertical retrace
That is when the electron beam jumps back from the bottom right corner
of the screen to the upper left corner of the screen 
This gives us a chance to draw things on the screen, changing the palette and
stuff like that while the electron beam aint drawing */
void wtsync(void)
{
asm     mov     dx,3DAh
WaitVR1:
asm     in      al,dx
asm     test    al,8
asm     jne     WaitVR1
WaitVR2:
asm     in      al,dx
asm     test    al,8
asm     je      WaitVR2
}

/* sets the 256 colours of the palette to the 256 first colours of pal */
void setpal(char*pal)
{
int i;
	outp(0x3c8,0);          /* set colorindex to 0 */
	for(i=0;i<256*3;i++)
	outp(0x3c9,pal[i]);     /* send palett-data to the palett */
}

/* reads the current palette and saves it in the array pal */
void getpal(char*pal)
{
int i;
	outp(0x3c7,0);
	for(i=0;i<256*3;i++)
	pal[i]=inp(0x3c9);
}

/* this function sets up a pal with smooth colorruns between some neat colours
 feel free to change te colours and see what it looks like */
void coolpal(char*pal)
{
int i,r=0,g=0,b=0,col=0;

outp(0x3c8,0);

	for(i=0;i<64;i++)      // BLACK - WHITE
	{
		pal[col++]=r;
		pal[col++]=g;
		pal[col++]=b;
		if(r<63)r++;
		if(g<63)g++;
		if(b<63)b++;
	}
	for(i=0;i<64;i++)      // WHITE - YELLOW
	{
		pal[col++]=r;
		pal[col++]=g;
		pal[col++]=b;
		if(b>0)b--;
	}
	for(i=0;i<64;i++)      // YELLOW - DARK BLUE
	{
		pal[col++]=r;
		pal[col++]=g;
		pal[col++]=b;
		if(r>0)r--;
		if(g>0)g--;
		if(b<63 && i%2==0)b++;
	}
	for(i=0;i<64;i++)      // DARKBLUE - GREEN
	{
		pal[col++]=r;
		pal[col++]=g;
		pal[col++]=b;
		if(g<63)g++;
		if(b>0 && i%2==0)b--;
	}
	for(i=0;i<64;i++)      // GREEN - DARK RED
	{
		pal[col++]=r;
		pal[col++]=g;
		pal[col++]=b;
		if(r<63 && i%2==0)r++;
		if(g>0)g--;
	}
	for(i=0;i<64;i++)      // DARKRED - 63 00 31
	{
		pal[col++]=r;
		pal[col++]=g;
		pal[col++]=b;
		if(r<63 && i%2==0)r++;
		if(b<63 && i%2==0)b++;
	}
	for(i=0;i<64;i++)      // 63 00 31 - 00 31 63
	{
		pal[col++]=r;
		pal[col++]=g;
		pal[col++]=b;
		if(b<63 && i%2==0)b++;
		if(g<63 && i%2==0)g++;
		if(r>0)r--;
	}
	for(i=0;i<64;i++)      // 00 31 63 - BLACK (00 00 00)
	{
		pal[col++]=r;
		pal[col++]=g;
		pal[col++]=b;
		if(b>0)b--;
		if(g>0 && i%2==0)g--;
	}

setpal(pal);                    // set the first 256 colours of pal
}

/* rotates the colours first - last in the array pal */
void rotpal(char*pal,int first, int last)
{
char r,g,b;
int i;

r=pal[first*3 + 0];             //save the first color in r,g,b
g=pal[first*3 + 1];
b=pal[first*3 + 2];

for(i=first*3;i<(last+1)*3;i++) //move all colors down one step (3 bytes)
pal[i]=pal[i+3];

pal[last*3+0]=r;                 //set the last color to r,g,b
pal[last*3+1]=g;
pal[last*3+2]=b;

wtsync();                       //wait for the vertical retrace
setpal(pal);                    //and set the first 256 colours of pal
}

/* putpixel draws a pixel with colour col at (x,y) of the screen */
/* the adress of the coordinate (x,y) is 0A000h:offset */
/* the offset is calculated like this: offset = WIDTH*Y + X */
/* the width of the screen is 320 bytes in mode 13h */
void putpixel(int x, int y, char col)
{
  asm{
    mov ax,0a000h       //ax = segment adress of the screen
    mov es,ax   //es = A000h
    mov bx,y    //bx = y
    mov di,bx   //di = y
    xchg bh,bl  //bx = 256*y
    shl di,6    //di = 64*y
    add di,bx   //di = (256 + 64)*y = 320*y
    add di,x    //di = 320*y + x
    mov al, col //move the colorbyte to al
    mov [es:di],al      // and move it to the screen
  }
}

/* get pixel is pretty similar to putpixel. 
It reads the colour at (x,y) and returns it */
char getpixel(int x, int y)
{
char col;
  asm{
    mov ax,0a000h
    mov es,ax
    mov bx,y      //bx = y
    mov di,bx     //di = y
    xchg bh,bl    //bx = 256*y
    shl di,6      //di = 64*y
    add di,bx     //di = (256 + 64)*y = 320*y
    add di,x      //di = 320*y + x
    mov al,[es:di]      //move the colour to al
    mov   col,al  //and move it to the char col (a char is one byte)
  }
return col;     //return the color
}

/* sets the graphic mode to mode mode !? */
void setmode(int mode)
{
asm     mov     ax,mode
asm     int     10h
}

void drawsincos(void)
{
int x,y;
char col;
for(x=0;x<320;x++)      //loop across all pixels on the screen
{                       // 320 in the x-direction
for(y=0;y<200;y++)      // 200 in the y-direction
{
	/* calculate a color with the following formula */
	col=(sin(x*KX*0.5)*sin(y*KY*0.5))*(127-20)+128;
	/* try changing the formula and see how the picture changes */
	
	putpixel(x,y,col);      // draw the pixel to the screen
}       // end for y
}       // end for x
}       // endfunction

void filtersincos(void)
{
int x,y;
char col;

for(x=0;x<320;x++)       //loop through all pixels but this time
{                        // read the existing colours from the screen
for(y=0;y<200;y++)       //and modify them with the formula below
{                        //this way a "filter" is put on the image
	col=getpixel(x,y);  //read the colour at (x,y)
	col+=(sin(x*KX*10)*sin(y*KY*10))*20;    //modify the read color
	putpixel(x,y,col); //and write the modified color at the same place
}       // end for y
}       // end for x
}       // endfunction


void main(void)
{
char pal[512*3];        //Use 512 colours 4 the palette (only 256 visible at a time)

setmode(0x0013);        // Enter demomode (320*200 256 colors)
			// also called MCGA and mode 13h
coolpal(pal);           //setup pal to smooth colorruns

drawsincos();           //draw a sincos picture to the screen
getch();                //wait for a keypress
filtersincos();         //change the screen with a sincos "filter"
getch();                //wait for a keypress again

do
{
	/* now just rotate the palette */
	/* until the keyboard is hit */
	
	rotpal(pal,1,511);

	/* notice that colour 0 is not rotated, that is because I don't */
	/* want the backgroundcolor to change */

}while(!kbhit());       

setmode(3);              //get back into textmode

}
