// Kochanek-Bartels spline drawer, written by MAD (smit@xs4all.nl)
// compiled with Borland C++ for dos
// see 3DSPLINE.DOC for an explanation of what is done
// http://www.xs4all.nl/~smit
// (C)opyright 1997, Ferdi Smit. All rights reserved.

void putpixel (int x, int y, int color)      // a slow put pixel
{ asm { mov ax,0xa000
	mov es,ax
	mov bx,y
	mov di,y
	shl di,8
	shl bx,6
	add di,bx
	add di,x
	mov ax,color
	mov byte ptr es:[di],al
      }
  return;
}

void main ()
{ asm { mov ax,0x13; int 0x10; }

  float x,y,z,w,ax,bx,cx,dx,ay,by,cy,dy;
  float p1x=160, p1y=100, p2x=180, p2y=90, p3x=300, p3y=120, p4x=240, p4y=160;
// a,d=tension b,e=bias c,f=continuity
//  float a=0, b=0, c=-1, d=0, e=0, f=-1; //lerp
  float a=0, b=0, c= 0, d=0, e=0, f= 0; //catmull-rom

  x=(1-a)*(1+b)*(1+c)/2;
  y=(1-a)*(1-b)*(1-c)/2;
  z=(1-d)*(1+e)*(1-f)/2;
  w=(1-d)*(1-e)*(1+f)/2;

  ax = -x*p1x + (x-y-z+2)*p2x + (y+z-w-2)*p3x + w*p4x;
  bx = 2*x*p1x + (-2*x+2*y+z-3)*p2x + (-2*y-z+w+3)*p3x + -w*p4x;
  cx = -x*p1x + (x-y)*p2x + y*p3x;
  dx = p2x;

  ay = -x*p1y  + (x-y-z+2)*p2y      + (y+z-w-2)*p3y    + w*p4y;
  by = 2*x*p1y + (-2*x+2*y+z-3)*p2y + (-2*y-z+w+3)*p3y + -w*p4y;
  cy = -x*p1y  + (x-y)*p2y          + y*p3y;
  dy =           p2y;

//setup forward differences
  float d0x, d0y, d1x, d2x, d3x, d1y, d2y, d3y;
  float step=.005;                      //in steps of 1/200
  float t=0;                           //start at t=0

  d0x = ax*t*t*t+bx*t*t+cx*t+dx;
  d1x = 3*ax*step*t*t + t*(3*ax*step*step+2*bx*step) + ax*step*step*step + bx*step*step + cx*step;
  d2x = 2*step*step*(3*ax*t+3*ax*step+bx);
  d3x = 6*ax*step*step*step;

  d0y = ay*t*t*t+by*t*t+cy*t+dy;
  d1y = 3*ay*step*t*t + t*(3*ay*step*step+2*by*step) + ay*step*step*step + by*step*step + cy*step;
  d2y = 2*step*step*(3*ay*t+3*ay*step+by);
  d3y = 6*ay*step*step*step;

  for (int n=200; n>0; n--)
  {  putpixel (d0x,d0y,255);
     d0x+=d1x, d1x+=d2x, d2x+=d3x;
     d0y+=d1y, d1y+=d2y, d2x+=d3y;
  }

  asm { mov ah,0x7; int 0x21; }
  asm { mov ax,3; int 0x10; }
  return;
}
