/** 3DGPL *************************************************\
 *  (MS-WINDOWS, 286+, 8bit deep modes)                   *
 *  Header for hardware specific stuff.                   *
 *                                                        *
 *  Defines:                                              *
 *    HW_open_screen         opening output surface;      *
 *    HW_blit                colourmap onto the screen;   *
 *    HW_close_screen        closing output;              *
 *                                                        *
 *    HW_run_event_loop      runiing for events;          *
 *    HW_quit_event_loop     quiting running.             *
 *                                                        *
 *  (6/1995) By Sergei Savhenko. (savs@cs.mcgill.ca).     *
 *  Copyright (c) 1995 Sergei Savchenko.                  *
 *  THIS SOURCE CODE CAN'T BE USED FOR COMERCIAL PURPOSES *
 *  WITHOUT AUTHORISATION                                 *
\**********************************************************/

#include <windows.h>                        /* all API stuff */
#include "../hardware/hardware.h"           /* macros */

extern void main(void);                     /* real main (well...) */

HDC HW_mem;                                 /* why? i wish i know why... */
HBITMAP HW_bmp;                             /* bitmap header */
RECT HW_rect;                               /* "client" area dimensions */
HWND HW_wnd;                                /* window */
HANDLE HW_instance;                         /* instance of this thing */
HPALETTE HW_palette;                        /* the palette headers */

int HW_cmd_show;                            /* not sure but needed */
unsigned char *HW_colourmap;                /* the bitmap bits */
char HW_class_name[]="hardware";            /* what is class name anyway? */

struct                                      /* the logical palette */
{
 WORD hw_version;
 WORD hw_no_entries;
 PALETTEENTRY hw_entries[256];
} HW_log_palette;

void HW_null_function(void) {}              /* default handler */
void (*HW_application_main)(void)=HW_null_function;
void (*HW_application_key_handler)(int key_code);

/**********************************************************\
 *  Implementations for fast memory operations.           *
\**********************************************************/

void HW_set_int(int *d,long l,int v) {long i; for(i=0;i<l;i++) *d++=v; }

/**********************************************************\
 *  Creating a window.                                    *
\**********************************************************/

int HW_open_screen(char *display_name,
			char *screen_name,
		   struct HW_colour palette[256],
		   unsigned char *colourmap
		  )
{
 PAINTSTRUCT ps;                            
 int i;
  
 HW_wnd=CreateWindow(HW_class_name,screen_name,WS_SYSMENU,
		     CW_USEDEFAULT,CW_USEDEFAULT,
		     HW_SCREEN_X_SIZE,HW_SCREEN_Y_SIZE+29,
		     NULL,NULL,HW_instance,NULL);

 HW_colourmap=colourmap;
 HW_mem=CreateCompatibleDC(BeginPaint(HW_wnd,&ps));
 if((GetDeviceCaps(ps.hdc,PLANES)!=1)&&
	 (GetDeviceCaps(ps.hdc,PLANES)!=8))
  MessageBox(NULL,"Screen mode with 256 colours needed...",
		  screen_name,MB_OK|MB_ICONSTOP);

 HW_bmp=CreateCompatibleBitmap(ps.hdc,HW_SCREEN_X_SIZE,HW_SCREEN_Y_SIZE);
 SelectObject(HW_mem,HW_bmp);

 HW_log_palette.hw_version=0x300;
 HW_log_palette.hw_no_entries=256;
 for(i=0;i<256;i++)
 {
  HW_log_palette.hw_entries[i].peRed=palette[i].hw_r;
  HW_log_palette.hw_entries[i].peGreen=palette[i].hw_g;
  HW_log_palette.hw_entries[i].peBlue=palette[i].hw_b;
  HW_log_palette.hw_entries[i].peFlags=PC_NOCOLLAPSE;
 }
 HW_palette=CreatePalette((LOGPALETTE*)&HW_log_palette);
 EndPaint(HW_wnd,&ps);

 HW_rect.left=HW_rect.top=0;
 HW_rect.right=HW_SCREEN_X_SIZE;
 HW_rect.bottom=HW_SCREEN_Y_SIZE;

 ShowWindow(HW_wnd,HW_cmd_show);
 UpdateWindow(HW_wnd);

 return(1);
}

/**********************************************************\
 *  Rendering the bitmap into the window.                 *
\**********************************************************/

void HW_blit(void)
{
 PAINTSTRUCT ps;

 BeginPaint(HW_wnd,&ps);

 SelectPalette(ps.hdc,HW_palette,FALSE);
 RealizePalette(ps.hdc);
 SetMapMode(ps.hdc,MM_TEXT);
 SetBitmapBits(HW_bmp,HW_COLOURMAP_SIZE_CHAR,HW_colourmap);
 BitBlt(ps.hdc,0,0,HW_SCREEN_X_SIZE,HW_SCREEN_Y_SIZE,HW_mem,0,0,SRCCOPY);

 EndPaint(HW_wnd,&ps);
}

/**********************************************************\
 *  Deallocating some stuff.                              *
\**********************************************************/

void HW_close_screen(void)
{
 DeleteDC(HW_mem);
 DeleteObject(HW_bmp);
}

/**********************************************************\
 *  Running the event loop.                               *
\**********************************************************/

void HW_run_event_loop(void (*application_main)(void),
		       void (*application_key_handler)(int key_code)
		      )
{
 MSG msg;

 HW_application_main=application_main;
 HW_application_key_handler=application_key_handler;

 while(1)
 {
  if(PeekMessage(&msg,NULL,0,0,PM_REMOVE))  /* this IS sensitive part! */ 
  {
   if(msg.message == WM_QUIT) break;
   TranslateMessage(&msg);                  
   DispatchMessage(&msg);  
  }
  else
  {
   InvalidateRect(HW_wnd,&HW_rect,TRUE);
   UpdateWindow(HW_wnd);
  }
 }
}

/**********************************************************\
 *  Running the event loop.                               *
\**********************************************************/

void HW_quit_event_loop(void)
{
 PostMessage(HW_wnd,WM_CLOSE,0,0L);         /* telling ourselves to quit */
}

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * *\
 *  Windows main callback function.                      * 
\* * * * * * * * * * * * * * * * * * * * * * * * * * * * */

long FAR PASCAL WndProc(HWND hWnd,UINT message,
			WPARAM wParam,LPARAM lParam)
{
 switch(message)
 {  
  case WM_PAINT:       HW_application_main();
		       break;   
  case WM_ERASEBKGND:  return(1L);
  case WM_DESTROY:     PostQuitMessage(0);
		       break;
  case WM_KEYDOWN:     HW_application_key_handler(wParam);
		       break;
  default: return(DefWindowProc(hWnd,message,wParam,lParam));
 }
 return(0L);
}

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * *\
 *  Windows Main function.                               *
\* * * * * * * * * * * * * * * * * * * * * * * * * * * * */

int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance,
		   LPSTR lpszCmdLine,int nCmdShow)
{
 WNDCLASS w;

 HW_cmd_show=nCmdShow;
 if(!(HW_instance=hPrevInstance))
 {
  w.style=CS_HREDRAW|CS_VREDRAW;
  w.lpfnWndProc=(LPVOID)WndProc;
  w.cbClsExtra=0;
  w.cbWndExtra=0;
  w.hInstance=hInstance;
  w.hIcon=NULL;
  w.hCursor=NULL;
  w.hbrBackground=GetStockObject(WHITE_BRUSH);
  w.lpszMenuName=NULL;
  w.lpszClassName=HW_class_name;

  if(! RegisterClass(&w))
   return FALSE;
 }

 main();                                    /* here, human way to start */

 return(0);
}

/**********************************************************/
