#ifndef _GRAPHICS_H_
#define _GRAPHICS_H_

/** 3DGPL *************************************************\
 *  (8bit deep bitmap)                                    *
 *  Header for 2D graphics stuff.                         *
 *                                                        *
 *  grp-base.c               basic graphics;              *
 *  grp-text.c               text;                        *
 *  grp-poly.c               polygon rendering.           *
 *                                                        *
 *  (6/1995) By Sergei Savhenko. (savs@cs.mcgill.ca).     *
 *  Copyright (c) 1995 Sergei Savchenko.                  *
 *  THIS SOURCE CODE CAN'T BE USED FOR COMERCIAL PURPOSES *
 *  WITHOUT AUTHORISATION                                 *
\**********************************************************/

#define G_MAX_TUPLES            50          /* big enough? */
#define G_MAX_SHADED_TUPLES    100
#define G_MAX_TEXTURED_TUPLES  120

unsigned char *G_init_graphics(void);
void G_clear(void);
void G_dot(int *vertex,unsigned char colour);
void G_line(int *vertex1,int *vertex2,unsigned char colour);

void G_text(int x,int y,char *string,unsigned char colour);

void G_ambient_polygon(int *edges,int length,unsigned char colour);
void G_shaded_polygon(int *edges,int length);
void G_textured_polygon(int *edges,int length,int *O,int *u,int *v,
                        unsigned char *texture,int log_texture_size,
                                               int log_texture_scale
                       );

/*********************************************************/

#endif
