BAT * Sample of advanced EBL-PLUS string and arithmetic...

    TYPE "The time in natural English is:"
    TYPE

* Extract the hours, minutes, and seconds from the time.
*       This is done by the PARSE command which splits the contents
*       of an expression into any number of parts. Note that the
*       character between each variable is ':' below. This command
*       will split (ie. parse) the time such as 12:50:00 into pieces
*       where the ':' character is located. The hour part is put into %H,
*       the minute part is put into %M, etc. Seconds are parsed but
*       not used for this exapmle.

     PARSE time() %H:%M:%1

*
* Now begin to convert to an English sentence. First step is to make
*       adjustments if we are leaning toward the top of the hour or
*       minute. Note that the TYPE command below is followed by text
*       then a ';'. The ';' indicates to show a word but not go to the
*       next line. This is used here because the resulting sentence is
*       built up in pieces word by word.
*
-Convert.time
     TYPE "It's ;"                |* start building..
     IF %M > 30 THEN %H += 1      |* towards an hour?
     IF ( %M % 5 ) <> 0           |* about on minute?
        THEN TYPE "about ;"
     %M -= ( %M % 5 )             |* find apx 5 mins
     %H += 0                      |* strip 0's fm hr
     IF %H = 0
        THEN %H = 12              |* handle midnight.
     IF %H > 12
        THEN %H -= 12             |* make it 12hr tim

*
* After the adjustment, the minute variable %M is adjusted to the
*       nearest five minutes. We will do a computed-GOTO in
*       order to show the proper phrase. This is similar to a CASE
*       statement in some other languages. That is, if %M contains 35,
*       then GOTO -min.%M is the same as GOTO -min.35. Also note that
*       several commands can be combined into a single EBL-Plus statement,
*       TYPE and GOTO in this instance.
*
     GOTO -min.%M                 |* multi-way GOTO
-min.0
-min.60 %M = 0                    | GOTO -Hour
-min.5  TYPE "five past ;"        | GOTO -Hour
-min.10 TYPE "ten past ;"         | GOTO -Hour
-min.15 TYPE "quarter past ;"     | GOTO -Hour
-min.20 TYPE "twenty past ;"      | GOTO -Hour
-min.25 TYPE "twenty-five past ;" | GOTO -Hour
-min.30 TYPE "half past ;"        | GOTO -Hour
-min.35 TYPE "twenty-five till ;" | GOTO -Hour
-min.40 TYPE "twenty till ;"      | GOTO -Hour
-min.45 TYPE "quarter till ;"     | GOTO -Hour
-min.50 TYPE "ten till ;"         | GOTO -Hour
-min.55 TYPE "five till ;"

*
* Now show the hour. A different approach is demonstrated here.
*       This time, we will select one word from several in a
*       string by using the WORD() function. EBL-Plus has many
*       advanced string and arithmetic functions to choose from.

*
*       First start by building a string (for convenience) of all
*       the words that can be shown. Note the use of '&=' which is
*       a short-hand approach to expressions. Specifically
*       the following two expressions are equivalant:
*
*               %N &= "eight nine ten eleven twelve"
*               %N = %N & "eight nine ten eleven twelve"
*
*       The '&' is the operator for string concatenation.
*
-Hour
        %N = "one two three four five six seven "
        %N &= "eight nine ten eleven twelve"

*
*       Now use the WORD() function to select the blank
*       delimited word in %N corresponding to the hour in %H.
*

        TYPE WORD(%N,%H) ;        |* show hr name

*
*       Then round off the English phrase if at the top
*       of the hour.
*
        IF %M = 0
           THEN TYPE " o'clock;"  |* add if exact.
        TYPE .
        EXIT
