;       ͻ
;                        
TITLE    CD-AUDIO PLAYER 
;                        
;       ͼ
;
; THIS CD-AUDIO PLAYER WAS CODED IN EARLY 1995
;
;                        BY SILVIO TURELLO (FRONTMAN/CREW242)
;
; FEATURES: PLAY, STOP, PAUSE, SKIP TRACK, REPEAT, FFWD, FBWD, ETC.
;
;
.ALPHA
.MODEL MEDIUM
COM_OR_OBJ	= 0
STACKLENGTH     = 0100H
UGROUPCD GROUP CODE_SEGCD, DATA_SEGCD
ASSUME CS:UGROUPCD, DS:UGROUPCD, SS:UGROUPCD
;=============================================================================
IRQ1            = 20H
IRQ2		= 21H
IRQ3		=0A0H
IRQ4		=0A1H
TIMER0		= 40H
TIMER2          = 42H
PIT1		= 43H
PPI             = 61H
UHR_INDEX	= 70H
UHR_PORT	= 71H
UHR_STATA	= 0AH
UHR_STATB	= 0BH
UHR_STATC	= 0CH
DAC_INDEX	= 03C8H
VERT_RETRACE    = 3DAH          ;Input Status-Register #1
VRAM_BASE	= 0A000H
;=============================================================================

DATA_SEGCD SEGMENT WORD USE16
;=============================================================================
PROG_START_SEG  DW 0
PROG_END_SEG    DW 0
COMP_SPEED2     DW 0106H
COMP_SPEED3     DW 4006H
COMP_SPEED4     DW 0
COMP_SPEED5     DW 1165
CHAINING	DW 0
IRQCOUNT	DB 56
SYSTEM		DB 0
TRACK_NAME	DB 2 DUP(0)
INFO_TEXT	DB "USAGE: CDAUDIO <# OF TRACK>",13,10,"$"
;-----------------------------------------------------------------------------
ALIGN 2
CD_DRIVE	DB 0
CD_STATUS	DB 0			;1=PLAYING, 2=PAUSED
CD_PLAYER	DB 1			;1=CD PLAYER, 0=GAME PLAYER
CD_CONTROL	DB 0			;1=REPEAT, 0=NO REPEAT
CD_COUNT	DW 1024			;IRQ COUNTER
VOL_INIT	DB 0
CD_TRACK	DB 0			;ACTUAL TRACKNO
CD_STARTPOS	DW 0,0			;ACTUAL STARTPOS IN REDBOOK
CD_ENDPOS	DW 0,0			;ACTUAL ENDPOS IN REDBOOK
CD_IRQPOS	DW 0,0			;ZAEHLER, UM ABFRAGE ZU AKTIVIEREN
CD_IRQEND	DW 0,0			;AB DIESEM ZAEHLER WIRD AKTIVIERT

IOCTLI1		LABEL	BYTE
REQ_HEAD1	DB 26			;LNGE VON IOCTL HEADER
SUB_UNIT1	DB 0
COMMAND1	DB 3
STATUS1		DW 0
		DB 8 DUP(0)
MEDIADESC1	DB 0
TRANSADR1	DW 0,0
SIZE1		DW 0
START1		DW 0
ID1		DD 0

IOGETHEADL	= 5
IOGETHEAD	DB 0			;GET DEVICE ADR
DEV_ENTRY	DW 0,0
DEV_INT		DW 0,0

DEVSTATL	= 5
DEVSTAT		DB 6			;GET DEVICE STATUS
DEV_STAT	DD 0

DISKINFOL	= 7
DISKINFO	DB 10			;GET DISK INFO (DIR)
LOW_TRACK	DB 0
HIGH_TRACK	DB 0
LEAD_OUT_TRACK	DD 0

TRACKINFOL	= 7
TRACKINFO	DB 11			;GET TRACK INFO (DIR)
TRACK_NO	DB 0
TRACK_START	DD 0
TRACK_CTL	DB 0

QINFOL		= 11
QINFO		DB 12			;GET PLAY STATUS
CTL_ADR		DB 0
TRACK_NOW	DB 0
INDEX_NOW	DB 0
TMIN_NOW	DB 0			;TRACK TIME
TSEC_NOW	DB 0
TFRAME_NOW	DB 0
TZERO_NOW	DB 0
DMIN_NOW	DB 0			;DISC TIME
DSEC_NOW	DB 0
DFRAME_NOW	DB 0

MEDCHL		= 2
MEDCH		DB 9			;CHECK MEDIA CHANGE
CD_CHANGE	DB 0

PLAY2		LABEL	BYTE
REQ_HEAD2	DB 22			;LNGE VON PLAY HEADER
SUB_UNIT2	DB 0
COMMAND2	DB 132
STATUS2		DW 0
		DB 8 DUP(0)
ADRMODE2	DB 0
STARTSECTOR2	DD 0
NUMBSECTOR2	DD 0

STOP3		LABEL	BYTE
REQ_HEAD3	DB 13			;LNGE VON STOP HEADER
SUB_UNIT3	DB 0
COMMAND3	DB 133
STATUS3		DW 0
		DB 8 DUP(0)

TOC		DD 100 DUP(0)		;TABLE OF CONTENTS (MAX 100)
					;STARTADRESSE DES NCHSTEN IST
					;ENDADRESSE DES MOMENTANEN
TCTRL		DB 100 DUP(0)		;TRACK CONTROL BYTE
					;01X0XXXX = DATA TRACK
;-----------------------------------------------------------------------------
PROG_END        LABEL   BYTE    ;MUSS LETZE ZEILE IM DATENSEGMENT SEIN!
;-----------------------------------------------------------------------------
DATA_SEGCD ENDS

.386
CODE_SEGCD SEGMENT PAGE USE16
ORG 100H
;=============================================================================
PUBLIC _MAINCD
_MAINCD PROC FAR
	JMP	SHORT MAIN_CONT		;0100
	NOP
	RETF
	CALL	DEVICE_INIT		;0104
	RETF
	CALL	GET_TOC			;0108
	RETF
	CALL	PLAY_TRACK		;010C
	RETF
	CALL	STOP_TRACK		;0110
	RETF
	CALL	PAUSE_TRACK		;0114
	RETF
	CALL	RESUME_TRACK		;0118
	RETF
	CALL	SEEK_TRACK		;011C
	RETF
	CALL	INFO_TRACK		;0120
	RETF
	CALL	GET_DEVSTAT		;0124
	RETF
	CALL	GET_MEDCHANGE		;0128
	RETF
_MAINCD ENDP
;=============================================================================

IF COM_OR_OBJ
;=============================================================================
MAIN_CONT PROC NEAR
	PUSH	BP DS CS CS
	POP	DS
	SHL	DI,2
	ADD	DI,0100H
	CALL	DI			;FAR CALL
	SETC	DL
	XOR	DH,DH
	POP	DS BP			;BP IS ABSOLUTELY IMPORTANT FOR C
	RETF
MAIN_CONT ENDP
;=============================================================================

ELSE
;=============================================================================
MAIN_CONT PROC NEAR
	MOV	AX,CS
	MOV	DS,AX
	MOV     PROG_START_SEG,ES       ;PROGRAMMANFANG
	MOV     AX,SS                   ;UND -ENDE MERKEN
	MOV     BX,OFFSET PROG_END
	ADD     BX,STACKLENGTH
	MOV     SP,BX
	SHR     BX,4
	INC     BX
	ADD     AX,BX
	MOV     PROG_END_SEG,AX
	CMP	BYTE PTR ES:[80H],0
	JE	SHORT GM2
	XOR	BX,BX
GL1:	MOV	AL,ES:[82H+BX]
	OR	AL,AL
	JZ	SHORT GL2
	CMP	AL,20H
	JE	SHORT GL2
	CMP	AL,0DH
	JE	SHORT GL2
	MOV	[TRACK_NAME+BX],AL
	INC	BX
	CMP	BX,2
	JB	GL1
GL2:	OR	BX,BX
	JZ	SHORT GM2
	MOV     BX,PROG_END_SEG         ;SPEICHER FREI MACHEN
	SUB     BX,PROG_START_SEG
	MOV     ES,PROG_START_SEG
	MOV     AH,4AH                  ;SPEICHERBLOCKGRSSE NDERN
	INT     21H
	CALL	DEVICE_INIT
	JC	GM1
	MOV	BX,WORD PTR TRACK_NAME
	AND	BL,0FH
	MOV	AL,BL
	TEST	BH,BH
	JZ	SHORT GM3
	MOV	AL,10
	AND	BH,0FH
	MUL	BL
	ADD	AL,BH
GM3:	MOV	AH,1			;SET REPEAT
	MOV	CX,0			;NO IRQ CHAINING, REAL TIME CLOCK IRQ
	CALL	PLAY_TRACK
	XOR	AX,AX
	INT	16H
	CALL	STOP_TRACK
	JMP	SHORT GM1
GM2:	MOV	DX,OFFSET INFO_TEXT
	MOV	AH,9
	INT	21H
GM1:	MOV	AX,4C00H
	INT	21H
MAIN_CONT ENDP
;=============================================================================
ENDIF

;=============================================================================
; INIT PLAYER
;-----------------------------------------------------------------------------
DEVICE_INIT PROC NEAR
	MOV	AX,CS
	MOV	CS:HOLD70_SEG,AX
	MOV	AX,1500H		;MSCDEX TEST
	XOR	BX,BX
	INT	2FH
	OR	BX,BX
	JZ	SHORT NO_AUDIO		;MSCDEX NICHT INSTALLIERT
	XOR	CH,CH
	MOV	CD_DRIVE,CL
	MOV	AX,1510H		;GET DEVICE DRIVER ADDRESS
	PUSH	DS
	POP	ES
	MOV	BX,OFFSET IOCTLI1
	MOV	SIZE1,IOGETHEADL
	MOV	TRANSADR1,OFFSET IOGETHEAD
	MOV	TRANSADR1+2,DS
	INT	2FH
	MOV	BX,DEV_ENTRY		;GET STRATEGY POINT FROM DEVICE HEADER
	MOV	ES,DEV_ENTRY+2
	MOV	AX,ES:[BX+6]
	MOV	DX,ES:[BX+8]
	MOV	DEV_ENTRY,AX		;DEV_ENTRY NOW ADR FUER DATA TRANSFER
	MOV	DEV_INT,DX		;DEV_INT JETZT ADR FUER DEV AKTION
	MOV	DEV_INT+2,ES
	MOV	AL,SUB_UNIT1
	MOV	SUB_UNIT2,AL
	MOV	SUB_UNIT3,AL
	CALL	GET_DEVSTAT		;CHECK AUDIO REPLAY CAPABILITY
	MOV	AX,WORD PTR DEV_STAT
	TEST	AX,10H
	JZ	SHORT NO_AUDIO		;KEIN MULTIMEDIA CD-ROM
	TEST	AX,200H
	JZ	SHORT NO_AUDIO		;KEIN MULTIMEDIA CD-ROM
	TEST	AX,801H
	JNZ	SHORT NO_AUDIO
	MOV	CD_STATUS,0		;CD-ROM ABSTELLEN, FALLS NOCH BUSY
	TEST	STATUS1,200H
	JZ	SHORT NOBUSY
	MOV	CD_STATUS,3
	CALL	STOP_TRACK
NOBUSY:	CALL	GET_TOC
	CLC
	RET
NO_AUDIO:
	STC
	RET
DEVICE_INIT ENDP
;=============================================================================
; INITIALISIERT NEUE CD
;-----------------------------------------------------------------------------
GET_TOC PROC NEAR
	PUSHA
	PUSH	ES
	PUSH	EAX
	MOV	CD_CONTROL,0		;IRQ TRACK CONTROL DISABLE
	PUSH	DS			;GET DISK INFO
	POP	ES
	MOV	BX,OFFSET IOCTLI1
	MOV	STATUS1,0
	MOV	SIZE1,DISKINFOL
	MOV	TRANSADR1,OFFSET DISKINFO
	CALL	DWORD PTR DS:[DEV_ENTRY]	
	CALL	DWORD PTR DS:[DEV_INT]
	MOV	CL,LOW_TRACK
	XOR	BX,BX
LGTO1:	PUSH	BX CX
	PUSH	DS			;GET TRACK INFO
	POP	ES
	MOV	BX,OFFSET IOCTLI1
	MOV	STATUS1,0
	MOV	SIZE1,TRACKINFOL
	MOV	TRANSADR1,OFFSET TRACKINFO
	MOV	TRACK_NO,CL
	CALL	DWORD PTR DS:[DEV_ENTRY]	
	CALL	DWORD PTR DS:[DEV_INT]
	POP	CX BX
	MOV	EAX,TRACK_START
	MOV	[TOC+BX],EAX
	SHR	BX,2
	MOV	AL,TRACK_CTL
	MOV	[TCTRL+BX],AL
	INC	BX
	SHL	BX,2
	INC	CL
	CMP	CL,HIGH_TRACK
	JBE	LGTO1
	MOV	EAX,LEAD_OUT_TRACK
	MOV	[TOC+BX],EAX
	MOV	CD_CHANGE,0
	POP	EAX
	POP	ES
	POPA
	RET
GET_TOC ENDP
;=============================================================================
; SPIELT EINEN TRACK
; AL= TRACK NUMBER, AH= 0 NO REPEAT, 1 REPEAT
; CX= BIT 0= 0/1 DON'T CHAIN/CHAIN IRQ
;     BIT 1= 0/1 RTC/TIMER IRQ
;-----------------------------------------------------------------------------
PLAY_TRACK PROC NEAR
	PUSHA
	PUSH	ES
	CMP	CD_CHANGE,0
	JNE	SHORT GPTR4
	CMP	CD_CONTROL,0
	JNE	SHORT GPTR4
	CMP	CD_PLAYER,0		;FALLS GAMEPLAY, DANN KEIN CHECK
	JE	SHORT GPTR3
	CALL	GET_MEDCHANGE
	CMP	CD_CHANGE,0
	JG	SHORT GPTR3
GPTR4:	CALL	GET_TOC
GPTR3:	MOV	CD_CHANGE,0
	CMP	AL,LOW_TRACK
	JB	GPTR1
	CMP	AL,HIGH_TRACK
	JA	GPTR1
	TEST	CD_STATUS,1
	JZ	SHORT GPTR2
	CALL	PAUSE_TRACK		;PAUSE BEFORE NEW
GPTR2:	MOV	CD_CONTROL,AH		;IRQ TRACK CONTROL
	MOV	CD_TRACK,AL
	MOV	CHAINING,CX
	SHR	CL,1
	AND	CL,1
	MOV	SYSTEM,CL
	SUB	AL,LOW_TRACK
	MOVZX	BX,AL
	SHL	BX,2
	MOV	AX,WORD PTR [TOC+BX]
	MOV	DX,WORD PTR [TOC+2+BX]
	MOV	CD_STARTPOS,AX
	MOV	CD_STARTPOS+2,DX
	CALL	RED2HSG
	MOV	SI,AX
	MOV	DI,DX
	ADD	BX,4
	MOV	AX,WORD PTR [TOC+BX]
	MOV	DX,WORD PTR [TOC+2+BX]
	MOV	CD_ENDPOS,AX
	MOV	CD_ENDPOS+2,DX
	CALL	RED2HSG
	SUB	AX,SI
	SBB	DX,DI
	MOV	WORD PTR STARTSECTOR2,SI
	MOV	WORD PTR STARTSECTOR2+2,DI
	MOV	WORD PTR NUMBSECTOR2,AX
	MOV	WORD PTR NUMBSECTOR2+2,DX
	PUSH	EAX EBX EDX
	MOV	EAX,NUMBSECTOR2
	XOR	EDX,EDX
	MOV	DWORD PTR CD_IRQPOS,EDX
	SHL	EAX,10
	MOV	EBX,75
	DIV	EBX
	SUB	EAX,1024*4
	JNC	SHORT GPTR5
	XOR	EAX,EAX
GPTR5:	MOV	DWORD PTR CD_IRQEND,EAX
	POP	EDX EBX EAX
	PUSH	DS			;PLAY TRACK
	POP	ES
	MOV	BX,OFFSET PLAY2
	MOV	STATUS2,0
	MOV	ADRMODE2,0
	CALL	DWORD PTR DS:[DEV_ENTRY]	
	CALL	DWORD PTR DS:[DEV_INT]
	CALL	IRQ_INIT
	OR	CD_STATUS,1
	AND	CD_STATUS,11111101B
GPTR1:	POP	ES
	POPA
	RET
PLAY_TRACK ENDP
;=============================================================================
; STOP STOPPT CD-ROM DURCH ZWEIMALIGES PAUSE
; PAUSE HAELT CD-ROM NUR AN
;-----------------------------------------------------------------------------
STOP_TRACK PROC NEAR
	CALL	PAUSE_TRACK
PAUSE_TRACK PROC NEAR
	PUSHA
	PUSH	ES
	TEST	CD_STATUS,3
	JZ	SHORT GSTR1
	MOV	CD_CONTROL,0		;IRQ TRACK CONTROL DISABLE
	PUSH	DS			;STOP TRACK
	POP	ES
	MOV	BX,OFFSET STOP3
	MOV	COMMAND3,133
	MOV	STATUS3,0
	CALL	DWORD PTR DS:[DEV_ENTRY]	
	CALL	DWORD PTR DS:[DEV_INT]
	TEST	CD_STATUS,1
	JZ	SHORT GSTR2
	OR	CD_STATUS,2
	AND	CD_STATUS,11111110B
	CALL	IRQ_INIT
	JMP	SHORT GSTR1
GSTR2:	AND	CD_STATUS,11111100B
GSTR1:	POP	ES
	POPA
	RET
PAUSE_TRACK ENDP
STOP_TRACK ENDP
;=============================================================================
; RESUME SETZT NACH PAUSE_TRACK WIEDER FORT
;-----------------------------------------------------------------------------
RESUME_TRACK PROC NEAR
	PUSHA
	PUSH	ES
	TEST	CD_STATUS,2
	JZ	SHORT GRTR1
	MOV	CD_CONTROL,0		;IRQ TRACK CONTROL DISABLE
	PUSH	DS			;RESUME TRACK
	POP	ES
	MOV	BX,OFFSET STOP3
	MOV	COMMAND3,136
	MOV	STATUS3,0
	CALL	DWORD PTR DS:[DEV_ENTRY]	
	CALL	DWORD PTR DS:[DEV_INT]
	CALL	IRQ_INIT
	OR	CD_STATUS,1
	AND	CD_STATUS,11111101B
GRTR1:	POP	ES
	POPA
	RET
RESUME_TRACK ENDP
;=============================================================================
; HOLT INFO UEBER TRACK POSITION
; CARRY= 0 PLAYING, 1= STOPPED
;-----------------------------------------------------------------------------
INFO_TRACK PROC NEAR
	PUSHA
	PUSH	ES
	MOV	AL,CD_CONTROL
	MOV	CD_CONTROL,0
	PUSH	AX
	PUSH	DS			;GET DISK INFO
	POP	ES
	MOV	BX,OFFSET IOCTLI1
	MOV	STATUS1,0
	MOV	SIZE1,QINFOL
	MOV	TRANSADR1,OFFSET QINFO
	CALL	DWORD PTR DS:[DEV_ENTRY]	
	CALL	DWORD PTR DS:[DEV_INT]
	TEST	STATUS1,200H
	JNZ	SHORT GITR2
	STC
	JMP	SHORT GITR1
GITR2:	CLC
GITR1:	POP	AX
	MOV	CD_CONTROL,AL
	POP	ES
	POPA
	RET
INFO_TRACK ENDP
;=============================================================================
; SPULT UM AL= -128 BIS 127 SEKUNDEN RUECK-/VORWAERTS
;-----------------------------------------------------------------------------
SEEK_TRACK PROC NEAR
	PUSHA
	PUSH	ES
	TEST	CD_STATUS,1
	JZ	GKTR3
	MOV	BL,CD_CONTROL
	MOV	BH,CD_STATUS
	PUSH	BX
	CALL	PAUSE_TRACK
	CALL	INFO_TRACK
	CBW
	MOVZX	DX,DMIN_NOW
	MOVZX	BX,DSEC_NOW
	ADD	AX,BX
LKTR1:	CMP	AX,60
	JB	SHORT GKTR1
	OR	AX,AX
	JNS	SHORT GKTR2
	ADD	AX,60
	DEC	DX
	JMP	LKTR1
GKTR2:	SUB	AX,60
	INC	DX
	JMP	LKTR1
GKTR1:	MOV	AH,AL
	MOV	AL,DFRAME_NOW
	CMP	DX,CD_STARTPOS+2
	JL	SHORT GKTR4
	JNE	SHORT GKTR6
	CMP	AX,CD_STARTPOS
	JL	SHORT GKTR4
GKTR6:	CMP	DX,CD_ENDPOS+2
	JG	SHORT GKTR7
	JNE	SHORT GKTR5
	CMP	AX,CD_ENDPOS
	JLE	SHORT GKTR5
GKTR7:	MOV	AX,CD_ENDPOS
	MOV	DX,CD_ENDPOS+2
	JMP	SHORT GKTR5
GKTR4:	MOV	AX,CD_STARTPOS
	MOV	DX,CD_STARTPOS+2
GKTR5:	CALL	RED2HSG
	MOV	WORD PTR STARTSECTOR2,AX
	MOV	WORD PTR STARTSECTOR2+2,DX
	MOV	SI,AX
	MOV	DI,DX
	MOV	AX,CD_ENDPOS
	MOV	DX,CD_ENDPOS+2
	CALL	RED2HSG
	SUB	AX,SI
	SBB	DX,DI
	MOV	WORD PTR NUMBSECTOR2,AX
	MOV	WORD PTR NUMBSECTOR2+2,DX
	PUSH	EAX EBX EDX
	MOV	EAX,NUMBSECTOR2
	XOR	EDX,EDX
	MOV	DWORD PTR CD_IRQPOS,EDX
	SHL	EAX,10
	MOV	EBX,75
	DIV	EBX
	SUB	EAX,1024*4
	JNC	SHORT GKTR8
	XOR	EAX,EAX
GKTR8:	MOV	DWORD PTR CD_IRQEND,EAX
	POP	EDX EBX EAX
	PUSH	DS			;PLAY TRACK
	POP	ES
	MOV	BX,OFFSET PLAY2
	MOV	STATUS2,0
	MOV	ADRMODE2,0
	CALL	DWORD PTR DS:[DEV_ENTRY]	
	CALL	DWORD PTR DS:[DEV_INT]
COMMENT	*
	MOV	WORD PTR STARTSECTOR4,AX
	MOV	WORD PTR STARTSECTOR4+2,DX
	PUSH	DS			;SEEK
	POP	ES
	MOV	BX,OFFSET SEEK4
	MOV	STATUS4,0
	MOV	ADRMODE4,0
	CALL	DWORD PTR DS:[DEV_ENTRY]	
	CALL	DWORD PTR DS:[DEV_INT]
	*
	CALL	IRQ_INIT
	POP	BX
	MOV	CD_CONTROL,BL
	MOV	CD_STATUS,BH
GKTR3:	POP	ES
	POPA
	RET
SEEK_TRACK ENDP
;=============================================================================
; HOLT DEVICE STATUS
;-----------------------------------------------------------------------------
GET_DEVSTAT PROC NEAR
	PUSHA
	PUSH	ES
	PUSH	DS			;GET DEVICE STATUS
	POP	ES
	MOV	BX,OFFSET IOCTLI1
	MOV	STATUS1,0
	MOV	SIZE1,DEVSTATL
	MOV	TRANSADR1,OFFSET DEVSTAT
	CALL	DWORD PTR DS:[DEV_ENTRY]	
	CALL	DWORD PTR DS:[DEV_INT]
	POP	ES
	POPA
	RET
GET_DEVSTAT ENDP
;=============================================================================
; CHECKT CD-ROM WECHSEL
;-----------------------------------------------------------------------------
GET_MEDCHANGE PROC NEAR
	PUSHA
	PUSH	ES
	PUSH	DS			;CHECK MEDIA CHANGE
	POP	ES
	MOV	BX,OFFSET IOCTLI1
	MOV	STATUS1,0
	MOV	SIZE1,MEDCHL
	MOV	TRANSADR1,OFFSET MEDCH
	CALL	DWORD PTR DS:[DEV_ENTRY]	
	CALL	DWORD PTR DS:[DEV_INT]
	POP	ES
	POPA
	RET
GET_MEDCHANGE ENDP
;=============================================================================
; KONVERTIERT REDBOOK ADR IN DX:AX NACH HIGH SIERRA ADR IN DX:AX
;-----------------------------------------------------------------------------
RED2HSG PROC NEAR
	PUSH	CX
	MOV	CX,AX
	MOVZX	AX,DL
	MOV	DX,60
	MUL	DX
	MOVZX	DX,CH
	ADD	AX,DX
	MOV	DX,75
	MUL	DX
	XOR	CH,CH
	ADD	AX,CX
	ADC	DX,0	
	SUB	AX,150
	SBB	DX,0
	POP	CX
	RET
RED2HSG ENDP
;=============================================================================
; UEBERWACHT REPEAT LOOP UND DOOR OPEN/CHANGE
;-----------------------------------------------------------------------------
TRACK_CONTROL PROC NEAR
	PUSHA
	PUSH	DS ES CS
	POP	DS
	CMP	SYSTEM,0
	JNE	SHORT WT6
	MOV	AL,UHR_STATC
	OUT	UHR_INDEX,AL
	JMP	SHORT WT1
WT1:	JMP	SHORT WT2
WT2:	IN	AL,UHR_PORT
WT6:	MOV     AL,20H
	OUT     IRQ3,AL
	OUT	IRQ1,AL
	STI

	CMP	CD_CONTROL,0
	JE	SHORT WT3
	TEST	CD_STATUS,1
	JZ	SHORT WT3
	CMP	CD_CHANGE,0
	JNE	SHORT WT3
	INC	DWORD PTR CD_IRQPOS
	DEC	CD_COUNT
	JNZ	SHORT WT3
	MOV	CD_COUNT,1024
	MOV	AX,CD_IRQPOS+2
	CMP	AX,CD_IRQEND+2
	JB	SHORT WT3
	JNE	SHORT WT8
	MOV	AX,CD_IRQPOS
	CMP	AX,CD_IRQEND
	JB	SHORT WT3
WT8:	CALL	INFO_TRACK
	MOV	AX,STATUS1
	TEST	AH,80H
	JZ	SHORT WT5
	MOV	CD_CHANGE,1		;VERMUTLICH EIN CD CHANGE
WT5:	MOV	AL,DFRAME_NOW
	MOV	AH,DSEC_NOW
	MOVZX	DX,DMIN_NOW
	ADD	AH,2
	CMP	AH,60
	JB	SHORT WT4
	SUB	AH,60
	INC	DX
WT4:	CMP	DX,CD_ENDPOS+2
	JB	SHORT WT3
	CMP	AX,CD_ENDPOS
	JB	SHORT WT3
	MOV	AL,CD_TRACK
	CALL	PLAY_TRACK
	MOV	CD_CONTROL,1

WT3:	TEST	CHAINING,1
	JNZ	SHORT WT9
	CMP	SYSTEM,0
	JE	SHORT WT7
	DEC	IRQCOUNT
	JNZ	SHORT WT7
	MOV	IRQCOUNT,56
WT9:	POP	ES DS
	POPA
	JMP	DWORD PTR CS:[HOLD70]
WT7:	POP	ES DS
	POPA
	IRET
HOLD70		LABEL DWORD
		DW OFFSET TRACK_CONTROL
HOLD70_SEG	DW 0
TRACK_CONTROL ENDP
;=============================================================================
; TIMER INTERRUPT & MUSIC REQUEST EINSTELLEN
; SERVICE IRQ UMLEITUNG; USES THE REAL-TIME-CLOCK IRQ
;-----------------------------------------------------------------------------
IRQ_INIT PROC NEAR
	CLI
	XOR	AX,AX	
	MOV	ES,AX
	CMP	SYSTEM,0
	JNE	WU11
	TEST	CHAINING,1
	JNZ	SHORT WU15
	MOV     AX,COMP_SPEED2		;XCHANGE INIT & STOP DATA FOR DOS
	MOV     DX,COMP_SPEED3
	MOV     COMP_SPEED2,DX
	MOV     COMP_SPEED3,AX
	MOV	AL,UHR_STATA		;UHR-IRQ-RATE EINSTELLEN (1024 HZ)
	OUT	UHR_INDEX,AL
	JMP	SHORT WU1
WU1:	JMP	SHORT WU2
WU2:	XCHG	AL,AH
	IN	AL,UHR_PORT
	AND	AL,0F0H
	OR	AL,DL
	XCHG	AL,AH
	OUT	UHR_INDEX,AL
	JMP	SHORT WU3
WU3:	JMP	SHORT WU4
WU4:	XCHG	AL,AH
	OUT	UHR_PORT,AL
	JMP	SHORT WU5
WU5:	JMP	SHORT WU6
WU6:	MOV	AL,UHR_STATB		;UHR-IRQ-MODUS EINSTELLEN
	OUT	UHR_INDEX,AL
	JMP	SHORT WU7
WU7:	JMP	SHORT WU8
WU8:	XCHG	AL,AH
	IN	AL,UHR_PORT
	AND	AL,08FH
	MOV	DL,DH
	AND	DL,40H
	OR	AL,DL
	XCHG	AL,AH
	OUT	UHR_INDEX,AL
	JMP	SHORT WU9
WU9:	JMP	SHORT WU10
WU10:	XCHG	AL,AH
	OUT	UHR_PORT,AL
	IN	AL,IRQ4			;IRQ8 DE-/MASKIEREN
	AND	AL,0FEH
	MOV	DL,DH
	AND	DL,1
	OR	AL,DL
	OUT	IRQ4,AL
	MOV	AL,UHR_STATC		;IRQ LSCHEN
	OUT	UHR_INDEX,AL
	JMP	SHORT WU20
WU20:	JMP	SHORT WU21
WU21:	IN	AL,UHR_PORT
WU15:	MOV     BX,4*70H                ;UHR-IRQ VERBIEGEN
	MOV     EAX,ES:[BX]
	MOV     EDX,CS:HOLD70
	MOV     ES:[BX],EDX
	MOV     CS:HOLD70,EAX
	JMP	SHORT WU12
WU11:	TEST	CHAINING,1
	JNZ	SHORT WU16
	MOV     AX,COMP_SPEED4		;FOR WINDOWS
	MOV     DX,COMP_SPEED5
	MOV     COMP_SPEED4,DX
	MOV     COMP_SPEED5,AX
	MOV     AL,00110110B            ;TIMER0 AUF 1.024 KHZ EINSTELLEN
	OUT     PIT1,AL                 ;TEILER=1193
	MOV     AL,DL
	OUT     TIMER0,AL
	JMP     SHORT OUT40
OUT40:  MOV     AL,DH
	OUT     TIMER0,AL
WU16:	MOV     BX,4*8H                 ;TIMEOUT-IRQ VERBIEGEN
	MOV     EAX,ES:[BX]
	MOV     EDX,CS:HOLD70
	MOV     ES:[BX],EDX
	MOV     CS:HOLD70,EAX
WU12:	MOV	AL,20H
	OUT	IRQ3,AL
	OUT	IRQ1,AL
	STI
	RET
IRQ_INIT ENDP
;=============================================================================
CODE_SEGCD ENDS

END _MAINCD
