TITLE MULTIMEDIA-INTERFACE FOR SOUNDSYS 
;======================================

STACKLAENGE= 0200H
DOSSEG
.MODEL SMALL
.STACK STACKLAENGE
.DATA
;=============================================================================
B		EQU BYTE PTR
W		EQU WORD PTR
D		EQU DWORD PTR
SCR_WIDTH	= 320
SCR_HEIGHT	= 200
IRQ1            = 20H
IRQ2		= 21H
IRQ3		=0A0H
IRQ4		=0A1H
TIMER0		= 40H
TIMER2          = 42H
PIT1		= 43H
PPI             = 61H
UHR_INDEX	= 70H
UHR_PORT	= 71H
UHR_STATA	= 0AH
UHR_STATB	= 0BH
UHR_STATC	= 0CH
SC_INDEX	= 3C4H		;Indexregister des Sequencer-Ctrl.
SC_SCREEN	= 1		;CLOCKING MODE, SCREEN OFF
DAC_INDEX	= 03C8H
VERT_RETRACE    = 3DAH          ;Input Status-Register #1
VRAM_BASE	= 0A000H
;=============================================================================
ALIGN 2
PROG_START_SEG	DW 0
PROG_END_SEG	DW 0
ENV_SEG		DW 0
MUSIC_CALL	DW 0
MUSIC_SEG	DW 0
INT66_OFF	DW OFFSET INT66_HANDLER
INT66_SEG	DW SEG INT66_HANDLER
IRQ_SP		DW 0
IRQ_SS		DW 0
TSR_SP		DW 0
TSR_SS		DW 0
IRQ_AX		DW 0
IRQ_BX		DW 0
IRQ_PSP		DW 0
IRQ_MS		DW 0
DETCARD		DW 0
DETCONFIG	DW 220H
		DB 1,7
		DW 22222
		DB 0,1,0,0,0,255,255,255
TEMP_NAME	DB 64 DUP(0)
MOD_NAME	DB 64 DUP(0)
FX_NAME		DB 64 DUP(0)
FLC_NAME	DB 64 DUP(0)
VOL_NAME	DB 64 DUP(0)
ERROR_MSG1	DB "Needs at least a 386!",13,10,"$"
TITLE_MSG2	DB 13,10
		DB "MultiMedia Interface for SoundSystem4   (pd)1995 by the Frontman of Crew242",13,10
		DB "Usage: MMI [Filenames] [Players [Commands [Arguments]]]",13,10
		DB "           -?,-H       Help",13,10
		DB "           -U,-Q,-X    Uninstall MMI",13,10
		DB "           -N          No messages",13,10,13,10
		DB "MMI is now resident",13,10,"$"
TITLE_MSG3	DB "MMI successfully uninstalled",13,10,"$"

HELP_TEXT1	LABEL BYTE
DB 13,10
DB "MultiMedia Interface for SoundSystem4   (pd)1995 by the Frontman of Crew242",13,10
DB "Usage: MMI [Filenames] [Players [Commands [Arguments]]]",13,10,13,10
DB "Filenames:                                Players:",13,10
DB "    .MOD = Module (4/8 channel)           -MD = Module-Player",13,10
DB "    .FXA = Amiga (signed sample)          -CD = CD-Player",13,10
DB "    .FXP = PC FX (unsigned sample)        -FL = FLC-Player",13,10
DB "    .FLC = Animation (16-bit coded)",13,10
DB "    .FLI = Animation (8-bit coded)",13,10
DB "       # = CD Track",13,10,13,10
DB "Commands & Arguments: (dec= decimal, hex= hexadecimal, bin= binary digits)",13,10
DB "-FL S=dec L=dec V=bin M=bin, Play animation with additional parameters",13,10
DB "    S= Speed, L= Loops, V= Videomode (x= change to graphics),",13,10
DB "    M= Mode (xxx= use FX list, IRQ type, IRQ chaining)",13,10
DB "-CD INIT       Init CD, Errorlevel= Status",13,10
DB "    TOC        Get CD contents, Errorlevel= Max track",13,10
DB "    PLAY       T=dec E=bin M=bin, Play track",13,10
DB "               T= Track, E= Endless, M= Mode (xx= IRQ type, IRQ chaining)",13,10
DB "    STOP       Stop track",13,10
DB "    PAUSE      Pause track",13,10
DB "    RESUME     Resume track",13,10
DB "    SEEK       F=dec R=dec, Seek position, F= Forward, R= Backward",13,10
DB "Hit a key...",13,10
DB "$"

HELP_TEXT2	LABEL BYTE
DB 13,10
DB "-MD AUTO       Soundcard auto-detection",13,10
DB "               Errorlevel= 0 no card, 1 SB, 2 SB16, 3 PAS16, 4 GUS",13,10
DB "    LOADPL     C=dec, Load MOD-player code for soundcard C",13,10
DB "    UNLOADPL   Unload MOD-player code",13,10
DB "    INIT       B=hex D=dec I=dec R=dec M=bin, Init MOD-player code",13,10
DB "               B= Base address, D= DMA, I= IRQ, R= Samplerate,",13,10
DB "               M= Mode (xxx= internal type, IRQ chaining, IRQ type)",13,10
DB "    LOADMD     filename.MOD, Load module, Errorlevel= Status",13,10
DB "    PLAYMD     P=dec L=dec M=bin, Play module, Errorlevel= Position",13,10
DB "               P= Starting position, L= Looping position,",13,10
DB "               M= Mode (xx= FX off, music off)",13,10
DB "    STOP       Stop module playing",13,10
DB "    ENDMD      Unload module",13,10
DB "    LOADFX     filename.FXA, filename.FXP, Load FX, Errorlevel= FX handle",13,10
DB "    PLAYFX     H=dec P=dec R=dec, Play FX",13,10
DB "               H= FX handle, P= Panning (L=0-255=R), R= Frequency",13,10
DB "    ENDFX      Unload all FX",13,10
DB "    VOLUME     A=dec S=dec F=dec, Set volumes, Errorlevel= Master volume",13,10
DB "               A= Master, S= Music, F= FX (min=0-255=max)",13,10
DB "    MODE       P=dec L=dec M=bin, Set mode, Errorlevel= Position",13,10
DB "               P= New position, L= Looping position,",13,10
DB "               M= Mode (xx= FX off, music off)",13,10
DB "Hit a key...",13,10
DB "$"
;-----------------------------------------------------------------------------
ALIGN 2
OUTPUT		DB 0
MESSAGES	DB 0

COM_QUIT	DB 0
COM_MD		DB 0
COM_CD		DB 0
COM_FL		DB 0
COM_NUMB	DB 0

MD_FX		DB 0
MD_ARG		DB 0
MD_PLAYING	DB 0

MD_AUTO		DB 0
MD_LOADPL	DB 0
MD_UNLOADPL	DB 0
MD_INIT		DB 0
MD_LOADMD	DB 0
MD_PLAYMD	DB 0
MD_STOP		DB 0
MD_ENDMD	DB 0
MD_LOADFX	DB 0
MD_PLAYFX	DB 0
MD_ENDFX	DB 0
MD_VOLUME	DB 0
MD_MODE		DB 0

CD_NUM		DB 0
CD_ARG		DB 0

CD_INIT		DB 0
CD_TOC		DB 0
CD_PLAY		DB 0
CD_STOP		DB 0
CD_PAUSE	DB 0
CD_RESUME	DB 0
CD_SEEK		DB 0

ARG_NUMB	DB 0
ENABLE		DB 26 DUP(0)
VALUE		DW 26 DUP(0)
TYPES		DB 1,2,1,1,1,1,0,1,1,0,0,1,3	; 0= NO USE, 1= DECIMAL
		DB 0,0,1,0,1,1,1,0,1,0,0,0,0    ; 2= HEX, 3= BINARY DIGITS

MD_COMMANDS	DB "AUTO",0,"LOADPL",0,"UNLOADPL",0,"INIT",0,"LOADMD",0
		DB "PLAYMD",0,"STOP",0,"ENDMD",0,"LOADFX",0,"PLAYFX",0
		DB "ENDFX",0,"VOLUME",0,"MODE",0,0
CD_COMMANDS	DB "INIT",0,"TOC",0,"PLAY",0,"STOP",0,"PAUSE",0,"RESUME",0,"SEEK",0,0
;-----------------------------------------------------------------------------
ALIGN 2
COMP_SPEED2     DW 0106H
COMP_SPEED3     DW 4006H
COMP_SPEED4     DW 0
COMP_SPEED5     DW 1165
GRAFX_BUS       DW 0                    ;0=LOCAL BUS, 1=ISA BUS
CHAINING	DW 0
IRQCOUNT	DB 56
SYSTEM		DB 0
GDDHANDLE       DW 0
GDDLENGTH	DD 0,0
GDDZEIG		DW 0
VIR_SEG		DW 0
TIMER_SYNC      DW 0
CD_FUNC_LIST	DW CD_INIT_DEV,CD_INIT_DEV,GET_TOC
		DW PLAY_TRACK,STOP_TRACK,PAUSE_TRACK,RESUME_TRACK
		DW SEEK_TRACK,INFO_TRACK,GET_DEVSTAT,GET_MEDCHANGE
FLC_FUNC_LIST	DW FLC_INIT,FLC_INIT,FLC_END,PLAY_FLI
;-----------------------------------------------------------------------------
ALIGN 2
CD_DRIVE	DB 0
CD_STATUS	DB 0			;1=PLAYING, 2=PAUSED
CD_PLAYER	DB 1			;1=CD PLAYER, 0=GAME PLAYER
CD_CONTROL	DB 0			;1=REPEAT, 0=NO REPEAT
CD_COUNT	DW 1024			;IRQ COUNTER
VOL_INIT	DB 0
CD_TRACK	DB 0			;ACTUAL TRACKNO
CD_STARTPOS	DW 0,0			;ACTUAL STARTPOS IN REDBOOK
CD_ENDPOS	DW 0,0			;ACTUAL ENDPOS IN REDBOOK
CD_IRQPOS	DW 0,0			;ZAEHLER, UM ABFRAGE ZU AKTIVIEREN
CD_IRQEND	DW 0,0			;AB DIESEM ZAEHLER WIRD AKTIVIERT

IOCTLI1		LABEL	BYTE
REQ_HEAD1	DB 26			;LNGE VON IOCTL HEADER
SUB_UNIT1	DB 0
COMMAND1	DB 3
STATUS1		DW 0
		DB 8 DUP(0)
MEDIADESC1	DB 0
TRANSADR1	DW 0,0
SIZE1		DW 0
START1		DW 0
ID1		DD 0

IOGETHEADL	= 5
IOGETHEAD	DB 0			;GET DEVICE ADR
DEV_ENTRY	DW 0,0
DEV_INT		DW 0,0

DEVSTATL	= 5
DEVSTAT		DB 6			;GET DEVICE STATUS
DEV_STAT	DD 0

DISKINFOL	= 7
DISKINFO	DB 10			;GET DISK INFO (DIR)
LOW_TRACK	DB 0
HIGH_TRACK	DB 0
LEAD_OUT_TRACK	DD 0

TRACKINFOL	= 7
TRACKINFO	DB 11			;GET TRACK INFO (DIR)
TRACK_NO	DB 0
TRACK_START	DD 0
TRACK_CTL	DB 0

QINFOL		= 11
QINFO		DB 12			;GET PLAY STATUS
CTL_ADR		DB 0
TRACK_NOW	DB 0
INDEX_NOW	DB 0
TMIN_NOW	DB 0			;TRACK TIME
TSEC_NOW	DB 0
TFRAME_NOW	DB 0
TZERO_NOW	DB 0
DMIN_NOW	DB 0			;DISC TIME
DSEC_NOW	DB 0
DFRAME_NOW	DB 0

MEDCHL		= 2
MEDCH		DB 9			;CHECK MEDIA CHANGE
CD_CHANGE	DB 0

PLAY2		LABEL	BYTE
REQ_HEAD2	DB 22			;LNGE VON PLAY HEADER
SUB_UNIT2	DB 0
COMMAND2	DB 132
STATUS2		DW 0
		DB 8 DUP(0)
ADRMODE2	DB 0
STARTSECTOR2	DD 0
NUMBSECTOR2	DD 0

STOP3		LABEL	BYTE
REQ_HEAD3	DB 13			;LNGE VON STOP HEADER
SUB_UNIT3	DB 0
COMMAND3	DB 133
STATUS3		DW 0
		DB 8 DUP(0)

TOC		DD 100 DUP(0)		;TABLE OF CONTENTS (MAX 100)
					;STARTADRESSE DES NCHSTEN IST
					;ENDADRESSE DES MOMENTANEN
TCTRL		DB 100 DUP(0)		;TRACK CONTROL BYTE
					;01X0XXXX = DATA TRACK
;-----------------------------------------------------------------------------
ALIGN 2
FliCount	DB 1
FliRealSpeed	DB 5
FrameCount      DW 0
FramePtr        DW 0
FliLcCount      DW 0
FliBrunCount    DW 0
FliFirstFrame   DW 0,0

FliSize         DD 0
FliMagic        DW 0            ;should be af11h
FliFrames       DW 0
FliWidth        DW 0
FliHeight       DW 0
FliDepth        DW 0
FliFlags        DW 0
FliSpeed        DW 0
FliNext         DD 0
FliFrit         DD 0
FliExpand       DB 66H DUP(0)

FrameSize       DD 0
FrameMagic      DW 0            ;should be f1fah
FrameChunks     DW 0
FrameExpand     DB 8 DUP(0)
;-----------------------------------------------------------------------------
ALIGN 2
FX_STATUS	DW 0
FX_PANNING	DW 0
FX_OFFSET	DW 0
FX_SEG		DW 0
FX_CALL		DW 0,0

FLIFX1		DW -1
;		DW FRAME NUMBER, FX HANDLE, FX FREQ, -1 = END
;=============================================================================

.386
.CODE
;=============================================================================
MAIN PROC NEAR
        MOV     AX,@DATA                ;DATENSEGMENT SETZEN
        MOV     DS,AX
	MOV	AX,CS
	MOV     PROG_START_SEG,ES       ;PROGRAMMANFANG
        MOV     AX,SS                   ;UND -ENDE MERKEN
        ADD     AX,(STACKLAENGE/16)+1
        MOV     PROG_END_SEG,AX
        MOV     AX,ES:[2CH]             ;SEGMENT DES ENVIRONMENT-BLOCK HOLEN
        MOV     ENV_SEG,AX
        MOV     ES,AX			;PROGRAMM PFAD+NAME HOLEN
        XOR     DI,DI
        MOV     CX,8000H
MAL1:	MOV     AX,ES:[DI]
        TEST	AX,AX
        JZ      SHORT MAG1
        INC     DI
        LOOP    MAL1
MAG1:	TEST	CX,CX
        JZ      SHORT MAG2
        XOR     BX,BX
        ADD     DI,4
MAL2:	MOV     AL,ES:[DI]              ;PFAD+NAME KOPIEREN
        MOV     [VOL_NAME+BX],AL
	INC	DI
	INC	BX
	TEST	AL,AL
	JNZ	MAL2
MAG2:	MOV     BX,WORD PTR PROG_END_SEG;SPEICHER FREI MACHEN
        SUB     BX,WORD PTR PROG_START_SEG
        MOV     ES,PROG_START_SEG
        MOV     AH,4AH                  ;SPEICHERBLOCKGRSSE NDERN
        INT     21H
	XOR	AX,AX			;TEST AUF MMI
	MOV	ES,AX
	MOV	BX,ES:[66H*4]
	MOV	ES,ES:[66H*4+2]
	ADD	BX,2
	CMP	D ES:[BX],"4IMM"
	JE	INTERFACE
;-----------------------------------------------------------------------------
; INSTALL MMI TSR
;-----------------------------------------------------------------------------
	CLD
        PUSHF                           ;TEST AUF 386 PROZESSOR
        MOV     AX,0
        PUSH    AX
        POPF
        PUSHF
        POP     AX
        POPF
        AND     AX,0F000H
        CMP     AX,0F000H
        JE      WRONG_PROCESSOR
        PUSHF
        MOV     AX,7000H
        PUSH    AX
        POPF
        PUSHF
        POP     AX
        POPF
        AND     AX,7000H
        JZ      WRONG_PROCESSOR
	XOR	AX,AX			;SET SERVICE INT
	MOV	ES,AX
	MOV	AX,ES:[66H*4]
	MOV	BX,ES:[66H*4+2]
	MOV	CX,INT66_OFF
	MOV	DX,INT66_SEG
	MOV	ES:[66H*4],CX
	MOV	ES:[66H*4+2],DX
	MOV	INT66_OFF,AX
	MOV	INT66_SEG,BX
	MOV	TSR_SP,SP
	MOV	TSR_SS,SS
	SUB	TSR_SP,STACKLAENGE/2
	CALL	SCAN_COMMANDLINE	;SCAN COMMANDLINE
	JC	SHORT LEAVING1
	CALL	EXEC_COMMANDLINE	;EXECUTE COMMANDLINE
	ADD	TSR_SP,STACKLAENGE/2
LEAVING1:
        MOV     DX,WORD PTR PROG_END_SEG;SPEICHER FREI MACHEN
        SUB     DX,WORD PTR PROG_START_SEG
	MOV	AL,OUTPUT
	MOV	AH,31H
	INT	21H
WRONG_PROCESSOR:
	MOV	DX,OFFSET ERROR_MSG1
	MOV	AH,9
	INT	21H
	MOV	AX,4C01H		;ZURCK NACH DOS
	INT	21H
;-----------------------------------------------------------------------------
; COMMANDLINE MMI TSR
;-----------------------------------------------------------------------------
INTERFACE:				;SCAN COMMANDLINE
	CALL	SCAN_COMMANDLINE
	JC	SHORT LEAVING2
EXECUTION:				;EXECUTE COMMANDLINE
	CALL	EXEC_COMMANDLINE
LEAVING2:
	MOV	AL,OUTPUT
	MOV	AH,4CH
	INT	21H
MAIN ENDP
;=============================================================================


;=============================================================================
SCAN_COMMANDLINE PROC NEAR
	MOV	ES,PROG_START_SEG
	MOV	BX,80H
	MOV	AL,ES:[BX]
	TEST	AL,AL
	JZ	MBG16
	INC	BX

MBL1:	MOV	AL,ES:[BX]
	CMP	AL,0DH
	JE	MBG15
	CMP	AL,20H
	JNE	SHORT MBG3
MBL2:	INC	BX
	CMP	BX,100H
	JB	MBL1
	JMP	MBG15

MBG3:	CMP	AL,"-"			;OPTION?
	JE	SHORT MBG4
	CMP	AL,"/"
	JNE	MBG5
MBG4:	INC	BX
	MOV	AX,ES:[BX]
	CMP	AL,"A"
	JB	SHORT MBG6
	AND	AL,0DFH
MBG6:	AND	AH,0DFH
	CMP	AL,"N"			;NO MESSAGES
	JNE	SHORT MBG19
	MOV	MESSAGES,1
MBG19:	CMP	AL,"?"			;HELP
	JE	SHORT MBG17
	CMP	AL,"H"
	JNE	SHORT MBG18
MBG17:	CMP	MESSAGES,0
	JNE	MBL2
	MOV	AH,9
	MOV	DX,OFFSET HELP_TEXT1
	INT	21H
	XOR	AX,AX
	INT	16H
	MOV	AH,9
	MOV	DX,OFFSET HELP_TEXT2
	INT	21H
	XOR	AX,AX
	INT	16H
	JMP	MBL2
MBG18:	CMP	AL,"U"			;UNINSTALL MMI
	JE	SHORT MBG20
	CMP	AL,"Q"
	JE	SHORT MBG20
	CMP	AL,"X"
	JNE	SHORT MBG21
MBG20:	MOV	COM_QUIT,1
	JMP	MBL2
MBG21:	CMP	AX,"DM"			;MOD COMMANDS
	JNE	SHORT MBG22
	ADD	BX,2
	MOV	COM_MD,1
	MOV	SI,OFFSET MD_COMMANDS
	MOV	DI,OFFSET MD_AUTO
	MOV	ARG_NUMB,0
	CALL	SCAN_SUB
	MOV	AL,ARG_NUMB
	MOV	MD_ARG,AL
	JMP	MBL1
MBG22:	CMP	AX,"DC"			;CD COMMANDS
	JNE	SHORT MBG23
	ADD	BX,2
	MOV	COM_CD,1
	MOV	SI,OFFSET CD_COMMANDS
	MOV	DI,OFFSET CD_INIT
	MOV	ARG_NUMB,0
	CALL	SCAN_SUB
	MOV	AL,ARG_NUMB
	MOV	CD_ARG,AL
	JMP	MBL1
MBG23:	CMP	AX,"LF"			;FLC ARGUMENTS
	JNE	SHORT MBG24
	ADD	BX,2
	MOV	COM_FL,1
	MOV	ARG_NUMB,0
	CALL	SCAN_ARG
	JMP	MBL1
MBG24:	MOV	AL,ES:[BX]
	CMP	AL,20H
	JE	MBL1
	CMP	AL,0DH
	JE	MBL1
	INC	BX
	CMP	BX,100H
	JB	MBG24
	JMP	MBG15

MBG5:	XOR	DI,DI			;NAME
MBL3:	MOV	AL,ES:[BX]
	CMP	AL,"A"
	JB	SHORT MBG7
	AND	AL,0DFH
MBG7:	MOV	[TEMP_NAME+DI],AL
	CMP	AL,0DH
	JE	SHORT MBG8
	CMP	AL,20H
	JE	SHORT MBG8
	INC	DI
	INC	BX
	CMP	BX,100H
	JB	MBL3
MBG8:	MOV	[TEMP_NAME+DI],0
	CMP	DI,4
	JB	SHORT MBG9
	CMP	D [TEMP_NAME-4+DI],"DOM."
	JNE	SHORT MBG11
MBL4:	MOV	AL,[TEMP_NAME+DI]	;MODULE
	MOV	[MOD_NAME+DI],AL
	DEC	DI
	JNS	MBL4
	JMP	MBL1
MBG11:	CMP	D [TEMP_NAME-4+DI],"AXF."
	JE	SHORT MBG12
	CMP	D [TEMP_NAME-4+DI],"PXF."
	JNE	SHORT MBG13
	MOV	MD_FX,80H
MBG12:	MOV	AL,[TEMP_NAME+DI]	;FX
	MOV	[FX_NAME+DI],AL
	DEC	DI
	JNS	MBG12
	JMP	MBL1
MBG13:	CMP	D [TEMP_NAME-4+DI],"ILF."
	JE	SHORT MBG14
	CMP	D [TEMP_NAME-4+DI],"CLF."
	JNE	MBL1
MBG14:	MOV	AL,[TEMP_NAME+DI]	;ANIMATION
	MOV	[FLC_NAME+DI],AL
	DEC	DI
	JNS	MBG14
	JMP	MBL1
MBG9:	MOV	AL,TEMP_NAME		;CD NUMBER
	CMP	AL,"0"
	JB	MBL1
	CMP	AL,"9"
	JA	MBL1
	AND	AL,0FH
	MOV	CL,TEMP_NAME+1
	CMP	CL,"0"
	JB	SHORT MBG10
	CMP	CL,"9"
	JA	SHORT MBG10
	MOV	AH,10
	AND	CL,0FH
	MUL	AH
	ADD	AL,CL
MBG10:	MOV	CD_NUM,AL
	JMP	MBL1
MBG15:	CLC
	RET
MBG16:	CMP	MESSAGES,0
	JNE	SHORT MBG99
	MOV	AH,9
	MOV	DX,OFFSET TITLE_MSG2
	INT	21H
MBG99:	STC
	RET
SCAN_COMMANDLINE ENDP
;-----------------------------------------------------------------------------
SCAN_SUB PROC NEAR
LSS0:	MOV	AL,ES:[BX]
	CMP	AL,20H
	JNE	SHORT GSS2
	INC	BX
	CMP	BX,100H
	JB	LSS0
	JMP	SHORT GSS1
GSS2:	MOV	DX,BX
	MOV	CX,SI
LSS1:	XOR	BP,BP
	MOV	SI,CX
LSS2:	MOV	AL,ES:[BX]
	CMP	B [SI],0		;COMMAND MATCH
	JNE	SHORT GSS3
	MOV	B DS:[DI+BP],1
	INC	ARG_NUMB
	CALL	SCAN_ARG
	MOV	DX,BX
	JMP	LSS1
GSS3:	CMP	AL,0DH
	JE	SHORT GSS1
	CMP	AL,"-"
	JE	SHORT GSS1
	CMP	AL,"/"
	JE	SHORT GSS1
	CMP	AL,20H
	JNE	SHORT GSS5
	INC	BX
	CMP	BX,100H
	JB	LSS1
	JMP	SHORT GSS1
GSS5:	AND	AL,0DFH
	CMP	AL,[SI]			;CHECK COMMAND
	JNE	SHORT GSS4
	INC	BX
	INC	SI
	JMP	LSS2
GSS4:	INC	SI			;CHECK NEXT COMMAND
	CMP	B [SI],0
	JNE	GSS4
	MOV	BX,DX
	INC	BP
	INC	SI
	CMP	B [SI],0		;END OF LIST
	JNE	LSS2
	MOV	BX,DX			;NO MATCH
GSS1:	RET
SCAN_SUB ENDP
;-----------------------------------------------------------------------------
SCAN_ARG PROC NEAR
	PUSH	SI
LSA0:	MOV	AL,ES:[BX]
	CMP	AL,20H
	JNE	SHORT LSA1
	INC	BX
	CMP	BX,100H
	JB	LSA0
	JMP	SHORT GSA1
LSA1:	MOV	AX,ES:[BX]
	CMP	AL,0DH
	JE	SHORT GSA1
	CMP	AL,"-"
	JE	SHORT GSA1
	CMP	AL,"/"
	JE	SHORT GSA1
	CMP	AL,20H
	JNE	SHORT GSA2
	INC	BX
	CMP	BX,100H
	JB	LSA1
	JMP	SHORT GSA1
GSA2:	CMP	AH,"="
	JNE	SHORT GSA1
	ADD	BX,2
	AND	AL,0DFH
	CMP	AL,"A"
	JB	SHORT GSA3
	CMP	AL,"Z"
	JA	SHORT GSA3
	SUB	AL,"A"
	MOVZX	SI,AL
	MOV	AH,[TYPES+SI]
	TEST	AH,AH
	JZ	SHORT GSA3
	MOV	[ENABLE+SI],1
	INC	ARG_NUMB
	SHL	SI,1
	DEC	AH
	JNZ	SHORT GSA4
	CALL	GET_DECIMAL
	MOV	[VALUE+SI],AX
	JMP	SHORT GSA3
GSA4:	DEC	AH
	JNZ	SHORT GSA5
	CALL	GET_HEX
	MOV	[VALUE+SI],AX
	JMP	SHORT GSA3
GSA5:	DEC	AH
	JNZ	SHORT GSA3
	CALL	GET_DIGITS
	MOV	[VALUE+SI],AX
GSA3:	JMP	LSA1
GSA1:	POP	SI
	RET
SCAN_ARG ENDP
;-----------------------------------------------------------------------------
GET_DECIMAL PROC NEAR
	PUSH	CX DX
	XOR	CX,CX
LGD0:	MOV	AL,ES:[BX]
	CMP	AL,20H
	JNE	SHORT LGD1
	INC	BX
	CMP	BX,100H
	JB	LGD0
	JMP	SHORT GGD1
LGD1:	MOV	AX,ES:[BX]
	CMP	AL,0DH
	JE	SHORT GGD1
	CMP	AL,"-"
	JE	SHORT GGD1
	CMP	AL,"/"
	JE	SHORT GGD1
	CMP	AL,20H
	JE	SHORT GGD1
	CMP	AL,"0"
	JB	SHORT GGD1
	CMP	AL,"9"
	JA	SHORT GGD1
	AND	AX,0FH
	PUSH	AX
	MOV	AX,10
	MUL	CX
	MOV	CX,AX
	POP	AX
	ADD	CX,AX
	INC	BX
	CMP	BX,100H
	JB	LGD1
GGD1:	MOV	AX,CX
	POP	DX CX
	RET
GET_DECIMAL ENDP
;-----------------------------------------------------------------------------
GET_HEX PROC NEAR
	PUSH	CX
	XOR	CX,CX
LGH0:	MOV	AL,ES:[BX]
	CMP	AL,20H
	JNE	SHORT LGH1
	INC	BX
	CMP	BX,100H
	JB	LGH0
	JMP	SHORT GGH1
LGH1:	MOV	AX,ES:[BX]
	CMP	AL,0DH
	JE	SHORT GGH1
	CMP	AL,"-"
	JE	SHORT GGH1
	CMP	AL,"/"
	JE	SHORT GGH1
	CMP	AL,20H
	JE	SHORT GGH1
	CMP	AL,"A"
	JB	SHORT GGH2
	AND	AL,0DFH
GGH2:	CMP	AL,"0"
	JB	SHORT GGH1
	CMP	AL,"F"
	JA	SHORT GGH1
	CMP	AL,"A"
	JB	SHORT GGH3
	SUB	AL,7
GGH3:	AND	AX,0FH
	SHL	CX,4
	ADD	CX,AX
	INC	BX
	CMP	BX,100H
	JB	LGH1
GGH1:	MOV	AX,CX
	POP	CX
	RET
GET_HEX ENDP
;-----------------------------------------------------------------------------
GET_DIGITS PROC NEAR
	PUSH	CX
	XOR	CX,CX
LGI0:	MOV	AL,ES:[BX]
	CMP	AL,20H
	JNE	SHORT LGI1
	INC	BX
	CMP	BX,100H
	JB	LGI0
	JMP	SHORT GGI1
LGI1:	MOV	AX,ES:[BX]
	CMP	AL,0DH
	JE	SHORT GGI1
	CMP	AL,"-"
	JE	SHORT GGI1
	CMP	AL,"/"
	JE	SHORT GGI1
	CMP	AL,20H
	JE	SHORT GGI1
	CMP	AL,"1"
	JE	SHORT GGI2
	XOR	AL,AL
GGI2:	AND	AX,0FH
	SHL	CX,1
	ADD	CX,AX
	INC	BX
	CMP	BX,100H
	JB	LGI1
GGI1:	MOV	AX,CX
	POP	CX
	RET
GET_DIGITS ENDP
;=============================================================================


;=============================================================================
EXEC_COMMANDLINE PROC NEAR
	CMP	MOD_NAME,0
	JNE	SHORT MCG53
	CMP	COM_MD,1
	JNE	SHORT MCG54
MCG53:	CALL	EXEC_MOD
MCG54:	CMP	CD_NUM,0
	JNE	SHORT MCG51
	CMP	COM_CD,1
	JNE	SHORT MCG52
MCG51:	CALL	EXEC_CD
MCG52:	CMP	FLC_NAME,0
	JE	SHORT MCG50
	CALL	EXEC_FLC
MCG50:	CMP	COM_QUIT,1		;UNINSTALL MMI
	JNE	SHORT MCG55
	MOV	BP,1
	INT	66H
	CMP	MESSAGES,0
	JNE	SHORT MCG55
	MOV	AH,9
	MOV	DX,OFFSET TITLE_MSG3
	INT	21H
MCG55:	RET
EXEC_COMMANDLINE ENDP
;-----------------------------------------------------------------------------
EXEC_MOD PROC NEAR
	CMP	COM_MD,1
	JE	SHORT GXMD2
	PUSH	DS			;AUTOMATIC PLAY
	POP	ES
	MOV	BX,OFFSET DETCONFIG
	MOV	BP,2
	INT	66H
	MOV	DETCARD,AX
	TEST	AX,AX
	JZ	GXMD1
	MOV	BP,3
	INT	66H
	SETC	OUTPUT
	JC	GXMD1
	MOV	CX,0C242H
	MOV	BX,OFFSET DETCONFIG
	MOV	BP,41H
	INT	66H
	MOV	DX,OFFSET MOD_NAME
	MOV	BP,42H
	INT	66H
	SETC	OUTPUT
	JC	SHORT GXDM51
	MOV	BP,43H
	INT	66H
	SETC	OUTPUT
	JC	SHORT GXDM50
	JMP	GXMD1
GXMD2:	CMP	MD_ARG,0
	JNE	SHORT GXMD3
	MOV	BP,44H			;AUTOMATIC STOP
	INT	66H
GXDM50:	MOV	BP,45H
	INT	66H
GXDM51:	MOV	BP,4
	INT	66H
	JMP	GXMD1
GXMD3:	CMP	MD_AUTO,1		;AUTODETECT
	JNE	SHORT GXMD4
	PUSH	DS
	POP	ES
	MOV	BX,OFFSET DETCONFIG
	MOV	BP,2
	INT	66H
	MOV	OUTPUT,AL
	MOV	DETCARD,AX
GXMD4:	CMP	MD_LOADPL,1		;LOAD PLAYER
	JNE	SHORT GXMD5
	MOV	AX,DETCARD
	CMP	ENABLE-"A"+"C",1
	JNE	SHORT GXMD20
	MOV	AL,B VALUE+2*(-"A"+"C")
GXMD20:	TEST	AX,AX
	JZ	SHORT GXMD5
	CMP	AX,4
	JA	SHORT GXMD5
	MOV	BP,3
	INT	66H
	SETC	OUTPUT
	JC	GXMD1
GXMD5:	CMP	MD_UNLOADPL,1		;UNLOAD PLAYER
	JNE	SHORT GXMD6
	MOV	BP,4
	INT	66H
GXMD6:	CMP	MD_INIT,1		;CONFIG INIT
	JNE	SHORT GXMD7
	CMP	ENABLE-"A"+"B",1
	JNE	SHORT GXMD21
	MOV	AX,VALUE+2*(-"A"+"B")
	MOV	DETCONFIG,AX
GXMD21:	CMP	ENABLE-"A"+"D",1
	JNE	SHORT GXMD22
	MOV	AL,B VALUE+2*(-"A"+"D")
	MOV	B DETCONFIG+2,AL
GXMD22:	CMP	ENABLE-"A"+"I",1
	JNE	SHORT GXMD23
	MOV	AL,B VALUE+2*(-"A"+"I")
	MOV	B DETCONFIG+3,AL
GXMD23:	CMP	ENABLE-"A"+"R",1
	JNE	SHORT GXMD24
	MOV	AX,VALUE+2*(-"A"+"R")
	MOV	DETCONFIG+4,AX
GXMD24:	CMP	ENABLE-"A"+"M",1
	JNE	SHORT GXMD33
	MOV	AL,B VALUE+2*(-"A"+"M")
	MOV	AH,AL
	SHR	AL,2
	AND	AH,3
	MOV	DETCONFIG+6,AX
GXMD33:	PUSH	DS
	POP	ES
	MOV	CX,0C242H
	MOV	BX,OFFSET DETCONFIG
	MOV	BP,41H
	INT	66H
GXMD7:	CMP	MD_LOADMD,1		;LOAD MOD
	JNE	SHORT GXMD8
	PUSH	DS
	POP	ES
	MOV	DX,OFFSET MOD_NAME
	MOV	BP,42H
	INT	66H
	SETC	OUTPUT
	JC	GXMD1
GXMD8:	CMP	MD_PLAYMD,1		;PLAY MOD
	JNE	SHORT GXMD9
	MOV	BP,43H
	INT	66H
	SETC	OUTPUT
	JC	GXMD1
	MOV	MD_MODE,1
GXMD9:	CMP	MD_STOP,1		;STOP MOD
	JNE	SHORT GXMD10
	MOV	BP,44H
	INT	66H
GXMD10:	CMP	MD_ENDMD,1		;END MOD
	JNE	SHORT GXMD11
	MOV	BP,45H
	INT	66H
GXMD11:	CMP	MD_LOADFX,1		;LOAD FX
	JNE	SHORT GXMD12
	PUSH	DS
	POP	ES
	MOV	DX,OFFSET FX_NAME
	MOV	CL,MD_FX
	MOV	BP,46H
	INT	66H
	SHR	AX,1
	MOV	OUTPUT,AL
GXMD12:	CMP	MD_PLAYFX,1		;PLAY FX
	JNE	SHORT GXMD13
	MOV	BX,0
	MOV	CX,11025
	MOV	AL,128
	CMP	ENABLE-"A"+"H",1
	JNE	SHORT GXMD25
	MOV	BX,VALUE+2*(-"A"+"H")
	SHL	BX,1
GXMD25:	CMP	ENABLE-"A"+"R",1
	JNE	SHORT GXMD26
	MOV	CX,VALUE+2*(-"A"+"R")
GXMD26:	CMP	ENABLE-"A"+"P",1
	JNE	SHORT GXMD27
	MOV	AL,B VALUE+2*(-"A"+"P")
GXMD27:	MOV	BP,47H
	INT	66H
GXMD13:	CMP	MD_ENDFX,1		;END FX
	JNE	SHORT GXMD14
	MOV	BP,48H
	INT	66H
GXMD14:	CMP	MD_VOLUME,1		;SET VOLUMES
	JNE	SHORT GXMD15
	MOV	BP,4AH
	INT	66H
	CMP	ENABLE-"A"+"A",1
	JNE	SHORT GXMD28
	MOV	AL,B VALUE+2*(-"A"+"A")
GXMD28:	CMP	ENABLE-"A"+"S",1
	JNE	SHORT GXMD29
	MOV	BL,B VALUE+2*(-"A"+"S")
GXMD29:	CMP	ENABLE-"A"+"F",1
	JNE	SHORT GXMD30
	MOV	BH,B VALUE+2*(-"A"+"F")
GXMD30:	MOV	OUTPUT,AL
	MOV	BP,4BH
	INT	66H
GXMD15:	CMP	MD_MODE,1		;SET MODE
	JNE	SHORT GXMD1
	CMP	ENABLE-"A"+"L",1
	JNE	SHORT GXMD31
	MOV	AL,B VALUE+2*(-"A"+"L")
	MOV	BP,4CH
	INT	66H
GXMD31:	CMP	ENABLE-"A"+"P",1
	JNE	SHORT GXMD32
	MOV	AL,B VALUE+2*(-"A"+"P")
	MOV	BP,4EH
	INT	66H
GXMD32:	CMP	ENABLE-"A"+"M",1
	JNE	SHORT GXMD1
	MOV	AL,B VALUE+2*(-"A"+"M")
	MOV	BP,50H
	INT	66H
	MOV	BP,4DH
	INT	66H
	MOV	OUTPUT,AL
GXMD1:	RET
EXEC_MOD ENDP
;-----------------------------------------------------------------------------
EXEC_CD PROC NEAR
	CMP	COM_CD,1
	JE	SHORT GXCD2
	MOV	BP,81H			;AUTOMATIC PLAY
	INT	66H
	SETC	OUTPUT
	JC	GXCD1
	MOV	AL,CD_NUM
	MOV	AH,0
	MOV	CX,0
	MOV	BP,83H
	INT	66H
	JMP	GXCD1
GXCD2:	CMP	CD_ARG,0
	JNE	SHORT GXCD3
	MOV	BP,84H			;AUTOMATIC STOP
	INT	66H
	JMP	GXCD1
GXCD3:	CMP	CD_INIT,1		;CD INIT
	JNE	SHORT GXCD4
	MOV	BP,81H
	INT	66H
	SETC	OUTPUT
	JC	GXCD1
GXCD4:	CMP	CD_TOC,1		;GET TOC
	JNE	SHORT GXCD5
	MOV	BP,82H
	INT	66H
	MOV	AL,HIGH_TRACK
	MOV	OUTPUT,AL
GXCD5:	CMP	CD_PLAY,1		;PLAY TRACK
	JNE	SHORT GXCD6
	MOV	AL,CD_NUM
	MOV	AH,0
	MOV	CX,0
	CMP	ENABLE-"A"+"T",1
	JNE	SHORT GXCD20
	MOV	AL,B VALUE+2*(-"A"+"T")
GXCD20:	CMP	ENABLE-"A"+"E",1
	JNE	SHORT GXCD21
	MOV	AH,B VALUE+2*(-"A"+"E")
GXCD21:	CMP	ENABLE-"A"+"M",1
	JNE	SHORT GXCD22
	MOV	CL,B VALUE+2*(-"A"+"M")
GXCD22:	MOV	BP,83H
	INT	66H
GXCD6:	CMP	CD_STOP,1		;STOP TRACK
	JNE	SHORT GXCD7
	MOV	BP,84H
	INT	66H
GXCD7:	CMP	CD_PAUSE,1		;PAUSE TRACK
	JNE	SHORT GXCD8
	MOV	BP,85H
	INT	66H
GXCD8:	CMP	CD_RESUME,1		;RESUME TRACK
	JNE	SHORT GXCD9
	MOV	BP,86H
	INT	66H
GXCD9:	CMP	CD_SEEK,1		;SEEK
	JNE	SHORT GXCD1
	CMP	ENABLE-"A"+"F",1
	JNE	SHORT GXCD10
	MOV	AL,B VALUE+2*(-"A"+"F")
	JMP	SHORT GXCD11
GXCD10:	CMP	ENABLE-"A"+"R",1
	JNE	SHORT GXCD1
	MOV	AL,B VALUE+2*(-"A"+"R")
	NEG	AL
GXCD11:	MOV	BP,87H
	INT	66H
GXCD1:	RET
EXEC_CD ENDP
;-----------------------------------------------------------------------------
EXEC_FLC PROC NEAR
	MOV	CX,1			;INIT FLC
	CMP	COM_FL,1
	JNE	SHORT GXFL1
	CMP	ENABLE-"A"+"V",1
	JNE	SHORT GXFL1
	MOV	CX,VALUE+2*(-"A"+"V")
GXFL1:	PUSH	CX
	MOV	BP,0C1H
	INT	66H

	MOV	AL,0			;PLAY FLC
	MOV	CL,5
	MOV	CH,1
	CMP	COM_FL,1
	JNE	SHORT GXFL4
	CMP	ENABLE-"A"+"M",1
	JNE	SHORT GXFL2
	MOV	AL,B VALUE+2*(-"A"+"M")
GXFL2:	CMP	ENABLE-"A"+"S",1
	JNE	SHORT GXFL3
	MOV	CL,B VALUE+2*(-"A"+"S")
GXFL3:	CMP	ENABLE-"A"+"L",1
	JNE	SHORT GXFL4
	MOV	CH,B VALUE+2*(-"A"+"L")
GXFL4:	PUSH	DS
	POP	ES
	MOV	DX,OFFSET FLC_NAME
	MOV	BP,0C3H
	INT	66H
	SETC	OUTPUT

	POP	CX			;END FLC
	MOV	BP,0C2H
	INT	66H
	RET
EXEC_FLC ENDP
;=============================================================================




;=============================================================================
;
; MULTIMEDIA INTERFACE FOR SOUNDSYSTEM4
;
; INT 66H: BP= FUNCTION NUMBER
;
;
; 00H + U = INTERFACE FUNCTIONS
;
;       1 = UNINSTALL MMI         -
;       2 = AUTODETECT SOUNDCARD  ES:BX= POINTER TO CONFIG STRUC
;                                 AX= OUTPUT NUMBER DETECTED CARD
;       3 = LOAD PLAYER		  AX= NUMBER OF DETECTED CARD
;       4 = UNLOAD PLAYER         -
;
;
; 40H + V = MOD-PLAYER FUNCTIONS
;
;       1 CONFIG_INIT             CX=0C242H, ES:BX= POINTER TO PARAM-BLOCK
;                                 AX=SEGMENT OF PLAYER (FOR FX-ROUTINE)
;                                 IF CARRY RETURNED IS 1 THEN ERROR
;       2 LOAD_MOD                ES:DX IS POINTER TO FILENAME
;       3 PLAY_MUSIC              IF CARRY RETURNED IS 1 THEN ERROR
;       4 STOP_MUSIC
;       5 END_MUSIC
;       6 LOAD_SAMPLE             ES:DX IS POINTER TO FILENAME
;                                 CL=0/80H AMIGA/PC SAMPLE
; 	  		          RETURNED AX IS HANDLE OF THE SAMPLE
;       7 PLAY_SAMPLE             BX= HANDLE, CX= FREQUENCY
;                                 AL= PANNING: 0= LEFT, 255=RIGHT
;       8 END_SAMPLE
;       9 SET_SAMPLERATE            AX=RATE 10000-44100
;      10 GET_VOLUME              \ AL=MASTER_VOLUME
;      11 SET_VOLUME              / BL=MUSIC_VOL, BH=FX_VOL
;      12 SET_SONGLOOP              AL=PATTERN ORDER, >127 IS NO LOOP
;      13 GET_SONGPOSITION        \ AL=0..127 POSITION IN PATTERN ORDER
;      14 SET_SONGPOSITION        /
;      15 GET_SONGMOD             \ AL=0 MUSIC & FX, =1 MUSIC ONLY
;      16 SET_SONGMOD             /   =2 FX ONLY, =3 NO SOUND
;
;
; 80H + X = CD-PLAYER FUNCTIONS
;
;       1 DEVICE_INIT     IF CARRY RETURNED IS 1 THEN ERROR
;       2 GET_TOC         GET TABLE OF CONTENTS FOR A NEW CD
;       3 PLAY_TRACK      AL= TRACK NUMBER, AH= 0 NO REPEAT, 1= REPEAT
;                         CX= BIT 0= 0/1 DON'T CHAIN/CHAIN IRQ
;                             BIT 1= 0/1 RTC/TIMER IRQ
;       4 STOP_TRACK      -
;       5 PAUSE_TRACK     -
;       6 RESUME_TRACK    -
;       7 SEEK_TRACK      AL= -128 TO 127 SECONDS BACK- OR FORWARD
;       8 INFO_TRACK      CARRY= 0 PLAYING, 1= STOPPED
;       9 GET_DEVSTAT     SETS INTERNAL VAR, NO OUTPUT
;      10 GET_MEDCHANGE   SETS INTERNAL VAR, NO OUTPUT
;
;
; C0H + Y = FLC-PLAYER FUNCTIONS
;
;       1 = INIT FLC-PLAYER
;             ES:DX= POINTER TO FX-LIST (IF FX ENABLED)
;             AX:BX= POINTER TO FX-ROUTINE (IF FX ENABLED)
;             CX= 0 NO VIDEO CHANGE, 1= INIT VIDEO MODE
;       2 = END FLC-PLAYER
;             CX= 0 NO VIDEO CHANGE, 1= SET VIDEO BACK
;       3 = PLAY FLI/FLC
;             ES:DX= FILENAME OF FLC-ANIMATION
;             CL= SPEED IN WAIT FRAMES (1-255)
;             CH= NUMBER OF LOOPS OF THE FILE
;             AL= STATUS, BIT 0= 0/1 DON'T CHAIN/CHAIN IRQ
;                         BIT 1= IRQ TYPE 0/1= RTC/TIMER
;                         BIT 2= USE FX DATA FROM DEVICE-INIT 0/1= NO/YES
;
;-----------------------------------------------------------------------------
INT66_HANDLER PROC FAR
	JMP	SHORT INTG1
	DB	"MMI4"
	NOP
	NOP
	NOP
	NOP
INTG1:	PUSH	DS
	PUSH	@DATA
	POP	DS
	CLI
	MOV	IRQ_SP,SP
	MOV	IRQ_SS,SS
	MOV	SP,TSR_SP
	MOV	SS,TSR_SS
	STI
	PUSHA
	PUSH	ES FS GS
	PUSH	AX BX
	MOV	AH,62H			;GET ACTUAL PSP
	INT	21H
	MOV	IRQ_PSP,BX
	MOV	BX,PROG_START_SEG	;SET OWN PSP
	MOV	AH,50H
	INT	21H
	POP	BX AX
	CMP	BP,40H
	JAE	SHORT INTG3
	CALL	INT_FUNC
	JMP	SHORT INTG2
INTG3:	CMP	BP,80H
	JAE	SHORT INTG4
	CALL	MOD_FUNC
	JMP	SHORT INTG2
INTG4:	CMP	BP,0C0H
	JAE	SHORT INTG5
	CALL	CD_FUNC
	JMP	SHORT INTG2
INTG5:	CALL	FLC_FUNC
INTG2:	MOV	IRQ_AX,AX
	MOV	IRQ_BX,BX
	LAHF
	MOV	IRQ_MS,AX
	MOV	BX,IRQ_PSP		;SET PSP BACK
	MOV	AH,50H
	INT	21H
	POP	GS FS ES
	POPA
	MOV	AX,IRQ_MS
	SAHF
	MOV	AX,IRQ_AX
	MOV	BX,IRQ_BX
	CLI
	MOV	SS,IRQ_SS
	MOV	SP,IRQ_SP
	STI
	POP	DS
	RETF	2
INT66_HANDLER ENDP
;=============================================================================


;=============================================================================
INT_FUNC PROC NEAR
	AND	BP,3FH
	CMP	BP,1			;UNINSTALL
	JNE	SHORT IFG2
	TEST	CD_STATUS,3		;AUTOMATIC CD STOP
	JZ	SHORT MCG58
	MOV	BP,84H
	CALL	CD_FUNC
MCG58:	CMP	MD_PLAYING,0		;AUTOMATIC MOD STOP
	JE	SHORT MCG56
	MOV	BP,44H
	CALL	MOD_FUNC
	MOV	MD_PLAYING,0
MCG56:	MOV	BP,45H
	CALL	MOD_FUNC
	CALL	UNLOAD_PLAYER
	XOR	AX,AX			;UNSET SERVICE INT
	MOV	ES,AX
	MOV	AX,ES:[66H*4]
	MOV	BX,ES:[66H*4+2]
	MOV	CX,INT66_OFF
	MOV	DX,INT66_SEG
	MOV	ES:[66H*4],CX
	MOV	ES:[66H*4+2],DX
	MOV	INT66_OFF,AX
	MOV	INT66_SEG,BX
	MOV	ES,ENV_SEG		;FREE MEM
	MOV	AH,49H
	INT	21H
	MOV	ES,PROG_START_SEG
	MOV	AH,49H
	INT	21H
	JMP	SHORT IFG1
IFG2:	CMP	BP,2
	JNE	SHORT IFG3
	CALL	AUTO_DETECT
	PUSH	@DATA
	POP	DS
	JMP	SHORT IFG1
IFG3:	CMP	BP,3
	JNE	SHORT IFG4
	CALL	LOAD_PLAYER
	JMP	SHORT IFG1
IFG4:	CMP	BP,4
	JNE	SHORT IFG1
	CALL	UNLOAD_PLAYER
IFG1:	RET
INT_FUNC ENDP
;=============================================================================


;=============================================================================
MOD_FUNC PROC NEAR
	CMP	MUSIC_SEG,0
	JE	SHORT MFG1
	AND	BP,3FH
	CMP	BP,16
	JA	SHORT MFG1
	PUSH	BP
	CMP	BP,3			;PLAY
	JNE	SHORT MFG2
	MOV	MD_PLAYING,1
MFG2:	CMP	BP,4			;STOP
	JNE	SHORT MFG3
	MOV	MD_PLAYING,0
MFG3:	SHL	BP,2
	ADD	BP,100H
	MOV	MUSIC_CALL,BP
	PUSH	DS ES
	POP	DS FS
	CALL	D FS:[MUSIC_CALL]
	PUSH	@DATA
	POP	DS
	POP	BP
	PUSHF
	JNC	SHORT MFG4
	CMP	BP,3
	JNE	SHORT MFG4
	MOV	MD_PLAYING,0
MFG4:	CMP	BP,1
	JNE	SHORT MFG5
	MOV	AX,MUSIC_SEG
MFG5:	POPF
MFG1:	RET
MOD_FUNC ENDP
;=============================================================================


;=============================================================================
CD_FUNC PROC NEAR
	AND	BP,3FH
	CMP	BP,10
	JA	SHORT CFG1
	SHL	BP,1
	CALL	DS:[CD_FUNC_LIST+BP]
CFG1:	RET
CD_FUNC ENDP
;=============================================================================


;=============================================================================
FLC_FUNC PROC NEAR
	AND	BP,3FH
	CMP	BP,3
	JA	SHORT FFG1
	SHL	BP,1
	CALL	DS:[FLC_FUNC_LIST+BP]
FFG1:	RET
FLC_FUNC ENDP
;=============================================================================


;=============================================================================
; PLAY FLI-FILE FROM VOL
; ES:DX= FILENAME, CL= SPEED, CH= ANZAHL LOOPS
; AL= STATUS, BIT 0= IRQ CHAINING 0/1= OFF/ON
;             BIT 1= IRQ TYPE 0/1= RTC/TIMER
;             BIT 2= USE FX DATA FROM DEVICE-INIT 0/1= NO/YES
;=============================================================================
PLAY_FLI PROC NEAR
	PUSH	DS
	POP	GS
	AND	CL,7FH
	TEST	CD_STATUS,1
	JNZ	SHORT NO_IRQ0
	MOV	CHAINING,AX
NO_IRQ0:
	MOV	FX_STATUS,AX
	SHR	AL,1
	AND	AL,1
	MOV	SYSTEM,AL
	MOV	FliRealSpeed,CL
	MOV	FliCount,CH
	CALL	FliInit
	JC	GFLI6
	MOV	BX,1000H
	MOV	AH,48H
	INT	21H
	MOV	VIR_SEG,AX
	MOV	FrameCount,0FFFFH
	MOV	TIMER_SYNC,0
	MOV	FX_PANNING,224
	TEST	CD_STATUS,1
	JNZ	SHORT NO_IRQ1
	CALL	IRQ_INIT
NO_IRQ1:
	MOV	AX,VRAM_BASE		;CLEAR SCREEN
	MOV	ES,AX
	XOR     DI,DI
	MOV     CX,(SCR_HEIGHT*SCR_WIDTH)/4
	XOR     EAX,EAX
	CLD
	REP     STOSD
NextLoop:
	MOV	AH,1
	INT	16H
	JZ	SHORT NO_KEY
	XOR	AX,AX
	INT	16H
	CMP	AL,27
	JE	GFLI1
NO_KEY:	CALL	FliNextFrame
	JC	GFLI4
	MOV	CL,FliRealSpeed
	AND	CX,7FH
	MOV	BX,CX
	SHL	BX,4
	MOV	DX,VERT_RETRACE		;Vertical Retrace abwarten
SpeedLoop:
	IN	AL,DX
	TEST	AL,8
	JNZ	SpeedLoop
No_Retrace:
	IN	AL,DX
	TEST	AL,8
	JZ	No_Retrace
	CMP	BX,TIMER_SYNC
	JBE	SHORT GFLI3
	LOOP	SpeedLoop
GFLI3:	MOV	TIMER_SYNC,0
	CALL	FliShowFrame
	JC	SHORT GFLI1
	TEST	FX_STATUS,4
	JZ	NextLoop
	MOV	BX,FX_OFFSET		;PLAY FX
	MOV	FS,FX_SEG
LFLI1:	MOV	AX,FS:[BX]
	CMP	AX,-1
	JE	NextLoop
	DEC	AX
	CMP	AX,FrameCount
	JNE	SHORT GFLI2
	NOT	FX_PANNING
	PUSHA
	PUSH	DS ES FS GS
	MOV	AX,FX_PANNING
	MOV	CX,FS:[BX+4]
	MOV	BX,FS:[BX+2]
	MOV	DI,7
	CALL	DWORD PTR DS:[FX_CALL]
	POP	GS FS ES DS
	POPA
GFLI2:	ADD	BX,6
	JMP	LFLI1
GFLI4:	CMP	FliCount,0
	JNE	SHORT GFLI1
	CLC
	JMP	SHORT GFLI5
GFLI1:	STC
GFLI5:	PUSHF
	TEST	CD_STATUS,1
	JNZ	SHORT NO_IRQ2
	CALL	IRQ_INIT
NO_IRQ2:
	MOV	ES,VIR_SEG
	MOV	AH,49H
	INT	21H
	POPF
GFLI6:	PUSHF
	MOV	BX,GDDHANDLE
	MOV	AH,3EH
	INT	21H
	POPF
	RET
;-----------------------------------------------------------------------------
;File ES:DX=FILENAME  ffnen, FliHeader laden und prfen
;-----------------------------------------------------------------------------
FliInit:
	PUSH	DS ES
	POP	DS
	MOV     AX,3D80H
	INT     21H
	POP	DS
	JC      SHORT GLDM1
	MOV     GDDHANDLE,AX
	MOV	BX,AX
	MOV	CX,80H
	MOV	DX,OFFSET FliSize
	MOV	AH,3FH			;READ CX BYTES TO DS:DX
	INT	21H
	JC	SHORT GLDM1
	CMP	FliMagic,0AF11H
	JE	SHORT GLDM2
	CMP	FliMagic,0AF12H
	JE	SHORT GLDM2
	STC
	JMP	SHORT GLDM1
GLDM2:	CLC
GLDM1:	RET
;-----------------------------------------------------------------------------
;holt nchstes Frame in Puffer
;-----------------------------------------------------------------------------
FliNextFrame:
	INC	FrameCount
	MOV	AX,FrameCount
	CMP	AX,FliFrames
	JB	SHORT FliNextOk
	JNE	SHORT FliNext1
	DEC	FliCount
	JNZ	SHORT FliNextOk
	JMP	SHORT FliNextError
FliNext1:
	MOV	FrameCount,1
	MOV	BX,GDDHANDLE
	MOV	DX,FliFirstFrame
	MOV	CX,FliFirstFrame+2
	MOV	AX,4200H		;setzt Pointer in File bx nach cx:dx
	INT	21H
	MOV	AX,FrameCount
	JMP	SHORT FliNextOk2
FliNextOk:
	CMP	AX,1
	JNE	SHORT FliNextOk2
	MOV	BX,GDDHANDLE		
	MOV	AX,4201H		;holt Pointer in File bx nach dx:ax
	XOR	CX,CX
	XOR	DX,DX
	INT	21H
	MOV	FliFirstFrame,AX
	MOV	FliFirstFrame+2,DX
FliNextOk2:
	MOV	BX,GDDHANDLE
	MOV	CX,16
	MOV	DX,OFFSET FrameSize
	MOV	AH,3FH			;READ CX BYTES TO DS:DX
	INT	21H
	JC	SHORT FliNextError
	MOV	BX,GDDHANDLE
	MOV	CX,WORD PTR FrameSize
	SUB	CX,16
	CMP	FrameMagic,0F1FAH
	JE	SHORT FliNextOk3
	MOV	DX,CX
	XOR	CX,CX			;INFO FRAME AUSLASSEN
	MOV	AX,4201H		;setzt Pointer in File bx nach cx:dx
	INT	21H
	JMP	FliNextOk2
FliNextOk3:
	PUSH	DS
	MOV	DS,VIR_SEG
	XOR	DX,DX
	MOV	AH,3FH			;READ CX BYTES TO DS:DX
	INT	21H
	POP	DS
	JC	SHORT FliNextError
	CMP	AX,CX
	JNE	SHORT FliNextError
	CLC
	RET
FliNextError:
	STC
	RET
;-----------------------------------------------------------------------------
;Verarbeitet Frame aus Puffer
;-----------------------------------------------------------------------------
FliShowFrame:
	CMP	FrameChunks,0
	JE	SHORT FliNoChunk
	MOV	FS,VIR_SEG
	XOR	BP,BP
	MOV	FramePtr,BP
FliNextChunk:				;64-LEVEL-COLOR
	CMP	WORD PTR FS:[BP+4],0BH	;CHUNKS OF FORMAT AF11H
	JNE	SHORT ChunkJ1
	XOR	AH,AH
	CALL	FliColorChunk
	JMP	SHORT FliEndChunk
ChunkJ1:				;DELTA-FLI, COMPRESSED, BYTE
	CMP	WORD PTR FS:[BP+4],0CH
	JNE	SHORT ChunkJ2
	CALL	FliLcChunk
	JMP	SHORT FliEndChunk
ChunkJ2:				;BLACK FRAME
	CMP	WORD PTR FS:[BP+4],0DH
	JNE	SHORT ChunkJ3
	CALL	FliBlackChunk
	JMP	SHORT FliEndChunk
ChunkJ3:				;BYTE RUN, COMPRESSED
	CMP	WORD PTR FS:[BP+4],0FH
	JNE	SHORT ChunkJ4
	CALL	FliBrunChunk
	JMP	SHORT FliEndChunk
ChunkJ4:				;LITERAL, UNCOMPRESSED
	CMP	WORD PTR FS:[BP+4],10H
	JNE	SHORT ChunkJ5
	CALL	FliCopyChunk
	JMP	SHORT FliEndChunk
ChunkJ5:				;256-LEVEL-COLOR
	CMP	WORD PTR FS:[BP+4],04H	;CHUNKS OF FORMAT AF12H
	JNE	SHORT ChunkJ6
	MOV	AH,1
	CALL	FliColorChunk
	JMP	SHORT FliEndChunk
ChunkJ6:				;DELTA-FLC, COMPRESSED, WORD
	CMP	WORD PTR FS:[BP+4],07H
	JNE	SHORT ChunkJ7
	CALL	FlcLcChunk
	JMP	SHORT FliEndChunk
ChunkJ7:				;18 PREVIEW STAMP SKIPPED
FliEndChunk:
	MOV	BP,FramePtr
	ADD	BP,FS:[BP]
	MOV	FramePtr,BP
	DEC	FrameChunks
	JNZ	FliNextChunk
FliNoChunk:
	CALL	SCREEN_ON
	CLC
	RET
FliFrameError:
	CALL	SCREEN_ON
	STC
	RET
;-----------------------------------------------------------------------------
;verarbeitet Chunk FLI_Color ab fs:bp
;AH=0 64-LEVEL-COLORS, #0 256-LEVEL-COLORS
;-----------------------------------------------------------------------------
FliColorChunk:
	CALL	SCREEN_OFF
	PUSH	DS FS
	POP	DS
	ADD	BP,6
	XOR	AL,AL
	MOV	BX,FS:[BP]
	ADD	BP,2
FliMoreColor:
	ADD	AL,FS:[BP]
	MOV	DX,DAC_INDEX
	OUT	DX,AL
	INC	DX
	MOV	SI,BP
	ADD	SI,2
	MOVZX	CX,FS:[BP+1]
	OR	CL,CL
	JNZ	SHORT FliNot256
	MOV	CX,100H
FliNot256:
	ADD	AL,CL
	OR	AH,AH
	JZ	SHORT Fli64L
	PUSH	AX
Fli256L:
	MOV	AX,[SI]
	SHR	AL,2
	SHR	AH,2
	OUT	DX,AL
	MOV	AL,AH
	INC	SI
	OUT	DX,AL
	INC	SI
	MOV	AL,[SI]
	INC	SI
	SHR	AL,2
	OUT	DX,AL
	LOOP	Fli256L
	POP	AX
	JMP	SHORT FliGoC
Fli64L:	MOV	DI,CX			; CX * 3
	ADD	CX,DI
	ADD	CX,DI
	REP OUTSB
FliGoC:	MOV	BP,SI
	DEC	BX
	JNZ	FliMoreColor
	POP	DS
	TEST	GRAFX_BUS,1
	JNZ	SHORT FliGoS
	CALL	SCREEN_ON
FliGoS:	CLC
	RET
;-----------------------------------------------------------------------------
;verarbeitet Chunk FLI_LC ab fs:bp
;-----------------------------------------------------------------------------
FliLcChunk:
	PUSH	DS FS
	POP	DS 
	ADD	BP,6
	MOV	AX,FS:[BP+2]
	MOV	GS:FliLcCount,AX
	MOV	AX,SCR_HEIGHT
	SUB	AX,GS:FliHeight
	SHR	AX,1
	ADD	AX,FS:[BP]
	MOV	DI,SCR_WIDTH
	MUL	DI
	MOV	DX,AX
	SUB	DI,GS:FliWidth
	SHR	DI,1
	ADD	DX,DI
	ADD	BP,4
FliLcNext2:
	MOVZX	BX,FS:[BP]
	INC	BP
	MOV	DI,DX
	ADD	DX,GS:FliWidth
	OR	BL,BL
	JZ	SHORT FliLcNext3
FliLcNext:
	MOVZX	CX,FS:[BP]
	ADD	DI,CX
	MOV	CL,FS:[BP+1]
	TEST	CL,80H
	JZ	SHORT FliLcSeq
	NEG	CL
	MOV	AL,FS:[BP+2]
	SHR	CL,1
	JNC	SHORT FliLcHalf1
	STOSB
FliLcHalf1:
	JCXZ	SHORT FliLcZero1
	MOV	AH,AL
	REP STOSW
FliLcZero1:
	ADD	BP,3
	DEC	BX
	JNZ	FliLcNext
FliLcNext3:
	DEC	GS:FliLcCount
	JNZ	FliLcNext2
	POP	DS
	CLC
	RET
FliLcSeq:
	ADD	BP,2
	MOV	SI,BP
	SHR	CL,1
	JNC	SHORT FliLcHalf2
	MOVSB
FliLcHalf2:
	JCXZ	SHORT FliLcZero2
	REP MOVSW
FliLcZero2:
	MOV	BP,SI
	DEC	BX
	JNZ	FliLcNext
	DEC	GS:FliLcCount
	JNZ	FliLcNext2
	POP	DS
	CLC
	RET
;-----------------------------------------------------------------------------
;verarbeitet Chunk FLC_LC ab fs:bp
;-----------------------------------------------------------------------------
FlcLcChunk:
	PUSH	DS FS
	POP	DS
	ADD	BP,6
	MOV	AX,FS:[BP]
	MOV	GS:FliLcCount,AX
	MOV	AX,SCR_HEIGHT
	SUB	AX,GS:FliHeight
	SHR	AX,1
	MOV	DX,SCR_WIDTH
	MUL	DX
	MOV	DX,SCR_WIDTH
	SUB	DX,GS:FliWidth
	SHR	DX,1
	ADD	DX,AX
	ADD	BP,2
FlcLcNext2:
	MOV	AX,FS:[BP]
	ADD	BP,2
	TEST	AH,80H
	JZ	SHORT FlcLcNext4
	TEST	AH,40H
	JZ	SHORT FlcLcNext5
	PUSH	DX
	MOV	DI,GS:FliWidth
	NEG	AX
	MUL	DI
	POP	DX
	ADD	DX,AX
	JMP	FlcLcNext2
FlcLcNext5:
	MOV	DI,DX
	ADD	DI,GS:FliWidth
	DEC	DI
	STOSB
	JMP	FlcLcNext2
FlcLcNext4:
	MOV	BX,AX
	MOV	DI,DX
	ADD	DX,GS:FliWidth
	OR	BX,BX
	JZ	SHORT FlcLcNext3
FlcLcNext:
	MOVZX	CX,FS:[BP]
	INC	BP
	ADD	DI,CX
	MOV	CL,FS:[BP]
	INC	BP
	TEST	CL,80H
	JZ	SHORT FlcLcSeq
	NEG	CL
	JCXZ	SHORT FlcLcZero1
	MOV	AX,FS:[BP]
	ADD	BP,2
	REP STOSW
	JMP	SHORT FlcLcZero1
FlcLcSeq:
	MOV	SI,BP
	JCXZ	SHORT FlcLcZero2
	REP MOVSW
FlcLcZero2:
	MOV	BP,SI
FlcLcZero1:
	DEC	BX
	JNZ	FlcLcNext
FlcLcNext3:
	DEC	GS:FliLcCount
	JNZ	FlcLcNext2
	POP	DS
	CLC
	RET
;-----------------------------------------------------------------------------
;verarbeitet Chunk FLI_BLACK ab fs:bp
;-----------------------------------------------------------------------------
FliBlackChunk:
	MOV	AX,GS:FliHeight
	MOV	DI,SCR_WIDTH
	MUL	DI
	MOV	CX,AX
	SHR	CX,2
	MOV	AX,SCR_HEIGHT
	SUB	AX,GS:FliHeight
	SHR	AX,1
	MUL	DI
	MOV	DI,AX
	XOR	EAX,EAX
	REP STOSD
	CLC
	RET
;-----------------------------------------------------------------------------
;verarbeitet Chunk FLI_BRUN ab fs:bp
;-----------------------------------------------------------------------------
FliBrunChunk:
	PUSH	DS FS
	POP	DS
	ADD	BP,6
	MOV	AX,GS:FliHeight
	MOV	GS:FliBrunCount,AX
	MOV	AX,SCR_HEIGHT
	SUB	AX,GS:FliHeight
	SHR	AX,1
	MOV	DI,SCR_WIDTH
	MUL	DI
	SUB	DI,GS:FliWidth
	SHR	DI,1
	ADD	DI,AX
FliBrunNext2:
	MOVZX	BX,FS:[BP]
	INC	BP
FliBrunNext:
	MOVZX	CX,FS:[BP]
	TEST	CL,80H
	JNZ	SHORT FliBrunSeq
	MOV	AL,FS:[BP+1]
	SHR	CL,1
	JNC	SHORT FliBrunHalf1
	STOSB
FliBrunHalf1:
	JCXZ	SHORT FliBrunZero1
	MOV	AH,AL
	REP STOSW
FliBrunZero1:
	ADD	BP,2
	DEC	BX
	JNZ	FliBrunNext
FliBrunNext3:
	DEC	GS:FliBrunCount
	JNZ	FliBrunNext2
	POP	DS
	CLC
	RET
FliBrunSeq:
	NEG	CL
	INC	BP
	MOV	SI,BP
	SHR	CL,1
	JNC	SHORT FliBrunHalf2
	MOVSB
FliBrunHalf2:
	JCXZ	SHORT FliBrunZero2
	REP MOVSW
FliBrunZero2:
	MOV	BP,SI
	DEC	BX
	JNZ	FliBrunNext
	DEC	GS:FliBrunCount
	JNZ	FliBrunNext2
	POP	DS
	CLC
	RET
;-----------------------------------------------------------------------------
;verarbeitet Chunk FLI_COPY ab fs:bp
;-----------------------------------------------------------------------------
FliCopyChunk:
	PUSH	DS FS
	POP	DS
	ADD	BP,6
	MOV	SI,BP
	MOV	AX,GS:FliHeight
	MOV	DI,GS:FliWidth
	MUL	DI
	MOV	CX,AX
	SHR	CX,2
	MOV	AX,SCR_HEIGHT
	SUB	AX,GS:FliHeight
	SHR	AX,1
	MOV	DI,SCR_WIDTH
	MUL	DI
	MOV	DI,AX
	REP MOVSD
	POP	DS
	CLC
	RET
PLAY_FLI ENDP
;=============================================================================
SCREEN_OFF PROC NEAR
	PUSH	AX DX
	MOV	DX,SC_INDEX
	MOV	AL,SC_SCREEN
	OUT	DX,AL
	INC	DX
	IN	AL,DX
	OR	AL,00100000B
	OUT	DX,AL
	OR	FliRealSpeed,80H
	POP	DX AX
	RET
SCREEN_OFF ENDP
;=============================================================================
SCREEN_ON PROC NEAR
	TEST	FliRealSpeed,80H
	JZ	SHORT GSCO1
	PUSH	AX DX
	MOV	DX,SC_INDEX
	MOV	AL,SC_SCREEN
	OUT	DX,AL
	INC	DX
	IN	AL,DX
	AND	AL,11011111B
	OUT	DX,AL
	AND	FliRealSpeed,7FH
	POP	DX AX
GSCO1:	RET
SCREEN_ON ENDP
;=============================================================================


;=============================================================================
; EINSTELLEN DES VIDEOMODUS
; ES:DX= POINTER TO FX-LIST, AX:BX= POINTER TO FX-ROUTINE
; CX= 0 DON'T CHANGE VIDEO MODE, 1= INIT VIDEO MODE
;-----------------------------------------------------------------------------
FLC_INIT PROC NEAR
	MOV	FX_OFFSET,DX
	MOV	FX_SEG,ES
	MOV	FX_CALL,BX
	MOV	FX_CALL+2,AX
	JCXZ	SHORT GVID1
DIM1:	MOV	DX,3DAH			;WAIT FOR RETRACE
	IN	AL,DX
	TEST	AL,8
	JZ	SHORT DIM1
	MOV	DX,DAC_INDEX
	XOR	AL,AL
	OUT	DX,AL
	INC	DX
	MOV	CX,256*3
DIM2:	OUT	DX,AL
	LOOP	DIM2
	MOV     AX,13H                  ;320*200 256-FARBEN-MODUS
	INT     10H
	MOV     AX,VRAM_BASE            ;VIDEORAM FLLEN (HORIZONTALE LIN.)
	MOV     ES,AX
	XOR     DI,DI
	MOV     CX,16000
	XOR     EAX,EAX
	CLD
	REP     STOSD
GVID1:	RET
FLC_INIT ENDP
;=============================================================================
; CX= 0 DON'T CHANGE VIDEO MODE, 1= END VIDEO MODE
;-----------------------------------------------------------------------------
FLC_END PROC NEAR
	JCXZ	SHORT GDE1
	MOV	AX,3
	INT	10H
GDE1:	RET
FLC_END ENDP
;=============================================================================


;=============================================================================
; INIT PLAYER
;-----------------------------------------------------------------------------
CD_INIT_DEV PROC NEAR
	CMP	CD_DRIVE,0
	JNE	NOBUSY
	MOV	AX,1500H		;MSCDEX TEST
	XOR	BX,BX
	INT	2FH
	OR	BX,BX
	JZ	SHORT NO_AUDIO		;MSCDEX NICHT INSTALLIERT
	XOR	CH,CH
	MOV	CD_DRIVE,CL
	MOV	AX,1510H		;GET DEVICE DRIVER ADDRESS
	PUSH	DS
	POP	ES
	MOV	BX,OFFSET IOCTLI1
	MOV	SIZE1,IOGETHEADL
	MOV	TRANSADR1,OFFSET IOGETHEAD
	MOV	TRANSADR1+2,DS
	INT	2FH
	MOV	BX,DEV_ENTRY		;GET STRATEGY POINT FROM DEVICE HEADER
	MOV	ES,DEV_ENTRY+2
	MOV	AX,ES:[BX+6]
	MOV	DX,ES:[BX+8]
	MOV	DEV_ENTRY,AX		;DEV_ENTRY NOW ADR FUER DATA TRANSFER
	MOV	DEV_INT,DX		;DEV_INT JETZT ADR FUER DEV AKTION
	MOV	DEV_INT+2,ES
	MOV	AL,SUB_UNIT1
	MOV	SUB_UNIT2,AL
	MOV	SUB_UNIT3,AL
	CALL	GET_DEVSTAT		;CHECK AUDIO REPLAY CAPABILITY
	MOV	AX,WORD PTR DEV_STAT
	TEST	AX,10H
	JZ	SHORT NO_AUDIO		;KEIN MULTIMEDIA CD-ROM
	TEST	AX,200H
	JZ	SHORT NO_AUDIO		;KEIN MULTIMEDIA CD-ROM
	TEST	AX,801H
	JNZ	SHORT NO_AUDIO
	MOV	CD_STATUS,0		;CD-ROM ABSTELLEN, FALLS NOCH BUSY
	TEST	STATUS1,200H
	JZ	SHORT NOBUSY
	MOV	CD_STATUS,3
	CALL	STOP_TRACK
	CALL	IRQ_INIT
NOBUSY:	CALL	GET_TOC
	CLC
	RET
NO_AUDIO:
	STC
	RET
CD_INIT_DEV ENDP
;=============================================================================
; INITIALISIERT NEUE CD
;-----------------------------------------------------------------------------
GET_TOC PROC NEAR
	PUSHA
	PUSH	ES
	PUSH	EAX
	MOV	CD_CONTROL,0		;IRQ TRACK CONTROL DISABLE
	PUSH	DS			;GET DISK INFO
	POP	ES
	MOV	BX,OFFSET IOCTLI1
	MOV	STATUS1,0
	MOV	SIZE1,DISKINFOL
	MOV	TRANSADR1,OFFSET DISKINFO
	CALL	DWORD PTR DS:[DEV_ENTRY]	
	CALL	DWORD PTR DS:[DEV_INT]
	MOV	CL,LOW_TRACK
	XOR	BX,BX
LGTO1:	PUSH	BX CX
	PUSH	DS			;GET TRACK INFO
	POP	ES
	MOV	BX,OFFSET IOCTLI1
	MOV	STATUS1,0
	MOV	SIZE1,TRACKINFOL
	MOV	TRANSADR1,OFFSET TRACKINFO
	MOV	TRACK_NO,CL
	CALL	DWORD PTR DS:[DEV_ENTRY]	
	CALL	DWORD PTR DS:[DEV_INT]
	POP	CX BX
	MOV	EAX,TRACK_START
	MOV	[TOC+BX],EAX
	SHR	BX,2
	MOV	AL,TRACK_CTL
	MOV	[TCTRL+BX],AL
	INC	BX
	SHL	BX,2
	INC	CL
	CMP	CL,HIGH_TRACK
	JBE	LGTO1
	MOV	EAX,LEAD_OUT_TRACK
	MOV	[TOC+BX],EAX
	MOV	CD_CHANGE,0
	POP	EAX
	POP	ES
	POPA
	RET
GET_TOC ENDP
;=============================================================================
; SPIELT EINEN TRACK
; AL= TRACK NUMBER, AH= 0 NO REPEAT, 1 REPEAT
; CX= BIT 0= 0/1 DON'T CHAIN/CHAIN IRQ
;     BIT 1= 0/1 RTC/TIMER IRQ
;-----------------------------------------------------------------------------
PLAY_TRACK PROC NEAR
	PUSHA
	PUSH	ES
	CMP	CD_CHANGE,0
	JNE	SHORT GPTR4
	CMP	CD_CONTROL,0
	JNE	SHORT GPTR4
	CMP	CD_PLAYER,0		;FALLS GAMEPLAY, DANN KEIN CHECK
	JE	SHORT GPTR3
	CALL	GET_MEDCHANGE
	CMP	CD_CHANGE,0
	JG	SHORT GPTR3
GPTR4:	CALL	GET_TOC
GPTR3:	MOV	CD_CHANGE,0
	CMP	AL,LOW_TRACK
	JB	GPTR1
	CMP	AL,HIGH_TRACK
	JA	GPTR1
	TEST	CD_STATUS,1
	JZ	SHORT GPTR2
	CALL	PAUSE_TRACK		;PAUSE BEFORE NEW
GPTR2:	MOV	CD_CONTROL,AH		;IRQ TRACK CONTROL
	MOV	CD_TRACK,AL
	MOV	CHAINING,CX
	SHR	CL,1
	AND	CL,1
	MOV	SYSTEM,CL
	SUB	AL,LOW_TRACK
	MOVZX	BX,AL
	SHL	BX,2
	MOV	AX,WORD PTR [TOC+BX]
	MOV	DX,WORD PTR [TOC+2+BX]
	MOV	CD_STARTPOS,AX
	MOV	CD_STARTPOS+2,DX
	CALL	RED2HSG
	MOV	SI,AX
	MOV	DI,DX
	ADD	BX,4
	MOV	AX,WORD PTR [TOC+BX]
	MOV	DX,WORD PTR [TOC+2+BX]
	MOV	CD_ENDPOS,AX
	MOV	CD_ENDPOS+2,DX
	CALL	RED2HSG
	SUB	AX,SI
	SBB	DX,DI
	MOV	WORD PTR STARTSECTOR2,SI
	MOV	WORD PTR STARTSECTOR2+2,DI
	MOV	WORD PTR NUMBSECTOR2,AX
	MOV	WORD PTR NUMBSECTOR2+2,DX
	PUSH	EAX EBX EDX
	MOV	EAX,NUMBSECTOR2
	XOR	EDX,EDX
	MOV	DWORD PTR CD_IRQPOS,EDX
	SHL	EAX,10
	MOV	EBX,75
	DIV	EBX
	SUB	EAX,1024*4
	JNC	SHORT GPTR5
	XOR	EAX,EAX
GPTR5:	MOV	DWORD PTR CD_IRQEND,EAX
	POP	EDX EBX EAX
	PUSH	DS			;PLAY TRACK
	POP	ES
	MOV	BX,OFFSET PLAY2
	MOV	STATUS2,0
	MOV	ADRMODE2,0
	CALL	DWORD PTR DS:[DEV_ENTRY]	
	CALL	DWORD PTR DS:[DEV_INT]
	CALL	IRQ_INIT
	OR	CD_STATUS,1
	AND	CD_STATUS,11111101B
GPTR1:	POP	ES
	POPA
	RET
PLAY_TRACK ENDP
;=============================================================================
; STOP STOPPT CD-ROM DURCH ZWEIMALIGES PAUSE
; PAUSE HAELT CD-ROM NUR AN
;-----------------------------------------------------------------------------
STOP_TRACK PROC NEAR
	CALL	PAUSE_TRACK
PAUSE_TRACK PROC NEAR
	PUSHA
	PUSH	ES
	TEST	CD_STATUS,3
	JZ	SHORT GSTR1
	MOV	CD_CONTROL,0		;IRQ TRACK CONTROL DISABLE
	PUSH	DS			;STOP TRACK
	POP	ES
	MOV	BX,OFFSET STOP3
	MOV	COMMAND3,133
	MOV	STATUS3,0
	CALL	DWORD PTR DS:[DEV_ENTRY]	
	CALL	DWORD PTR DS:[DEV_INT]
	TEST	CD_STATUS,1
	JZ	SHORT GSTR2
	OR	CD_STATUS,2
	AND	CD_STATUS,11111110B
	CALL	IRQ_INIT
	JMP	SHORT GSTR1
GSTR2:	AND	CD_STATUS,11111100B
GSTR1:	POP	ES
	POPA
	RET
PAUSE_TRACK ENDP
STOP_TRACK ENDP
;=============================================================================
; RESUME SETZT NACH PAUSE_TRACK WIEDER FORT
;-----------------------------------------------------------------------------
RESUME_TRACK PROC NEAR
	PUSHA
	PUSH	ES
	TEST	CD_STATUS,2
	JZ	SHORT GRTR1
	MOV	CD_CONTROL,0		;IRQ TRACK CONTROL DISABLE
	PUSH	DS			;RESUME TRACK
	POP	ES
	MOV	BX,OFFSET STOP3
	MOV	COMMAND3,136
	MOV	STATUS3,0
	CALL	DWORD PTR DS:[DEV_ENTRY]	
	CALL	DWORD PTR DS:[DEV_INT]
	CALL	IRQ_INIT
	OR	CD_STATUS,1
	AND	CD_STATUS,11111101B
GRTR1:	POP	ES
	POPA
	RET
RESUME_TRACK ENDP
;=============================================================================
; HOLT INFO UEBER TRACK POSITION
; CARRY= 0 PLAYING, 1= STOPPED
;-----------------------------------------------------------------------------
INFO_TRACK PROC NEAR
	PUSHA
	PUSH	ES
	MOV	AL,CD_CONTROL
	MOV	CD_CONTROL,0
	PUSH	AX
	PUSH	DS			;GET DISK INFO
	POP	ES
	MOV	BX,OFFSET IOCTLI1
	MOV	STATUS1,0
	MOV	SIZE1,QINFOL
	MOV	TRANSADR1,OFFSET QINFO
	CALL	DWORD PTR DS:[DEV_ENTRY]	
	CALL	DWORD PTR DS:[DEV_INT]
	TEST	STATUS1,200H
	JNZ	SHORT GITR2
	STC
	JMP	SHORT GITR1
GITR2:	CLC
GITR1:	POP	AX
	MOV	CD_CONTROL,AL
	POP	ES
	POPA
	RET
INFO_TRACK ENDP
;=============================================================================
; SPULT UM AL= -128 BIS 127 SEKUNDEN RUECK-/VORWAERTS
;-----------------------------------------------------------------------------
SEEK_TRACK PROC NEAR
	PUSHA
	PUSH	ES
	TEST	CD_STATUS,1
	JZ	GKTR3
	MOV	BL,CD_CONTROL
	MOV	BH,CD_STATUS
	PUSH	BX
	CALL	PAUSE_TRACK
	CALL	INFO_TRACK
	CBW
	MOVZX	DX,DMIN_NOW
	MOVZX	BX,DSEC_NOW
	ADD	AX,BX
LKTR1:	CMP	AX,60
	JB	SHORT GKTR1
	OR	AX,AX
	JNS	SHORT GKTR2
	ADD	AX,60
	DEC	DX
	JMP	LKTR1
GKTR2:	SUB	AX,60
	INC	DX
	JMP	LKTR1
GKTR1:	MOV	AH,AL
	MOV	AL,DFRAME_NOW
	CMP	DX,CD_STARTPOS+2
	JL	SHORT GKTR4
	JNE	SHORT GKTR6
	CMP	AX,CD_STARTPOS
	JL	SHORT GKTR4
GKTR6:	CMP	DX,CD_ENDPOS+2
	JG	SHORT GKTR7
	JNE	SHORT GKTR5
	CMP	AX,CD_ENDPOS
	JLE	SHORT GKTR5
GKTR7:	MOV	AX,CD_ENDPOS
	MOV	DX,CD_ENDPOS+2
	JMP	SHORT GKTR5
GKTR4:	MOV	AX,CD_STARTPOS
	MOV	DX,CD_STARTPOS+2
GKTR5:	CALL	RED2HSG
	MOV	WORD PTR STARTSECTOR2,AX
	MOV	WORD PTR STARTSECTOR2+2,DX
	MOV	SI,AX
	MOV	DI,DX
	MOV	AX,CD_ENDPOS
	MOV	DX,CD_ENDPOS+2
	CALL	RED2HSG
	SUB	AX,SI
	SBB	DX,DI
	MOV	WORD PTR NUMBSECTOR2,AX
	MOV	WORD PTR NUMBSECTOR2+2,DX
	PUSH	EAX EBX EDX
	MOV	EAX,NUMBSECTOR2
	XOR	EDX,EDX
	MOV	DWORD PTR CD_IRQPOS,EDX
	SHL	EAX,10
	MOV	EBX,75
	DIV	EBX
	SUB	EAX,1024*4
	JNC	SHORT GKTR8
	XOR	EAX,EAX
GKTR8:	MOV	DWORD PTR CD_IRQEND,EAX
	POP	EDX EBX EAX
	PUSH	DS			;PLAY TRACK
	POP	ES
	MOV	BX,OFFSET PLAY2
	MOV	STATUS2,0
	MOV	ADRMODE2,0
	CALL	DWORD PTR DS:[DEV_ENTRY]	
	CALL	DWORD PTR DS:[DEV_INT]
COMMENT	*
	MOV	WORD PTR STARTSECTOR4,AX
	MOV	WORD PTR STARTSECTOR4+2,DX
	PUSH	DS			;SEEK
	POP	ES
	MOV	BX,OFFSET SEEK4
	MOV	STATUS4,0
	MOV	ADRMODE4,0
	CALL	DWORD PTR DS:[DEV_ENTRY]	
	CALL	DWORD PTR DS:[DEV_INT]
	*
	CALL	IRQ_INIT
	POP	BX
	MOV	CD_CONTROL,BL
	MOV	CD_STATUS,BH
GKTR3:	POP	ES
	POPA
	RET
SEEK_TRACK ENDP
;=============================================================================
; HOLT DEVICE STATUS
;-----------------------------------------------------------------------------
GET_DEVSTAT PROC NEAR
	PUSHA
	PUSH	ES
	PUSH	DS			;GET DEVICE STATUS
	POP	ES
	MOV	BX,OFFSET IOCTLI1
	MOV	STATUS1,0
	MOV	SIZE1,DEVSTATL
	MOV	TRANSADR1,OFFSET DEVSTAT
	CALL	DWORD PTR DS:[DEV_ENTRY]	
	CALL	DWORD PTR DS:[DEV_INT]
	POP	ES
	POPA
	RET
GET_DEVSTAT ENDP
;=============================================================================
; CHECKT CD-ROM WECHSEL
;-----------------------------------------------------------------------------
GET_MEDCHANGE PROC NEAR
	PUSHA
	PUSH	ES
	PUSH	DS			;CHECK MEDIA CHANGE
	POP	ES
	MOV	BX,OFFSET IOCTLI1
	MOV	STATUS1,0
	MOV	SIZE1,MEDCHL
	MOV	TRANSADR1,OFFSET MEDCH
	CALL	DWORD PTR DS:[DEV_ENTRY]	
	CALL	DWORD PTR DS:[DEV_INT]
	POP	ES
	POPA
	RET
GET_MEDCHANGE ENDP
;=============================================================================
; KONVERTIERT REDBOOK ADR IN DX:AX NACH HIGH SIERRA ADR IN DX:AX
;-----------------------------------------------------------------------------
RED2HSG PROC NEAR
	PUSH	CX
	MOV	CX,AX
	MOVZX	AX,DL
	MOV	DX,60
	MUL	DX
	MOVZX	DX,CH
	ADD	AX,DX
	MOV	DX,75
	MUL	DX
	XOR	CH,CH
	ADD	AX,CX
	ADC	DX,0	
	SUB	AX,150
	SBB	DX,0
	POP	CX
	RET
RED2HSG ENDP
;=============================================================================
; UEBERWACHT REPEAT LOOP UND DOOR OPEN/CHANGE
;-----------------------------------------------------------------------------
TRACK_CONTROL PROC NEAR
	PUSHA
	PUSH	DS ES
	PUSH	@DATA
	POP	DS
	CMP	SYSTEM,0
	JNE	SHORT WT6
	MOV	AL,UHR_STATC
	OUT	UHR_INDEX,AL
	JMP	SHORT WT1
WT1:	JMP	SHORT WT2
WT2:	IN	AL,UHR_PORT
WT6:	MOV     AL,20H
	OUT     IRQ3,AL
	OUT	IRQ1,AL
	STI

	INC	TIMER_SYNC
	CMP	CD_CONTROL,0
	JE	SHORT WT3
	TEST	CD_STATUS,1
	JZ	SHORT WT3
	CMP	CD_CHANGE,0
	JNE	SHORT WT3
	INC	DWORD PTR CD_IRQPOS
	DEC	CD_COUNT
	JNZ	SHORT WT3
	MOV	CD_COUNT,1024
	MOV	AX,CD_IRQPOS+2
	CMP	AX,CD_IRQEND+2
	JB	SHORT WT3
	JNE	SHORT WT8
	MOV	AX,CD_IRQPOS
	CMP	AX,CD_IRQEND
	JB	SHORT WT3
WT8:	CALL	INFO_TRACK
	MOV	AX,STATUS1
	TEST	AH,80H
	JZ	SHORT WT5
	MOV	CD_CHANGE,1		;VERMUTLICH EIN CD CHANGE
WT5:	MOV	AL,DFRAME_NOW
	MOV	AH,DSEC_NOW
	MOVZX	DX,DMIN_NOW
	ADD	AH,2
	CMP	AH,60
	JB	SHORT WT4
	SUB	AH,60
	INC	DX
WT4:	CMP	DX,CD_ENDPOS+2
	JB	SHORT WT3
	CMP	AX,CD_ENDPOS
	JB	SHORT WT3
	MOV	AL,CD_TRACK
	CALL	PLAY_TRACK
	MOV	CD_CONTROL,1

WT3:	TEST	CHAINING,1
	JNZ	SHORT WT9
	CMP	SYSTEM,0
	JE	SHORT WT7
	DEC	IRQCOUNT
	JNZ	SHORT WT7
	MOV	IRQCOUNT,56
WT9:	POP	ES DS
	POPA
	JMP	DWORD PTR CS:[HOLD70]
WT7:	POP	ES DS
	POPA
	IRET
HOLD70		LABEL DWORD
		DW OFFSET TRACK_CONTROL
HOLD70_SEG	DW SEG TRACK_CONTROL
TRACK_CONTROL ENDP
;=============================================================================
; TIMER INTERRUPT & MUSIC REQUEST EINSTELLEN
; SERVICE IRQ UMLEITUNG; USES THE REAL-TIME-CLOCK IRQ
;-----------------------------------------------------------------------------
IRQ_INIT PROC NEAR
	CLI
	XOR	AX,AX	
	MOV	ES,AX
	CMP	SYSTEM,0
	JNE	WU11
	TEST	CHAINING,1
	JNZ	SHORT WU15
	MOV     AX,COMP_SPEED2		;XCHANGE INIT & STOP DATA FOR DOS
	MOV     DX,COMP_SPEED3
	MOV     COMP_SPEED2,DX
	MOV     COMP_SPEED3,AX
	MOV	AL,UHR_STATA		;UHR-IRQ-RATE EINSTELLEN (1024 HZ)
	OUT	UHR_INDEX,AL
	JMP	SHORT WU1
WU1:	JMP	SHORT WU2
WU2:	XCHG	AL,AH
	IN	AL,UHR_PORT
	AND	AL,0F0H
	OR	AL,DL
	XCHG	AL,AH
	OUT	UHR_INDEX,AL
	JMP	SHORT WU3
WU3:	JMP	SHORT WU4
WU4:	XCHG	AL,AH
	OUT	UHR_PORT,AL
	JMP	SHORT WU5
WU5:	JMP	SHORT WU6
WU6:	MOV	AL,UHR_STATB		;UHR-IRQ-MODUS EINSTELLEN
	OUT	UHR_INDEX,AL
	JMP	SHORT WU7
WU7:	JMP	SHORT WU8
WU8:	XCHG	AL,AH
	IN	AL,UHR_PORT
	AND	AL,08FH
	MOV	DL,DH
	AND	DL,40H
	OR	AL,DL
	XCHG	AL,AH
	OUT	UHR_INDEX,AL
	JMP	SHORT WU9
WU9:	JMP	SHORT WU10
WU10:	XCHG	AL,AH
	OUT	UHR_PORT,AL
	IN	AL,IRQ4			;IRQ8 DE-/MASKIEREN
	AND	AL,0FEH
	MOV	DL,DH
	AND	DL,1
	OR	AL,DL
	OUT	IRQ4,AL
	MOV	AL,UHR_STATC		;IRQ LSCHEN
	OUT	UHR_INDEX,AL
	JMP	SHORT WU20
WU20:	JMP	SHORT WU21
WU21:	IN	AL,UHR_PORT
WU15:	MOV     BX,4*70H                ;UHR-IRQ VERBIEGEN
	MOV     EAX,ES:[BX]
	MOV     EDX,CS:HOLD70
	MOV     ES:[BX],EDX
	MOV     CS:HOLD70,EAX
	JMP	SHORT WU12
WU11:	TEST	CHAINING,1
	JNZ	SHORT WU16
	MOV     AX,COMP_SPEED4		;FOR WINDOWS
	MOV     DX,COMP_SPEED5
	MOV     COMP_SPEED4,DX
	MOV     COMP_SPEED5,AX
	MOV     AL,00110110B            ;TIMER0 AUF 1.024 KHZ EINSTELLEN
	OUT     PIT1,AL                 ;TEILER=1193
	MOV     AL,DL
	OUT     TIMER0,AL
	JMP     SHORT OUT40
OUT40:  MOV     AL,DH
	OUT     TIMER0,AL
WU16:	MOV     BX,4*8H                 ;TIMEOUT-IRQ VERBIEGEN
	MOV     EAX,ES:[BX]
	MOV     EDX,CS:HOLD70
	MOV     ES:[BX],EDX
	MOV     CS:HOLD70,EAX
WU12:	MOV	AL,20H
	OUT	IRQ3,AL
	OUT	IRQ1,AL
	STI
	RET
IRQ_INIT ENDP
;=============================================================================



LOCALS xx
;=============================================================================
; Main Routine and Interface
; IN:  ES:BX = Zeiger auf Struktur
; OUT: AX = SoundcardType	;0=NO,1=SB/SBPRO,2=SB16,3=PAS,4=GUS
;
;	meaning		offset	size
;	baseport	 0	dw 0
;	dma_number	 2	db 0
;	irq_number	 3	db 0
;	samplerate	 4	dw 0
;	intern_type	 6	db 0
;	irq_type	 7	db 0
;	start_pos	 8	db 0
;	loop_pos	 9	db 0
;	song_mod	10	db 0
;	char master_vol	11	db 0
;	char music_vol	12	db 0
;	char fx_vol	13	db 0
;-----------------------------------------------------------------------------
AUTO_DETECT PROC NEAR
	CALL	DetectSound
	SETC	DL
	XOR	DH,DH
	MOV	AX,CS:SoundPort
	MOV	ES:[BX],AX
	MOV	AL,CS:SoundDMA
	MOV	ES:[BX+2],AL
	MOV	AL,CS:SoundIRQ
	MOV	ES:[BX+3],AL
	MOV	AX,22222
	MOV	ES:[BX+4],AX		;DEFAULT SAMPLERATE = 22222
	XOR	AX,AX
	MOV	ES:[BX+6],AL		;DEFAULT INTERN TYPE =  0
	MOV	ES:[BX+8],AL		;START_POS = 0
	MOV	ES:[BX+9],AL		;LOOP_POS = 0 (ENDLESS LOOPING)
	MOV	ES:[BX+10],AL		;SONG_MOD = 0
	INC	AL
	MOV	ES:[BX+7],AL		;IRQ DEFAULT TO WINDOWS (TIMER)
	DEC	AL
	DEC	AL
	MOV	ES:[BX+11],AL		;VOLUMES TO MAX
	MOV	ES:[BX+12],AL
	MOV	ES:[BX+13],AL
	MOV	AL,CS:SoundType
	CMP	AL,2
	JB	SHORT MEND
	JA	SHORT MT1
	DEC	AL
	MOV	ES:[BX+6],AL
	JMP	SHORT MEND
MT1:	CMP	AL,3
	JNE	SHORT MT2
	INC	AL
	JMP	SHORT MEND
MT2:	CMP	AL,4
	JNE	SHORT MT3
	DEC	AL
	JMP	SHORT MEND
MT3:	CMP	AL,5
	JNE	SHORT MEND
	MOV	AL,2
MEND:	RET

SoundType       db      0	;0=no,1=SB,2=SBPro,3=GUS,4=PAS16,5=SB16
SoundPort       dw      0
SoundDMA        db      0
SoundIRQ        db      0

AUTO_DETECT ENDP

;-----------------------------------------------------------------------------
;(Auto)detect Soundkarte: c=0 ok

DetectSound proc near
                pusha
                push    ds es cs
                pop     es
                mov     di,offset xxULTRASND
                call    GetEnv
                jnc     short xxGUSEnv
xxSBNoGUS:      mov     di,offset xxBLASTER
                call    GetEnv
                jnc     short xxSBEnv
                xor     dx,dx
                mov     cs:SoundType,3
                call    DetGUSHW
                jnc     xxEndDetect
                mov     cs:SoundType,4
		call	detectPAS
		jnc	xxEndDetect
                mov     cs:SoundType,1

xxSBHW:         call    detectSBProHW
                jnc     xxEndDetect
                call    detectSBHW
                jnc     xxEndDetect
                jmp     xxErrorDetect

xxGUSEnv:       mov     cs:SoundType,3
                call    GetValue
                mov     cs:SoundPort,ax
                jc      short xxSBNoGUS
                call    GetValue
                mov     cs:SoundDMA,al
                jc      short xxSBNoGUS
                call    GetValue
                jc      short xxSBNoGUS
                call    GetValue
                mov     cs:SoundIRQ,al
                jc      short xxSBNoGUS

                mov     dx,cs:SoundPort
                call    DetGUSHW
                jc      short xxSBNoGUS
                jmp     short xxEndDetect

xxSBEnv:        mov     cs:SoundType,1
xxNextSB:       lodsb
                cmp     al,0
                je      short xxSBEnd
                and     al,11011111b

                cmp     al,'A'
                jne     short xxNoA
                call    GetValue
                mov     cs:SoundPort,ax
                jnc     short xxNextSB
                jmp     short xxSBEnd

xxNoA:          cmp     al,'I'
                jne     short xxNoI
                call    GetValue
                mov     cs:SoundIRQ,al
                jnc     short xxNextSB
                jmp     short xxSBEnd

xxNoI:          cmp     al,'D'
                jne     short xxNoD
                call    GetValue
                mov     cs:SoundDMA,al
                jnc     short xxNextSB
                jmp     short xxSBEnd

xxNoD:          cmp     al,'T'
                jne     short xxNextSB
                call    GetValue
                pushf
                cmp     al,3
                jb      short xxSBOld
                mov     cs:SoundType,2
                cmp     al,4
                jb      short xxSBOld
                mov     cs:SoundType,5
xxSBOld:        popf
                jnc     short xxNextSB

xxSBEnd:        xor     ax,ax
                cmp     cs:SoundPort,ax
                je      xxSBHW
                cmp     cs:SoundIRQ,al
                je      xxSBHW
                cmp     cs:SoundDMA,al
                je      xxSBHW

xxEndDetect:	xor	ax,ax
		cmp     cs:SoundPort,ax
                je      short xxErrorDetect
                cmp     cs:SoundIRQ,al
                je      short xxErrorDetect
                cmp     cs:SoundDMA,al
                je      short xxErrorDetect
                clc
                pop     es ds
                popa
                ret
xxErrorDetect:  stc
                mov     cs:SoundType,0
                pop     es ds
                popa
                ret

xxBLASTER       db      "BLASTER",0
xxULTRASND      db      "ULTRASND",0

DetectSound endp

;------------------------------------------------------------------------------
;Liest Wert (hex) ab ds:si, zurck in ax, c=1 String mit 0 terminiert

GetValue proc near

                push    bx

                xor     ax,ax
                xor     bx,bx

xxNoStart:      lodsb
                cmp     al,' '
                je      short xxNoStart
                jmp     short xxEntry

xxNext:         lodsb
xxEntry:	test	al,al
		jz	short xxEnd1
		cmp     al,' '
                je      short xxEnd2
                cmp     al,','
                je      short xxEnd2
                and     al,11011111b
                cmp     al,40h
                jb      short xxNoChar
                add     al,9
xxNoChar:       and     al,0fh
                shl     bx,4
                add     bx,ax
                jmp     short xxNext

xxEnd1:         stc
                mov     ax,bx
                pop     bx
                ret

xxEnd2:         clc
                mov     ax,bx
                pop     bx
                ret

GetValue endp

;------------------------------------------------------------------------------
;holt Umgebungsvariable es:di, ds:si zeigt auf erstes Zeichen, c=1 Fehler

GetEnv proc near

                push    bx
                push    di
                push    es

                mov     ah,62h          ;ds:si points at dos env.
                int     21h
                mov     ds,bx
                mov     ds,ds:2ch
                xor     si,si

xxLoop3:        xor     bx,bx
xxLoop:         lodsb
                cmp     al,0
                je      short xxError
                cmp     al,es:[di+bx]
                jne     short xxNextOne
                inc     bx
                jmp     short xxLoop
xxNextOne:      cmp     al,'='
                jne     short xxLoop2
                cmp     es:[di+bx],byte ptr 0
                je      short xxGotIt
xxLoop2:        lodsb
                cmp     al,0
                jne     short xxLoop2
                jmp     short xxLoop3

xxError:        stc
                jmp     short xxEnde

xxGotIt:        clc

xxEnde:         pop     es
                pop     di
                pop     bx
                ret
GetEnv endp

;------------------------------------------------------------------------------
;Autodetect/Check GUS
;dx = port, dx = 0 -> autodetect, else check port

DetGUSHW proc near

                pusha
                push    ds
                push    es

                mov     bp,1
                mov     si,dx
                xor     di,di
                cmp     dx,di
                jne     short xxnoAutodetect
                mov     si,210h
                mov     bp,6
                mov     di,-1

xxnoAutodetect: mov bx,si

                mov cs:xxBasePort,bx
                add bx,6h
                mov cs:xxStatusPort,bx
                add bx,2+1+100h-9h+3
                mov cs:xxCommandPort,bx
                inc bx
                mov cs:xxDataLowPort,bx
                inc bx
                mov cs:xxDataHighPort,bx
                add bx,2
                mov cs:xxDRAMIOPort,bx

                mov bx,cs:xxCommandPort
                mov cx,cs:xxDataHighPort
                mov dx,bx
                mov al,4ch      ;Initialize
                out dx,al
                mov dx,cx
                mov al,0
                out dx,al
                mov dx,cs:xxBasePort
                REPT 8
                in al,dx
                ENDM

                mov dx,bx
                mov al,4Ch
                out dx,al
                mov dx,cx
                mov al,1
                out dx,al
                mov dx,cs:xxBasePort
                REPT 8
                in al,dx
                ENDM

                mov dx,bx
                mov al,41h      ;DMACtrl
                out dx,al
                mov dx,cx
                mov al,0
                out dx,al
                mov dx,bx
                mov al,45h
                out dx,al
                mov dx,cx
                mov al,0
                out dx,al
                mov dx,bx
                mov al,49h
                out dx,al
                mov dx,cx
                mov al,0
                out dx,al

                mov dx,bx
                mov al,0eh      ;VoicesActive
                out dx,al
                mov dx,cx
                mov al,20       ;NumVoices
                dec al
                or  al,0C0h
                out dx,al

                mov dx,cs:xxStatusPort
                in  al,dx
                mov dx,bx
                mov al,41h      ;DMACtrl
                out dx,al
                mov dx,cx
                in  al,dx
                mov dx,bx
                mov al,49h
                out dx,al
                mov dx,cx
                in  al,dx
                mov dx,bx
                mov al,8Fh
                out dx,al
                mov dx,cx
                in  al,dx

                mov dx,bx
                mov al,4ch
                out dx,al
                mov dx,cx
                mov al,7
                out dx,al

                mov dx,cs:xxCommandPort
                mov al,43h      ;DRAMAddrLo
                out dx,al
                mov dx,cs:xxDataLowPort
                mov ax,113h
                out dx,ax

                mov dx,cs:xxCommandPort
                mov al,44h      ;DRAMAddrHi
                out dx,al
                mov dx,cs:xxDataHighPort
                xor al,al
                out dx,al

                mov dx,cs:xxDRAMIOPort
                mov al,0d4h                             ;testwert 1 d4h
                out dx,al

                mov dx,cs:xxCommandPort
                mov al,43h      ;DRAMAddrLo
                out dx,al
                mov dx,cs:xxDataLowPort
                mov ax,12h                              ;testweise mal 12h beschreiben
                out dx,ax

                mov dx,cs:xxCommandPort
                mov al,44h      ;DRAMAddrHi
                out dx,al
                mov dx,cs:xxDataHighPort
                xor al,al
                out dx,al

                mov dx,cs:xxDRAMIOPort
                mov al,53h                              ;testwert 2 53h
                out dx,al


                mov dx,cs:xxCommandPort
                mov al,43h      ;DRAMAddrLo
                out dx,al
                mov dx,cs:xxDataLowPort
                mov ax,113h                             ;also testwert 1 lesen
                out dx,ax

                mov dx,cs:xxCommandPort
                mov al,44h      ;DRAMAddrHi
                out dx,al
                mov dx,cs:xxDataHighPort
                xor al,al
                out dx,al

                mov dx,cs:xxDRAMIOPort
                in  al,dx                               ;speicher lesen
                cmp al,0d4h                             ;testwert Ok ?
                jne short xxnotfound

                mov dx,cs:xxCommandPort
                mov al,43h      ;DRAMAddrLo
                out dx,al
                mov dx,cs:xxDataLowPort
                mov ax,12h                              ;testoffset 2
                out dx,ax

                mov dx,cs:xxCommandPort
                mov al,44h      ;DRAMAddrHi
                out dx,al
                mov dx,cs:xxDataHighPort
                xor al,al
                out dx,al

                mov dx,cs:xxDRAMIOPort
                in  al,dx
                cmp al,53h                              ;wert = testwert 2 ?
                jne short xxnotfound                    ;n, nicht gefunden
                jmp short xxfoundGUS
xxnotfound:
                cmp di,0ffffh
                jne short xxno
                add si,10h
                dec bp
                jnz xxnoAutodetect
xxno:
                pop es
                pop ds
                popa
                xor dx,dx
                stc                                     ;Carry setzen
                ret

xxfoundGUS:     pop     es
                pop     ds
                popa
                mov dx,cs:xxBasePort
                mov cs:SoundPort,dx
		mov cs:SoundDMA,1
		mov cs:SoundIRQ,11
                clc
                ret

xxBasePort      dw      0
xxStatusPort    dw      0
xxCommandPort   dw      0
xxDataLowPort   dw      0
xxDataHighPort  dw      0
xxDRAMIOPort    dw      0

DetGUSHW endp

; /***********************************************************************
; *
; *     File        : DETSBHW.ASM
; *
; *     Description : Sound Blaster hardware detection routines
; *
; ************************************************************************

waitSB MACRO
	local	l1
l1:
	in	al,dx
	or	al,al
        js      short l1
ENDM

waitSBport MACRO
	local	l1

        mov     dx,cs:SoundPort
	add	dx,0Ch
l1:
	in	al,dx
	or	al,al
        js      short l1
ENDM

waitSBPROport MACRO
	local	l1

        mov     dx,cs:SoundPort
	add	dx,0Ch
l1:
	in	al,dx
	or	al,al
        js      short l1
ENDM

;/*************************************************************************
; *
; *	Function    : 	checkPort_SB
; *
; *	Description :   Checks if given address is SB's I/O address
; *
; *	Input       : 	DX = port to check
; *
; *	Returns     :	AX = 0	successful
; *		      	AX = 1	unsuccessful
; *
; ************************************************************************/

checkPort_SB proc near

	push	dx
	add	dl,6			; Init Sound Blaster
	mov	al,1
	out	dx,al
	in	al,dx			; Wait for awhile
	in	al,dx
	in	al,dx
	in	al,dx
	in	al,dx
	mov	al,0
	out	dx,al
	sub	dl,6

	add	dl,0Eh          	; DSP data available status
	mov	cx,1000
xxloop:
	in	al,dx			; port 22Eh
	or	al,al
        js      short xx10
        loop    short xxloop

	mov	ax,1
        jmp     short xxexit
xx10:
	sub	dl,4
	in	al,dx			; port 22Ah
	cmp	al,0AAh			; Is ID 0AAh?
	mov	ax,0
        je      short xxexit
	mov	ax,1
xxexit:
	pop	dx
	or	ax,ax			; Set zero-flag accordingly
	ret

checkPort_SB endp

;/*************************************************************************
; *
; *	Function    : 	findDMAIRQ_SB
; *
; *	Description :	Finds SB's DMA interrupt number
; *
; *	Returns     :	AX = 0	error
; *			AX = port number (2,3,5,7)
; *
; ************************************************************************/

findDMAIRQ_SB proc near

        push    ds
        push    es
	push	cs
	pop	ds

	mov	ah,35h
	mov	al,8+2
	int	21h
        mov     cs:xxsaveVect+2,es
        mov     cs:xxsaveVect,bx
	mov	ah,35h
	mov	al,8+3
	int	21h
        mov     cs:xxsaveVect+6,es
        mov     cs:xxsaveVect+4,bx
	mov	ah,35h
	mov	al,8+5
	int	21h
        mov     cs:xxsaveVect+10,es
        mov     cs:xxsaveVect+8,bx
	mov	ah,35h
	mov	al,8+7
	int	21h
        mov     cs:xxsaveVect+14,es
        mov     cs:xxsaveVect+12,bx

	mov	ah,25h
	mov	dx,offset DMA2		; Set vectors
	mov	al,8+2
	int	21h
	mov	ah,25h
	mov	dx,offset DMA3
	mov	al,8+3
	int	21h
	mov	ah,25h
	mov	dx,offset DMA5
	mov	al,8+5
	int	21h
	mov	ah,25h
	mov	dx,offset DMA7
	mov	al,8+7
	int	21h

	cli
	in	al,21h
        mov     cs:xxintMask,al            ; Save interrupt mask
	mov	al,0FFh
	out	21h,al			; Mask out all interrupts				; Disable interrupts

        mov     al,cs:xxintMask
	and	al,01010011b		; Allow DMA interrupts (2,3,5 & 7)
	out	21h,al
	sti				; Set DMA up

	MOV	AL,5
	OUT	0AH,AL			;DMA-KANAL MASKIEREN
	AND	AL,3
	OR	AL,01011000B
	OUT	0BH,AL			;DMA-MODUS FR SB
	OUT	0CH,AL			;FLIP-FLOP LSCHEN
	AND	AL,3
	MOVZX	DX,AL
	SHL	DL,1
	MOV	AL,0			;DMA CHANNEL 1-4
	OUT	DX,AL			;OFFSET LOW
	MOV	AL,0
	OUT	DX,AL			;OFFSET HIGH
	INC	DL
	MOV	AL,0
	OUT	DX,AL			;SIZE LOW
	MOV	AL,0
	OUT	DX,AL			;SIZE HIGH
	SHR	DL,1
	MOV	AL,2
	OUT	83H,AL			;PAGE 2
	MOV	AL,DL
	OUT	0AH,AL			;DMA-KANAL DEMASKIEREN

        mov     dx,cs:SoundPort
	add	dx,0Ch
	waitSB
	mov	al,40h                  ; Set DSP speed
	out	dx,al
	waitSB
	mov	al,0D2h			; 22000 Hz
	out	dx,al
	waitSB
	mov	al,14h			; 14h = output command
	out	dx,al
	waitSB
	mov	al,0			; digitize 4 byte
	out	dx,al
	waitSB
	mov	al,0
        mov     cs:SoundIRQ,byte ptr 0  ; Clear interrupt value
	out	dx,al
	mov	cx,0FFFFh		; Big loop
xxloop: cmp     cs:SoundIRQ,byte ptr 0  ; Wait dmaIRQ to change
        loope   short xxloop            ; loop if it doesn't
	cli
        mov     al,cs:xxintMask
	out	21h,al			; Restore interrupt mask
	sti				; Allow interrupts

        push    ds
	mov	ah,25h
        lds     dx,dword ptr cs:xxsaveVect
	mov	al,8+2
	int	21h
 	mov	ah,25h
        lds     dx,dword ptr cs:xxsaveVect+4
	mov	al,8+3
	int	21h
 	mov	ah,25h
        lds     dx,dword ptr cs:xxsaveVect+8
	mov	al,8+5
	int	21h
	mov	ah,25h
        lds     dx,dword ptr cs:xxsaveVect+12
	mov	al,8+7
	int	21h
        pop     ds

        pop     es
        pop     ds

	sub	ax,ax
        mov     al,cs:SoundIRQ             ; Return with interrupt number
        ret

xxsaveVect      dw      8 dup(0)
xxintMask       db      0

findDMAIRQ_SB endp

;/*************************************************************************
; *
; *	Function    : 	findDMAIRQ_SBpro
; *
; *	Description :	Finds SBpro's DMA interrupt number
; *
; *	Returns     :	AX = 0	error
; *                     AX = IRQ number (2,3,5,7,10)
; *
; ************************************************************************/

findDMAIRQ_SBpro proc near

        push    ds
        push    es
	push	cs
	pop	ds

	mov	ah,35h
	mov	al,8+2
	int	21h
        mov     cs:xxsaveVect+2,es
        mov     cs:xxsaveVect,bx
	mov	ah,35h
	mov	al,8+5
	int	21h
        mov     cs:xxsaveVect+6,es
        mov     cs:xxsaveVect+4,bx
	mov	ah,35h
	mov	al,8+7
	int	21h
        mov     cs:xxsaveVect+10,es
        mov     cs:xxsaveVect+8,bx
	mov	ah,35h
	mov	al,72h
	int	21h
        mov     cs:xxsaveVect+14,es
        mov     cs:xxsaveVect+12,bx

	mov	ah,25h
	mov	dx,offset DMA2		; Set vectors
	mov	al,8+2
	int	21h
	mov	ah,25h
	mov	dx,offset DMA5
	mov	al,8+5
	int	21h
	mov	ah,25h
	mov	dx,offset DMA7
	mov	al,8+7
	int	21h
	mov	ah,25h
	mov	dx,offset DMA10
	mov	al,72h
	int	21h

	cli
	in	al,21h
        mov     cs:xxintMask1,al           ; Save interrupt mask
	mov	al,0FFh
	out	21h,al			; Mask out all interrupts
	in	al,0A1h
        mov     cs:xxintMask2,al           ; Save interrupt mask
	mov	al,0FFh
	out	0A1h,al			; Mask out all interrupts

        mov     al,cs:xxintMask1
	and	al,01010011b		; Allow DMA interrupts (2,3,5 & 7)
	out	21h,al
        mov     al,cs:xxintMask2
	and	al,11111011b		; Allow DMA interrupt 10
	out	0A1h,al
	sti

	mov	cx,1000
xxwaitloop:
	in	al,21h
        loop    short xxwaitloop

	mov	al,4
	out	0Ah,al			; Break on
	mov	al,5
	out	0Ah,al			; Break on
	mov	al,7
	out	0Ah,al			; Break on

        mov     dx,cs:SoundPort
	add	dx,0Ch
	waitSB
	mov	al,40h                  ; Set DSP speed
	out	dx,al
	waitSB
	mov	al,0D3h			; 22222 Hz
	out	dx,al
	waitSB
	mov	al,14h			; 14h = output command
	out	dx,al
	waitSB
	mov	al,0			; digitize 1 byte
	out	dx,al
	waitSB
	mov	al,0
	out	dx,al

	mov	ax,1			; Check for DMA channel 1
        call    findDMAchannel_SBpro
	or	ax,ax
        jnz     short xxchannelFound
	mov	ax,0			; Channel 0
        call    findDMAchannel_SBpro
	or	ax,ax
        jnz     short xxchannelFound
	mov	ax,3			; Channel 3
        call    findDMAchannel_SBpro
	or	ax,ax
        jnz     short xxchannelFound
        mov     cs:SoundIRQ,0
xxchannelFound:
        mov     cs:SoundDMA,al

        mov     dx,cs:SoundPort
	add	dl,6			; Init Sound Blaster
	mov	al,1
	out	dx,al
	in	al,dx			; Wait for awhile
	in	al,dx
	in	al,dx
	in	al,dx
	in	al,dx
	mov	al,0
	out	dx,al
	sub	dl,6

	add	dx,0Eh			; Reset SB
	in	al,dx

        push    ds
	mov	ah,25h
        lds     dx,dword ptr cs:xxsaveVect
	mov	al,8+2
	int	21h
	mov	ah,25h
        lds     dx,dword ptr cs:xxsaveVect+4
	mov	al,8+5
	int	21h
	mov	ah,25h
        lds     dx,dword ptr cs:xxsaveVect+8
	mov	al,8+7
	int	21h
	mov	ah,25h
        lds     dx,dword ptr cs:xxsaveVect+12
	mov	al,72h
	int	21h
        pop     ds

        mov     al,cs:xxintMask1
	out	21h,al			; Restore interrupt mask
        mov     al,cs:xxintMask2
	out	0A1h,al			; Restore interrupt mask
        sti                             ; Allow interrupts

        pop     es
        pop     ds

	sub	ax,ax
        mov     al,cs:SoundIRQ        ; Return with interrupt number
        ret

xxsaveVect      dw      8 dup(0)
xxintMask1      db      0
xxintMask2      db      0

findDMAIRQ_SBpro endp

;/*************************************************************************
; *
; *	Function    :	findDMAchannel_SBpro
; *
; *	Description :	Checks if given channel is the channel SBPro uses
; *
; *	Input       :	AX = Channel to test
; *
; *	Returns     :	AX = 0 if error
; *			AX = channel if OK
; *
; ************************************************************************/

findDMAchannel_SBpro proc near

        mov     cs:xxchannel,al
	add	al,4
	out	0Ah,al			; Break on
	mov	al,0
	out	0Ch,al			; Reset counter
	mov	al,48h
        add     al,cs:xxchannel
	out	0Bh,al			; DMA -> DSP (output)
	mov	dx,87h
        cmp     cs:xxchannel,byte ptr 0
        je      short xx10
	mov	dx,83h
        cmp     cs:xxchannel,byte ptr 1
        je      short xx10
	mov	dx,82h			; Channel is 3
xx10:
	mov	al,2
	out	dx,al			; page 2
        mov     dl,cs:xxchannel
	shl	dx,1
	mov	al,0
	out	dx,al			; offset 0
	mov	al,0
	out	dx,al			; whole address is 0000:0000
	inc	dx
	mov	al,10
	out	dx,al			; count = 10
	mov	al,0
	out	dx,al
        mov     al,cs:xxchannel
	out	0Ah,al			; Break off

	mov	cx,0FFFFh		; Big loop
        mov     cs:SoundIRQ,byte ptr 0  ; Clear interrupt value
xxloop: cmp     cs:SoundIRQ,byte ptr 0  ; Wait dmaIRQ to change
        loope   short xxloop            ; loop if it doesn't

        mov     al,cs:xxchannel
	add	al,4
	out	0Ah,al			; Break on
	mov	al,0
	out	0Ch,al			; Reset counter
        mov     al,cs:xxchannel
	out	0Ah,al			; Break off

	sub	ax,ax
        cmp     cs:SoundIRQ,byte ptr 0
        je      short xxexit
	inc	ah			; Indicate success
        mov     al,cs:xxchannel
xxexit:
	ret

xxchannel       db      0

findDMAchannel_SBpro endp

;/*************************************************************************
; *
; *	Function    : 	DMAint_SB
; *
; *	Description :	Interrupt function that determines SB's interrupt
; *
; ************************************************************************/

DMAint_SB proc near

DMA2:
        push    ds
	push	ax
	push	dx
        mov     cs:SoundIRQ,byte ptr 2               ; Set interrupt number
        jmp     short xxDMAdone
DMA3:
        push    ds
	push	ax
	push	dx
        mov     cs:SoundIRQ,byte ptr 3
        jmp     short xxDMAdone
DMA5:
        push    ds
	push	ax
	push	dx
        mov     cs:SoundIRQ,byte ptr 5
        jmp     short xxDMAdone
DMA7:
        push    ds
	push	ax
	push	dx
        mov     cs:SoundIRQ,byte ptr 7
        jmp     short xxDMAdone
DMA10:
        push    ds
	push	ax
	push	dx
        mov     cs:SoundIRQ,byte ptr 10
	mov	al,20h
	out	0A0h,al
xxDMAdone:
        mov     dx,cs:SoundPort
	add	dl,0Eh
	in	al,dx			; Reset SB
	mov	al,20h
	out	20h,al			; EOI (end of interrupt)
	pop	dx
	pop	ax
        pop     ds
	iret

DMAint_SB endp

;/*************************************************************************
; *
; *	Function    :	detectSB
; *
; *	Description :	Checks for presence of SB.
; *
; *	Returns     :	c=0  if succesful
; *			c=1  on error (no card found)
; *
; ************************************************************************/

detectSBHW proc near

        mov     cs:xxretvalue,word ptr -1           ; Assume failure
	mov	dx,220h
	call	checkPort_SB
        jz      short xxOK
	mov	dx,210h
	call	checkPort_SB		; Check for every possible I/O value
        jz      short xxOK
	mov	dx,230h
	call	checkPort_SB
        jz      short xxOK
	mov	dx,240h
	call	checkPort_SB
        jz      short xxOK
	mov	dx,250h
	call	checkPort_SB
        jz      short xxOK
	mov	dx,260h
	call	checkPort_SB
        jnz     short xxexit                  ; No match found, error exit
xxOK:
        mov     cs:SoundPort,dx       ; ioPort is for internal use only

        push    es
	push	di
        call    findDMAIRQ_SB           ; Find DMA interrupt number
	pop	di
        pop     es
	or	ax,ax			; 0 = error
        jz      short xxexit
        mov     cs:SoundIRQ,al
        mov     cs:SoundDMA,1

        mov     cs:xxretrycount,word ptr 10
xxretry:
        dec     word ptr cs:xxretrycount
        jnz     short xxcontinue
	mov	ax,0			; not found
        jmp     short xxdone
xxcontinue:
        mov     dx,cs:SoundPort
	add	dx,0Ch
	waitSB
	mov	al,0E1h			; Read version number
	out	dx,al

	add	dl,2			; DX = 22Eh
	sub	al,al
	mov	cx,1000
xx10:
        in      al,dx                   ; Read version high
	or	al,al
        js      short xx10ok
        loop    short xx10
        jmp     short xxretry
xx10ok:
	mov	cx,1000
	sub	dl,4
	in	al,dx
	mov	ah,al

	add	dl,4
	sub	al,al
xx20:
	in	al,dx			; Read version low
	or	al,al
        js      short xx20ok
        loop    short xx20
        jmp     short xxretry
xx20ok:
	sub	dl,4
	in	al,dx
xxdone:
        mov     cs:xxretvalue,word ptr 0
xxexit:
        mov     ax,cs:xxretvalue
        or      ax,ax
        jne     short xxexiterror
        clc
	ret
xxexiterror:
        stc
        ret

xxretvalue      dw      0
xxretrycount    dw      0

detectSBHW endp

;/*************************************************************************
; *
; *     Function    :   detectSBProHW
; *
; *	Description :	Checks for presence of SB Pro.
; *
; *	Returns     :	c=0  if succesful
; *			c=1  on error (no card found)
; *
; ************************************************************************/

detectSBProHW proc near

        mov     cs:xxretvalue,word ptr -1           ; Assume failure
	mov	dx,220h
	call	checkPort_SB
        jz      short xxOK
	mov	dx,210h
	call	checkPort_SB		; Check for every possible I/O value
        jz      short xxOK
	mov	dx,230h
	call	checkPort_SB
        jz      short xxOK
	mov	dx,240h
	call	checkPort_SB
        jz      short xxOK
	mov	dx,250h
	call	checkPort_SB
        jz      short xxOK
	mov	dx,260h
	call	checkPort_SB
        jnz     xxexit                  ; No match found, error exit
xxOK:
        mov     cs:SoundPort,dx       ; ioPort is for internal use only

        mov     cs:xxretrycount,word ptr 10
xxretry:
        dec     word ptr cs:xxretrycount
        jnz     short xxcontinue
	mov	ax,0			; not found
        jmp     short xxdone
xxcontinue:
        mov     dx,cs:SoundPort
	add	dx,0Ch
	waitSB
	mov	al,0E1h			; Read version number
	out	dx,al

	add	dl,2			; DX = 22Eh
	sub	al,al
	mov	cx,1000
xx10:
	in	al,dx			; Read version high
	or	al,al
        js      short xx10ok
        loop    short xx10
        jmp     short xxretry
xx10ok:
	mov	cx,1000
	sub	dl,4
	in	al,dx
	mov	ah,al

	add	dl,4
	sub	al,al
xx20:
	in	al,dx			; Read version low
	or	al,al
        js      short xx20ok
        loop    short xx20
        jmp     short xxretry
xx20ok:
	sub	dl,4
	in	al,dx
xxdone:
	cmp	ax,0300h
        jl      short xxexit            ; Not SBpro
	mov	cs:SoundType,2		;is sb16
	cmp	ax,0400h
	jl	short xxpro
	mov	cs:SoundType,5		;is sb16
xxpro:
        push    es
        push    di
        call    findDMAIRQ_SBpro        ; Find DMA interrupt number
	pop	di
        pop     es
	or	ax,ax			; 0 = error
        jz      short xxexit
        mov     cs:SoundIRQ,al

        mov     cs:xxretvalue,word ptr 0
xxexit:
        mov     ax,cs:xxretvalue
        or      ax,ax
        jne     short xxexiterror
        clc
	ret
xxexiterror:
        stc
        ret

xxretvalue      dw      0
xxretrycount    dw      0

detectSBProHW endp

;/*************************************************************************
; *
; *     Function    :   detectPAS
; *
; *	Description :	Checks for presence of PAS16.
; *
; *	Returns     :	c=0  if successful
; *			c=1  on error (no card found)
; *
; ************************************************************************/

DEFAULT_BASE	EQU	00388h		;; default base I/O address
ALT_BASE_1	EQU	00384h		;; first alternate address
ALT_BASE_2	EQU	0038Ch		;; second alternate address
ALT_BASE_3	EQU	00288h		;; third alternate address
ALT_BASE_4	EQU	00280h		;; 4th alternate address
ALT_BASE_5	EQU	00284h		;; 5th alternate address
ALT_BASE_6	EQU	0028Ch		;; 6th alternate address
INTRCTLR	EQU	00B8Bh		;; Interrupt Control Register write
fICrevbits	EQU	11100000B	;; revision mask field bits

detectPAS proc near
        mov     di,DEFAULT_BASE         ; try the first address
	mov	SoundPort,di
	call	SearchHWVersion
	jnc	xxpas_ok

	mov	di,ALT_BASE_1		; try the first alternate
	mov	SoundPort,di
	call	SearchHWVersion
	jnc	xxpas_ok

	mov	di,ALT_BASE_2		; try the second alternate
	mov	SoundPort,di
	call	SearchHWVersion
	jnc	xxpas_ok

	mov	di,ALT_BASE_3		; try the third alternate
	mov	SoundPort,di
	call	SearchHWVersion
	jnc	xxpas_ok

	mov	di,ALT_BASE_4		; try the 4th alternate
	mov	SoundPort,di
	call	SearchHWVersion
	jnc	xxpas_ok

	mov	di,ALT_BASE_5		; try the 5th alternate
	mov	SoundPort,di
	call	SearchHWVersion
	jnc	xxpas_ok

	mov	di,ALT_BASE_6		; try the 6th alternate
	mov	SoundPort,di
	call	SearchHWVersion
xxpas_ok:
	ret
detectPAS endp

;   /*\
;---|*|----====< SearchHWVersion >====----
;---|*|
;---|*| Given a specific I/O address, this routine will see if the
;---|*| hardware exists at this address.
;---|*|
;---|*| Entry Conditions:
;---|*|     DI holds the I/O address to test
;---|*|
;---|*| Exit Conditions:
;---|*|     c=0 ok
;---|*|     c=1 no card found
;   \*/

SearchHWVersion proc near
;
; calculate the translation code
;
	xor	di,DEFAULT_BASE 	; di holds the translation code
	mov	ax,0BC00H		; make sure MVSOUND.SYS is loaded
	mov	bx,'??'                 ; this is our way of knowing if the
	xor	cx,cx			; hardware is actually present.
	xor	dx,dx
	int	2fh			; get the ID pattern
	xor	bx,cx			; build the result
	xor	bx,dx
	cmp	bx,'MV'                 ; if not here, exit...
	jnz	xxbad
;
; get the MVSOUND.SYS specified DMA and IRQ channel
;
        mov     ax,0bc04h               ; get the DMA and IRQ numbers
	int	2fh
	mov	cs:SoundDMA,bl		; save the correct DMA & IRQ
	mov	cs:SoundIRQ,cl
;
; grab the version # in the interrupt mask. The top few bits hold the version #
;
        mov     dx,INTRCTLR             ; board ID is in MSB 3 bits
	xor	dx,di			; adjust to other address
	in	al,dx
	cmp	al,-1			; bus float meaning not present?
	je	xxbad			; yes, there is no card here
	mov	ah,al			; save an original copy
	xor	al,fICrevbits		; the top bits wont change
	out	dx,al			; send out the inverted bits
	jmp	xxl1
xxl1:	jmp	xxl2
xxl2:	in	al,dx			; get it back...
	cmp	al,ah			; both should match now...
	xchg	al,ah			; (restore without touching the flags)
	out	dx,al
	jnz	xxbad			; we have a bad board
;
; We do have hardware! Load the product bit definitions
;
	clc
	ret
xxbad:	stc
	ret
SearchHWVersion endp
;=============================================================================


;=============================================================================
; LOAD PLAYER
; AX= PLAYER NUMBER
;-----------------------------------------------------------------------------
LOAD_PLAYER PROC NEAR
	MOV	BP,AX
	MOV	DX,OFFSET VOL_NAME
	MOV	AX,3D00H		;OPEN MOD
	INT	21H
	JC	GGTV1
	MOV	GDDHANDLE,AX
	MOV	BX,GDDHANDLE
	MOV	CX,6			;EXE HEADER LESEN
	MOV	DX,OFFSET GDDLENGTH
	MOV	AH,3FH
	INT	21H
	MOV	AX,4200H
	XOR	DX,DX
	MOV	CX,W GDDLENGTH+4
	DEC	CX
	SHRD	DX,CX,7
	SHR	CX,7
	ADD	DX,W GDDLENGTH+2
	ADC	CX,0
	INT	21H
LGDM1:  MOV     DX,OFFSET GDDLENGTH
	MOV     CX,4
	MOV     AH,3FH
	INT     21H
	DEC     BP
	JZ      SHORT LGDM2
	MOV     DX,W GDDLENGTH
	MOV     CX,W GDDLENGTH+2
	MOV	AX,4201H
	INT     21H
	JMP     LGDM1
LGDM2:	MOV     DX,OFFSET GDDLENGTH
	MOV     CX,4
	MOV     AH,3FH
	INT     21H
	MOV     DX,OFFSET GDDLENGTH+4
	MOV     CX,2
	MOV     AH,3FH
	INT     21H
	SUB     GDDLENGTH,2
	MOV     BX,W GDDLENGTH
	ADD	BX,100H
	SHR     BX,4
	INC     BX
	MOV     AH,48H
	INT     21H
	JC      SHORT GGTV1
	MOV	MUSIC_SEG,AX
	MOV     ES,AX
	MOV	DI,100H
	XOR     ECX,ECX
	MOV     GDDZEIG,CX
	CLD
LGTV2:  MOV     CX,1
	CALL    GET_QUEUE
	CMP     AL,0C0H
	JB      SHORT GGTV4
	AND     AL,3FH
	MOV     CL,AL
	CALL    GET_QUEUE
GGTV4:  SUB     GDDLENGTH,ECX
	REP STOSB
	JNZ     LGTV2
	CLC
GGTV1:  RET
LOAD_PLAYER ENDP
;-----------------------------------------------------------------------------
GET_QUEUE PROC NEAR
	CMP     GDDZEIG,0
	JNE     SHORT GTQ1
	PUSHA
	MOV     DX,OFFSET TEMP_NAME
	MOV     CX,64
	MOV     BX,GDDHANDLE
	MOV     AH,3FH
	INT     21H
	POPA
GTQ1:   MOV     BX,GDDZEIG
	MOV     AL,[TEMP_NAME+BX]
	INC	BX
	AND	BX,3FH
	MOV     GDDZEIG,BX
	RET
GET_QUEUE ENDP
;-----------------------------------------------------------------------------
UNLOAD_PLAYER PROC NEAR
	CMP	MUSIC_SEG,0
	JE	SHORT LGDM5
	MOV	ES,MUSIC_SEG
	MOV	AH,49H
	INT	21H
	MOV	MUSIC_SEG,0
LGDM5:	RET
UNLOAD_PLAYER ENDP
;=============================================================================


END MAIN