; less documented source with a few more miscellanious features
.model small
.stack 0300h

.data
cx_save         dw      ?
esdx_save       dd      ?
message_left    db      "The left mouse button has been pressed!", 13, 10, "$"
message_right   db      "The right mouse button has been pressed!", 13, 10, "$"
message_moved   db      "The mouse has been moved!", 13, 10, "$"

.code
start:

; hide cursor
mov     ah, 01h
mov     ch, 01h
mov     cl, 00h
int     10h

mov     ax,0000h            ; initialize mouse
int     33h
mov     ax, 0001h           ; show mouse cursor
int     33h

; get, save, and reset mouse handler
mov     ax, 0014h
mov     cx, 0bh              ; act on mouse left or right button press
push    cs
pop     es
mov     dx, offset cs:mouse
int     33h
mov     [cx_save], cx 
mov     [word ptr esdx_save], es
mov     [word ptr esdx_save+2],dx

; wait for keypress
mov     ah, 00h
int     16h

; hide cursor
mov     ax, 0002h           
int     33h

; restore original mouse buttons and handler
mov     cx, [cx_save]
mov     es, [word ptr esdx_save]
mov     dx, [word ptr esdx_save+2]
mov     ax, 0014h
int     33h


; restore cursor size
mov     ah, 01h
mov     ch, 029
mov     cl, 030
int     10h

call    ts_clear

mov     ah, 04ch
int     21h

;****************************************************************************
;*************** P R O C E D U R E S ****************************************
;****************************************************************************
mouse   proc near
push    ax
push    bx
push    cx
push    dx

cmp     ax, 08h
jnz     left_or_move
jmp     right
left_or_move:
cmp     ax, 1
jnz     left
jmp     moved
left:
mov     bl,8
push    cx
push    dx
pop     ax
div     bl
mov     dh, al
pop     ax
div     bl
mov     dl, al
inc     dl

mov     ah,02h
mov     bh, 00h
int     10h

call ts_clear

; display message
mov     ax, @data                                                                       
mov     ds, ax
mov     dx, offset message_left
mov     ah, 09h
int     21h
jmp     exit

moved:                          ; mouse moved
; routine to place cursor
mov     bl,8
push    cx
push    dx
pop     ax
div     bl
mov     dh, al
pop     ax
div     bl
mov     dl, al
inc     dl

mov     ah,02h
mov     bh, 00h
int     10h

call ts_clear

mov     ax, @data
mov     ds, ax
mov     dx, offset message_moved
mov     ah, 09h
int     21h
jmp      exit

right:                  ; right mouse button pressed
mov     bl,8
push    cx
push    dx
pop     ax
div     bl
mov     dh, al
pop     ax
div     bl
mov     dl, al
inc     dl

mov     ah, 02h
mov     bh, 00h
int     10h

call    ts_clear

; display message
mov     ax, @data
mov     ds, ax
mov     dx, offset message_right
mov     ah, 09h
int     21h
jmp     exit


exit:

pop     dx
pop     cx
pop     bx
pop     ax
mouse   endp
retf                    ; this is a "far" procedure
;****************************************************************

;****************************************************************
ts_clear proc near      ; text screen clear
push    ax
push    cx
push    es
push    di

mov     ax, 0b800h
mov     es, ax
mov     di, 0000h
mov     ax, 1700h
mov     cx, 0fa0h
cld
repz
stosw

pop     di
pop     es
pop     cx
pop     ax

ret
ts_clear endp
;****************************************


end start
