.model small
.stack 0100h
.code
start:

;-------initialize the mouse
xor     ax, ax
int     33h

;-------check to see if mouse is installed
cmp     ax,0000h

;-------proceed if mouse driver loaded
jnz     it_lives

;-------if not, then exit
jmp     error

;-------begin mouse routine
it_lives:

;-------initialize our data area
mov     ax, @data
mov     ds, ax
mov     es, ax

;-------Make sure we're in video mode 3 (text mode)
mov     ah, 0
mov     al, 3
int     10h

;-------call routine to clear the screen, display message,
;        and hide screen cursor
call    ts_clear
call    exit_message
call    cursor_hide 

;-------make arrow shape in font tables
call    change_font

;-------set boundaries for, and make mouse cursor visible on screen 
call    boundaries
mov     ax, 0001h
int     33h

;-------set cursor shape to take on our newly defined font (arrow)
mov     ax, 0ah
mov     bx, 00h
mov     cx, 00h
mov     dx, 1c02h
int     33h

;-------wait for keypress
mov     ah, 00h
int     16h

;-------hide mouse cursor and clear the screen
mov     ax, 0002h
int     33h
call    ts_clear

jmp     exit
;-------no mouse loaded so, exit with error message
error:
mov     ax, @data
mov     ds, ax
mov     dx, offset err_message
mov     ah, 09h
int     21h

;-------terminate program
exit:
mov     ah, 04ch
int     21h

;-------procedure to clear text screen
ts_clear proc near

push    ax
push    cx
push    es
push    di

mov     ax, 0b800h
mov     es, ax
mov     di, 0000h
mov     ax, 1700h
mov     cx, 0fa0h
cld
repz
stosw

pop     di
pop     es
pop     cx
pop     ax
ret
ts_clear endp

;-------procedure to create arrow in font-table
change_font proc near

;-------save the registers that we'll be changing
pushf
push    ax
push    bx
push    cx
push    dx
push    ds
push    es
push    bp

;-------BIOS routine to load user defined character font
mov     ax, 1100h       ; BIOS  function  to  load  user_specified  font 
mov     bh, 14          ; Number of bytes_per_character in table (below)
mov     bl, 0           ; Character generator RAM block 
mov     cx, 1           ; Number  of  character  we  are going to change
mov     dx, 2           ; First  (only)  character  we   are   changeing
mov     bp, offset figure       ; Address   character  generation  table
int     10h

;-------return saved registers
pop     bp
pop     es
pop     ds
pop     dx
pop     cx
pop     bx
pop     ax
popf

ret
endp    change_font 

; display exit message
exit_message proc near

push    ax
push    dx
mov     dx, offset quit
mov     ah, 09h
int     21h
pop     dx
pop     ax
ret
exit_message endp

; hide screen cursor
cursor_hide proc near

push    ax
push    bx
push    dx
mov     ah,02h
mov     bh,0
mov     dh, 25
mov     dl, 0
int     10h
pop     dx
pop     bx
pop     ax
ret     
cursor_hide endp

; set upper mouse boundaries
boundaries proc near

push    ax
push    cx
push    dx
mov     ax, 0008h
mov     cx, 8
mov     dx, 199
int     33h
pop     dx
pop     cx
pop     ax
ret
boundaries endp

;-------Data Area------------------------------------------------------------
.data
quit            db      "                             -- Hit any key to exit -- $"
err_message     db      12 dup(10, 13)
                db      "                 A mouse drive must first be loaded" 
                db      " in memory"
                db      10, 13
                db      "                         prior to running this prog"
                db      "ram!"
                db      12 dup(10, 13)
                db      "$"

figure  db        00000000b     ; arrow to replace normal ascii character
        db        10000000b
        db        11000000b
        db        11100000b
        db        11110000b
        db        11111000b
        db        11111100b
        db        11111110b
        db        11111111b
        db        00011000b
        db        00001100b
        db        00000110b
        db        00000000b
        db        00000000b



end start

