; very basic program to display mouse cursor on screen in text mode
.model small
.stack 0100h

.data
err_message     db      12 dup(10, 13)
                db      "                 A mouse drive must first be loaded in memory"
                db      10, 13
                db      "                         prior to running this program!"
                db      12 dup(10, 13)
                db      "$"

.code
start:

; initialize the mouse
xor ax, ax
int 33h

; check to see if mouse is installed
cmp ax,0000h

; proceed if mouse driver loaded
jnz it_lives

; if not, then exit
jmp error

; begin mouse routine
it_lives:

; call routine to clear the screen
call ts_clear

; make mouse cursor visible on screen
mov ax, 0001h
int 33h

; wait for keypress
mov ah, 00h
int 16h

; hide mouse cursor
mov ax, 0002h
int 33h

jmp exit
; no mouse loaded so, exit with error message
error:
mov ax, @data
mov ds, ax
mov dx, offset err_message
mov ah, 09h
int 21h

; terminate program
exit:
mov ah, 04ch
int 21h

; clear the text screen
ts_clear proc near

push ax
push cx
push es
push di

mov ax, 0b800h
mov es, ax
mov di, 0000h
mov ax, 1700h
mov cx, 0fa0h
cld
repz
stosw

pop di
pop es
pop cx
pop ax
ret
ts_clear endp

end start

