; Example program #1
; This one demonstrates possible IRQ screwups under VCPI and DPMI.
; When it starts, there should be 2 boxes flashing on and off in the upper
; right of the screen. Then when you press a key, nothing should change. But
; unfortunately, under VCPI, one of the boxes will stop blinking. This is when
; control passes to the real mode BIOS key routine. As it waits in real mode,
; protected control is in the hands of the VCPI server. And this program will
; not regain control for its IRQ handlers. Under DPMI both boxes should
; continue to blink just like in raw mode. But sometimes they may not. This
; is when the DPMI host is not reflecting the IRQs correctly.

        .386p
        jumps

code16  segment para public use16
        assume cs:code16, ds:code16

;
nrirq0:
        push ax ds
        mov ax,0b800h
        mov ds,ax
        xor byte ptr ds:[156],91h
        pop ds
        mov al,20h
        out 20h,al
        sti
        pop ax
        iret

code16  ends

code32  segment para public use32
        assume cs:code32, ds:code32

include pmode.inc

public  _main

;
; DATA
;
oirq0           dd      ?
orirq0          dd      ?

;
; CODE
;

;
nirq0:
        push ds
        mov ds,cs:_selzero
        xor byte ptr ds:[0b8000h+158],0fbh
        pop ds
        jmp cs:oirq0                    ; chain to old IRQ0 redirector
;
_main:
        mov dword ptr gs:[0b8000h+156],0f200f20h        ; clear upper right

        xor bl,bl                       ; hook into pmode IRQ0 redirector
        call _getirqvect
        mov oirq0,edx
        mov edx,offset nirq0
        call _setirqvect

        mov eax,gs:[20h]                ; replace real mode IRQ0 handler
        mov orirq0,eax
        mov word ptr gs:[20h],offset nrirq0
        mov word ptr gs:[22h],code16
        sti

mainl0:                                 ; wait in pmode for key
        mov ax,gs:[41ah]
        cmp ax,gs:[41ch]
        je mainl0
        mov al,16h                      ; get key to clear buffer
        mov v86r_ah,0
        int 33h

        mov al,16h                      ; wait for key in real mode
        mov v86r_ah,0
        int 33h

        mov eax,orirq0                  ; must replace real mode int vect
        mov gs:[20h],eax
        jmp _exit

code32  ends
        end

