; **************************************************************************
; *                      Procedure :  BinInt                               *
; **************************************************************************
; *                                                                        *
; * Author  : Assembly Book Page 172                                       *
; * Purpose : converts an ASCII decimal to a 16-bit integer                *
; * input   : DS:SI address of ASCII decimal string                        *
; *           CX length of ASCII decimal string                            *
; * output  : If CF=0  AX is integer and SF and ZF are defined             *
; *           else if overflow AL=0 and AH is sign, if data error AL=1     *
; *                                                                        *
; **************************************************************************

TITLE   BININT
.MODEL  SMALL

.DATA

        .CODE
        PUBLIC  BININT
BININT          PROC
                PUSH    BX              ; save records
                PUSH    CX
                PUSH    DI
                PUSH    DX
                PUSH    SI
                SUB     AX,AX           ; clear AX
                MOV     BX,AX           ; DX:BX is number so far
                MOV     DX,AX
                MOV     DI,AX           ; DI is sign flag
                JCXZ    BININT4         ; finished if length is zero

; Find First Non-Blank

                DEC     SI              ; point to preceding character
NONBLANK1:      INC     SI              ; point to next character
                CMP  BYTE PTR [SI],' '  ; compare to blank
                LOOPE   NONBLANK1       ; loop if equal and CX not zero
                JZ      BININT4         ; exit if all blanks

; Check for signs

                INC     CX              ; include this byte in length
                MOV     AL,[SI]         ; get first non-blank
                CMP     AL,'+'          ; Is it Plus?
                JE      BININT1         ; branch if yes
                CMP     AL,'-'          ; If it isn't positive is it negative?
                JNE     BININT2         ; If it isn't plus or minus
                NOT     DI              ; DI = -1 if negative
BININT1:        INC     SI              ; have sign point next to byte
                DEC     CX              ; and decrement length

; Convert to Binary

BININT2:        JCXZ    BININT4         ; finished if length is zero
BININT3:        MOV     AL,[SI]         ; get next digit
                CMP     AL,'0'          ; is character below zero?
                JB      BININT3C        ; Continue with code
                CMP     AL,'9'          ; is character above nine?
                JA      BININT3C        ; Continue with code
                CMP     AX,AX           ; Set Zero Flag
BININT3C:       JNZ     BININT9         ; data error if not digit
                XCHG    AX,BX           ; digit in BX,number so far in AX
                MOV     DX,10           ; multiply number so far by 10
                MUL     DX             
                JC      BININT8         ; overflow if carry
                SUB     BL,'0'          ; convert ASCII digit to binary
                ADD     AX,BX           ; add digit in number so far
                XCHG    BX,AX           ; number so far in BX, 0 in AH
                JC      BININT8         ; repeat while no errors
                INC     SI              ; point to next byte
                LOOP    BININT3         ; repeat until no more digits

; Have number check for overflow

BININT4:        MOV     AX,BX           ; put number in AX
                OR      DI,DI           ; check sign flag
                JS      BININT5         ; branch if negative
                CMP     AX,32767        ; check for positive overflow
                JNA     BININT6         ; okay if less than or equal to 32767
                JMP     SHORT BININT8   ; overflow if above 32767
BININT5:        NEG     AX              ; make number negative
                JZ      BININT6         ; okay if zero
                JNS     BININT8         ; overflow if no sign

; Here for normal exit

BININT6:        OR      AX,AX           ; define ZF, SF
                CLC                     ; Clear error flag
BININT7:        POP     SI              ; Restore REgisters
                POP     DX
                POP     DI
                POP     CX
                POP     BX
                RET

; Here if overflow

BININT8:        MOV     AX,DI           ; Sign in AH
                SUB     AL,AL           ; error code 0 in AL
                STC                     ; set error flag
                JMP     BININT7
BININT9:        MOV     AL,1            ; error code 1 in AL
                STC                     ; set error flag
                JMP     BININT7
BININT  ENDP
        END
