; **************************************************************************
; *                      Procedure :  Write Line                           *
; **************************************************************************
; *                                                                        *
; * Author  : Assembly Book Page 108                                       *
; * Purpose : advances cursor to next line                                 *
; * input   : none.                                                        *
; * output  : none.                                                        *
; *                                                                        *
; **************************************************************************

TITLE WRITELN
.MODEL  SMALL

.DATA

        .CODE
        PUBLIC  WRITELN
WRITELN PROC
        PUSH    DX                      ; save altered registers
        PUSH    CX
        PUSH    BX
        PUSH    AX
        PUSH    DS
        PUSH    CS                      ; push CS onto the stack
        POP     DS                      ; inorder to pop it onto DS
        MOV     DX,OFFSET CR_LF         ; offset to CR/LF sequence in DS:DX
        MOV     CX,2                    ; write characters
        MOV     BX,1                    ; select standard output device
        MOV     AH,40H                  ; select write to file/device
        INT     21                      ; write CR/LF
        POP     DS
        POP     AX
        POP     BX
        POP     CX
        POP     DX
        RET
CR_LF   DB      13,10
WRITELN ENDP
        END

