;Module   : PUT_INT             File: Put_Int.ASM
;Function : Display's a Word Integer
;Input    : Integer in AX
; Output  : none

TITLE   PUT_INT
.Model  Small

                .Data
 

                .Code
                PUBLIC  Put_Int
Put_Int         Proc
 
                PUSH    DX              ; Save Registers
                PUSH    CX
                PUSH    BX
                PUSH    AX

; ***********************************************************************
; *                            Display Sign                             *
; ***********************************************************************

                MOV     DL,' '          ; Assume a Positive Sign
                CMP     AX,0            ; Check for a Negative Number
                JGE     PUTINT1         ; branch if positive
                MOV     DL,'-'          ; make sign if negative
                NEG     AX              ; Invert to a positive number

PUTINT1:        MOV     CX,AX           ; Save number temporarily in CX
                MOV     AH,2            ; Select Display Character Function
                INT     21h             ; Display sign in DL

; ***********************************************************************
; *                       Convert to a Decimal                          *
; ***********************************************************************

                MOV     AX,CX           ; number back in AX
                MOV     BX,10           ; divisor 10 in BX
                SUB     CX,CX           ; Clear CX Register

PUTINT2:        SUB     DX,DX           ; divide quotent in DX:AX
                DIV     BX              ; by ten in BX
                ADD     DL,'0'          ; convert remainder to ASCII
                PUSH    DX              ; push remainder
                INC     CX              ; count digit
                CMP     AX,0            ; if quotent is not zero
                JNZ     PUTINT2         ; get next digit

; ***********************************************************************
; *                       Display ASCII digits                          *
; ***********************************************************************

PUTINT3:        POP     DX              ; retrieve digit
                MOV     AH,2            ; select display character fctn
                INT     21H             ; display digit in dl
                LOOP    PUTINT3         ; next digit

                POP     AX              ; Retore all Registers
                POP     BX
                POP     CX
                POP     DX

                RET
PUT_INT         ENDP
                END

