;**********************************
;* FLamoot VGA SetUp include file *
;**********************************

EXTRN _SetVGA: FAR
EXTRN _WaitVBL: FAR
EXTRN _WaitHBL: FAR

VSYNC MACRO          ; Om de VBL te wachten...
      call _WaitVBL
      ENDM

MPUSH   MACRO reg1:REQ,reg2:VARARG   ; Vive Y.Roggeman/Greg & ses Macros
        push reg1                    ; recursives !!!!!!! yahouuuuu !!!
        IFNB <reg2>
        MPUSH reg2
        ENDIF
        ENDM

MPOP    MACRO reg1:REQ,reg2:VARARG   ; bis bis !!!
        IFNB <reg2>                  ; type brol = record....
        MPOP reg2                    ; donc a fait 20 bytes !!!
        ENDIF                        ; donc 1 word ....
        pop reg1                     ; brol je dis struct !!!
        ENDM


;*** GFX-mode structure *** 

mode RECORD hgh:5, ver:3, hor:3, col:2, adr:2
;
; rem:   hgh = line doubling factor
;        ver = 0 --> 350 lines display     hor = 0 --> 128 horiz width
;              1     400 big                     1     160
;              2     400                         2     180
;              3     400 60hz                    3     256
;              4     448                         4     320
;              5     480                         5     360
;              6     512                         
;              7     540
;        col = 0 --> 256 colors display    adr = 0 --> planar scheme (X-mode)
;              1     16                          1 --> chained
;              2     4                           2 --> cga
;              3     text 16                     3 --> mono
;
; PS: if you choose a 16 colors display, the horiz width is doubled !!!!!

; predefined modes ....
;-----------------------
m160x67x256c      EQU mode<5,2,1,0,1>  ; 7-mode like
m160x70x256c      EQU mode<4,0,1,0,1>  ; 7-mode like
m160x80x256c      EQU mode<4,2,1,0,1>  ; 7-mode like
m160x100x256c     EQU mode<3,2,1,0,1>  ; 7-mode
m160x200x256p60hz EQU mode<1,3,1,0,0>  ; 7-mode like
m320x67x256c      EQU mode<5,2,4,0,1>
m320x70x256c      EQU mode<4,0,4,0,1>
m320x80x256c      EQU mode<4,2,4,0,1>
m320x100x256c     EQU mode<3,2,4,0,1>
m320x200x256c     EQU mode<1,2,4,0,1>
m320x200x256p60hz EQU mode<1,3,4,0,0>
m320x400x256p     EQU mode<0,2,4,0,0>
m320x400x256pbig  EQU mode<0,1,4,0,0>
m320x480x256p     EQU mode<0,5,4,0,0>

;misc. examples
;--------------
m320x200x256p EQU mode<1,2,4,0,0>
m320x240x256p EQU mode<1,5,4,0,0>
m360x480x256p EQU mode<0,5,5,0,0>
m256x256x256p EQU mode<1,6,3,0,0>
m320x240x16p  EQU mode<1,5,1,1,0>
m640x400x16p  EQU mode<0,2,4,1,0>
m512x512x16p  EQU mode<0,6,3,1,0>
m720x480x16p  EQU mode<0,5,5,1,0>
m320x200x16c  EQU mode<1,2,1,1,1>

m320x400x256c EQU mode<0,2,4,0,1>
m320x480x256c EQU mode<0,5,4,0,1>
m320x448x256c EQU mode<0,4,4,0,1>
m256x256x256c EQU mode<1,6,3,0,1>

m1440x480x4c  EQU mode<0,5,5,2,1>
m720x480x16c  EQU mode<0,5,5,1,1>


; some constants and macros by -=MorFlame/TFL-TDV=-

; ===  - Valeurs registres VGA -  ===
                              
VGA_Segment     EQU     0A000h                ; Segment mmoire vga
ATTRIB_Ctrl     EQU     03C0h                 ; Contrleur d'attribut VGA 
GC_Index        EQU     03CEh                 ; Contrleur graphique VGA 
SC_Index        EQU     03C4h                 ; Contrleur squenceur VGA
SC_Data         EQU     03C5h                 ; Port de donnes sq. VGA
CRTC_Index      EQU     03D4h                 ; Contrleur crt VGA
CRTC_Data       EQU     03D5h                 ; Contrleur donnes crt VGA
MISC_OUTPUT     EQU     03C2h                 ; Registre VGA divers
INPUT_1         EQU     03DAh                 ; Registre statut d'input #1
                              
DAC_WRITE_ADDR  EQU     03C8h                 ; Reg addr criture DAVGA
DAC_READ_ADDR   EQU     03C7h                 ; Reg addr lecture DAVGA
PEL_DATA_REG    EQU     03C9h                 ; Reg donnes R/W DAC/PEL VGA
PIXEL_PAN_REG   EQU     033h                  ; Index attr: Reg pixel pan
MAP_MASK        EQU     002h                  ; Index seq : write map mask
READ_MAP        EQU     004h                  ; Reg lect map GIndex
START_DISP_HI   EQU     00Ch                  ; CRTIndex: display start hi
START_DISP_LO   EQU     00Dh                  ; CRTIndex: display start lo
                              
MAP_MASK_PLANE1 EQU     00102h                ; Map Register + Plane 1 
MAP_MASK_PLANE2 EQU     01102h                ; Map Register + Plane 2
ALL_PLANES_ON   EQU     00F02h                ; Map Register + All Bit Planes

PLANE1_ON       EQU     0102h                              
PLANE2_ON       EQU     0202h                              
PLANE3_ON       EQU     0402h
PLANE4_ON       EQU     0802h

CHAIN4_OFF      EQU     00604h                ; Chain 4 mode Off
ASYNC_RESET     EQU     00100h                ; (A)synchronous Reset
SEQU_RESTART    EQU     00300h                ; Sequencer Restart
                              
LATCHES_ON      EQU     00008h                ; Bit Mask + Data from Latches
LATCHES_OFF     EQU     0FF08h                ; Bit Mask + Data from CPU 
                                                                  
VERT_RETRACE    EQU     08h                   ; INPUT_1: Vertical Retrace Bit
PLANE_BITS      EQU     03h                   ; Bits 0-1 of Xpos = Plane #
ALL_PLANES      EQU     0Fh                   ; All Bit Planes Selected
CHAR_BITS       EQU     0Fh                   ; Bits 0-3 of Character Data
                              
GET_CHAR_PTR    EQU     01130h                ; VGA BIOS Func: Get Char Set 
ROM_8x8_Lo      EQU     03h                   ; ROM 8x8 Char Set Lo Pointer 
ROM_8x8_Hi      EQU     04h                   ; ROM 8x8 Char Set Hi Pointer 


OUT_16 MACRO Register, Value
; Macro to OUT a 16 bit value to an I/O port
IFDIFI <Register>, <DX>               ; If DX not setup
    MOV             DX, Register  ; then Select Register
ENDIF
IFDIFI <Value>, <AX>                  ; If AX not setup 
    MOV             AX, Value     ; then Get Data Value
ENDIF
    OUT             DX, AX        ; Set I/O Register(s)
ENDM
                              
OUT_8 MACRO Register, Value
; Macro to OUT a 8 bit value to an I/O Port
IFDIFI <Register>, <DX>               ; If DX not setup
        MOV             DX, Register  ; then Select Register
ENDIF
IFDIFI <Value>, <AL>                  ; If AL not Setup
        MOV             AL, Value     ; then Get Data Value
ENDIF
        OUT             DX, AL        ; Set I/O Register
ENDM

