; Subtract source from dest (both 64-bit numbers)
;
; Tim Victor, January 5, 1993
;
; Callable from C as follows:
; int ExtSub(src, dest);
;   always return 0
;
        .model  small
        .code
        public _ExtSub
_ExtSub proc near

        push bp         ; save caller's stack frame
        mov  bp,sp      ; address stack frame of this call
        push si
        push di

; just subtract four pairs of words
        mov  si,[bp+4]  ; source address
        mov  di,[bp+6]  ; dest address

        mov  ax,[si]
        sub  [di],ax
        mov  ax,[si+2]
        sbb  [di+2],ax
        mov  ax,[si+4]
        sbb  [di+4],ax
        mov  ax,[si+4]
        sbb  [di+4],ax

        sub  ax,ax      ; return 0

        pop  di
        pop  si
        pop  bp

        ret

_ExtSub endp
        end

