;*****************************************************************************
; Filename: MK_FAR.ASM
;   Author: Peter Andersson
;  Version: 0.0
;  Created: 1994.09.19
;  Updated: 1995.03.11
;*****************************************************************************
; Copyright Peter Andersson, 1994-1995.
; All rights reserved.
;*****************************************************************************
; Function: PVOID @MK_FAR(PVOID address)
;  Comment: Converts a segment:offset to a 32bit pointer. The pointer which
;           are returned _does not_ wrap around at 1MB which means that
;           0FFFFh:0010h: returns a pointer to 100000h!
;    Input: Eax - address to convert
;  Returns: 32bit pointer
;*****************************************************************************

        Include STDDEF.INC

        Codeseg

Proc    MK_FAR  ,1
                Mov     Edx,Eax
                Shr     Eax,12
                And     Edx,0FFFFh
                And     Eax,0FFFF0h
                Add     Eax,Edx
                Add     Eax,[_zero]
                Ret
Endp

        End
