;ͻ
;         USFUL MACROS FOR YOUR PROTECTED MODE PROGRAMS           
;Written by Adam Seychell                                         
;                                                                 
;ͼ

TRUE    EQU     1
FALSE   EQU     0
CRLF    EQU     10,13

Halt MACRO
        mov     ax,4c00h
        int     21h
ENDM

;-----------------------------------------------------------------------
;                    OPEN A FILE
;
; OpenFile     <Handle>,<'path\filename'>
;
; Example:      OpenFile      myfile,'c:\gif\bird.gif'
;
;-----------------------------------------------------------------------
OpenFile macro X, FileName, nameOFS
local skip_opfi
        IFB <nameOFS>
              mov edx,offset file_to_open&X    ; DS:EDX   points to file name
        ELSE
                mov edx,nameOFS
        ENDIF
        mov ax,3D02h		; open a file function
        Int 21h
        mov FileHandle&X , AX
        jmp  skip_opfi
file_to_open&X  db FileName,0
FileHandle&X    dw 0
skip_opfi:
endm



;-----------------------------------------------------------------------
;       	         CREATE A FILE
;
; Usage:       CreateFile     <Handle>,<'path\filename'>
;
; Example:      CreateFile      myfile,'drum.voc'
;
;-----------------------------------------------------------------------
CreateFile macro X, FileName , nameSEG , nameOFS
local skip_crfi
	jmp skip_crfi
file_to_open&X  db FileName,0
FileHandle&X    dw 0
skip_crfi:
        IFB <nameOFS>
              mov edx,offset file_to_open&X    ; DS:EDX   points to file name
        ELSE
                mov edx,nameOFS
        ENDIF
        mov 	ax,3C02h            ; creat a file function
        xor     ecx,ecx
        Int 21h
        mov FileHandle&X , AX
endm




;-----------------------------------------------------------------------
;               	  CLOSE A FILE
; Usage:         Close    <Handel>
;
; Example:       Close     myfile
;
;-----------------------------------------------------------------------
Close  macro  X
        mov ah,03Eh         ; close a file function
        mov BX,FileHandle&X
        int 21h
endm


;-----------------------------------------------------------------------
;                   READ BLOCK FROM A FILE
;
; Usage:   	BlockRead    <handel>,<32bit offset>,<bytes to read>
;
; Example:      BlockRead   myfile, EDX ,700000
;
;-----------------------------------------------------------------------
BlockRead  macro   X , POINTER, BYTE_COUNT
        push    dword ptr BYTE_COUNT
        push    dword ptr POINTER
        pop     edx
        pop     ecx
        mov     BX,FileHandle&X
        mov     ah,3Fh
        int     21h

endm


;-----------------------------------------------------------------------
;                   WRITE A BLOCK TO A FILE
;
; Usage:     BlockWrite  <handel>,<32bit offset>,<bytes to read>
;
; Example:     BlockWrite   myfile, EDX ,700000
;
;-----------------------------------------------------------------------
BlockWrite  macro  X , POINTER, BYTE_COUNT
        push    dword ptr BYTE_COUNT
        push    dword ptr POINTER
        pop     edx
        pop     ecx
        mov     BX,FileHandle&X
        mov     ah,40h
        int     21h
endm






;-------------------------------------------------------------------------
;              DISPLAY A STRING ON SCREEN
;
; Usage:        Write   <' string to display '>
;
;
;-------------------------------------------------------------------------
Write MACRO STRING_, COLOR5_T
LOCAL TEXT5_T , skip_wrln
        push  eax
        push  edx
        jmp skip_wrln

        IFB <STRING_>
TEXT5_T DB 36
        ELSE
TEXT5_T DB STRING_,36
        ENDIF
skip_wrln:

        MOV     EDX,OFFSET TEXT5_T
        mov     ah,9
        int     21h
        pop edx
        pop eax
ENDM



;-------------------------------------------------------------------------
;              DISPLAY A STRING ON SCREEN WITH CARAGE RETURN
;
; Usage:       Writeln   <' string to display '>
;
;
;-------------------------------------------------------------------------
Writeln MACRO STRING_
LOCAL TEXT3_S
local skip_wrln
        push eax
        push edx

        jmp skip_wrln

        IFB <STRING_>
TEXT3_S DB 13,10,36
        ELSE
TEXT3_S DB STRING_,13,10,36
        ENDIF
skip_wrln:
        mov     EDX,offset TEXT3_S
        mov     ah,9
        Int  21h
        pop edx
        pop eax
ENDM







CRTC		equ	3D4h
SEQ		EQU	3C4h
GC		EQU	3CEh
ATTR		EQU	3C0h

	
;
;		MACROS FOR     VGA    REGISTERS
;


inp	MACRO	port
	mov	dx,port		;; Read a byte from port 'port' into al
	in	al,dx
ENDM

outp	MACRO	port, value
	mov	dx,port		;; Write a byte to port 'port'
	mov	al,value
	out	dx,al
ENDM

outpW	MACRO	port, value
	mov	dx,port		;; Write a byte to port 'port'
	mov	ax,value
	out	dx,ax
ENDM

rdindex	MACRO	port, index
	mov	dx,port		;; Read register 'port' index 'index'
	mov	al,index
	out	dx,al
	inc	dx
	in	al,dx		;; Result in AL
ENDM

wrindex	MACRO	port, index, val
	mov	al,index	;; Write 'port' index 'index' with 'val'
	mov	ah,val
	mov	dx,port
	out	dx,ax
ENDM

modindex	MACRO	port, index, mask, nvw
	mov	dx,port
	mov	al,index
	out	dx,al
	inc	dx
	in	al,dx			;; Read the old value
	and	al,not mask		;; Mask out bits to be changed
	or	al,nvw			;; Or in the changed bits
	out	dx,al			;; Write the value back again
ENDM
