From  Herman Dullink - VESA BIOS Extensions

There are a few things of notice:

 - It (probably) _only_ works on a ET4000/W32p (yet) as I don't have
   enough data (yet). The ET4000/W32p uses a granularity of 4MB,
   as far as I know, an ET4000/W32(i) uses 0.5MB, 1 or 2MB.

 - The TSR needs VBE 1.2 as base, my video card has this on-board.
   Some people probably have to load 'tlivesa' first.
 
 - For DOS, 96 bytes of the PSP are important for termination, I move the
   TSR part from the end to the program to address cs:96 and further.
   BEWARE, that there's only about 20 bytes between the end of the TSR and
   the 'rep movsb' instruction that moved the TSR, if the TSR gets bigger,
   it probably will overwrite the rep movsb, and the program will crash.
   So be aware of this when you adapt this source to your own video card.
   S3 users should have no problem as they can use a simple BIOS call
   instead of that large block full of INs and OUTs.

 - This code is freeware, feel free to use it and adapt it for your own
   purposes.

 - The functions are as VBE compliant as my interpretation of the official
   VBE specifications. The only feature I'm not 100% sure of is the
   vertical retrace. If a card has a 'bad' (snowing) DAC, it has to be
   mentioned in the Capabilities field of Function 00h, and the application
   has to add 80h for every palette service so palette updates are done in
   the vertical retrace. This version of VBE2 will _never_ wait for a
   vertical retrace as it isn't necessary for my DAC. I'm not sure if
   I _have_ to wait if the application adds 80h.

 - When the Flat/Linear frame buffer is enabled, it's up to yourself how
   to access it. I use my own FLAT package. If you use a DOS-extender/DPMI,
   you have to built a descriptor.

 - This is a tricky one :-) I've used the _very_ same code for both the
   Real Mode _and_ Protected Mode Funcion 09h : Set/Get Palette data.
   By being extreemly carefull in selecting the instructions, the same
   code works in RM as well as PM...


[VBE2.ASM]
; VESA BIOS EXTENSIONS (VBE) Core Functions 2.0
;    for the Hercules Dynamite Power series
; ( and probably most other ET4000/W32p cards )

code    segment

   assume  cs:code

   org     100h

Env             equ 2Ch
Signature       equ 60h
AMC             equ 65h
VBE2mode        equ 66h
Old_int10h      equ 68h
TSR_entry       equ 6Ch

.386

vbe2    proc

; Write VBE2 version message      

   mov     ah,09h
   mov     dx,offset VBE2version
   int     21h

; Get Memory size

   mov     ax,1318h
   out     70h,al
   in      al,71h
   add     al,ah
   shr     al,4
   mov     ds:AMC,al

; Get Parameter        

   mov     ax,' '
   mov     cx,81h
   mov     di,cx
   repe    scasb
   dec     di
   mov     bx,di
v1:     scasb
   jc      short v1
   dec     di
   mov     si,di
v2:     cmp     byte ptr ds:[si],0Dh
   je      short v3
   repe    scasb
   cmp     byte ptr ds:[di-1],0Dh
   jne     short Info

; Interpret parameter

v3:     cmp     bx,si
   mov     byte ptr ds:[si],0
   je      short Install
   or      ax,ds:[bx]
   cmp     ax,'u'
   je      short Unload
   cmp     ax,'=a'
   je      short Address

; Write Information

Info:
   mov     ah,09h
   mov     dx,offset information
   int     21h
   ret

Unload:
   mov     ax,3510h
   int     21h
   cmp     dword ptr es:Signature,'2EBV'
   jne     short v4
   mov     ax,2510h
   push    ds
   lds     dx,dword ptr es:Old_int10h
   int     21h
   pop     ds
   mov     ah,49h
   int     21h
   jc      short v4
   mov     ah,09h
   mov     dx,offset Unloaded
   int     21h
   ret

v4:     mov     ah,09h
   mov     dx,offset ErrorUnload
   int     21h
   ret

Address:
   lea     si,bx[2]
   xor     bx,bx
v5:     lodsb
   sub     al,'0'
   cmp     al,9
   ja      V6
   imul    bx,bx,10
   add     bl,al
   jmp     short V5
v6:     cmp     bl,ds:AMC
   jae     short Install
   cmp     al,'!'-'0'
   je      short v7
   mov     ah,09h
   mov     dx,offset AMCerror
   int     21h
   ret
v7:     mov     ah,09h
   mov     dx,offset AMCwarning
   int     21h
   mov     ds:AMC,bl

Install:
   mov     ax,4F00h
   mov     di,offset VbeInfoBlock
   int     10h
   cmp     ax,4F00h
   je      short v8
   cmp     word ptr es:di[4],0102h
   jb      short v8
   je      short v9
   mov     ah,09h
   mov     dx,offset VBE2present
   int     21h
   ret
v8:     mov     ah,09h
   mov     dx,offset VBE12absent
   int     21h
   ret
v9:     mov     al,0ECh
   mov     dx,217Ah
   out     dx,al
   inc     dx
   in      al,dx
   test    al,80h
   jnz     short v11
   mov     ah,al
   shr     al,1
   xor     al,ah
   cmp     al,030h
   jae     short v11
v10:    mov     ah,09h
   mov     dx,offset W32pabsent
   int     21h
   ret
V11:    mov     ah,49h
   mov     es,ds:env
   int     21h
   mov     dword ptr ds:Signature,'2EBV'
   mov     byte ptr ds:Signature[4],0
   mov     ax,4F03h
   int     10h
   mov     word ptr ds:VBE2mode,bx
   mov     ax,3510h
   int     21h
   mov     word ptr ds:Old_int10h[0],bx
   mov     word ptr ds:Old_int10h[2],es
   mov     cx,offset VbeInfoBlock - TSR
   mov     dx,TSR_entry
   push    ds
   mov     si,offset TSR
   mov     di,dx
   pop     es
   rep     movsb
   mov     ax,2510h
   int     21h
   mov     ah,09h
   mov     dx,offset VBE2installed
   int     21h
   mov     dx,di
   int     27h

vbe2    endp

VBE2version     db 'VBE2 Version 1.0',13,10,10,'$'

Information     db 'Syntax:',13,10
      db '    VBE2 [a=<address>[!]|u]',13,10,10
      db 'Parameters:',13,10
      db '    a=<0..255>[!]',13,10
      db 9,'Specifies the address in 4MB units of the linear frame
buffer.',13,10
      db 9,'Normally, VBE2 will use the next 4MB boundary beyond the system
RAM.',13,10
      db 9,'If the specified address conflicts with the system''s installed
RAM,',13,10
      db 9,'VBE2 will not install. However, VBE2 will allways install when
the',13,10
      db 9,'specified address is terminated with an exclamation point
(!).',13,10,10
      db '    u',10
      db 9,'Unloads a previous installed version of VBE2.',13,10,10
      db 'VBE2 is designed to be used with the Hercules Dynamite Power
Series',10
      db '$'

Unloaded        db 'VBE2 unloaded',10,'$'
ErrorUnload     db 'Unable to unload VBE2, or VBE2 not installed',10,'$'

AMCwarning      db 'WARNING!! '
AMCerror        db 'Address conlicts with system''s installed RAM',13,10,'$'

VBE12absent     db 'VBE 1.2 Core not present',10,'$'
VBE2present     db 'VBE 2.0 Core already present',10,'$'
VBE2installed   db 'VBE2 installed',10,'$'

W32pabsent      db 'Unable to find the proper video hardware',10,'$'

tsr     proc
   cmp     ah,4Fh
   jne     F0?

; Function 00h - Return VBE Controller Information
F00:    cmp     al,00h
   jne     short F01
   cmp     dword ptr es:di,'2EBV'
   jne     short L00
   push    di eax cs Signature
   add     di,20
   mov     ah,01h
   stosw
   pop     eax
   stosd
   stosd
   stosd
   pop     eax di
L00:    pushf
   call    dword ptr cs:old_int10h
   shl     word ptr es:di[4],8
   iret

; Function 01h - Return VBE Mode Information
F01:    cmp     al,01h
   jne     short F02
   pushf
   call    dword ptr cs:old_int10h
   test    ah,ah
   jne     short L01
   push    ax
   mov     al,cs:AMC
   or      byte ptr es:di[0],80h
   shl     ax,6
   mov     word ptr es:di[2Ah],ax
   pop     ax
L01:    iret

; Function 02h - Set VBE Mode
F02:    cmp     al,02h
   jne     short F03
   push    bx
   and     bh,0BFh
   pushf
   call    dword ptr cs:old_int10h
   pop     bx
   test    ah,ah
   jne     short L01
   mov     cs:VBE2Mode,bx
   test    bh,40h
   jz      short L01
   push    dx ax
   mov     al,3            ; Set key
   mov     dx,3BFh
   out     dx,al
   mov     al,0A0h
   mov     dl,0D8h
   out     dx,al
   mov     al,30h          ; Set AMC
   mov     ah,cs:AMC
   mov     dl,0D4h
   out     dx,ax
   mov     al,36h          ; Enable linear addressing
   out     dx,al
   inc     dx
   in      al,dx
   and     al,3
   or      al,10h
   out     dx,al
   mov     al,29h          ; Turn off key
   mov     dl,0D8h
   out     dx,al
   mov     al,1
   mov     dl,0BFh
   out     dx,al
   pop     ax dx
   iret

; Function 03h - Return current VBE Mode
F03:    cmp     al,03h
   jne     short F05
   mov     ax,004Fh
   mov     bx,cs:VBE2Mode
   iret

; Function 05h - Display Window Control
F05:    cmp     al,05h
   jne     short F07
   test    byte ptr cs:VBE2Mode[1],40h
   jz      short F0?
   mov     ax,034Fh
   iret

; Function 07h - Set/Get Display Start
F07:    cmp     al,07h
   jne     short F09
   and     bl,1

; Function 09h - Set/Get Palette Data
F09:    cmp     al,09h
   jne     short F0A
   call    PMF09
   iret

F0A:    cmp     al,0Ah
   jne     short F0?
   test    bl,bl
   jne     short F0?
   mov     ax,004Fh
   push    cs
   mov     cx,offset VbeInfoBlock - PMC
   pop     es
   mov     di,offset PMC - TSR + TSR_entry
   iret

; Other VBE Functions
F0?:    jmp     dword ptr cs:old_int10h

PMC     dw      offset PMF05 - PMC
   dw      offset PMF07 - PMC
   dw      offset PMF09 - PMC
   dw      0

; Protected Mode Function 05h - Display Window Control
PMF05:  mov     cl,dl
   db      66h
   mov     dx,3CBh
   in      al,dx
   mov     dl,0CDh
   mov     ah,al
   in      al,dx
   test    bh,1
   jnz     short L052

   mov     ch,cl           ; Set memory window
   test    bl,1
   jnz     short L050
   db      66h             ; Window A
   and     ax,0FCF0h
   and     cl,0Fh
   shr     ch,4
   jmp     short L051    
L050:   db      66h             ; Window B
   and     ax,0CF0Fh
   shl     cl,4
   and     ch,30h
L051:   db      66h
   or      ax,cx
   out     dx,al
   mov     dl,0CBh
   mov     al,ah
   out     dx,al
   jmp     short L055

L052:   test    bl,1            ; Get memory window
   jnz     short L053
   and     al,0Fh          ; Window A
   shl     ah,4
   jmp     short L054
L053:   shr     al,4            ; Window B
   and     ah,dh
L054:   or      al,ah
   and     al,3Fh
   mov     dl,al
L055:   db      66h
   mov     ax,004Fh
   ret

; Protected Mode Function 07h - Set Display Start
PMF07:  push    bx
   mov     al,0Dh
   mov     ah,cl
   mov     bl,dl
   db      66h
   mov     dx,3D4h
   out     dx,ax
   dec     al
   mov     ah,ch
   out     dx,ax
   mov     al,33h
   out     dx,al
   inc     dx
   in      al,dx
   and     al,0F0h
   or      al,bl
   out     dx,al
   pop     bx
   db      66h
   mov     ax,004Fh
   ret

; Protected Mode Function 09h - Set/Get Palette Data
;  Code for both 16-bit Real _AND_ 32-bit Protected Mode !!!!
PMF09:  mov     ah,2
   test    bl,2
   jnz     short L094
   pushf
   push    dx cx
   mov     al,dl
   mov     dl,0C7h
   mov     dh,3
   out     dx,al
   inc     dx
   out     dx,al
   inc     dx
   std
   test    bl,1
   jnz     short L091

   push    ds si es        ; Set Palette Data
   pop     ds
   mov     si,di           ; Can't use 'lea si,di[2]' as in 32-bit PM
   add     si,2            ; it'll be interpreted as 'lea esi,ebp[2]'
L090:   outsb
   outsb
   outsb
   add     si,7
   dec     cl
   jnz     short L090
   pop     si ds
   jmp     short L093

L091:   push    di              ; Get Palette Data
   add     di,2
L092:   insb
   insb
   insb
   add     di,7
   dec     cl
   jnz     short L092
   pop     di
L093:   mov     ah,cl
   pop     cx dx
   popf
L094:   mov     al,4Fh
   ret

tsr     endp

VbeInfoBlock    db 256 dup(?)

code    ends

   end vbe2

