; TENIE REMMEL                                            1:202/747
;**********************************************************; 
;* 90WIDE -- Small program to set 90 chars/line text mode *; 
;**********************************************************; 
 
Ideal    
Model Tiny 
P186 
CodeSeg 
Org 100h 
 
Proc        Set90 
 
            pusha                  ;Save all registers 
            mov dx,03C4h           ;Sequencer Port 
            mov ax,0100h           ;Synchronous reset 
            out dx,ax              ;Send command 
            inc ax                 ;8 pixels/char 
            out dx,ax              ;Send command 
             
            mov dx,03CCh           ;Misc Output Read Port

            in al,dx               ;Read value 
            and al,0F3h            ;Bits 2-3: 01 = 28MHz 
            or al,4 
            mov dx,03C2h           ;Misc Output Write Port 
            out dx,al              ;Send command 
             
            mov dx,03DAh           ;Read this port to reset 
            in al,dx               ;the Attribute Controller 
            mov dx,03C0h           ;Attribute Controller Port 
            mov al,13h             ;Horizontal Panning 
            out dx,al              ;Select register 
            xor al,al              ;Set Shift = 0 
            out dx,al              ;Send command 
            mov al,20h             ;Restart Screen 
            out dx,al              ;Select register 
            out dx,al              ;Send command 
             
            mov dx,03D4h           ;CRT Controller Port 
            mov al,11h             ;Register Protect 
            out dx,al              ;Select register 
            inc dx 
            in al,dx               ;Read register 
            and al,7Fh             ;Turn off Protect 
            out dx,al              ;Send command 
            dec dx 
            mov si,offset CRTCdata ;Offset of CRTC data 
            mov cx,7               ;7 words 
            rep outsw              ;Send data 
            mov ah,al              ;Protect value 
            mov al,11h             ;Set up for word OUT 
            or ah,80h              ;Turn on Protect 
            out dx,ax              ;Send command 
             
            mov dx,03C4h           ;Sequencer Port 
            mov ax,0300h           ;Restart Sequencer 
            out dx,ax              ;Send command 
             
            xor ax,ax              ;Tell the BIOS 
            mov ds,ax              ;about the new 
            mov [byte 044Ah],90    ;width (90) 
            mov ax,1114h           ;Load 8x16 font 
            int 10h                ;BIOS video 
            popa                   ;Restore registers 
            ret                    ;Return 
 
CRTCdata    dw 06B00h          ;Horizontal Total 
            dw 05901h          ;Horizontal Displayed 
            dw 05A02h          ;Start Horiz Blanking 
            dw 08E03h          ;End Horiz Blanking 
            dw 06004h          ;Start Horiz Retrace 
            dw 08D05h          ;End Horiz Retrace 
            dw 02D13h          ;Memory Allocation 
 
EndP        Set90 
 
End Set90 
