;
; EMS system implemented by
;
; David Lindauer
;
; gclind01@ulkyvx.louisville.edu
;
; August, 1995 
;
; As part of the FREE-DOS project
;
;
; Pic.asm
;
; Function: Programmable interrupt controller functionality
;   Handles mapping interrupts to the DOS or Kernel locations
;
	.386P
	PUBLIC	pic386, pic8086, waitforint

include segs.asi
include	pic.asi

seg386data	SEGMENT
						; we're about to step on
setup8086	db	11h		; ICW1
		db	BIOSPIC0VECTOR	; ICW2
		db	4		; ICW3
		db	1		; icw4
pic0stat	db	0			; Original interrupt enable
		db	11h		; ICW1
		db	BIOSPIC1VECTOR	; ICW2
		db	2		; ICW3
		db	1		; icw4
pic1stat	db	0			; Original interrupt enable
setup386	db	11h		; ICW1
		db	PIC0VECTOR	; ICW2
		db	4		; ICW3
		db	1		; icw4
pic0stat2	db	0			; Original interrupt enable
		db	11h		; ICW1
		db	PIC1VECTOR	; ICW2
		db	2		; ICW3
		db	1		; icw4
pic1stat2	db	0			; Original interrupt enable
seg386data	ends

;
;	Initialize PIC
;
seg386	SEGMENT
	assume	cs:DGROUP, ds: DGROUP
picini	PROC
	cld				; Upward dir
	mov	dx,PIC0ADR		; Do PIC0
	call	picout
	mov	dl,PIC1ADR		; Do PIC 1
picout:
	lodsb				; GET ICW1 
	out	dx,al			; output
	inc	dx			; Set to control reg
	mov	ecx,4			; 4 more to output
piclp:
	outsb				; Output one
	PICDELAY
	loop	piclp			; Loop
	ret				; Done
picini	endp
;
; Restore 8086 mode
;
pic8086	PROC
	pushf
	cli
	mov	esi,offset DGROUP:setup8086
	call	picini				; Initialize PIC
	popf
	ret
pic8086	endp
;
; Set 386 mode
;
pic386	proc
	pushfd
	cli
	PICREAD	1,PIC0ADR			; Read interrupt enable status
	mov	[pic0stat],al
	mov	[pic0stat2],al
	PICREAD	1,PIC1ADR
	mov	[pic1stat],al
	mov	[pic1stat2],al
	mov	esi,offset DGROUP:setup386
	call	picini				; Initialize PIC
	popfd
	ret
pic386	endp
;
; Wait for an interrupt to occur.  Note the emulator
; will have ints cleared when it calls this so the int won't be taken.
; Only ints that are masked enabled will cause an end to the halt.
;
; Note that as implemented this routine changes PIC state OCW3.  This WILL
; cause a problem for 8086 code that assumes OCW3 will remain unchanged
; through a hlt.
;
waitforint	proc
	PICREAD	1,PIC0ADR	; Read the enable masks
	mov	bh,al		;
	PICREAD	1,PIC1ADR	;
	mov	bl,al		;
	not	ebx		; Set enabled bits to 1
	mov	al,PR_REQUEST	; Program the PICS to return the request reg

	PICWRITE 0,PIC0ADR	;
	PICWRITE 0,PIC1ADR	;

@lp:
	PICREAD	0,PIC0ADR	; Read PIC 0 request reg
	mov	ah,al
	PICREAD	1,PIC1ADR	; Or in PIC 1 request reg
	and	ax,bx		; And in the enable masks
	or	al,ah		;
	jz	@lp		; Loop while no interrupts available
	ret
waitforint	endp
seg386	ends
	END













wc