/****************************************************************************

    PROGRAM:    Vlibdemo.exe

    PURPOSE:    To demonstrate the usage of Visualib(TM) functions.
    
    PROVIDER:   Visual Technology, Co.
				P.O.Box 901-413
				Kansas City, MO 64190
				Tel. (219) 289-0235
				Fax. (816) 746-6618
    
    DATE:		May, 1993

****************************************************************************/

#include <windows.h>
#include <math.h>
#include "visualib.h"
#include "menu.h"
#include "vlibdemo.h"
#include "demoproc.h"
#include "dialogs.h"

HINSTANCE	hInst;
HPALETTE    hpal;
short   viewer20, viewer21, viewer22;
short   viewer30, viewer31, viewer32, viewer33, viewer34, viewer35;
short   demo_function, animate_length;
short   light0, light1, light2, light3, light4, light5, light6, light7, light8;
short   mater0, mater1, mater2, mater3, mater4, mater5, mater6, mater7;
HGLOBAL hdib1, hdib2, hdib3;
COLORREF	backcolor;
BOOL	withframe = FALSE;

void    FunctionDemos (HDC hdc); 

int PASCAL WinMain (HINSTANCE hInst, HINSTANCE hPrev, LPSTR CmdLine, int nCmdShow)
{
    MSG msg;

    if (hPrev)
        return (FALSE);

    if (!InitApplication (hInst))
        return (FALSE);
    
    if (!InitInstance (hInst, nCmdShow))
        return (FALSE);
    
    while (GetMessage (&msg, NULL, NULL, NULL)) {
        TranslateMessage (&msg);
        DispatchMessage (&msg);
    }
    return (msg.wParam);
}

void    ViewerReset ()
{
    RECT    port;

    SetViewerName (viewer21, "2D Objects");
    SetRect (&port, 10, 10, 110, 110);
    SetViewport (viewer21, port);
    SetWindow2D (viewer21, -10, -10, 10, 10);

    SetViewerName (viewer22, "U.S. Flag");
    SetRect (&port, 10, 10, 410, 227);
    SetViewport (viewer22, port);
    SetWindow2D (viewer22, 0, 0, 1, (real) (13.0 / 24.0));

    SetViewerName (viewer31, "View Motion");
    SetRect (&port, 120, 10, 220, 110);
    SetViewport (viewer31, port);
    SetView3D (viewer31, 100, 100, 100, 0, 0, 0, 0);
    SetPerspective (viewer31, 45, 1, 1, 1000);

    SetViewerName (viewer32, "Object Rotation");
    SetRect (&port, 230, 10, 330, 110);
    SetViewport (viewer32, port);
    SetView3D (viewer32, 100, 100, 100, 0, 0, 0, 0);
    SetPerspective (viewer32, 45, 1, 1, 1000);

    SetViewerName (viewer33, "View Zoom");
    SetRect (&port, 230, 130, 330, 230);
    SetViewport (viewer33, port);
    SetPolarView (viewer33, 1, 1, 0, 20, 75, 45, 0);
    SetPerspective (viewer33, 90, 1, 1, 1000);

    SetViewerName (viewer34, "Ortho Project");
    SetRect (&port, 120, 130, 220, 230);
    SetViewport (viewer34, port);
    SetPolarView (viewer34, 0, 0, 0, 10, 45, 45, 0);
    SetProjection3D (viewer34, -10, -10, 10, 10, 1, 100, VL_ORTHOGONAL);

    SetViewerName (viewer35, "Depth Clipping");
    SetRect (&port, 10, 130, 110, 230);
    SetViewport (viewer35, port);
    SetPolarView (viewer35, 0, 0, 0, 20, 75, 45, 0);
    SetPerspective (viewer35, 90, 1, 1, 80);
}

/****************************************************************************

    FUNCTION: InitApplication (HANDLE)

    PURPOSE: Initializes window data and registers window class

    COMMENTS:

        This function is called at initialization time only if no other 
        instances of the application are running.  This function performs 
        initialization tasks that can be done once for any number of running 
        instances.  

        In this case, we initialize a window class by filling out a data 
        structure of type WNDCLASS and calling the Windows RegisterClass () 
        function.  Since all instances of this application use the same window
        class, we only need to do this when the first instance is initialized.

****************************************************************************/

BOOL InitApplication (HINSTANCE hInstance)
{
    WNDCLASS  wc;
    RECT    port;
	VECTOR3	parameter;

	if (!InitializeVisualib ())
		return (FALSE);
	SelectLight (light0 = CreateLight (NULL, VL_POINTLIGHT));
	SetLightCoordinateType (VL_CURRENT, VL_WORLDLIGHT);
	VSET3 (parameter, 50, 250, 0);
	ShadingParameter (VL_CURRENT, VL_LIGHTLOCATION, FALSE, parameter);
	ShadingColor (VL_CURRENT, VL_LIGHTCOLOR, RGB (255, 255, 255));
	SwitchLight (VL_CURRENT, TRUE);

	SelectLight (light1 = CreateLight (NULL, VL_POINTLIGHT));
	SetLightCoordinateType (VL_CURRENT, VL_WORLDLIGHT);
	VSET3 (parameter, 350, -100, 200);
	ShadingParameter (VL_CURRENT, VL_LIGHTLOCATION, FALSE, parameter);
	ShadingColor (VL_CURRENT, VL_LIGHTCOLOR, RGB (255, 255, 255));
	SwitchLight (VL_CURRENT, TRUE);

	SelectLight (light2 = CreateLight (NULL, VL_POINTLIGHT));
	VSET3 (parameter, -50, 0, 0);
	ShadingParameter (VL_CURRENT, VL_LIGHTLOCATION, FALSE, parameter);
	ShadingColor (VL_CURRENT, VL_LIGHTCOLOR, RGB (51, 255, 51));

	SelectLight (light3 = CreateLight (NULL, VL_POINTLIGHT));
	VSET3 (parameter, 250, -20, 0);
	ShadingParameter (VL_CURRENT, VL_LIGHTLOCATION, FALSE, parameter);
	ShadingColor (VL_CURRENT, VL_LIGHTCOLOR, RGB (51, 51, 255));

	SelectLight (light4 = CreateLight (NULL, VL_SPOTLIGHT));
	SetLightCoordinateType (VL_CURRENT, VL_WORLDLIGHT);
	VSET3 (parameter, 0, 100, 100);
	ShadingParameter (VL_CURRENT, VL_LIGHTLOCATION, FALSE, parameter);
	VSET3 (parameter, 0, -0.707, -0.707);
	ShadingParameter (VL_CURRENT, VL_LIGHTDIRECTION, FALSE, parameter);
	ShadingFactor (VL_CURRENT, VL_SPOTLIGHTANGLE, 20);
	ShadingFactor (VL_CURRENT, VL_SPOTLIGHTSPREAD, 50);
	ShadingColor (VL_CURRENT, VL_LIGHTCOLOR, RGB (255, 0, 0));

    SelectLight (light5 = CreateLight (NULL, VL_SPOTLIGHT));
	SetLightCoordinateType (VL_CURRENT, VL_WORLDLIGHT);
	VSET3 (parameter, 100, 0, 100);
	ShadingParameter (VL_CURRENT, VL_LIGHTLOCATION, FALSE, parameter);
	VSET3 (parameter, -0.707, 0, -0.707);
	ShadingParameter (VL_CURRENT, VL_LIGHTDIRECTION, FALSE, parameter);
	ShadingFactor (VL_CURRENT, VL_SPOTLIGHTANGLE, 20);
	ShadingFactor (VL_CURRENT, VL_SPOTLIGHTSPREAD, 50);
	ShadingColor (VL_CURRENT, VL_LIGHTCOLOR, RGB (0, 255, 0));

	SelectLight (light6 = CreateLight (NULL, VL_SPOTLIGHT));
	SetLightCoordinateType (VL_CURRENT, VL_WORLDLIGHT);
	VSET3 (parameter, 100, 100, 100);
	ShadingParameter (VL_CURRENT, VL_LIGHTLOCATION, FALSE, parameter);
	VSET3 (parameter, -0.577, -0.577, -0.577);
	ShadingParameter (VL_CURRENT, VL_LIGHTDIRECTION, FALSE, parameter);
	ShadingFactor (VL_CURRENT, VL_SPOTLIGHTANGLE, 20);
	ShadingFactor (VL_CURRENT, VL_SPOTLIGHTSPREAD, 50);
	ShadingColor (VL_CURRENT, VL_LIGHTCOLOR, RGB (0, 0, 255));

	SelectLight (light7 = CreateLight (NULL, VL_POINTLIGHT));
	SetLightCoordinateType (VL_CURRENT, VL_WORLDLIGHT);
	VSET3 (parameter, 50, 250, 0);
	ShadingParameter (VL_CURRENT, VL_LIGHTLOCATION, FALSE, parameter);
	ShadingColor (VL_CURRENT, VL_LIGHTCOLOR, RGB (255, 255, 255));

	SelectLight (light8 = CreateLight (NULL, VL_POINTLIGHT));
	SetLightCoordinateType (VL_CURRENT, VL_WORLDLIGHT);
	VSET3 (parameter, 350, -100, 200);
	ShadingParameter (VL_CURRENT, VL_LIGHTLOCATION, FALSE, parameter);
	ShadingColor (VL_CURRENT, VL_LIGHTCOLOR, RGB (255, 255, 255));

	ShadingOption (VL_CURRENT, VL_SHADINGMETHOD, VL_PHONGSHADE);
    ShadingOption (VL_CURRENT, VL_BACKFACEREMOVAL, TRUE);
    ShadingOption (VL_CURRENT, VL_DEPTHBUFFER, TRUE);
	ShadingOption (VL_CURRENT, VL_LOCALVIEWER, TRUE);

	SelectMaterial (mater0 = CreateMaterial (NULL));
	ShadingColor (VL_CURRENT, VL_MATERIALSPECULAR, RGB (255, 255, 255));
	ShadingFactor (VL_CURRENT, VL_SPECULARREFLECT, 1);
	ShadingColor (VL_CURRENT, VL_MATERIALAMBIENT, RGB (255, 255, 255));
	ShadingFactor (VL_CURRENT, VL_AMBIENTREFLECT, 0.2f);
	ShadingColor (VL_CURRENT, VL_MATERIALDIFFUSE, RGB (255, 255, 255));
	ShadingFactor (VL_CURRENT, VL_SHININESS, 30);

	SelectMaterial (mater1 = CreateMaterial (NULL));
	ShadingColor (VL_CURRENT, VL_MATERIALSPECULAR, RGB (255, 255, 255));
	ShadingColor (VL_CURRENT, VL_MATERIALAMBIENT, RGB (255, 0, 0));
	ShadingFactor (VL_CURRENT, VL_AMBIENTREFLECT, 0.3f);
	ShadingColor (VL_CURRENT, VL_MATERIALDIFFUSE, RGB (255, 0, 0));
	ShadingFactor (VL_CURRENT, VL_SHININESS, 40);

	SelectMaterial (mater2 = CreateMaterial (NULL));
	ShadingColor (VL_CURRENT, VL_MATERIALSPECULAR, RGB (255, 255, 255));
	ShadingColor (VL_CURRENT, VL_MATERIALAMBIENT, RGB (255, 255, 255));
	ShadingFactor (VL_CURRENT, VL_AMBIENTREFLECT, 0.4f);
	ShadingColor (VL_CURRENT, VL_MATERIALDIFFUSE, RGB (0, 255, 0));
	ShadingFactor (VL_CURRENT, VL_SHININESS, 20);

	SelectMaterial (mater3 = CreateMaterial (NULL));
	ShadingColor (VL_CURRENT, VL_MATERIALSPECULAR, RGB (255, 255, 255));
	ShadingFactor (VL_CURRENT, VL_SPECULARREFLECT, 0.5f);
	ShadingColor (VL_CURRENT, VL_MATERIALAMBIENT, RGB (255, 255, 255));
	ShadingFactor (VL_CURRENT, VL_AMBIENTREFLECT, 0.1f);
	ShadingColor (VL_CURRENT, VL_MATERIALDIFFUSE, RGB (0, 0, 255));
	ShadingFactor (VL_CURRENT, VL_SHININESS, 10);
	mater4 = CreateMaterial (NULL);
	mater5 = CreateMaterial (NULL);
	mater6 = CreateMaterial (NULL);
	mater7 = CreateMaterial (NULL);
    SelectMaterial (mater0);

    hpal = SetRGBPalette ();
    SetRect (&port, 0, 0, 400, 300);
    viewer20 = CreateViewer ("2D Primitive Test", port, VL_TWOD, VL_HORZFIT);
    SetWindow2D (viewer20, -10, -10, 10, 10); 
    viewer30 = CreateViewer ("3D Primitive Test", port, VL_THREED, VL_HORZFIT);
    SetView3D (viewer30, 100, 100, 100, 0, 0, 0, 0);
    SetPerspective (viewer30, 45, 1, 30, 1000);
    SetDepthBuffer (viewer30);

    viewer21 = CreateViewer ("2D Objects", port, VL_TWOD, VL_HORZFIT);
    viewer22 = CreateViewer ("U.S. Flag", port, VL_TWOD, VL_ALLFIT);
    viewer31 = CreateViewer ("View Motion", port, VL_THREED, VL_ALLFIT);
    viewer32 = CreateViewer ("Object Rotation", port, VL_THREED, VL_ALLFIT);
    viewer33 = CreateViewer ("View Zoom", port, VL_THREED, VL_ALLFIT);
    viewer34 = CreateViewer ("Ortho Project", port, VL_THREED, VL_HORZFIT);
    viewer35 = CreateViewer ("Depth Clipping", port, VL_THREED, VL_ALLFIT);
	ViewerReset ();
	demo_function = IDM_DEMO_START;
//	demo_function = 0;
    wc.style = NULL;
    wc.lpfnWndProc = MainWndProc;
    wc.cbClsExtra = 0;
    wc.cbWndExtra = 0;
    wc.hInstance = hInstance;
    wc.hIcon = LoadIcon (hInstance, MAKEINTRESOURCE (VL_LOGO));
    wc.hCursor = LoadCursor (NULL, IDC_ARROW);
	backcolor = RGB (0, 64, 64);
    wc.hbrBackground = CreateSolidBrush (backcolor);
    wc.lpszMenuName = "VlibDemo";
    wc.lpszClassName = "VlibDemoClass";

    return (RegisterClass (&wc));

}

/****************************************************************************

    FUNCTION:  InitInstance (HANDLE, int)

    PURPOSE:  Saves instance handle and creates main window

    COMMENTS:

        This function is called at initialization time for every instance of 
        this application.  This function performs initialization tasks that 
        cannot be shared by multiple instances.  

        In this case, we save the instance handle in a static variable and 
        create and display the main program window.  
    
****************************************************************************/

BOOL InitInstance (HINSTANCE hInstance, int nCmdShow)
{
    HWND    hWnd;
    int     sw, sh, ww, wh;

    sw = GetSystemMetrics (0);
    sh = GetSystemMetrics (1);
    hInst = hInstance;

    ww = (int) (sw * 0.8);
    wh = (int) (sh * 0.8);
    sw = (int) (sw * 0.1);
    sh = (int) (sh * 0.1);
    hWnd = CreateWindow ("VlibDemoClass",
        "Visualib 2.0 Demonstration",
        WS_OVERLAPPEDWINDOW, sw, sh, ww, wh,
        NULL, NULL, hInstance, NULL);

    if (!hWnd)
        return (FALSE);

    ShowWindow (hWnd, nCmdShow);
    UpdateWindow (hWnd);
	PostMessage (hWnd, WM_COMMAND, IDM_DEMO_WITHFRAME, 0L);
	return (TRUE);
}

POINT3D surf[16] = {
    {-3, 0, 1}, {2, 1, 0}, {5, 0, 0}, {8, 0, 2},
    {-2, 2, 3}, {1, 4, 3}, {6, 4, 1}, {7, 2, 1},
    {-2, 5, 5}, {1, 7, 3}, {5, 5, 2}, {7, 6, 3},
    {-2, 8, 8}, {2, 9, 0}, {4, 7, 4}, {8, 9, 9}
};

real    sknot[20] = {0, 0, 0, 1, 1, 1, 2, 2, 3, 4, 4, 4};
real    tknot[20] = {0, 0, 0, 1, 1, 1, 2, 2, 3, 4, 4, 4};

void    ObjectMotion2D (HDC hdc)
{
    short   i;

    SelectViewer (viewer21);
	PenColor (hdc, VL_BLUE);
    DisplayViewerFrame (hdc, VL_CURRENT);
	TextColor (hdc, VL_BLUE, VL_BLACK, TRANSPARENT);
    DisplayViewerName (hdc, VL_CURRENT, 0);

    BeginDoubleBuffer (&hdc, VL_CURRENT);

	PenColor (hdc, VL_RED);
    for (i = 0; i < 5 * animate_length; i ++) {
        ClearViewer (hdc, VL_CURRENT, VL_GRAY);
        BrushColor (hdc, VL_GREEN);
		Flower2D (hdc, 0, 0, 0, 6, 6, 10, 4.5f / 6);
        BrushColor (hdc, VL_RED);
        Star2D (hdc, 0, 0, 0, 4, 4, 5);
        Rotate2D (6);
        UpdateDoubleBuffer (hdc, VL_CURRENT);
    }
    for (i = 0; i < 5 * animate_length; i ++) {
        ClearViewer (hdc, VL_CURRENT, VL_GRAY);
        BrushColor (hdc, VL_GREEN);
        Flower2D (hdc, 0, 0, 0, 6, 6, 10, 4.5f / 6);
        BrushColor (hdc, VL_RED);
        Star2D (hdc, 0, 0, 0, 4, 4, 5);
        MoveViewer2D (VL_CURRENT, (real)0.25, 0, TRUE);
        UpdateDoubleBuffer (hdc, VL_CURRENT);
    }

    for (i = 0; i < 5 * animate_length; i ++) {
        ClearViewer (hdc, VL_CURRENT, VL_GRAY);
        BrushColor (hdc, VL_GREEN);
        Flower2D (hdc, 0, 0, 0, 6, 6, 10, 4.5f / 6);
        BrushColor (hdc, VL_RED);
        Star2D (hdc, 0, 0, 0, 4, 4, 5);
        Scale2D ((real)1.06, (real)1.06);
        UpdateDoubleBuffer (hdc, VL_CURRENT);
    }
    EndDoubleBuffer (&hdc, VL_CURRENT);
}

void    ViewerMotion3D (HDC hdc)
{
    short   i, depthbuffer, shadingmethod;

	shadingmethod = ShadingOption (VL_CURRENT, VL_SHADINGMETHOD, VL_FLATSHADE);
	depthbuffer = ShadingOption (VL_CURRENT, VL_DEPTHBUFFER, FALSE);
    ShadingOption (VL_CURRENT, VL_BACKFACEREMOVAL, TRUE);
    ShadingOption (VL_CURRENT, VL_TWOSIDESHADE, FALSE);
    SelectViewer (viewer31);
	PenColor (hdc, VL_BLUE);
    DisplayViewerFrame (hdc, VL_CURRENT);
	TextColor (hdc, VL_BLUE, VL_BLACK, TRANSPARENT);
    DisplayViewerName (hdc, VL_CURRENT, 0);

    BeginDoubleBuffer (&hdc, VL_CURRENT);
    SelectMaterial (mater1);
	PenColor (hdc, VL_NONE);
    for (i = 0; i < 3 * animate_length; i ++) {
		MoveViewer3D (VL_CURRENT, 0, 0, -10, TRUE);
        ClearViewer (hdc, VL_CURRENT, VL_GRAY);
		if (Cube (hdc, 50, 50, 25))
			UpdateDoubleBuffer (hdc, VL_CURRENT);
		else
			goto exit;
    }
    SelectMaterial (mater2);
    for (i = 0; i < 3 * animate_length; i ++) {
        MoveViewer3D (VL_CURRENT, 0, 5, 0, TRUE);
        ClearViewer (hdc, VL_CURRENT, VL_GRAY);
		if (Cube (hdc, 50, 50, 25))
			UpdateDoubleBuffer (hdc, VL_CURRENT);
		else
			goto exit;
    }
    SelectMaterial (mater3);
    for (i = 0; i < 3 * animate_length; i ++) {
        MoveViewer3D (VL_CURRENT, 5, 0, 0, TRUE);
        ClearViewer (hdc, VL_CURRENT, VL_GRAY);
		if (Cube (hdc, 50, 50, 25))
			UpdateDoubleBuffer (hdc, VL_CURRENT);
		else
			goto exit;
    }
    SelectMaterial (mater0);
    for (i = 0; i < 5 * animate_length; i ++) {
        RotateViewer3D (VL_CURRENT, 6, 'z', FALSE);
        ClearViewer (hdc, VL_CURRENT, VL_GRAY);
        if (!Cube (hdc, 50, 50, 25))
			goto exit;
        UpdateDoubleBuffer (hdc, VL_CURRENT);
    }
    SelectMaterial (mater1);
    for (i = 0; i < 5 * animate_length; i ++) {
        ClearViewer (hdc, VL_CURRENT, VL_GRAY);
        RotateViewer3D (VL_CURRENT, 6, 'y', FALSE);
        if (Cube (hdc, 50, 50, 25))
			UpdateDoubleBuffer (hdc, VL_CURRENT);
		else
			goto exit;
    }
    SelectMaterial (mater2);
    for (i = 0; i < 5 * animate_length; i ++) {
        ClearViewer (hdc, VL_CURRENT, VL_GRAY);
        RotateViewer3D (VL_CURRENT, 6, 'x', FALSE);
		if (Cube (hdc, 50, 50, 25))
			UpdateDoubleBuffer (hdc, VL_CURRENT);
		else
			goto exit;
	}
exit:
    EndDoubleBuffer (&hdc, VL_CURRENT);
	ShadingOption (VL_CURRENT, VL_DEPTHBUFFER, depthbuffer);
	ShadingOption (VL_CURRENT, VL_SHADINGMETHOD, shadingmethod);
}

void    ObjectMotion3D (HDC hdc)
{
    short   i, depthbuffer, shadingmethod;

	depthbuffer = ShadingOption (VL_CURRENT, VL_DEPTHBUFFER, FALSE);
	shadingmethod = ShadingOption (VL_CURRENT, VL_SHADINGMETHOD, VL_FLATSHADE);
    SelectViewer (viewer32);
	PenColor (hdc, VL_BLUE);
    DisplayViewerFrame (hdc, VL_CURRENT);
	TextColor (hdc, VL_BLUE, VL_BLACK, TRANSPARENT);
    DisplayViewerName (hdc, VL_CURRENT, 0);

    BeginDoubleBuffer (&hdc, VL_CURRENT);

    SelectMaterial (mater1);
	PenColor (hdc, VL_NONE);
    for (i = 0; i <= 5 * animate_length; i ++) {
        ClearViewer (hdc, VL_CURRENT, VL_GRAY);
		if (Cylinder (hdc, 30, 40, 50)) {
			Rotate3D (3, 'z');
			Rotate3D (6, 'x');
			Rotate3D (3, 'y');
			UpdateDoubleBuffer (hdc, VL_CURRENT);
		}
		else
			break;
	}
    EndDoubleBuffer (&hdc, VL_CURRENT);
	ShadingOption (VL_CURRENT, VL_DEPTHBUFFER, depthbuffer);
	ShadingOption (VL_CURRENT, VL_SHADINGMETHOD, shadingmethod);
}

void    ViewerZoom3D (HDC hdc)
{
    short   i, depthbuffer, shadingmethod;
    POINT3D p = {0, 0, 0};

	depthbuffer = ShadingOption (VL_CURRENT, VL_DEPTHBUFFER, FALSE);
	shadingmethod = ShadingOption (VL_CURRENT, VL_SHADINGMETHOD, VL_FLATSHADE);	ShadingOption (VL_CURRENT, VL_TWOSIDESHADE, FALSE);
    SelectViewer (viewer33);
	PenColor (hdc, VL_RED);
    DisplayViewerFrame (hdc, VL_CURRENT);
	TextColor (hdc, VL_BLUE, VL_BLACK, TRANSPARENT);
    DisplayViewerName (hdc, VL_CURRENT, 0);

    BeginDoubleBuffer (&hdc, VL_CURRENT);

    SelectMaterial (mater2);
	PenColor (hdc, VL_NONE);
    for (i = 0; i < 5 * animate_length; i ++) {
        ClearViewer (hdc, VL_CURRENT, VL_GRAY);
        if (Cone (hdc, 3, 5, 10)) {
			ZoomViewer3D (VL_CURRENT, 1.05f);
			UpdateDoubleBuffer (hdc, VL_CURRENT);
		}
		else
			break;
    }
    EndDoubleBuffer (&hdc, VL_CURRENT);
	ShadingOption (VL_CURRENT, VL_DEPTHBUFFER, depthbuffer);
	ShadingOption (VL_CURRENT, VL_SHADINGMETHOD, shadingmethod);
}

void    OrthoProject3D (HDC hdc)
{
    POINT3D p = {3, -1, -4};

	PenColor (hdc, VL_RED);
    DisplayViewerFrame (hdc, viewer34);
	TextColor (hdc, VL_BLUE, VL_BLACK, TRANSPARENT);
    DisplayViewerName (hdc, viewer34, 0);
    SelectViewer (viewer34);
    SelectMaterial (mater3);
    PenColor (hdc, VL_NONE);
    Ellipsoid (hdc, 3, 4, 5);
}

void    RotateStar (HDC hdc)
{
    short   i;
	BOOL	depthbuffer, shadingmethod;

	depthbuffer = ShadingOption (VL_CURRENT, VL_DEPTHBUFFER, FALSE);
	shadingmethod = ShadingOption (VL_CURRENT, VL_SHADINGMETHOD, VL_FLATSHADE);
	PenColor (hdc, VL_RED);
    DisplayViewerFrame (hdc, viewer35);
	TextColor (hdc, VL_BLUE, VL_BLACK, TRANSPARENT);
    DisplayViewerName (hdc, viewer35, 0);

    SelectViewer (viewer35);
    BeginDoubleBuffer (&hdc, viewer35);
	PenColor (hdc, VL_NONE);
    for (i = 0; i < 5 * animate_length; i ++) {
        ClearViewer (hdc, viewer35, VL_GRAY);
		if (SolidStar (hdc, 5, 20, 20, 5)) {
			MoveViewer3D (viewer35, 0, 0, (real)-0.5, TRUE);
			Rotate3D (6 * i, 'z');
			UpdateDoubleBuffer (hdc, viewer35);
		}
		else
			break;
    }
    EndDoubleBuffer (&hdc, viewer35);
	ShadingOption (VL_CURRENT, VL_DEPTHBUFFER, depthbuffer);
	ShadingOption (VL_CURRENT, VL_SHADINGMETHOD, shadingmethod);
}

void CompositeDemo2D (HDC hdc)
{
    RECT    orgport, newport;

    SelectViewer (viewer22);
	PenColor (hdc, VL_BLACK);
    DisplayViewerFrame (hdc, VL_CURRENT);
    USFlag (hdc);
	TextColor (hdc, VL_BLUE, VL_BLACK, TRANSPARENT);
    DisplayViewerName (hdc, VL_CURRENT, 0);

    GetViewport (VL_CURRENT, &orgport);
    SetRect (&newport, 350, 230, 410, 260);
    SetViewport (VL_CURRENT, newport);
    USFlag (hdc);
	PenColor (hdc, VL_BLACK);
    DisplayViewerFrame (hdc, VL_CURRENT);
    SetViewport (VL_CURRENT, orgport);
}

void    RotateSpring (HDC hdc)
{
    short   i, depthbuffer, shadingmethod;
	depthbuffer = ShadingOption (VL_CURRENT, VL_DEPTHBUFFER, FALSE);
	shadingmethod = ShadingOption (VL_CURRENT, VL_SHADINGMETHOD, VL_FLATSHADE);
    SelectViewer (viewer31);
	PenColor (hdc, VL_BLUE);
    DisplayViewerFrame (hdc, VL_CURRENT);
    SetViewerName (VL_CURRENT, "3D Curve");
	TextColor (hdc, VL_BLUE, VL_BLACK, TRANSPARENT);
    DisplayViewerName (hdc, VL_CURRENT, 0);
    BeginDoubleBuffer (&hdc, VL_CURRENT);
    Scale3D (20, 20, 20);
    for (i = 0; i < 5 * animate_length; i ++) {
        ClearViewer (hdc, VL_CURRENT, VL_GRAY);
		PenColor (hdc, VL_BLUE);
        Spring (hdc, 3, 2, 0.5f);
        Translate3D (0.05f, 0, 0);
        Rotate3D (-6, 'y');
        PushTransformation3D (NULL);
		SelectMaterial (mater0);
		PenColor (hdc, VL_NONE);
        Rotate3D (6 * i, 'z');
        Translate3D (0, 2, 0);
		Rotate3D (3, 'y');
		if (!Tetrahedron (hdc, 1))
			break;
        PushTransformation3D (NULL);
		SelectMaterial (mater1);
        Rotate3D (6, 'x');
        Translate3D (0, 0, 2);
        Rotate3D (3 * i, 'z');
		if (!Octahedron (hdc, 1))
			break;
        PopTransformation3D (NULL);
        PopTransformation3D (NULL);
        UpdateDoubleBuffer (hdc, VL_CURRENT);
    }
    EndDoubleBuffer (&hdc, VL_CURRENT);
	ShadingOption (VL_CURRENT, VL_DEPTHBUFFER, depthbuffer);
	ShadingOption (VL_CURRENT, VL_SHADINGMETHOD, shadingmethod);
}

void    RotateFrame (HDC hdc)
{
    short   i;
	COORD	point[] = {0, 0, 0, 1, 1, -1, 1, 1, 1, -1, -1, 1, -1, 1, -1,
		1, -1, -1, 1, 1, 1, 1, -1, 1, -1, -1, 1, -1, 1, 1, -1, 1, -1,
		-1, -1, -1, 1, -1, -1, 1, 1, -1, -1, 1, 1,
		0, 0, 0, 1, -1, 1, -1, -1, -1, 0, 0, 0};
    
	PenColor (hdc, VL_BLUE);
    SelectViewer (viewer32);
    DisplayViewerFrame (hdc, VL_CURRENT);
    BeginDoubleBuffer (&hdc, VL_CURRENT);
    Scale3D (30, 30, 30);
	PenColor (hdc, VL_BLUE);
    for ( i = 0; i < 5 * animate_length; i++) {
        ClearViewer (hdc, VL_CURRENT, VL_GRAY);
		Polyline3D (hdc, VL_3D, point, 19);
        Rotate3D (6, 'z');
        UpdateDoubleBuffer (hdc, VL_CURRENT);
    }
    EndDoubleBuffer (&hdc, VL_CURRENT);
}

void    RotateSurface (HDC hdc)
{
    short   i, depthbuffer, shadingmethod;

	shadingmethod = ShadingOption (VL_CURRENT, VL_SHADINGMETHOD, VL_FLATSHADE);
	depthbuffer = ShadingOption (VL_CURRENT, VL_DEPTHBUFFER, FALSE);
	ShadingOption (VL_CURRENT, VL_TWOSIDESHADE, TRUE);
    SelectViewer (viewer35);
	PenColor (hdc, VL_BLUE);
    DisplayViewerFrame (hdc, VL_CURRENT);
    SetViewerName (VL_CURRENT, "NURBS Surface");
	TextColor (hdc, VL_BLUE, VL_BLACK, TRANSPARENT);
    DisplayViewerName (hdc, VL_CURRENT, 0);
    BeginDoubleBuffer (&hdc, VL_CURRENT);
    PenColor (hdc, VL_MAGENTA);
	ShadingOption (VL_CURRENT, VL_TWOSIDESHADE, TRUE);
    for (i = 0; i < 5 * animate_length; i++) {
        ClearViewer (hdc, VL_CURRENT, VL_GRAY);
		if (!NURBSSurface (hdc, VL_3D, (LPCOORD) surf, 4, 4, sknot, tknot, 8, 8))
			break;
        Rotate3D (6, 'z');
        Rotate3D (12, 'x');
        Rotate3D (3, 'y');
        UpdateDoubleBuffer (hdc, VL_CURRENT);
    }
    EndDoubleBuffer (&hdc, VL_CURRENT);
	ShadingOption (VL_CURRENT, VL_DEPTHBUFFER, depthbuffer);
	ShadingOption (VL_CURRENT, VL_SHADINGMETHOD, shadingmethod);
	ShadingOption (VL_CURRENT, VL_TWOSIDESHADE, FALSE);
}

void    RotateDodecahedron (HDC hdc)
{
    short   i, depthbuffer, shadingmethod;

	shadingmethod = ShadingOption (VL_CURRENT, VL_SHADINGMETHOD, VL_FLATSHADE);
	depthbuffer = ShadingOption (VL_CURRENT, VL_DEPTHBUFFER, FALSE);
    ShadingOption (VL_CURRENT, VL_BACKFACEREMOVAL, TRUE);
    ShadingOption (VL_CURRENT, VL_TWOSIDESHADE, FALSE);
    SelectViewer (viewer33);
	PenColor (hdc, VL_RED);
    DisplayViewerFrame (hdc, VL_CURRENT);
    SetViewerName (VL_CURRENT, "Dodecahedron");
	TextColor (hdc, VL_BLUE, VL_BLACK, TRANSPARENT);
    DisplayViewerName (hdc, VL_CURRENT, 0);
    BeginDoubleBuffer (&hdc, VL_CURRENT);
    Scale3D (6, 6, 6);
    BrushColor (hdc, VL_BROWN);
	PenColor (hdc, VL_NONE);
    for (i = 0; i < 5 * animate_length; i ++) {
        ClearViewer (hdc, VL_CURRENT, VL_GRAY);
		if (!Dodecahedron (hdc, 0.5f))
			break;
        Translate3D (0, (real)0.1, 0);
        Rotate3D (6, 'z');
        UpdateDoubleBuffer (hdc, VL_CURRENT);
    }
    EndDoubleBuffer (&hdc, VL_CURRENT);
	ShadingOption (VL_CURRENT, VL_DEPTHBUFFER, depthbuffer);
	ShadingOption (VL_CURRENT, VL_SHADINGMETHOD, shadingmethod);
}

void    RotateIcosahedron (HDC hdc)
{
    short   i, depthbuffer, shadingmethod;

	shadingmethod = ShadingOption (VL_CURRENT, VL_SHADINGMETHOD, VL_FLATSHADE);
	depthbuffer = ShadingOption (VL_CURRENT, VL_DEPTHBUFFER, FALSE);
    ShadingOption (VL_CURRENT, VL_BACKFACEREMOVAL, TRUE);
    ShadingOption (VL_CURRENT, VL_TWOSIDESHADE, FALSE);
    SelectViewer (viewer34);
	PenColor (hdc, VL_RED);
    DisplayViewerFrame (hdc, VL_CURRENT);
    SetViewerName (VL_CURRENT, "Icosahedron");
	TextColor (hdc, VL_BLUE, VL_BLACK, TRANSPARENT);
    DisplayViewerName (hdc, VL_CURRENT, 0);
    BeginDoubleBuffer (&hdc, VL_CURRENT);
    Scale3D (3, 3, 3);
    BrushColor (hdc, VL_YELLOW);
	PenColor (hdc, VL_NONE);
    for (i = 0; i < 5 * animate_length; i ++) {
        ClearViewer (hdc, VL_CURRENT, VL_GRAY);
		if (Icosahedron (hdc, 1)) {
			Rotate3D (3, 'y');
			Translate3D ((real)0.1, 0, 0);
			Rotate3D (6, 'z');
			UpdateDoubleBuffer (hdc, VL_CURRENT);
		}
		else
			break;
    }
    EndDoubleBuffer (&hdc, VL_CURRENT);
	ShadingOption (VL_CURRENT, VL_DEPTHBUFFER, depthbuffer);
	ShadingOption (VL_CURRENT, VL_SHADINGMETHOD, shadingmethod);
}

void	Surfaces (HDC hdc, WORD cmd)
{
    SelectViewer (viewer30);
    ClearDepthBuffer (0xffff);
	if (ShadingOption (VL_CURRENT, VL_SHADINGMETHOD, VL_INQUIRE) == VL_WIREFRAME) {
		PenColor (hdc, VL_RED);
	}
	else {
		ShadingOption (VL_CURRENT, VL_TWOSIDESHADE, TRUE);
		PenColor (hdc, VL_NONE);
	}

	PushTransformation3D (NULL);
	switch (cmd) {
		case IDM_SURFACE_BEZIER:
		{
			POINT3D surf[16] = {
				{0, 6, 3}, {2, 6, 0}, {4, 6, 2}, {6, 6, 0},
				{0, 4, 0}, {2, 4, 5}, {4, 4, 0}, {6, 4, 6},
				{0, 2, 5}, {2, 2, 0}, {4, 2, 6}, {6, 2, 0},
				{0, 0, 0}, {2, 0, 3}, {4, 0, 0}, {6, 0, 3}};

			Scale3D (5, 5, 5);
			BezierSurface (hdc, VL_3D, (LPCOORD) surf, 16, 16);
			PenColor (hdc, VL_GREEN);
			Net3D (hdc, VL_3D, (LPCOORD) surf, 4, 4);
			PolyMark3D (hdc, VL_3D, (LPCOORD) surf, 16, 2, 2, VL_CIRCLEMARK);
			break;
		}
		case IDM_SURFACE_HERMIT:
		{
			POINT3D surf[16] = {
				{0, 0, 0}, {0, 6, 0}, {0, 6, 6}, {0, 6, -2},
				{6, 0, 0}, {6, 6, 0}, {0, 2, 2}, {0, 6, -2},
				{2, 0, 2}, {2, 0, 2}, {0, 0, 0}, {0, 0, 0},
				{2, 0, 2}, {2, 0, 2}, {0, 0, 0}, {0, 0, 0}};

			Scale3D (5, 5, 5);
			HermitSurface (hdc, VL_3D, (LPCOORD) surf, 16, 16);
			PenColor (hdc, VL_GREEN);
//			Net3D (hdc, VL_3D, (LPCOORD) surf, 4, 4);
//			PolyMark3D (hdc, VL_3D, (LPCOORD) surf, 16, 2, 2, VL_DIAMONDMARK);
			break;
		}
		case IDM_SURFACE_BSPLINE:
		{
			break;
		}
		case IDM_SURFACE_NURBS:
		{
			POINT3D surf[36] = {
				{0,0,0},{1,0,0},{2,0,0},{3,0,0},{4,0,0},{5,0,0},
				{0,1,0},{1,1,0},{2,1,0},{3,1,0},{4,1,0},{5,1,0},
				{0,2,0},{1,2,0},{2,2,9},{3,2,9},{4,2,0},{5,2,0},
				{0,3,0},{1,3,0},{2,3,9},{3,3,9},{4,3,0},{5,3,0},
				{0,4,0},{1,4,0},{2,4,0},{3,4,0},{4,4,0},{5,4,0},
				{0,5,0},{1,5,0},{2,5,0},{3,5,0},{4,5,0},{5,5,0}};
			real    sknot[20] = {0,0,0,1,2,3,3,3};
			real    tknot[20] = {0,0,0,1,2,3,3,3};

			SwitchLight (light0, FALSE);
			SwitchLight (light1, FALSE);
			SwitchLight (light4, TRUE);
			Scale3D (10, 10, 5);
			Translate3D (-3, -2, 0);
			NURBSSurface (hdc, VL_3D, (LPCOORD) surf, 6, 6, sknot, tknot, 4, 4);
			PenColor (hdc, VL_GREEN);
			Net3D (hdc, VL_3D, (LPCOORD) surf, 6, 6);
			PolyMark3D (hdc, VL_3D, (LPCOORD) surf, 36, 2, 2, VL_BOXMARK);
			break;
		}
		case IDM_SURFACE_COONSPATCH:
		{
			POINT3D	point[] = {{0,0,4},{1,-2,3},{2,-2,2},{3,0,1},
							   {4,0,0},{4,1,0},{4,2,0},{4,3,0},
							   {4,4,0},{3,4,0},{2,4,0},{1,4,0},
							   {0,4,0},{0,3,1},{-2,2,2},{-2,1,3}};
			Scale3D (5, 5, 5);
			CoonsPatch (hdc, VL_3D, (LPCOORD) point, 5, 5);
/*
			POINT3D	cpu0[]={{0,0,4},{1,0,3},{2,0,2},{3,0,1},{4,0,0}};
			POINT3D	cpu1[]={{0,4,0},{1,4,0},{2,4,0},{3,4,0},{4,4,0}};
			POINT3D	cpv0[]={{0,0,4},{0,1,3},{0,2,2},{0,3,1},{0,4,0}};
			POINT3D	cpv1[]={{4,0,0},{4,1,0},{4,2,0},{4,3,0},{4,4,0}};
			Scale3D (5, 5, 2);
			CoonsPatch (hdc, cpu0, cpu1, 5, cpv0, cpv1, 5);
*/
			break;
		}
	}
	PopTransformation3D (NULL);
}

void    Curves3D (HDC hdc, WORD cmd)
{
	POINT3D curve[16] = {
		{0, 0, 0}, {20, -30, 30}, {40, 30, -30}, {60, 0, 0},
		{0, 4, 0}, {2, 4, 5}, {4, 4, 0}, {6, 4, 6},
		{0, 2, 5}, {2, 2, 0}, {4, 2, 6}, {6, 2, 0},
		{0, 0, 0}, {2, 0, 3}, {4, 0, 0}, {6, 0, 3}};
	COORD	point[] = {0, 0, 0, 1, 1, 1, 1, 0, 2, 0, 3, 1, 4, 1, 4, 0};
	real Knot1[] = {0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
	real Knot2[] = {0, 0, 0, 1, 1, 1, 4, 5, 5, 5};
	real Knot3[] = {0, 0, 0, 1, 1, 1, 1, 2, 3, 4, 5, 6};
	real Knot4[] = {0, 0, 0, 1, 3, 5, 7, 9, 10, 15};

    SelectViewer (viewer30);
    ClearDepthBuffer (0xffff);
	PushTransformation3D (NULL);
    switch (cmd) {
        case IDM_3DCURVE_SPRING:
			MarkPosition3D (hdc, 0, 0, 0, 20, VL_ORIGIN);
            PenColor (hdc, VL_BLUE);
            Spring3D (hdc, 30, 10, 10, 40);
			PenColor (hdc, VL_YELLOW);
			Rotate3D (90, 'y');
            Spring3D (hdc, 30, 10, 10, 40);
			PenColor (hdc, VL_GREEN);
			Rotate3D (-90, 'x');
            Spring3D (hdc, 30, 10, 10, 40);
			SetViewerName (VL_CURRENT, "3D Springs");
            break;
        case IDM_3DCURVE_SPIRAL:
			MarkPosition3D (hdc, 0, 0, 0, 20, VL_ORIGIN);
            PenColor (hdc, VL_GREEN);
            Spiral3D (hdc, 0, 10, 0, 0.5f, 40);
			PenColor (hdc, VL_YELLOW);
			Rotate3D (90, 'y');
            Spiral3D (hdc, 0, 10, 0, 0.5f, 40);
			PenColor (hdc, VL_RED);
			Rotate3D (-90, 'x');
            Spiral3D (hdc, 0, 10, 0, 0.5f, 40);
			SetViewerName (VL_CURRENT, "3D Spiral");
			break;
        case IDM_3DCURVE_BEZIER:
            PenColor (hdc, VL_GREEN);
            BezierCurve3D (hdc, VL_3D, (LPCOORD) curve);
			SetViewerName (VL_CURRENT, "3D Bezier Curve");
            break;
        case IDM_3DCURVE_HERMIT:
            PenColor (hdc, VL_GREEN);
            HermitCurve3D (hdc, VL_3D, (LPCOORD) curve);
			SetViewerName (VL_CURRENT, "3D Hermit Curve");
            break;
        case IDM_3DCURVE_BSPLINE:
            PenColor (hdc, VL_GREEN);
            BSplineCurve3D (hdc, VL_3D, (LPCOORD) curve, 16);
			SetViewerName (VL_CURRENT, "3D B-Spline Curve");
            break;
        case IDM_3DCURVE_NURBS:
            PenColor (hdc, VL_GREEN);
			Scale3D (5, 5, 5);
            NURBSCurve3D (hdc, VL_2D, point, 8, Knot3);
			SetViewerName (VL_CURRENT, "3D NURBS Curve");
            break;
        case IDM_3DCURVE_QBEZIER:
		{
			COORD	point[] = {0, 0, 0, 1, 1, 1, 1, 0, 2, 0, 3, 1, 4, 1, 4, 0};
			SetViewerName (VL_CURRENT, "3D Quadratic Bezier Curve");
			Scale3D (12, 12, 12);
			PenColor (hdc, VL_RED);
			Polyline3D (hdc, VL_2D, point, 3);
			PenColor (hdc, VL_BLUE);
			PolyMark3D (hdc, VL_2D, point, 3, 3, 3, VL_DIAMONDMARK);
			PenColor (hdc, VL_GREEN);
			QBezierCurve3D (hdc, VL_2D, point);
			SetViewerName (VL_CURRENT, "3D Quadratic Bezier Curve");
			break;
		}
        case IDM_3DCURVE_QBSPLINE:
		{
			COORD	point[] = {0, 0, 0, 1, 1, 1, 1, 0, 2, 0, 3, 1, 4, 1, 4, 0};
			SetViewerName (VL_CURRENT, "3D Quadratic B-Spline Curve");
			Scale3D (12, 12, 12);
			PenColor (hdc, VL_RED);
			Polyline3D (hdc, VL_2D, point, 8);
			PenColor (hdc, VL_BLUE);
			PolyMark3D (hdc, VL_2D, point, 8, 3, 3, VL_DIAMONDMARK);
			PenColor (hdc, VL_GREEN);
			QBSplineCurve3D (hdc, VL_2D, point, 8);
			break;
		}
        case IDM_3DCURVE_QNURBS:
		{
			COORD	point[] = {0, 0, 0, 1, 1, 1, 1, 0, 2, 0, 3, 1, 4, 1, 4, 0};
			real knot[] = {0, 0, 0, 1, 1, 1, 1, 2, 3, 4, 5, 6};
			
			SetViewerName (VL_CURRENT, "3D Quadratic NURBS Curve");
			Scale3D (12, 12, 12);
			PenColor (hdc, VL_RED);
			Polyline3D (hdc, VL_2D, point, 8);
			PenColor (hdc, VL_BLUE);
			PolyMark3D (hdc, VL_2D, point, 8, 3, 3, VL_DIAMONDMARK);
			PenColor (hdc, VL_GREEN);
			QNURBSCurve3D (hdc, VL_2D, point, 8, knot);
			break;
		}
        case IDM_3DCURVE_CATMULLROM:
//          CatmullRomSpline3D (hdc, cp3, n);
            break;
        case IDM_3DSHAPE_ELLIPSOID:
            Ellipsoid (hdc, 20, 30, 40);
            break;
        case IDM_3DSHAPE_ELLIPTICPARAB:
//          EllipticParaboloid (hdc, height, count1, count2);
            break;
        case IDM_3DSHAPE_HYPERBOLOID1:
//          Hyperboloid1 (hdc, z1, z2, count1, count2);
            break;
        case IDM_3DSHAPE_HYPERBOLOID2:
//          Hyperboloid2 (hdc, height, count1, count2);
            break;
        case IDM_3DSHAPE_HYPERBOLICPARAB:
//          HyperbolicParaboloid (hdc, x1, x2, y1, y2, count1, count2);
            break;
    }
	PopTransformation3D (NULL);
}

VOIDED	ShowSolidPrimitives (HDC hdc, WORD cmd)
{
	ClearDepthBuffer (0xffff);
	switch (cmd) {
		case IDM_SOLID_TUBE:
			SetViewerName (VL_CURRENT, "Tube and Ring");
			Tube (hdc, 15, 20, 2, 30);
			break;
        case IDM_SOLID_TORUS:
			SetViewerName (VL_CURRENT, "Torus and Wedged Torus");
			TranslateTo3D (-20, 20, 0);
			if (!Torus (hdc, 15, 5))
				break;
			TranslateTo3D (20, -20, 0);
			WedgedTorus (hdc, 15, 5, 90, 360, 180, 90);
            break;
        case IDM_SOLID_SPHERE:
			SetViewerName (VL_CURRENT, "Sphere and Wedged Sphere");
			WedgedSphere (hdc, 20, 20, 30, 90, 0, 45, 135);
            break;
        case IDM_SOLID_ELLIPSOID:
			SetViewerName (VL_CURRENT, "Ellipsoid");
			PenColor (hdc, VL_NONE);
            Ellipsoid (hdc, 20, 40, 30);
            break;
        case IDM_SOLID_CYLINDER:
			SetViewerName (VL_CURRENT, "Cylinder and Wedge");
			if (!WedgedCylinder (hdc, 10, 20, 30, 0.7f, 90, 0))
				break;
            TranslateTo3D (30, -30, 0);
            if (!Wedge (hdc, 20, 10, 5, 45, 180))
				break;
            TranslateTo3D (-30, 30, 0);
            Wedge (hdc, 20, 10, 5, 180, 45);
            break;
        case IDM_SOLID_CONE:
			SetViewerName (VL_CURRENT, "Cone and Wedged Cone");
			if (!WedgedCone (hdc, 10, 20, 30, 90, 0))
				break;
            TranslateTo3D (30, -30, 0);
			if (!WedgedCone (hdc, 20, 10, 30, 110, 0))
				break;
			TranslateTo3D (-30, 30, 0);
            WedgedCone (hdc, 20, 10, 30, 180, 45);
            break;
        case IDM_SOLID_TETRAHEDRON:
			SetViewerName (VL_CURRENT, "Tetrahedron (4 facets)");
            Tetrahedron (hdc, 20);
            MarkPosition3D (hdc, 0, 0, 0, 10, VL_CROSSHAIR);
            break;
        case IDM_SOLID_OCTAHEDRON:
			SetViewerName (VL_CURRENT, "Octahedron (8 facets)");
            Octahedron (hdc, 20);
            MarkPosition3D (hdc, 0, 0, 0, 20, VL_ORIGIN);
            break;
        case IDM_SOLID_DODECAHEDRON:
			SetViewerName (VL_CURRENT, "Dodecahedron (12 facets)");
            Dodecahedron (hdc, 20);
            MarkPosition3D (hdc, 0, 0, 0, 10, VL_ORIGIN);
            break;
        case IDM_SOLID_ICOSAHEDRON:
			SetViewerName (VL_CURRENT, "Icosahedron (20 facets)");
            Icosahedron (hdc, 20);
            MarkPosition3D (hdc, 0, 0, 0, 10, VL_ORIGIN);
            break;
        case IDM_SOLID_FRUSTUM:
			SetViewerName (VL_CURRENT, "Frustum");
            Frustum (hdc, 20, 30, 10, 20, 20);
            break;
        case IDM_SOLID_RIDGE:
			SetViewerName (VL_CURRENT, "Ridge");
            Ridge (hdc, 20, 30, 10, 20);
            break;
        case IDM_SOLID_BOX:
			SetViewerName (VL_CURRENT, "Box");
			Cube (hdc, 40, 40, 20);
            break;
        case IDM_SOLID_STAR:
			SetViewerName (VL_CURRENT, "Solid Star");
            SolidStar (hdc, 5, 20, 20, 10);
            break;
        case IDM_SOLID_FLOWER:
			SetViewerName (VL_CURRENT, "Solid Flower");
            SolidFlower (hdc, 8, 0.666f, 30, 30, 10);
            break;
	}
	PenColor (hdc, VL_BLUE);
	DisplayViewerFrame (hdc, VL_CURRENT);
	TextColor (hdc, VL_BLUE, VL_BLACK, TRANSPARENT);
	DisplayViewerName (hdc, VL_CURRENT, FALSE);
}

void    ShadingSettings (HWND hwnd, WORD cmd)
{
	COLORREF	color;
	FARPROC		lpProc;

	switch (cmd) {
		case IDM_OPTION_PREVIEW:
		{
			RECT rect = {50, 50, 100, 100};
			HDC	hdc;

			SelectViewer (viewer30);
			hdc = GetDC (hwnd);
			ShadingPreview (hdc, &rect, 40, 173);
			ReleaseDC (hwnd, hdc);
			break;
		}
        case IDM_GLOBAL_AMBIENT:
            color = ShadingColor (VL_CURRENT, VL_GLOBALAMBIENT, VL_INQUIRE);
			color = SelectColor (color);
			ShadingColor (VL_CURRENT, VL_GLOBALAMBIENT, color);
            break;
		case IDM_OPTION_BACKCOLOR:
		{
			HBRUSH	hbrush;

			backcolor = SelectColor (backcolor);
			hbrush = GetClassWord (hwnd, GCW_HBRBACKGROUND);
			DeleteObject (hbrush);
			hbrush = CreateSolidBrush (backcolor);
			SetClassWord (hwnd, GCW_HBRBACKGROUND, hbrush);
            InvalidateRect (hwnd, NULL, TRUE);
			UpdateWindow (hwnd);
			break;
		}
		case IDM_OPTION_REDRAW:
            InvalidateRect (hwnd, NULL, TRUE);
			UpdateWindow (hwnd);
			break;
		case IDM_OPTION_SHADEMODE:
 			lpProc = MakeProcInstance (DlgShading, hInst);
			DialogBox (hInst, "DLGSHADING", hwnd, lpProc);
			FreeProcInstance (lpProc);
			break;
        case IDM_SELECT_M1:
            SelectMaterial (mater0);
			lpProc = MakeProcInstance (DlgMaterial, hInst);
			DialogBox (hInst, "DLGMATERIAL", hwnd, lpProc);
			FreeProcInstance (lpProc);
            break;
        case IDM_SELECT_M2:
            SelectMaterial (mater1);
			lpProc = MakeProcInstance (DlgMaterial, hInst);
			DialogBox (hInst, "DLGMATERIAL", hwnd, lpProc);
			FreeProcInstance (lpProc);
            break;
        case IDM_SELECT_M3:
            SelectMaterial (mater2);
			lpProc = MakeProcInstance (DlgMaterial, hInst);
			DialogBox (hInst, "DLGMATERIAL", hwnd, lpProc);
			FreeProcInstance (lpProc);
            break;
        case IDM_SELECT_M4:
            SelectMaterial (mater3);
			lpProc = MakeProcInstance (DlgMaterial, hInst);
			DialogBox (hInst, "DLGMATERIAL", hwnd, lpProc);
			FreeProcInstance (lpProc);
            break;
        case IDM_SELECT_L1:
            SelectLight (light0);
			lpProc = MakeProcInstance (DlgLightSetup, hInst);
			DialogBox (hInst, "DLGLIGHTSETUP", hwnd, lpProc);
			FreeProcInstance (lpProc);
            break;
        case IDM_SELECT_L2:
            SelectLight (light1);
			lpProc = MakeProcInstance (DlgLightSetup, hInst);
			DialogBox (hInst, "DLGLIGHTSETUP", hwnd, lpProc);
			FreeProcInstance (lpProc);
            break;
        case IDM_SELECT_L3:
            SelectLight (light2);
			lpProc = MakeProcInstance (DlgLightSetup, hInst);
			DialogBox (hInst, "DLGLIGHTSETUP", hwnd, lpProc);
			FreeProcInstance (lpProc);
            break;
        case IDM_SELECT_L4:
            SelectLight (light3);
			lpProc = MakeProcInstance (DlgLightSetup, hInst);
			DialogBox (hInst, "DLGLIGHTSETUP", hwnd, lpProc);
			FreeProcInstance (lpProc);
            break;
        case IDM_OPTION_TEXTURE:
			lpProc = MakeProcInstance (DlgTexture, hInst);
			DialogBox (hInst, "DLGTEXTURE", hwnd, lpProc);
			FreeProcInstance (lpProc);
            break;
	}
}

WORD	halign = TA_CENTER;
WORD	valign = TA_BASELINE;

VOIDED	ShowTextPrimitives (HDC hdc, int func)
{
	char	str[40];

	wsprintf (str, "Visualib\nAdvanced\nTechnology");
	switch (func) {
		case IDM_TEXT_2D:
			SelectViewer (viewer20);
			TextParameter (VL_TEXT_HEIGHT, 4);
			BrushColor (hdc, VL_RED);
			PenColor (hdc, VL_GREEN);
			SetTextAlign (hdc, halign | valign);
			Text2D (hdc, 0, 0, 0, str);
			SetViewerName (VL_CURRENT, "2D Horizontal Text");
			break;
		case IDM_TEXT_3D:
			SelectViewer (viewer30);
            MarkPosition3D (hdc, 0, 0, 0, 40, VL_ORIGIN);
			PushTransformation3D (NULL);
			TextParameter (VL_TEXT_HEIGHT, 15);
			BrushColor (hdc, VL_YELLOW);
			PenColor (hdc, VL_BLUE);
			SetTextAlign (hdc, TA_LEFT | TA_BOTTOM);
			Text3D (hdc, 3, 1, 0, str);
			PushTransformation3D (NULL);
			Rotate3D (90, 'y');
			SetTextAlign (hdc, TA_RIGHT | TA_BOTTOM);
			Text3D (hdc, -3, 1, 0, str);
			PopTransformation3D (NULL);
			Rotate3D (-90, 'x');
			SetTextAlign (hdc, TA_TOP | TA_LEFT);
			Text3D (hdc, 3, -1, 0, str);
			PopTransformation3D (NULL);
			SetViewerName (VL_CURRENT, "3D Horizontal Text");
			break;
		case IDM_TEXT_SOLID:
			SelectViewer (viewer30);
			TextParameter (VL_TEXT_HEIGHT, 30);
			ClearDepthBuffer (0xffff);
			TextParameter (VL_TEXT_THICKNESS, 8);
			SelectMaterial (mater0);
			PushTransformation3D (NULL);
			Rotate3D (135, 'z');
			Rotate3D (30, 'x');
			SetTextAlign (hdc, TA_BASELINE | TA_CENTER);
			SolidText (hdc, str);
			PopTransformation3D (NULL);
			SetViewerName (VL_CURRENT, "Solid Text");
			break;
	}
	PenColor (hdc, VL_BLUE);
	DisplayViewerFrame (hdc, VL_CURRENT);
	TextColor (hdc, VL_BLUE, VL_BLACK, TRANSPARENT);
	DisplayViewerName (hdc, VL_CURRENT, FALSE);
}

void    ProcessWindowPaint (HWND hwnd)
{
    PAINTSTRUCT ps;
    HDC         hdc;

    hdc = BeginPaint (hwnd, &ps);
    SelectPalette (hdc, hpal, 0);
    RealizePalette (hdc);
	FunctionDemos (hdc);
    EndPaint (hwnd, &ps);
}

void	SpotlightDemo (HDC hdc)
{
	SelectViewer (viewer30);
	PenColor (hdc, VL_BLUE);
	DisplayViewerFrame (hdc, VL_CURRENT);
	SetViewerName (VL_CURRENT, "Spot Lights Demo");
	TextColor (hdc, VL_BLUE, VL_BLACK, TRANSPARENT);
	DisplayViewerName (hdc, VL_CURRENT, FALSE);
	ShadingOption (VL_CURRENT, VL_TWOSIDESHADE, FALSE);
	ShadingOption (VL_CURRENT, VL_BACKFACEREMOVAL, TRUE);
	ShadingOption (VL_CURRENT, VL_DEPTHBUFFER, TRUE);
	ShadingOption (VL_CURRENT, VL_SHADINGMETHOD, VL_PHONGSHADE);
	ClearDepthBuffer (0xffff);
	SelectMaterial (mater0);
	SwitchLight (light4, TRUE);
	SwitchLight (light5, TRUE);
	SwitchLight (light6, TRUE);
	SolidFlower (hdc, 8, 0.666f, 30, 30, 10);
}

void	ImageMappingDemo (HDC hdc)
{
	COORD	point[12];
	static BOOL	LoadImage = TRUE;

	if (LoadImage) {
//		ReadDIBFile ("redmarbl.bmp", &hdib1);
		ReadDIBFile (NULL, &hdib1);
		ReadDIBFile ("deer256.bmp", &hdib2);
		ReadDIBFile ("c:\\windows\\system\\vgalogo.rle", &hdib3);
		LoadImage = FALSE;
	}

	SelectViewer (viewer30);
	SetViewerName (VL_CURRENT, "Image Mapping");
	PenColor (hdc, VL_BLUE);
	DisplayViewerFrame (hdc, VL_CURRENT);
	TextColor (hdc, VL_BLUE, VL_BLACK, TRANSPARENT);
	DisplayViewerName (hdc, VL_CURRENT, 0);
	Scale3D (20, 20, 30);

	point[0] = -1; point[1] = -1; point[2] = 1;
	point[3] = 1; point[4] = -1; point[5] = 1;
	point[6] = 1; point[7] = 1; point[8] = 1;
	point[9] = -1; point[10] = 1; point[11] = 1;
	if (hdib1) {
		if (!ImageMap3D (hdc, hdib1, VL_3D, point))
			return;
	}

	point[0] = 1; point[1] = 1; point[2] = 1;
	point[3] = 1; point[4] = 1; point[5] = -1;
	point[6] = -1; point[7] = 1; point[8] = -1;
	point[9] = -1; point[10] = 1; point[11] = 1;
	if (hdib2) {
		if (!ImageMap3D (hdc, hdib2, VL_3D, point))
			return;
	}

	point[0] = 1; point[1] = -1; point[2] = -1;
	point[3] = 1; point[4] = 1; point[5] = -1;
	point[6] = 1; point[7] = 1; point[8] = 1;
	point[9] = 1; point[10] = -1; point[11] = 1;
	if (hdib3) {
		ImageMap3D (hdc, hdib3, VL_3D, point);
	}
}

void	TranslateTransf2D (HDC hdc)
{
	SetTextAlign (hdc, TA_CENTER | TA_BASELINE);
	SetViewerName (VL_CURRENT, "2D Translate Transformation");
	BrushColor (hdc, VL_RED);
	Star2D (hdc, 0, 0, 0, 2, 2, 5);
	Label2D (hdc, 0, 0, "Original");
	TranslateTo2D (5, 3);
	BrushColor (hdc, VL_GREEN);
	Star2D (hdc, 0, 0, 0, 2, 2, 5);
	Label2D (hdc, 0, 0, "Translated To (5,3)");
	PushTransformation2D (NULL);
	Translate2D (0, -6);
	BrushColor (hdc, VL_YELLOW);
	Star2D (hdc, 0, 0, 0, 2, 2, 5);
	Label2D (hdc, 0, 0, "Translated (0,-6) from above");
	PopTransformation2D (NULL);
	Translate2D (-10, 0);
	BrushColor (hdc, VL_BLUE);
	Star2D (hdc, 0, 0, 0, 2, 2, 5);
	Label2D (hdc, 0, 0, "Translated (-10,0) from right");
	Translate2D (0, -6);
	BrushColor (hdc, VL_WHITE);
	Star2D (hdc, 0, 0, 0, 2, 2, 5);
	Label2D (hdc, 0, 0, "Translated (0,-6) from above");
}

void	MirrorTransf2D (HDC hdc)
{
	SetTextAlign (hdc, TA_CENTER | TA_BASELINE);
	SetViewerName (VL_CURRENT, "2D Mirror Transformation");
	BrushColor (hdc, VL_RED);
	Star2D (hdc, 5, 3, 0, 2, 2, 5);
	Label2D (hdc, 5, 3, "Original");
	PushTransformation2D (NULL);
	Mirror2D (0, 0, 0);
	BrushColor (hdc, VL_GREEN);
	Star2D (hdc, 5, 3, 0, 2, 2, 5);
	Label2D (hdc, 5, 3, "Mirrored along (0,0) with 0 degree");
	PopTransformation2D (NULL);
	PushTransformation2D (NULL);
	Mirror2D (0, 0, 90);
	BrushColor (hdc, VL_YELLOW);
	Star2D (hdc, 5, 3, 0, 2, 2, 5);
	Label2D (hdc, 5, 3, "Mirrored along (0,0) with 90 degree");
	PopTransformation2D (NULL);
	PushTransformation2D (NULL);
	Mirror2D (0, 0, (real)(atan2 (-5, 3) * RTOD));
	BrushColor (hdc, VL_BLUE);
	Star2D (hdc, 5, 3, 0, 2, 2, 5);
	Label2D (hdc, 5, 3, "Mirrored along (0,0) with radian (-5,3)");
	PopTransformation2D (NULL);
}

void	StretchTransf2D (HDC hdc)
{
	SetTextAlign (hdc, TA_CENTER | TA_BASELINE);
	SetViewerName (VL_CURRENT, "2D Stretch Transformation");
	BrushColor (hdc, VL_RED);
	Star2D (hdc, 0, 0, 0, 2, 2, 5);
	Label2D (hdc, 0, 0, "Original");
	PushTransformation2D (NULL);
	Stretch2D (5, 3, 0, 1.5f);
	BrushColor (hdc, VL_GREEN);
	Star2D (hdc, 5, 3, 0, 2, 2, 5);
	Label2D (hdc, 5, 3, "Stretched along 0 degree");
	PopTransformation2D (NULL);
	PushTransformation2D (NULL);
	Stretch2D (5, -3, 90, 1.5f);
	BrushColor (hdc, VL_YELLOW);
	Star2D (hdc, 5, -3, 0, 2, 2, 5);
	Label2D (hdc, 5, -3, "Stretched along 90 degree");
	PopTransformation2D (NULL);
	PushTransformation2D (NULL);
	Stretch2D (-5, -3, 45, 1.5f);
	BrushColor (hdc, VL_BLUE);
	Star2D (hdc, -5, -3, 0, 2, 2, 5);
	Label2D (hdc, -5, -3, "Stretched along 45 degree");
	PopTransformation2D (NULL);
	PushTransformation2D (NULL);
	Stretch2D (-5, 3, 45, -1.5f);
	BrushColor (hdc, VL_BROWN);
	Star2D (hdc, -5, 3, 0, 2, 2, 5);
	Label2D (hdc, -5, 3, "Stretched and flipped 45 degree");
	PopTransformation2D (NULL);
}

void	ShearTransf2D (HDC hdc)
{
	SetTextAlign (hdc, TA_CENTER | TA_BASELINE);
	SetViewerName (VL_CURRENT, "2D Shear Transformation");
	BrushColor (hdc, VL_RED);
	Star2D (hdc, 0, 0, 0, 2, 2, 5);
	Label2D (hdc, 0, 0, "Original");
	PushTransformation2D (NULL);
	Shear2D (5, 3, 0, 0.5f, 0);
	BrushColor (hdc, VL_GREEN);
	Star2D (hdc, 5, 3, 0, 2, 2, 5);
	Label2D (hdc, 5, 3, "Horizontal shear");
	PopTransformation2D (NULL);
	PushTransformation2D (NULL);
	Shear2D (5, -3, 0, 0, 0.5f);
	BrushColor (hdc, VL_BLUE);
	Star2D (hdc, 5, -3, 0, 2, 2, 5);
	Label2D (hdc, 5, -3, "Vertical shear");
	PopTransformation2D (NULL);
	PushTransformation2D (NULL);
	Shear2D (-5, -3, 0, 0.5f, 0.5f);
	BrushColor (hdc, VL_YELLOW);
	Star2D (hdc, -5, -3, 0, 2, 2, 5);
	Label2D (hdc, -5, -3, "Horizontal and vertical shear");
	PopTransformation2D (NULL);
	PushTransformation2D (NULL);
	Shear2D (-5, 3, 45, 0.5f, 0);
	BrushColor (hdc, VL_BROWN);
	Star2D (hdc, -5, 3, 0, 2, 2, 5);
	Label2D (hdc, -5, 3, "Horizontal shear along 45 degree");
	PopTransformation2D (NULL);
}

void	PointRotateTransf2D (HDC hdc)
{
	SetTextAlign (hdc, TA_CENTER | TA_BOTTOM);
	Label2D (hdc, 5, 3, "(5,3)");
	SetTextAlign (hdc, TA_RIGHT | TA_BASELINE);
	Label2D (hdc, -5, 3, "(-5,3)");
	SetTextAlign (hdc, TA_CENTER | TA_TOP);
	Label2D (hdc, -5, -3, "(-5,-3)");
	SetTextAlign (hdc, TA_LEFT | TA_BASELINE);
	Label2D (hdc, 5, -3, "(5,-3)");
	SetTextAlign (hdc, TA_CENTER | TA_BASELINE);
	SetViewerName (VL_CURRENT, "2D Point Ratate Transformation");
	PenColor (hdc, VL_WHITE);
	BrushColor (hdc, VL_RED);
	Star2D (hdc, 0, 0, 0, 2, 2, 5);
	Label2D (hdc, 0, 0, "Original");
	Line2D (hdc, 5, 3, 0, 0);
	PushTransformation2D (NULL);
	PointRotate2D (5, 3, 90);
	BrushColor (hdc, VL_GREEN);
	Label2D (hdc, 0, 0, "Rotate 90 degree around (5,3)");
	Star2D (hdc, 0, 0, 0, 2, 2, 5);
	LineTo2D (hdc, 0, 0);
	LineTo2D (hdc, 5, 3);
 	PopTransformation2D (NULL);
	Line2D (hdc, -5, 3, 0, 0);
	PushTransformation2D (NULL);
	PointRotate2D (-5, 3, 45);
	BrushColor (hdc, VL_YELLOW);
	Label2D (hdc, 0, 0, "Rotate 45 degree around (-5,3)");
	Star2D (hdc, 0, 0, 0, 2, 2, 5);
	LineTo2D (hdc, 0, 0);
	LineTo2D (hdc, -5, 3);
	PopTransformation2D (NULL);
	Line2D (hdc, 5, -3, 0, 0);
	PushTransformation2D (NULL);
	PointRotate2D (5, -3, 45);
	BrushColor (hdc, VL_BLUE);
	Label2D (hdc, 0, 0, "Rotate 45 degree around (5,-3)");
	Star2D (hdc, 0, 0, 0, 2, 2, 5);
	LineTo2D (hdc, 0, 0);
	LineTo2D (hdc, 5, -3);
	PopTransformation2D (NULL);
	Line2D (hdc, -5, -3, 0, 0);
	PushTransformation2D (NULL);
	PointRotate2D (-5, -3, 90);
	BrushColor (hdc, VL_BROWN);
	Label2D (hdc, 0, 0, "Rotate 90 degree around (-5,-3)");
	Star2D (hdc, 0, 0, 0, 2, 2, 5);
	LineTo2D (hdc, 0, 0);
	LineTo2D (hdc, -5, -3);
	PopTransformation2D (NULL);
}

void	PointScaleTransf2D (HDC hdc)
{
	SetTextAlign (hdc, TA_CENTER | TA_BASELINE);
	BrushColor (hdc, VL_RED);
	Star2D (hdc, 5, 3, 0, 2, 2, 5);
	Label2D (hdc, 5, 3, "Original");
	PushTransformation2D (NULL);
	PointScale2D (0, 0, -1, 1);
	BrushColor (hdc, VL_GREEN);
	Star2D (hdc, 5, 3, 0, 2, 2, 5);
	Label2D (hdc, 5, 3, "Horizontal flipped");
	PopTransformation2D (NULL);
	PushTransformation2D (NULL);
	PointScale2D (0, 0, 1, -1);
	BrushColor (hdc, VL_BLUE);
	Star2D (hdc, 5, 3, 0, 2, 2, 5);
	Label2D (hdc, 5, 3, "Vertical flipped");
	PopTransformation2D (NULL);
	PushTransformation2D (NULL);
	PointScale2D (0, 0, -1, -1);
	BrushColor (hdc, VL_YELLOW);
	Star2D (hdc, 5, 3, 0, 2, 2, 5);
	Label2D (hdc, 5, 3, "Horizontal and vertical flipped");
	PopTransformation2D (NULL);
}
	
void	Transformation2D (HDC hdc, int func)
{
	SetROP2 (hdc, R2_XORPEN);
	TextColor (hdc, VL_WHITE, VL_BLACK, TRANSPARENT);
	PushTransformation2D (NULL);
	switch (func) {
		case IDM_2DTRANSF_TRANSLATE:
			TranslateTransf2D (hdc);
			break;
		case IDM_2DTRANSF_SCALE:
			break;
		case IDM_2DTRANSF_POINTSCALE:
			PointScaleTransf2D (hdc);
			break;
		case IDM_2DTRANSF_ROTATE:
			break;
		case IDM_2DTRANSF_POINTROTATE:
			PointRotateTransf2D (hdc);
			break;
		case IDM_2DTRANSF_STRETCH:
			StretchTransf2D (hdc);
			break;
		case IDM_2DTRANSF_SHEAR:
			ShearTransf2D (hdc);
			break;
		case IDM_2DTRANSF_MIRROR:
			MirrorTransf2D (hdc);
			break;
	}
	PopTransformation2D (NULL);
	PenColor (hdc, VL_BLUE);
	DisplayViewerFrame (hdc, VL_CURRENT);
	TextColor (hdc, VL_BLUE, VL_BLACK, TRANSPARENT);
	DisplayViewerName (hdc, VL_CURRENT, FALSE);
}

void	AxleRotateTransf3D (HDC hdc)
{
	short	i;
	VECTOR3	ref = {0, 0, 0}, dir;
	char	str[] = "Visualib";

	SetTextAlign(hdc, TA_LEFT | TA_BOTTOM);
	TextParameter (VL_TEXT_HEIGHT, 20);
	MarkPosition3D (hdc, 0, 0, 0, 20, VL_ORIGIN);
	BrushColor (hdc, VL_RED);
	Text3D (hdc, 15, 15, 0, str);
	VSET3 (dir, 1, 0, 0);
	for (i = 1; i < 4; i++) {
		PushTransformation3D (NULL);
		AxleRotate3D (ref, dir, i * 90);
		BrushColor (hdc, i+1);
		Text3D (hdc, 15, 15, 0, str);
		PopTransformation3D (NULL);
	}
	VSET3 (dir, 0, 1, 0);
	for (i = 1; i < 4; i++) {
		PushTransformation3D (NULL);
		AxleRotate3D (ref, dir, i * 90);
		BrushColor (hdc, i+4);
		Text3D (hdc, 15, 15, 0, str);
		PopTransformation3D (NULL);
	}
	VSET3 (dir, 1, -1, 0);
	for (i = 1; i < 4; i++) {
		PushTransformation3D (NULL);
		AxleRotate3D (ref, dir, i * 90);
		BrushColor (hdc, i+7);
		Text3D (hdc, 15, 15, 0, str);
		PopTransformation3D (NULL);
	}
}

void	StretchTransf3D (HDC hdc)
{
	VECTOR3	ref = {0, 0, 0}, dir;

	TextParameter (VL_TEXT_HEIGHT, 30);
	SetTextAlign (hdc, TA_CENTER | TA_BASELINE);
	PushTransformation3D (NULL);
	VSET3 (dir, -1, 1, 1);
	Stretch3D (ref, dir, 1.5f);
	Cube (hdc, 20, 20, 20);
	MarkPosition3D (hdc, 0, 0, 0, 40, VL_ORIGIN);
	PopTransformation3D (NULL);
}

void	ShearTransf3D (HDC hdc)
{
	VECTOR3	origin = {0, 0, 0}, normal = {0, 0, 1};

	TextParameter (VL_TEXT_HEIGHT, 30);
	SetTextAlign (hdc, TA_CENTER | TA_BASELINE);
	PushTransformation3D (NULL);
	Shear3D (origin, normal, -0.5f, 0.5f);
	Cube (hdc, 20, 20, 20);
	MarkPosition3D (hdc, 0, 0, 0, 40, VL_ORIGIN);
	PopTransformation3D (NULL);
}

void	MirrorTransf3D (HDC hdc)
{
	VECTOR3	ref = {0, 0, 0}, dir;
	char	str[] = "Visualib";

	MarkPosition3D (hdc, 0, 0, 0, 40, VL_ORIGIN);
	SetViewerName (VL_CURRENT, "3D Mirror Transformation");
	SetTextAlign (hdc, TA_LEFT | TA_BOTTOM);
	TextParameter (VL_TEXT_HEIGHT, 20);
	BrushColor (hdc, VL_RED);
	Text3D (hdc, 3, 3, 0, str);
	PushTransformation3D (NULL);
	VSET3 (dir, 1, 0, 0);
	Mirror3D (ref, dir);
	BrushColor (hdc, VL_GREEN);
	Text3D (hdc, 3, 3, 0, str);
	PopTransformation3D (NULL);
	PushTransformation3D (NULL);
	VSET3 (dir, 0, 1, 0);
	Mirror3D (ref, dir);
	BrushColor (hdc, VL_YELLOW);
	Text3D (hdc, 3, 3, 0, str);
	PopTransformation3D (NULL);
	PushTransformation3D (NULL);
	VSET3 (dir, -1, -1, 0);
	Mirror3D (ref, dir);
	BrushColor (hdc, VL_BLUE);
	Text3D (hdc, 3, 3, 0, str);
	PopTransformation3D (NULL);
}

void	PointScaleTransf3D (HDC hdc)
{
	char	str[] = "Visualib";

	MarkPosition3D (hdc, 0, 0, 0, 40, VL_ORIGIN);
	SetViewerName (VL_CURRENT, "3D PointScale Transformation");
	SetTextAlign (hdc, TA_LEFT | TA_BOTTOM);
	TextParameter (VL_TEXT_HEIGHT, 20);
	BrushColor (hdc, VL_RED);
	Text3D (hdc, 3, 3, 0, str);
	PushTransformation3D (NULL);
	PointScale3D (0, 0, 0, -1, 1, 1);
	BrushColor (hdc, VL_GREEN);
	Text3D (hdc, 3, 3, 0, str);
	PopTransformation3D (NULL);
	PushTransformation3D (NULL);
	PointScale3D (0, 0, 0, 1, -1, 1);
	BrushColor (hdc, VL_YELLOW);
	Text3D (hdc, 3, 3, 0, str);
	PopTransformation3D (NULL);
	PushTransformation3D (NULL);
	PointScale3D (0, 0, 0, -1, -1, 1);
	BrushColor (hdc, VL_BLUE);
	Text3D (hdc, 3, 3, 0, str);
	PopTransformation3D (NULL);
}

void	Transformation3D (HDC hdc, int func)
{
	TextColor (hdc, VL_WHITE, VL_BLACK, TRANSPARENT);
	ClearDepthBuffer (0xffff);
	switch (func) {
		case IDM_3DTRANSF_TRANSLATE:
			break;
		case IDM_3DTRANSF_SCALE:
			break;
		case IDM_3DTRANSF_POINTSCALE:
			PointScaleTransf3D (hdc);
			break;
		case IDM_3DTRANSF_ROTATE:
			break;
		case IDM_3DTRANSF_AXLEROTATE:
			AxleRotateTransf3D (hdc);
			break;
		case IDM_3DTRANSF_STRETCH:
			StretchTransf3D (hdc);
			break;
		case IDM_3DTRANSF_SHEAR:
			ShearTransf3D (hdc);
			break;
		case IDM_3DTRANSF_MIRROR:
			MirrorTransf3D (hdc);
			break;
	}
	PenColor (hdc, VL_BLUE);
	DisplayViewerFrame (hdc, VL_CURRENT);
	TextColor (hdc, VL_RED, VL_BLACK, TRANSPARENT);
	DisplayViewerName (hdc, VL_CURRENT, FALSE);
}

VOIDED	MaterialPropertyDemo (HDC hdc)
{
	short	i, j, n = 1;
	real	ks, kd, orgks, orgkd, orgn;
	RECT	rect;

	SwitchLight (light7, TRUE);
	SwitchLight (light8, TRUE);
	SelectViewer (viewer30);
	SetViewerName (VL_CURRENT, "Material Reflection Property");
	PenColor (hdc, VL_BLUE);
	DisplayViewerFrame (hdc, VL_CURRENT);
	TextColor (hdc, VL_BLUE, VL_BLACK, TRANSPARENT);
	DisplayViewerName (hdc, VL_CURRENT, 0);
	orgks = ShadingFactor (VL_CURRENT, VL_SPECULARREFLECT, VL_INQUIRE);
	orgkd = ShadingFactor (VL_CURRENT, VL_DIFFUSEREFLECT, VL_INQUIRE);
	orgn = ShadingFactor (VL_CURRENT, VL_SHININESS, VL_INQUIRE);
	rect.top = 10;
	ks = 0;
	for (i = 0; i < 6; i++) {
		kd = 0;
		rect.left = 10;
		rect.bottom = rect.top + 40;
		for (j = 0; j < 10; j++) {
			rect.right = rect.left + 40;
			ShadingFactor (VL_CURRENT, VL_SHININESS, n);
			ShadingFactor (VL_CURRENT, VL_SPECULARREFLECT, ks);
			ShadingFactor (VL_CURRENT, VL_DIFFUSEREFLECT, kd);
			if (!ShadingPreview (hdc, &rect, 5, 173))
				goto exit;
			rect.left += 49;
			kd += 0.1f;
		}
		ks += 0.2f;
		rect.top += 53;
		n *= 2;
	}
exit:
	ShadingFactor (VL_CURRENT, VL_DIFFUSEREFLECT, orgkd);
	ShadingFactor (VL_CURRENT, VL_SPECULARREFLECT, orgks);
	ShadingFactor (VL_CURRENT, VL_SHININESS, orgn);
}

void	CompositeDemo3D (HDC hdc)
{
	real	r0, r1, r2, t1, t2, h;
	short	i;
	BOOL	zbuf, flag;

	SelectViewer (viewer30);
	SetViewerName (VL_CURRENT, "Object Composition");
	PenColor (hdc, VL_WHITE);
	DisplayViewerFrame (hdc, VL_CURRENT);
	TextColor (hdc, VL_WHITE, VL_BLACK, TRANSPARENT);
	DisplayViewerName (hdc, VL_CURRENT, 0);
	zbuf = ShadingOption (VL_CURRENT, VL_DEPTHBUFFER, TRUE);
	ClearDepthBuffer (0xffff);
	SwitchLight (light7, TRUE);
//	SwitchLight (light8, TRUE);
	SelectMaterial (mater0);
	PushTransformation3D (NULL);
	r0 = 4.5f; r1 = 30; r2 = 40;
	h = 10;
	t1 = 3, t2 = 2;
	if (!Tube (hdc, r1, r1, t1, h))
		goto exit;

	if (!Ring (hdc, r2, r2, t2, h, 90, 360, 1))
		goto exit;
	h *= 0.5f;
	Translate3D (0, 0, h);
	SelectMaterial (mater1);
	for (i = 0; i < 18; i++) {
		Rotate3D (20, 'z');
		PushTransformation3D (NULL);
		Translate3D (35, 0, 0);
		flag = Sphere (hdc, r0);
		PopTransformation3D (NULL);
		if (!flag)
			break;
	}
exit:
	PopTransformation3D (NULL);
	ShadingOption (VL_CURRENT, VL_DEPTHBUFFER, zbuf);
}

void	DepthClippingDemo (HDC hdc)
{
	SelectViewer (viewer30);
	SetViewerName (VL_CURRENT, "Depth Buffer and Clipping");
	TextColor (hdc, VL_YELLOW, VL_BLACK, TRANSPARENT);
	DisplayViewerName (hdc, VL_CURRENT, 0);
	PenColor (hdc, VL_YELLOW);
	DisplayViewerFrame (hdc, VL_CURRENT);
	SetPerspective (VL_CURRENT, 45, 1, 141, 200);
	ShadingOption (VL_CURRENT, VL_DEPTHBUFFER, TRUE);
	ShadingOption (VL_CURRENT, VL_SHADINGMETHOD, VL_PHONGSHADE);
	ClearDepthBuffer (0xffff);
//	SwitchLight (light7, TRUE);
	SwitchLight (light8, TRUE);
	SelectMaterial (mater1);
	TranslateTo3D (20, 0, 0);
	if (!Sphere (hdc, 20))
		goto exit;
	SelectMaterial (mater2);
	TranslateTo3D (0, 20, 0);
	if (!Sphere (hdc, 20))
		goto exit;
	SelectMaterial (mater3);
	TranslateTo3D (0, 0, 20);
	if (!Sphere (hdc, 20))
		return;
	TranslateTo3D (0, 0, 0);
	SelectMaterial (mater0);
	if (!Cube (hdc, 40, 40, 40))
		goto exit;
 exit:
	SetPerspective (VL_CURRENT, 45, 1, 30, 1000);
}

void	MarbleRingDemo (hdc)
{
	BOOL	depthbuffer;
	short	texture;

	SelectViewer (viewer30);
	SetViewerName (VL_CURRENT, "Marble Ring");
	TextColor (hdc, VL_BROWN, VL_BLACK, TRANSPARENT);
	DisplayViewerName (hdc, VL_CURRENT, 0);
	PenColor (hdc, VL_BROWN);
	DisplayViewerFrame (hdc, VL_CURRENT);
	depthbuffer = ShadingOption (VL_CURRENT, VL_DEPTHBUFFER, TRUE);
	ClearDepthBuffer (0xffff);
	texture = SolidTexture (VL_MARBLE);
	ShadingColor (VL_CURRENT, VL_MATERIALSPECULAR, RGB (255, 255, 255));
	ShadingFactor (VL_CURRENT, VL_SPECULARREFLECT, 1);
	SwitchLight (light7, TRUE);
	SwitchLight (light8, TRUE);
	Torus (hdc, 35, 10);
	ShadingOption (VL_CURRENT, VL_DEPTHBUFFER, depthbuffer);
	SolidTexture (texture);
}

void	WoodSurfaceDemo (HDC hdc)
{
	BOOL	depthbuffer;
	short	texture;
	
	POINT3D surf[36] = {
		{0,0,0},{1,0,0},{2,0,0},{3,0,0},{4,0,0},{5,0,0},
		{0,1,0},{1,1,0},{2,1,0},{3,1,0},{4,1,0},{5,1,0},
		{0,2,0},{1,2,0},{2,2,9},{3,2,9},{4,2,0},{5,2,0},
		{0,3,0},{1,3,0},{2,3,9},{3,3,9},{4,3,0},{5,3,0},
		{0,4,0},{1,4,0},{2,4,0},{3,4,0},{4,4,0},{5,4,0},
		{0,5,0},{1,5,0},{2,5,0},{3,5,0},{4,5,0},{5,5,0}};
	real    sknot[20] = {0,0,0,1,2,3,3,3};
	real    tknot[20] = {0,0,0,1,2,3,3,3};

	SelectViewer (viewer30);
	SetViewerName (VL_CURRENT, "Wood Surface");
	TextColor (hdc, VL_GREEN, VL_BLACK, TRANSPARENT);
	DisplayViewerName (hdc, VL_CURRENT, 0);
	PenColor (hdc, VL_GREEN);
	DisplayViewerFrame (hdc, VL_CURRENT);
	depthbuffer = ShadingOption (VL_CURRENT, VL_DEPTHBUFFER, TRUE);
	ClearDepthBuffer (0xffff);
	texture = SolidTexture (VL_WOODGRAIN);
	ShadingColor (VL_CURRENT, VL_MATERIALSPECULAR, RGB (255, 255, 255));
	ShadingFactor (VL_CURRENT, VL_SPECULARREFLECT, 1);
	SwitchLight (light7, TRUE);
	SwitchLight (light8, TRUE);
	Translate3D (-15, -15, 5);
	Scale3D (10, 10, 5);
	NURBSSurface (hdc, VL_3D, (LPCOORD) surf, 6, 6, sknot, tknot, 4, 4);
	SolidTexture (texture);
	ShadingOption (VL_CURRENT, VL_DEPTHBUFFER, depthbuffer);
}

void	GraniteCubeDemo (HDC hdc)
{
	BOOL	depthbuffer;
	real	l7, l8;
	short	texture;

	SelectViewer (viewer30);
	SetViewerName (VL_CURRENT, "Granite Cube");
	TextColor (hdc, VL_WHITE, VL_BLACK, TRANSPARENT);
	DisplayViewerName (hdc, VL_CURRENT, 0);
	PenColor (hdc, VL_WHITE);
	DisplayViewerFrame (hdc, VL_CURRENT);
	ClearDepthBuffer (0xffff);
	texture = SolidTexture (VL_GRANITE);
	depthbuffer = ShadingOption (VL_CURRENT, VL_DEPTHBUFFER, TRUE);
	ShadingColor (VL_CURRENT, VL_MATERIALSPECULAR, RGB (255, 255, 255));
	ShadingFactor (VL_CURRENT, VL_SPECULARREFLECT, 1);
	l7 = ShadingFactor (light7, VL_LIGHTINTENSITY, 2);
	l8 = ShadingFactor (light8, VL_LIGHTINTENSITY, 2);
	SwitchLight (light7, TRUE);
	SwitchLight (light8, TRUE);
	Cube (hdc, 30, 30, 30);
	ShadingOption (VL_CURRENT, VL_DEPTHBUFFER, depthbuffer);
	SolidTexture (texture);
	ShadingFactor (light7, VL_LIGHTINTENSITY, l7);
	ShadingFactor (light8, VL_LIGHTINTENSITY, l8);
}

void	StereoTextDemo (HDC hdc)
{
	BOOL	depthbuffer;

	if (!SelectFont ())
		return;
	SelectViewer (viewer30);
	SetViewerName (VL_CURRENT, "Stereo Text");
	PenColor (hdc, VL_BLUE);
	DisplayViewerFrame (hdc, VL_CURRENT);
	TextColor (hdc, VL_BLUE, VL_BLACK, TRANSPARENT);
	DisplayViewerName (hdc, VL_CURRENT, 0);
	depthbuffer = ShadingOption (VL_CURRENT, VL_DEPTHBUFFER, TRUE);
	ClearDepthBuffer (0xffff);
	TextParameter (VL_TEXT_HEIGHT, 40);
	TextParameter (VL_TEXT_THICKNESS, 8);
	SwitchLight (light4, TRUE);
	SwitchLight (light7, TRUE);
	SelectMaterial (mater0);
	PushTransformation3D (NULL);
	Rotate3D (135, 'z');
	Rotate3D (90, 'x');
	SetTextAlign (hdc, TA_CENTER | TA_BASELINE);
	SolidText (hdc, "Visualib");
	PopTransformation3D (NULL);
	ShadingOption (VL_CURRENT, VL_DEPTHBUFFER, depthbuffer);
}

void	AnimationDemo (HDC hdc, WORD cmd)
{
	switch (cmd) {
		case IDM_ANIMATE_FRAME:
			animate_length = 10;
			RotateFrame (hdc);
			break;
		case IDM_ANIMATE_OBJECT2D:
			animate_length = 10;
			ObjectMotion2D (hdc);
			break;
		case IDM_ANIMATE_SURFACE:
			animate_length = 10;
			RotateSurface (hdc);
			break;
		case IDM_ANIMATE_ICOSAHEDRON:
			animate_length = 10;
			RotateIcosahedron (hdc);
			break;
		case IDM_ANIMATE_SPRING:
			animate_length = 15;
			RotateSpring (hdc);
			break;
		case IDM_ANIMATE_STAR3D:
			animate_length = 15;
			RotateStar (hdc);
			break;
		case IDM_ANIMATE_DODECAHEDRON:
			animate_length = 15;
			RotateDodecahedron (hdc);
			break;
		case IDM_ANIMATE_VIEWER3D:
			animate_length = 7;
			ViewerMotion3D (hdc);
			break;
		case IDM_ANIMATE_ZOOM3D:
			animate_length = 15;
			ViewerZoom3D (hdc);
			break;
	}
	ViewerReset ();
}

void	Welcome (HDC hdc)
{
	char	str[80];

	SelectViewer (viewer20);
	PushTransformation2D (NULL);
	Scale2D (0.1f, 0.1f);
	SetTextAlign (hdc, TA_BASELINE | TA_CENTER);
	TextParameter (VL_TEXT_HEIGHT, 40);
	PenColor (hdc, VL_RED);
	BrushColor (hdc, VL_YELLOW);
	wsprintf (str, "Welcome\nto\nVisuaLib");
	Text2D (hdc, 0, 0, 0, str);
	DisplayViewerFrame (hdc, VL_CURRENT);
	PopTransformation2D (NULL);
}

void	VlibDemo (HDC hdc, int func)
{
	BOOL	l0, l1, l2, l3;

	l0 = SwitchLight (light0, FALSE);
	l1 = SwitchLight (light1, FALSE);
	l2 = SwitchLight (light2, FALSE);
	l3 = SwitchLight (light3, FALSE);
	switch (func) {
		case IDM_DEMO_START:
			Welcome (hdc);
			break;
		case IDM_DEMO_SPOTLIGHT:
			SpotlightDemo (hdc);
			break;
		case IDM_DEMO_MATERIALPROPERTY:
			MaterialPropertyDemo (hdc);
			break;
		case IDM_DEMO_IMAGEMAPPING:
			ImageMappingDemo (hdc);
			break;
		case IDM_DEMO_DEPTHCLIPPING:
			DepthClippingDemo (hdc);
			break;
		case IDM_DEMO_MARBLERING:
			MarbleRingDemo (hdc);
			break;
		case IDM_DEMO_GRANITECUBE:
			GraniteCubeDemo (hdc);
			break;
		case IDM_DEMO_WOODSURFACE:
			WoodSurfaceDemo (hdc);
			break;
		case IDM_DEMO_3DCOMPOSITE:
			CompositeDemo3D (hdc);
			break;
		case IDM_DEMO_STEREOTEXT:
			StereoTextDemo (hdc);
			break;
		case IDM_DEMO_2DCOMPOSITE:
			CompositeDemo2D (hdc);
			break;
		case IDM_DEMO_NURBSCURVE:
			SelectViewer (viewer20);
			Primitives2D (hdc, IDM_2DCURVE_NURBS);
			SelectViewer (viewer30);
			Primitives3D (hdc, IDM_3DCURVE_NURBS);
			break;
	}
	SwitchLight (light0, l0);
	SwitchLight (light1, l1);
	SwitchLight (light2, l2);
	SwitchLight (light3, l3);
	SwitchLight (light4, FALSE);
	SwitchLight (light5, FALSE);
	SwitchLight (light6, FALSE);
	SwitchLight (light7, FALSE);
	SwitchLight (light8, FALSE);
}

void    FunctionDemos (HDC hdc)
{
	int		func = demo_function;

	SetROP2 (hdc, R2_COPYPEN);
	if (func > IDM_2DPRIME_START && func < IDM_2DPRIME_END) {
		SelectViewer (viewer20);
		Prime2D (hdc, func);
	}
	else if (func > IDM_3DPRIME_START && func < IDM_3DPRIME_END) {
		SelectViewer (viewer30);
		Prime3D (hdc, func);
	}
	else if (func > IDM_2DCURVE_START && func < IDM_2DCURVE_END) {
		SelectViewer (viewer20);
		Curves2D (hdc, func);
	}
	else if (func > IDM_3DCURVE_START && func < IDM_3DCURVE_END) {
		SelectViewer (viewer30);
		Curves3D (hdc, func);
	}
	else if (func >= IDM_SURFACE_START && func < IDM_SURFACE_END) {
		SelectViewer (viewer30);
		Surfaces (hdc, func);
	}
	else if (func >= IDM_SOLID_START && func < IDM_SOLID_END) {
		SelectViewer (viewer30);
		ShowSolidPrimitives (hdc, func);
	}
	else if (func > IDM_ANIMATE_START && func < IDM_ANIMATE_END) {
		AnimationDemo (hdc, func);
	}
	else if (func > IDM_TEXT_START && func < IDM_TEXT_END) {
		ShowTextPrimitives (hdc, func);
	}
	else if (func > IDM_2DTRANSF_BEGIN && func < IDM_3DTRANSF_BEGIN) {
		SelectViewer (viewer20);
		Transformation2D (hdc, func);
	}
	else if (func > IDM_3DTRANSF_BEGIN && func < IDM_3DTRANSF_END) {
		SelectViewer (viewer30);
		Transformation3D (hdc, func);
	}
	else if (func > IDM_2DPRIMIT_START && func < IDM_2DPRIMIT_END) {
		SelectViewer (viewer20);
		Primitives2D (hdc, func);
	}
	else if (func > IDM_3DPRIMIT_START && func < IDM_3DPRIMIT_END) {
		SelectViewer (viewer30);
		Primitives3D (hdc, func);
	}
	else if (func > IDM_3DARRAY_BEGIN && func < IDM_3DARRAY_END) {
		SelectViewer (viewer30);
		ObjectArray3D (hdc, func);
	}
	else if (func > IDM_2DARRAY_BEGIN && func < IDM_2DARRAY_END) {
		SelectViewer (viewer20);
		ObjectArray2D (hdc, func);
	}
    else {
		VlibDemo (hdc, func);
    }
}

void    AdjustViewer (HWND hwnd, int viewid)
{
    RECT    rect;

    GetClientRect (hwnd, &rect);
	rect.left += 10;
	rect.right -= 10;
	rect.top += 10;
	rect.bottom -= 20;
    SetViewport (viewid, rect);
}

BINARY	SavePicture (HWND hwnd, BOOL withframe)
{
	RECT	rect;
	HANDLE	hdib;
	BOOL	flag;

	GetScreenRect (hwnd, withframe, &rect);
	hdib = ScreenToDIB (&rect);
	if (!hdib)
		return (FALSE);
	flag = WriteDIBFile (NULL, hdib);
	GlobalUnlock (hdib);
	GlobalFree (hdib);
	return (flag);
}

BINARY	PrintPicture (HWND hwnd, BOOL withframe)
{
	RECT	rect;
	HANDLE	hdib;
	BOOL	flag;

	GetScreenRect (hwnd, withframe, &rect);
	hdib = ScreenToDIB (&rect);
	if (!hdib)
		return (FALSE);
	flag = PrintImage (hdib,
		VL_BESTFIT | VL_VERTCENTER | VL_HORZCENTER | VL_MARKCORNER,
		0, 0, 0, 0);
	GlobalUnlock (hdib);
	GlobalFree (hdib);
	return (flag);
}

void	PrintFlag (void)
{
	SelectViewer (viewer22);
	PrintDrawing (USFlag,
		VL_BESTFIT | VL_HORZCENTER | VL_VERTCENTER | VL_MARKCORNER,
		0, 0, 0, 0);
}

void	ExitDemo (void)
{
	ExitVisualib ();
	GlobalUnlock (hdib1);
	GlobalFree (hdib1);
	GlobalUnlock (hdib2);
	GlobalFree (hdib2);
	GlobalUnlock (hdib3);
	GlobalFree (hdib3);
	PostQuitMessage (0);
}

void	AlterMenuItem (HWND hwnd, WORD entry)
{
	short	flag = MF_BYCOMMAND;

	switch (entry) {
		case IDM_DEMO_WITHFRAME:
			withframe = !withframe;
			flag |= (withframe) ? MF_CHECKED : MF_UNCHECKED;
			break;
	}
	CheckMenuItem (GetMenu (hwnd), entry, flag);
}
						
/****************************************************************************

    FUNCTION: MainWndProc (HWND, WORD, WORD, LONG)

    PURPOSE:  Processes messages

    MESSAGES:

    WM_COMMAND  - application menu (About dialog box)
    WM_DESTROY  - destroy window

    COMMENTS:

    To process the IDM_ABOUT message, call MakeProcInstance () to get the
    current instance address of the About () function.  Then call Dialog
    box which will create the box according to the information in your
    vlibdemo.rc file and turn control over to the About () function.    When
    it returns, free the intance address.

****************************************************************************/

long WINAPI MainWndProc (HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
    switch (msg) {
        case WM_COMMAND:
            switch (wParam) {
                case IDM_DEMO_EXIT:
					ExitDemo ();
                    break;
                case IDM_HELP_ABOUT:
					AboutVisualib ();
					SendMessage (hWnd, WM_COMMAND, IDM_DEMO_START, 0L);
                    break;
				case IDM_HELP_LICENSE:
					LicenseInfo ();
					break;
                case IDM_HELP_DEMOPROG:
                    WinHelp (hWnd, "vlibdemo.hlp", HELP_INDEX, 0);
                    break;
                case IDM_HELP_VISUALIB:
                    WinHelp (hWnd, "visualib.hlp", HELP_INDEX, 0);
                    break;
				case IDM_DEMO_SAVEPICTURE:
					SavePicture (hWnd, withframe);
					break;
				case IDM_DEMO_PRINTPICTURE:
					PrintPicture (hWnd, withframe);
					break;
				case IDM_DEMO_WITHFRAME:
					AlterMenuItem (hWnd, wParam);
					break;
				case IDM_DEMO_PRINTFLAG:
					PrintFlag ();
					break;
				case IDM_TEXT_SELECTFONT:
					SelectFont ();
					return (NULL);
                default:
					if (wParam > 200 && wParam < 300) {
						ShadingSettings (hWnd, wParam);
						break;
					}
					if (wParam > IDM_ANIMATE_START &&
						wParam < IDM_ANIMATE_END) {
						HDC	hdc;

						hdc = GetDC (hWnd);
						AnimationDemo (hdc, wParam);
						ReleaseDC (hWnd, hdc);
						break;
					}
                    demo_function = wParam;
                    InvalidateRect (hWnd, NULL, TRUE);
                    return (DefWindowProc (hWnd, msg, wParam, lParam));
            }
            break;
        case WM_DESTROY:
            ExitVisualib ();
			GlobalUnlock (hdib1);
			GlobalFree (hdib1);
			GlobalUnlock (hdib2);
			GlobalFree (hdib2);
			GlobalUnlock (hdib3);
			GlobalFree (hdib3);
            PostQuitMessage (0);
            break;

        case WM_PAINT:
            ProcessWindowPaint (hWnd);
            break;
        
        case WM_SIZE:
            AdjustViewer (hWnd, viewer20);
            AdjustViewer (hWnd, viewer30);
            InvalidateRect (hWnd, NULL, TRUE);
            break;

        default:
            return (DefWindowProc (hWnd, msg, wParam, lParam));
    }
    return (NULL);
}

