/*
 * A code fragment to allow using PC-specific keys.  It's here on a
 * separate file to minimize clutter of the original source files.
 */
      if (info_input_stream == stdin) {
        int i;
        static struct
        {
          int inkey;
          unsigned char outkey1, outkey2;
        } DJGPP_keytab[] = {
          {K_Control_PageDown,  'n', 0},  /*these are for moving between nodes*/
          {K_Control_PageUp,    'p', 0},
          {K_Control_Up,        'u', 0},
          {K_Control_Down,      'm', 0},
          {K_Control_Center,    'l', 0},

          {K_Home,      K_Control_A, 0}, /* .. and these for moving IN a node */
          {K_End,       K_Control_E, 0}, /* they're Numeric-Keypad-Keys, so */
          {K_Left,      K_Control_B, 0}, /* NUMLOCK should be off !! */
          {K_Right,     K_Control_F, 0},
          {K_Down,      K_Control_N, 0},
          {K_Up,        K_Control_P, 0},
          {K_PageDown,  SPC, 0},
          {K_PageUp,    K_Control_Backspace, 0},
          {K_Control_Left,  ESC, 'b'},
          {K_Control_Right, ESC, 'f'},
          {K_Control_Home,  'B', 0},
          {K_Control_End,   'E', 0},

          {K_EHome,      K_Control_A, 0}, /* also for moving IN a node */
          {K_EEnd,       K_Control_E, 0}, /* they're the 'extended' keys */
          {K_ELeft,      K_Control_B, 0},
          {K_ERight,     K_Control_F, 0},
          {K_EDown,      K_Control_N, 0},
          {K_EUp,        K_Control_P, 0},
          {K_EPageDown,  SPC, 0},
          {K_EPageUp,    K_Control_Backspace, 0},
          {K_Control_ELeft,  ESC, 'b'},
          {K_Control_ERight, ESC, 'f'},
          {K_Control_EHome,  'B', 0},
          {K_Control_EEnd,   'E', 0},

          {K_BackTab, ESC, TAB},
          {K_Alt_X, ESC, 'X'}, /* the most/only important M-???-key */
          {K_F1, K_Control_H, 0}, /* YEAH, gimme that goodold F-one-thing */
          {K_Delete, K_Control_Backspace, 0}, /* to make Delete be DEL (0x7f) */
          {0, 0, 0}
        };

        do {
          rawkey=getxkey();
          if (rawkey & 0x300) {
            for (i = 0; DJGPP_keytab[i].inkey; i++) {
              if (rawkey == DJGPP_keytab[i].inkey) {
                rawkey = DJGPP_keytab[i].outkey1;
                pending_input_character = DJGPP_keytab[i].outkey2;
                break;
              }
            }
          }
        } while (rawkey & 0x300);
      } else
