/* TGD Support Functions V1.2
 * Copyright (C) 1994 Tale Software
 * All rights reserved.
 */

#include <alloc.h>	/* for malloc */

#include "tgdconst.h"	/* common tgdlp4 data types and structures */

void waittof(void);	/* for framewait(); defined in tgdlp4.h */

/* TGD support procedures */
bitmap far *newbitmap(uword xsize,uword ysize)
{ ubyte plane,huge *bitmapmem;
  uword x8size;
  udword bmemreq,planelen;
  bitmap far *bmheader;

  /* allocate memory for bitmapheader structure */
  bmheader=farmalloc(sizeof(bitmap));
  if (!bmheader) return(0);

  /* allocate memory for bitmap */
  x8size=xsize&7? (xsize&0xfff8)+8:xsize;
  bmemreq=(udword)x8size*(udword)ysize;
  if (!bmemreq) { farfree(bmheader); return(0); };
  bitmapmem=farmalloc(bmemreq);
  if (!bitmapmem) { farfree(bmheader); return(0); };

  /* initialize bitmapheader structure */
  /* set xsize, ysize */
  bmheader->xsize=xsize-1;
  bmheader->ysize=ysize-1;

  /* set bytes per line */
  bmheader->bytespline=x8size>>2;

  /* set planeptrs */
  for (planelen=bmemreq>>2,plane=0;plane<4;plane+=1)
  { bmheader->plane[plane]=planelen*(udword)plane+bitmapmem; };
  return(bmheader);
}

void freebitmap(bitmap far *yourbitmap)
{
  if (!yourbitmap) return;
  /* free bitmap */
  farfree(yourbitmap->plane[0]);
  /* free bitmapheader */
  farfree(yourbitmap);
}

spriteinc far *newsprite(word collxpos,word collypos,uword collxsize,uword collysize,spritemap far *spritedef)
{ spriteinc far *sprinchdr;

  /* allocate memory for sprite incarnation structure */
  sprinchdr=farmalloc(sizeof(spriteinc));
  if (!sprinchdr) return(0);

  /* initialize sprite incarnation */
  sprinchdr->sprkrxpos=collxpos; sprinchdr->sprkrypos=collypos;
  sprinchdr->dblsprkrxpos=collxpos; sprinchdr->dblsprkrypos=collypos;
  sprinchdr->sprkxsize=collxsize; sprinchdr->sprkysize=collysize;
  sprinchdr->dblsprkxsize=collxsize; sprinchdr->dblsprkysize=collysize;
  sprinchdr->sprdef=spritedef;
  return(sprinchdr);
}

void freesprite(spriteinc far *yoursprite)
{
  if (!yoursprite) return;
  /* free sprite incarnation */
  farfree(yoursprite);
}

void framewait(uword frames)
{ uword frametmp;

  for (frametmp=0;frametmp<frames;frametmp+=1)
  { waittof(); };
}
