/* LP4 Support Library Application Header
 * Copyright (C) 1994 Tale Software
 * All rights reserved.
 */

/* LP4SUPP.H already included? */
#ifndef LP4SUPP_H
#define LP4SUPP_H

/* define common tgdlp4 data types and structures */
#include "tgdconst.h"

/* LP4 format Version 1.2 */
#define LP4_VERSION 1
#define LP4_REVISION 2

/* LP4 font types */
#define LP4_FONT_FIXED 0
#define LP4_FONT_PROP 1

/* define errors */
#define LP4ERR_NOFILE 1
#define LP4ERR_BADFILE 2
#define LP4ERR_NOMEM 3
#define LP4ERR_EOF 4

/* define LP4 structures */

/* file color map header */
typedef struct { ubyte colors;
	       } cmhdr;

/* file bit map header */
typedef struct { uword xsize,ysize;
		 uword bytespline;
		 udword maxbitmaplen;
		 udword planeoffset[4];
	       } bmhdr;

/* file font map header */
typedef struct { ubyte fonttype;
		 ubyte startchr,stopchr;
		 ubyte pad;		/* for word alignment */
		 uword chrxsize,chrysize;
		 word spacingx,spacingy;
		 bmhdr fontbitmap;
/*               uword propxsize[256];     only for proportional width fonts */
	       } fmhdr;

/* file sprite map header */
typedef struct { ubyte animseqno;
		 ubyte pad;		/* for word alignment */
		 uword animseqsize;
		 bmhdr spritebitmap;
	       } smhdr;


/* LP4 Support Library bitmap descriptor */
typedef struct { cmhdr huge *cmdescr;
		 ubyte far *cmap;	    /* this is a huge ptr really */
		 bmhdr huge *bmdescr;
		 ubyte huge *bmap;
		 bitmap far *tgdbmdescr;    /* this is a huge ptr really */
	       } bcdescr;

/* LP4 Support Library font descriptor */
typedef struct { cmhdr huge *cmdescr;
		 ubyte far *cmap;	    /* this is a huge ptr really */
		 fmhdr huge *fmdescr;
		 ubyte huge *bmap;
		 fontmap far *tgdfmdescr;   /* this is a huge ptr really */
	       } fcdescr;

/* LP4 Support Library sprite descriptor */
typedef struct { cmhdr huge *cmdescr;
		 ubyte far *cmap;	    /* this is a huge ptr really */
		 smhdr huge *smdescr;
		 ubyte huge *bmap;
		 spritemap far *tgdsmdescr; /* this is a huge ptr really */
	       } scdescr;

/* these procedures are currently available */
void freebc(bcdescr huge *bcinfo);
bcdescr huge *readbc(const char far *filename,ubyte bcnumber,ubyte far *loaderr);
void freefc(fcdescr huge *fcinfo);
fcdescr huge *readfc(const char far *filename,ubyte fcnumber,ubyte far *loaderr);
void freesc(scdescr huge *scinfo);
scdescr huge *readsc(const char far *filename,ubyte scnumber,ubyte far *loaderr);

#endif /* LP4SUPP_H */
