/* LP4 File Format Constants
 * Copyright (C) 1994 Tale Software
 * All rights reserved.
 */

/* LP4CONST.H already included? */
#ifndef LP4CONST_H
#define LP4CONST_H

/* universal definitions */
#define FALSE 0
#define TRUE -1

/* define origin data types as understood by tale software */
#ifndef TALE_DATA_TYPES
 #define TALE_DATA_TYPES
 typedef unsigned char ubyte;	   /* unsigned byte */
 typedef signed char byte;	   /* signed byte */
 typedef unsigned int uword;	   /* unsigned word */
 typedef signed int word;	   /* signed word */
 typedef unsigned long int udword; /* unsigned double word */
#endif

/* LP4 format Version 1.2 */
#define LP4_VERSION 1
#define LP4_REVISION 2

/* max. titlelen for () chunk excl. \0 */
#define MAX_TITLE_LEN 31

/* use this value for pad filling */
#define LP4_PAD_FILL 0

/* LP4 font types */
#define LP4_FONT_FIXED 0
#define LP4_FONT_PROP 1

/* define LP4 structures */
typedef struct { ubyte version,revision;
	       } lp4hdr;

typedef struct { char cnkname[2];
		 udword cnklen;
	       } lp4cnkhdr;

typedef struct { ubyte colors;
	       } cmhdr;

typedef struct { uword xsize,ysize;
		 uword bytespline;
		 udword maxbitmaplen;
		 udword planeoffset[4];
	       } bmhdr;

typedef struct { ubyte fonttype;
		 ubyte startchr,stopchr;
		 ubyte pad;		/* for word alignment */
		 uword chrxsize,chrysize;
		 word spacingx,spacingy;
		 bmhdr fontbitmap;
/*               uword propxsize[256];     only for proportional width fonts */
	       } fmhdr;

typedef struct { ubyte animseqno;
		 ubyte pad;		/* for word alignment */
		 uword animseqsize;
		 bmhdr spritebitmap;
	       } smhdr;

/* define LP4 chunkIDs */
const char lp4ID[]="LP4 \x1a",signID[2]="()";
const char chID[2]="CH",cmID[2]="CM";
const char bcID[2]="BC",bhID[2]="BH",bmID[2]="BM";
const char fcID[2]="FC",fhID[2]="FH";
const char scID[2]="SC",shID[2]="SH";

#endif /* LP4CONST_H */
