//This program should run under either Microsoft or Borland C.
//TDIG.LIB must be included in project file.

#include <stdio.h>
#include <tdig.h>

typedef unsigned int uint;

struct dcomplex beta[20] = {0};  //Array for polynomial coefficients
struct dcomplex beta2[20] = {0}; //Duplicate of beta[]
struct lcomplex root[20] = {0};  //Array to receive polynomial roots

struct lcomplex x, f, f1, f2;

void main(void)
{
  uint i, n;
  int errcode;

  n = 6;             //Solve a polynomial of 6th degree

  beta[0].x = 6.0;   //Initialize polynomial.
  beta[1].x = 1.0;   //Will use real coefficients. Imaginary parts already zero.
  beta[2].x = 2.0;
  beta[3].x = 7.0;
  beta[4].x = 3.0;
  beta[5].x = 4.0;
  beta[6].x = 1.0;

  for(i = 0; i <= n; i++)  //Make duplicate copy of polynomial since
    beta2[i] = beta[i];    //getroots() destroys beta[].

  errcode = getroots(n, beta, root);  //Compute polynomial roots
  if(errcode < 0)                     //errcode either 0 or -1
  {
    printf("Unable to find polynomial roots.\n");
    return;
  }

//Print the roots along with corresponding polynomial values (which should
//all be zero in the absence of roundoff error).  The polynomial is computed
//with calcpoly(), which also returns the first two derivatives of the
//polynomial (f1 and f2).

  printf("#          root.x      root.y         f.x         f.y\n");
  for(i = 0; i < n; i++)
  {
    calcpoly(n, beta2, &root[i], &f, &f1, &f2);
    printf("%-5u%12.8Lf%12.8Lf%12.8Lf%12.8Lf\n", i, root[i].x, root[i].y, f.x, f.y);
  }

}
