;-----------------------------------------------------------------------------
; Example code for Flat-Real mode routines.
; By NiX / MASSiVE

; This routine fills 1Mb of XMS memory with data using flat real mode, not
; usefull, but just to show how it works.

STAPEL SEGMENT STACK USE16 'Stack'
dw 200 dup(?)
ENDS

CODE SEGMENT USE16
Assume cs:code, ss:stapel

include flatmem.inc     ; Flat Real Mode routines

Handle          dw      ?  ; XMS-handle
V86mess         db      "Error: V86 Mode present!",7,13,10,"$"
Himemmess       db      "Error: No HIMEM.SYS found!",7,13,10,"$"
NoFreeMem       db      "Error: Not enough free XMS memory!",7,13,10,"$"

Start:          call    Set4Gig         ; Swap to Flat Real Mode
                jc      V86Error        ; If V86-Mode present give an error

                mov     ax,cs
                mov     ds,ax

                call    Himem_Init      ; Initialize HIMEM.SYS
                jc      NoHimem         ; No Himempresent?

                mov     dx,1024         ; 1024Kb
                call    Alloc_XMS       ; Allocate memory
                jc      NoFreememerr
                mov     cs:Handle,dx    ; Store handle

                call    GetLinearAddress ; Get XMS adress

                call    EnableA20       ; Enable the A20-line
                
                mov     edi,edx
                mov     ecx,1024*1024 ; 1024Kb

                xor     ax,ax           ; Set segment register to 0
                mov     gs,ax           ;
                
Fillloop:       mov     gs:byte ptr[edi],al  ; Put 1 byte in XMS
                inc     edi                  ; Next byte
                inc     al                   ; Another value... (zeros are so boring...)
                dec     ecx
                jnz     Fillloop
                
                mov     dx,cs:Handle
                call    DAlloc_XMS

                mov     ax,4c00h
                int     21h

;-------------------------------------------------------------
; Error routines
V86error:       mov     dx,offset V86Mess
                mov     ah,9
                int     21h
                mov     ax,4c00h
                int     21h

Nohimem:        mov     dx,offset Himemmess
                mov     ah,9
                int     21h
                mov     ax,4c00h
                int     21h

Nofreememerr:   mov     dx,offset Nofreemem
                mov     ah,9
                int     21h
                mov     ax,4c00h
                int     21h

ENDS
End Start






