
/********************************************************************
 *                                                                  *
 *	 JULIAN DATE LIBRARY DEMO (c)Copyright 1992 by CalcShop Inc.    *
 *					  All rights reserved.                          *
 *                                                                  *
 *                 JULIAN v1.05 d08/02/93                           *
 *                                                                  *
 *						 Robert Emmons                              *
 *						 CalcShop Inc.                              *
 *						  P.O Box 1231                              *
 *					 W. Caldwell, NJ  07007                         *
 *			 Phones: (201)228-9139 or (800)466-3469                 *
 *                                                                  *
 ********************************************************************/

#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <string.h>
#include <dos.h>
#include <time.h>
#include <ctype.h>
#include "juldef.h"


int waitkey(void);
int timestamp(FILE *fp);
int makedate(char *, int);



main(int argc, char *argv[] /* ,char *env[] */)
{
	char str[82];			/* allows for 80 chars + \n + \0 */
	int done = FALSE, pass = 1, autorun = FALSE;
	int nearyear = 2000;
	int weekday;
	long jday;
	double jear;
	GDATE gdate, jdaychkdate, jearchkdate;

	fputs("\n", stdout);
	timestamp(stdout);
	fprintf(stdout, "     nearyear = %-5d", nearyear);
	fputs("\nOutput shows: \"Stardate\", dayofweek = mm/dd/yy (if possible) = mm/dd/yyyy", stdout);

	if(argc > 1 && toupper(*argv[1]) == 'M')
		autorun = FALSE;
	else{
		autorun = TRUE;
	}
	done = FALSE;
	pass = 1;			/* counter for automatic operation */
	while(done != TRUE)
	{

		/* input a Gregorian date string from the keyboard or
		   the preprogrammed list
		*/
		if(autorun == TRUE)
			done = makedate(str, pass);
		else{
			fputs("\n\nEnter date (mm/dd/yyyy): ", stdout);
			fgets(str, 80, stdin);
			done = TRUE;
		}

		/* use various JULIAN LIBRARY conversion and other functions */
		gdate = mmddyyyytogreg(str, nearyear);
		jday = gregtojday(gdate);
		jear = gregtojear(gdate);
		weekday = dayofweek(jday);
		jdaychkdate = jdaytogreg(jday);
		jearchkdate = jeartogreg(jear);

		/* Display the input and converted dates */
		if(autorun == TRUE){
			fputs("\n          Entered date = ", stdout);
			fputs(str, stdout);
		}
		if(jday > 0){
			fprintf(stdout, "   %6ld, %8.3lf, %d = ", jday, jear, weekday);
			*str = '\x0';
			gregtommddyyyy(str, jdaychkdate, nearyear);
			fprintf(stdout, "%-10s = ", str);
			*str = '\x0';
			gregtommddyyyy(str, jearchkdate, FALSE);
			fputs(str, stdout);
		}
		else
			fputs("\nSorry: bad date entry.", stdout);


		/* decide whether or not to exit the demo */
		if(done == TRUE){
			autorun = FALSE;
			fputs("\nEnter another date (Y/N)? Y", stdout);
			done = waitkey();
			if(toupper(done) == 'N')
				done = TRUE;
			else{
				done = FALSE;
				pass = 0;
			}
		}
		++pass;
	}
	fputs("\nGoodbye!", stdout);
	return(FALSE);
}


int makedate(char *str, int pass)
{
	switch(pass){
		case 1:
			strcpy(str, "12/31/0001\n");
			pass = FALSE;
			break;
		case 2:
			strcpy(str, "01/01/0002\n");
			pass = FALSE;
			break;
		case 3:
			strcpy(str, "12/31/0003\n");
			pass = FALSE;
			break;
		case 4:
			strcpy(str, "01/01/0004\n");
			pass = FALSE;
			break;
		case 5:
			strcpy(str, "12/31/0004\n");
			pass = FALSE;
			break;
		case 6:
			strcpy(str, "01/01/0005\n");
			pass = FALSE;
			break;
		case 7:
			strcpy(str, "12/31/0399\n");
			pass = FALSE;
			break;
		case 8:
			strcpy(str, "01/01/0400\n");
			pass = FALSE;
			break;
		case 9:
			strcpy(str, "12/31/0400\n");
			pass = FALSE;
			break;
		case 10:
			strcpy(str, "01/01/0401\n");
			pass = FALSE;
			break;
		case 11:
			strcpy(str, "12/31/49\n");
			pass = FALSE;
			break;
		case 12:
			strcpy(str, "01/01/50\n");
			pass = FALSE;
			break;
		case 13:
			strcpy(str, "12/31/51\n");
			pass = FALSE;
			break;
		case 14:
			strcpy(str, "01/01/52\n");
			pass = FALSE;
			break;
		case 15:
			strcpy(str, "12/31/91\n");
			pass = FALSE;
			break;
		case 16:
			strcpy(str, "01/01/92\n");
			pass = FALSE;
			break;
		case 17:
			strcpy(str, "12/31/04\n");
			pass = FALSE;
			break;
		case 18:
			strcpy(str, "01/01/05\n");
			pass = FALSE;
			break;
		default:
			strcpy(str, "01/01/0001\n");
			pass = TRUE;
			break;
	}
	return pass;
}


int waitkey(void)
{
	int chr;
	return(!(chr = getch())? getch() + 128: chr);
}


int timestamp(FILE *fp)
{
	struct time tim;
	struct date dat;

	gettime(&tim);
	getdate(&dat);
	fprintf
	(	fp,
		"time stamp: %d/%d/%d %2d:%02d:%02d",
		dat.da_mon, dat.da_day, dat.da_year - 1900,
		tim.ti_hour, tim.ti_min, tim.ti_sec
	);
	return FALSE;
}


