/*
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SAMPDLG.C

AUTHOR: Craig Muller P. Eng. 1991,1992,1993
        cmuller@ccu.umanitoba.ca
        Computer Vision Laboratory
        Mech. Engn.,Univ. of Manitoba
        Winnipeg, Manitoba. R3T 2N2

DESCRIPTION:
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*/
#include <windows.h>

#pragma hdrstop

#include <stdio.h>
#include <string.h>

#include "iwf.h"

// Defines.
#define  MODULENAME "SAMPDLG"

// Exported Procedures.
BOOL FAR PASCAL _export DP_SampDlg(HWND hDlg,WORD wMsg,WORD wParam,LONG lParam);

// Private variables.
HWND  hDlgSampDlg=NULL;

static HINSTANCE hInstance;              // Application instance handle.

/*
--------------------------------------------------------------------------
SampDlg()
~~~~~~~~

SAMPDLG STARTUP PROCESSING PROCEDURE.
This is called when the user selects this option from the main menu.
This procedure check to see if the popup window exists. If so it simply
passes focus to the window and returns since there is nothing more to do.
If it does not exist then it proceeds to create the popup window and menu
and displays it on the screen. The popup window acts like a sub-program
within the main program and receives messages from the main program.
--------------------------------------------------------------------------
*/
void SampDlg(HWND hWndParent)
   {
   FARPROC lpProc;
   RECT rc0,rc1;
   int w,h;

   if (IsWindow(hDlgSampDlg))
      {
      SetFocus(hDlgSampDlg);
      }
   else
      {
      hInstance = GetWindowWord(hWndParent,GWW_HINSTANCE);
      lpProc = MakeProcInstance(DP_SampDlg,hInstance);
      hDlgSampDlg = CreateDialog(hInstance,MODULENAME,hWndParent,lpProc);
      GetWindowRect(hWndParent,&rc0);
      GetWindowRect(hDlgSampDlg,&rc1);
      w = rc1.right - rc1.left;
      h = rc1.bottom - rc1.top;
      MoveWindow(hDlgSampDlg,rc0.right-10-w,rc0.top+45,w,h,TRUE);
      }
   }



 /*
===============================================================================
BOOL FAR PASCAL _export DP_SampDlg(HWND hDlg,WORD wMsg,WORD wParam,LONG lParam)

Decription:
This window procedure handles all the messaging for the SampDlg Image Viewing
module. Special code is called which produces a red and blue composite
image from both left and right grey scale image. The user the puts on red
and blue 3D glasses to view the image in 3D.
===============================================================================
*/
BOOL FAR PASCAL _export DP_SampDlg(HWND hWnd,WORD wMsg,WORD wParam,LONG lParam)
   {
   switch (wMsg)
      {
      case WM_INITDIALOG:                        // WINDOW CREATION.
      PostMessage(hWnd,WM_USER,0,0);             // Ready to show the window
      break;

      case WM_USER:
      ShowWindow(hWnd,SW_SHOW);                  // Show the window
		hWndMod = hWnd;                            // Make this module active.
      break;

      case WM_CTLCOLOR:
      switch(HIWORD(lParam))
         {
         case CTLCOLOR_STATIC:
         SetBkColor((HDC)wParam,GetSysColor(COLOR_BTNFACE));
         return (LRESULT) GetStockObject(LTGRAY_BRUSH);
         }
      return (LRESULT) NULL;

      case WM_PAINT:                             // IMAGE NEEDS PAINTING.
      {
      RECT rc;
      PAINTSTRUCT ps;

      BeginPaint(hWnd,&ps);

      if (IsIconic(hWnd))
         {
         DrawIcon(ps.hdc,0,0,LoadIcon(hInstance,"SAMPDLG"));
         }
      else
         {
         GetClientRect(hWnd,&rc);
         FillRect(ps.hdc,&rc,GetStockObject(LTGRAY_BRUSH));
         }

      EndPaint(hWnd,&ps);                        // Painting complete.
      }
      break;
      
      case WM_LBUTTONUP:                         // LEFT BUTTON UP.
		case WM_RBUTTONUP:                         // RIGHT BUTTON UP.
		{
		HDC hDC;
		char sz[80];
		int scale;
		RECT rc;
		IMAGE *image;

		hDC = GetDC(hWnd);
		GetClientRect(hWnd,&rc);
		rc.bottom = 100;
		FillRect(hDC,&rc,GetStockObject(LTGRAY_BRUSH));
		SetBkColor(hDC,GetSysColor(COLOR_BTNFACE));
		if (IsWindow((HWND)wParam))
			{
			image = GetImage((HWND)wParam);
			scale = GetScale((HWND)wParam);
			sprintf(sz,"Message from image window");
			TextOut(hDC,10,10,sz,strlen(sz));
			sprintf(sz,"File: %s",image->fspec);
			TextOut(hDC,10,25,sz,strlen(sz));
			sprintf(sz,"Scale: %d  Width: %d  Height: %d",scale,image->hres,image->vres);
			TextOut(hDC,10,40,sz,strlen(sz));
			}
		else
			{
			sprintf(sz,"Message from user window");
			TextOut(hDC,10,10,sz,strlen(sz));
			hWndMod = hWnd;                            // Make this module active.
			}
		ReleaseDC(hWnd,hDC);
		}
		break;

		case WM_LBUTTONDBLCLK:
		hWndMod = hWnd;                            // Make this module active.
		break;

		case WM_CHAR:
      case WM_COMMAND:                           // MENU COMMAND SELECTED.
		break;

		case WM_SETFOCUS:                          // FOCUS HAS BEEN SET.
      hWndMod = hWnd;                            // Make this module active.
      break;

      case WM_KILLFOCUS:                         // FOCUS HAS BEEN KILLED.
      break;

      case WM_CLOSE:
      DestroyWindow(hWnd);
      break;

      case WM_DESTROY:
      break;
      }

   lParam=lParam;

   return(NULL);
   }

